function [log_pdf, dlogp] = neglogp_tau(para,x,y, sigma_t)

%function [log_pdf, dlogp] = neglogp_tau(para,x,y, sigma_t)
% the posterior distribution of tau: p(tau|y, theta, sigma_t) = p(y|tau, theta)p(tau|sigma_t)
% the constant coefficience, (2pi)^(-n/2) * (2pi)^(-n/2) * sigma_t^(-n), is
% not included.
% dependencies: k_ij.m
%Verified for the case of one dimension
% Verified by simple two dimensional data

n = length(x);
tau = para(1:n);
theta = para(n+1: end);
n2 = size(y, 2);
l = theta(1); sigma_n = theta(2); sigma_f = theta(3);

%----------1.) calculate matrix k----------%
%k = zeros(n);
%k1 = zeros(n); 
%for i = 1:n
 %   for j = 1:n
  %      k(i,j)  = k_ij( x(i)-tau(i), x(j)-tau(j), l, sigma_f);
   % end
%end
[k, dk_dtau, dk_dl, dk_dsigma_f] = k_matrix(x - tau, l, sigma_f);

%---------2.) calculate p(tau|y, theta, sigma_t) = p(y|tau,theta)p(tau|sigma_t)-------%
diags = max(1e3*eps, sigma_n^2);% beef up the diagonal if sigma_n = 0
k_sn = k  + diags*eye(n);
L  = chol (k_sn,'lower');
alpha  = L\y;
log_pi = .5 * n * log(2*pi);
log_L = log(prod(diag(L)));
log_pdf = - 0.5 * tau' * tau * sigma_t^(-2) - log_pi - n * log(sigma_t);
for i = 1: n2
    log_pdf = log_pdf - 0.5*alpha(:, i)' * alpha(:,i) - log_pi - log_L;
end

pdf = exp(log_pdf);

%---------3.) calculate gradient of logP-------------------%
invk_sn = inv(k_sn);

a = invk_sn * y;

A = a*a' - n2*invk_sn;

if nargout >=2
    dlogp_dtau = zeros(n,1);
    for i = 1:n
        dlogp_dtau(i) = 0.5 * trace(A*dk_dtau(:,:,i)) - tau(i)/sigma_t^2;
    end

    dlogp_dtheta = zeros(3,1);
    dlogp_dtheta(1) = 0.5 * trace(A*dk_dl);
    dlogp_dtheta(3) = 0.5 * trace(A*dk_dsigma_f);
    dlogp_dtheta(2) = 0.5 * 2 * sigma_n * trace(A);
    dlogp = [dlogp_dtau; dlogp_dtheta];

end


log_pdf = - log_pdf;
if nargout >= 2
    dlogp = - dlogp;
end






 