// CellInfoInterface.java - GFR data for each cell of the grid
//
// Coded by N. Jacobson July-August, 2006

public interface CellInfoInterface
{

	// Each cell has an intensity reading and time that that reading was taken.

	// value for cell not yet surveyed
	public static final int NO_DATA = 0;

	// time value for cell not yet surveyed;
	// form is "YYYY-MM-DD HH:MM:SS"
	public static final String DATE_TIME_NA = "0000-00-00 00:00:00";


	// construct a new cell, one that has not yet been surveyed
	// 	public <class that implements this interface()


	// set the cell's intensity to a new value
	public void updateIntensity(int newIntensity);

	// set the time the cell's GPR was done to a new value
	public void updateTimeTaken(String newTimeTaken);

	// return the cell's intensity
	public int getIntensity();

	// return the time the cell's GPR was done
	public String getTimeTaken();
}