// GPRGridInterface.java - the grid's GPR data
//
// Coded by N. Jacobson July-August, 2006
// Slightly revised for use in Eclipse by Norman Jacobson, March 2010

// The GFR grid is a 2D array of surveyed cells
// with a name, dimensions of the grid (# rows and cols)
// Each square contains info obtained from GPR scanning
// (see CellInfoInterface.java)
public interface GPRGridInterface
{
	// At program start, when the GPR file is unspecified, all is unknown.
	// Have a constructor that makes a grid with all information missing:
	// public <class that implements this interface>();

	// Also have a constructor that makes a new grid using the
	// the 'results' text file:
	// 		public <class that implements this interface>(Scanner results);
	//
	// The file's format is
	// 	line 1: name of the site
	// 	line 2: <number of rows (width)><space><number of columns (length)>
	// 	lines 3 to end - each line contains info on one cell; format is
	//		<row><white space><column><space><intensity><space><time taken>
	//		<intensity> ranges from 0 (not yet surveyed) to 600
	//		<time> is a string in the form YYYY-MM-DD HH:MM:SS
	//		  If the cell is not yet surveyed, time is 0000-00-00 00:00:00


	// return the site name
	public String getSiteName();

	// return the number of rows
	public int getNumberOfRows();

	// return the number of columns
	public int getNumberOfCols();

	// return the surveyed area, each cell is stored by its row and column
	public CellInfo[][] getSurveyedArea();
}