// SurveryReportInterface.java
//   create GPR report suitable for graphics screen display
// Coded by N. Jacobson August, 2006
// Slightly revised for use in Eclipse by Norman Jacobson, March 2010

public interface SurveyReportInterface
{
	// orders in which report can be sorted

	// decreasing order of intensity; within intensity,
	// increasing order of row; within row, increasing
	// order by column
	public final static int SORT_BY_INTENSITY = 1;

	// increasing order of row; within row, increasing
	// order by column
	public final static int SORT_BY_ROW = 2;

	// increasing order of column; within column, increasing
	// order by row
	public final static int SORT_BY_COLUMN = 3;

	// decreasing order of time survey of cell done;
	// within time, increasing order by row;
	// within row, increasing order by column
	// cells not yet surveyed appear at the
	// *bottom* of the list, in increasing order
	// by row; within row, increasing order by column
	public final static int SORT_BY_TIME = 4;


	// The report is one (long string), as it is a String that
	// the graphics display requires to be given in order to
	// print the report on the (graphics) screen in the report window.
	// Thus, SurveyReport, given the GFR information stored in theGrid
	// and the the order in which the cell information is to be displayed --
	// the reportOrder -- provides and stores in a String field the
	// formatted report. So make your constructor
	//
	// public <class that implements this interface>(GPRGrid theGrid, int reportOrder)


	// returns the  string that contains the formatted report to
	// display on the graphics screen
	public String getContent();

	// Hints:
	//	The assignment requires the the sorting of cell data
	//  be done via the use of a priority queue (PQ) that uses
	//  an unordered linked list as its underlying data
	//  structure. The PQ is only needed for this report,
	//  so a good strategy is to make it an inner class of
	//  your implementation of this interface.
	//
	//  Consider making another inner class that defines
	//  the info comprising one entry in the priority
	//  queue, and have it includec everything needed to
	//  correctly choose the next line to place on the
	//  report and all the data that is needed for that
	//  line. This approach will make it straight-forward
	//  to delete (the right) item from the queue and
	//  Immediately use that item to construct the
	//  report line that contains the info about the
	//  just-retrieved cell.
}