// AbstractMapKey.java
//
// Written by Norman Jacobson, April 2006 for the ICS 23 lab Searching for a Better Way
// Updated comments, by N. Jacobson, November, 2006
// Updated to include Proxmaps, by N. Jacobson, March 2010
// Minor edits by N. Jacobson, June 2010


/* This abstract class sets up the 'rules' for map keys used in
   conjunction with proxmaps and chain lists. For each map key you want
   to test

   -- define a class that extends this class; e.g., RealMapKey1

   -- define the computeMapKey() and computeLargestMapKey() methods
      for that class, overriding the methods here

   -- override the constant LARGEST_KEY_VALUE, if appropriate
      to reflect the largest map key your map key method can produce

   -- in the test program that calls ProxmapSearch and ChainSearch,
   	  construct the map key; have that object's reference be of type
   	  AbstractMapKey; for example,

      AbstractMapKey chainMapKey = new RealMapKey1();
      AbstractMapKey proxmapMapKey = new RealMapKey2();

      and pass the map keys to the constructor for the Proxmap and ChainList, 
      so it "knows" to use that map key:

      ChainList myChainList = new ChainList(chainMapKey);
      Proxmap myProxMap = new Proxmap(proxmapMapKey);

      (The proxmap and chain list can use the same or different
      map keys -- experiment to find which keys work best)

   If you then want to try a different map key, say RealMapKey3, all that
   changes is the construction line, to, for example

         AbstractMapKey chainMapKey = new RealMapKey3();

	Through the miracles of polymorphism, Java will automatically now use
	the map key methods associated with RealMapKey3 if you pass mapKey to
	Proxmap() and ChainList(), as done just above.
*/

public abstract class AbstractMapKey
{
	// The largest possible key --  the largest possible 5-digit ZIP code
	public static final int LARGEST_KEY_VALUE = 99999;

	// Computes and returns the mapKey for a given key
	public abstract int computeMapKey(int key);

	// Computes and returns the mapKey for the largest possible key;
	public abstract int computeLargestMapKey();
}