// ChainList.java
//
// Written by Norman Jacobson, March 2006 for the ICS 23 lab
// Searching for a Better Way, along the lines of SkipList.java,
//	written by Alex Thornton, Summer, 2005.
// Minor revisions to comments, November 2006
// Revised to use ZipCodeGroup and PhoneGroup classes, to parallel
//  Proxmap, March 2010, by N. Jacobson
// Minor edits, June 2010, by N. Jacobson
// A few parameter types were the wrong ones; problem fixed, May 2011,
//  by N. Jacobson
// Simplified a couple of headers and cleaned up comments, June 2011, 
//  by N. Jacobson

// Below is a skeleton of a ChainList class where each key (zip code) is an int
// and each value (a list of phone groups) is an ArrayList<ZipcodeGroup>.

// Signatures for methods to complete the required work are included;
// leave the public signatures as they are. You may add, change,
// or delete any private methods, fields and/or inner classes you see fit.

import java.util.ArrayList;
import java.util.Scanner;

public class ChainList
{
	private ArrayList<Chain> chainList;	// the list of chains

	// ChainList(): Builds a chain list from the contents
	// of the master file masterFileName (with the help of the buildList() method).
	//
	// See the lab write-up for details on the master file format.
	//
	// The chain list is an ArrayList<Chain>. Chain, a private inner class,
	// is a singly-linked list with ZipCodeGroup references as the data field.
	// A ZipcodeGroup consists of a zip code, the key, and an ArrayList
	// of PhoneGroup references. A Phonegroup is a class that defines
	// a phone group, an area code-prefix pair. (See the files ZipcodeGroup.java
	// and PhoneGroup.java for more information on these classes.)
	public ChainList(AbstractMapKey mapKeyToUse, String masterFileName)
	{

	}


	// buildList() builds the chain list from the file masterFileName
	// (with the help of insert()).
	private void buildList(String masterFileName)
	{

	}


	// insert() takes a zip code group and places it into the correct
	// location of the appropriate chain
	private void insert(ZipcodeGroup zipGroup)
	{

	}


	// lookup() takes a key (zip code) as a parameter and returns the list
	// of values associated with it (the list of phone groups in that zip code).
	// If the key does not appear in the list, a NoSuchZipException is thrown.
	public ArrayList<PhoneGroup> lookup(int key) throws NoSuchZipException
	{

	}


	// toString() builds an easy-to-interpret String representation
	// of the chain list structure. I suggest printing out each chain
	// on its own line (and using the toString() in Chain to handle
	//  printing the chain itself). An *excellent* debugging tool!
	public String toString()
	{

	}

	// ----------------------------- Chains ---------------------------------
	// A Chain is just a singly-linked list of Nodes containing ZipcodeGroups.
    // We use our own inked-list and node structures for speed: Java's LinkedList
	// class has a lot of overhead and features we don't need. Chains and
	// their nodes are manipulated in ChainList directly, so the need for
	// Chain methods is minimal.
	private class Chain
	{
		public Node startOfChain;	// start of key list
		public Node current;		// current node

		// Create a new chain; it's null to start
		public Chain()
		{
			startOfChain = null;
			current = null;
		}

		// Insert a node with a ZipcodeGroup into the chain at the point needed
		// to preserve key order, or, if the key (Zip code) already exists, add
		// the phone group of this ZipcodeGroup to the zipcode's list.
		public void insert(ZipcodeGroup zipGroup)
		{

		}

		// Return the node in this chain that contains the 'key to find'.
		// If no such node, return null
		public Node find(int keyToFind)
		{

		}

		// toString() builds a String representation of this chain
		// I suggest printing out each key on its own line and printing
		// with each key its value list. An *excellent* debugging tool!
		public String toString()
		{

		}
	}

	// A Node holds a reference to a ZipcodeGroup and a reference to
	// the next item in the list.
	private static class Node
	{
		public ZipcodeGroup zipGroup;		// zip code with its phone group
		public Node next;					// next node

		// Make a node with a given ZipcodeGroup
		public Node(ZipcodeGroup zipGroup)
		{

		}

		// getZipcode() returns the key (zip code) stored in this node.
		public int getZipcode()
		{

		}

		// getPhoneGroups() returns the list of phone groups stored is this node.
		public ArrayList<PhoneGroup> getPhoneGroups()
		{

		}

		// addPhoneGroup() adds a phone group to the phone group list.
		private void addPhoneGroup(PhoneGroup item)
		{

		}

		// compareToSearchKey() compares the zip code in this node to the
		// given zip for which we are searching, returning a negative
		// number if this key is less than the search key, zero if they 
		// are equal, and a positive number if this key is greater than 
		// the search key.
		public int compareToSearchKey(int searchKey)
		{
			int nodeZipcode = getZipcode();
			if (nodeZipcode < searchKey)
			{
				return -1;
			}
			else if (nodeZipcode > searchKey)
			{
				return 1;
			}
			else
			{
				return 0;
			}
		}
	}
}
