// Proxmap.java
//
// Written by Norman Jacobson, March 2010 for the ICS 23 lab
// Searching for a Better Way, along the lines of ChainList.java.

// Below is a skeleton of a Proxmap class where each item in the proxmap array
// is a reference to a ZipcodeGroup, each of which contains a zip code and a list
// of PhoneGroups -- areas code/prefix pairs that are associated with that zip code.

// Signatures for methods to complete the required work are included;
// leave the public signatures as they are. You may add, change,
// or delete any private methods, fields and/or inner classes, as you see fit.

import java.util.ArrayList;
import java.util.Scanner;

public class Proxmap
{
	private ArrayList<ZipcodeGroup> unsortedList; // the unsorted list of ZipCodeGroup
	private ArrayList<ZipcodeGroup> sortedList;   // the sorted list of ZipCodeGroup
	private int[] hitCount;						  // hit counts
	private int[] proxMap;						  // start of each subarray
	private int[] location;					      // where to place each key


	// Build the prox map with given map key and file of zip code/phone groups
	// (with the help of buildUnsortedList() and insert())
	public Proxmap(AbstractMapKey mapKeyToUse, String fileToUse)
	{

	}

	// buildUnsortedList() takes the contents of the master file with name
	// masterFileName and builds an ArrayList of unsorted zip code groups.
	// See the lab assignment for the format of the master file.
	// Note the master file is not necessarily in sorted order.

	// The unsortedList is an ArrayList of ZipCodeGroup references, each of which
	// points to a zip code group that was built up from a line-by-line reading of
	// the master file.
	private void buildUnsortedList(String masterFileName)
	{

	}


	// Insert a ZipcodeGroup into the sortedlist at the point needed to
	// preserve key order -- which will be at position start or later in
	// the same subarray -- or, if the key (Zip code) already exists, add
	// the phone group of this ZipcodeGroup to the zipcode's phone group list.
	// The values in the phone group list are in no particular order
	private void insert(ZipcodeGroup zipGroup, int start) 
	{

	}


	// lookup() takes a key (zip code) as a parameter and returns the list
	// of values associated with it (the list of phone groups in that zip code).
	// If the key does not appear in the sorted arary, a NoSuchKeyException is thrown.
	public ArrayList<PhoneGroup> lookup(int key) throws NoSuchZipException
	{

	}


	// printList(String whichOne) prints out the contents of the various
	// Proxmap arrays and ArrayLists -- neatly, as determined by whichOne's
	// value:
	//	"unsorted" - the unsorted list of zip code groups
	//	"sorted" -- the sorted list of zip code groups
	//	"hit count" -- the hit coutn aray
	//	"proxmap" -- the proxmap array
	//	"location" -- the location array

	// When printing the unsorted and sorted list, we suggest printing out
	// the value of each ZIP Code, followed by, indented on separate lines,
	// each phone group that's associated with that ZIP, organized and labeled
	// so a reader can quickly discern if something is amiss.
	public void printList(String whichOne)
	{

	}

}
