using System;
using System.Collections.Generic;
using System.Reflection;

using log4net;
using Nini.Config;
using OpenMetaverse;

using OpenSim.Framework;
using OpenSim.Region.Environment;
using OpenSim.Region.Environment.Interfaces;
using OpenSim.Region.Environment.Scenes;

namespace HelloWorld
{
    public class HelloWorldModule : IRegionModule
    {
        private static readonly ILog m_log = LogManager.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        List<Scene> m_scenes = new List<Scene>();
        Dictionary<Scene, List<SceneObjectGroup>> scene_prims = new Dictionary<Scene, List<SceneObjectGroup>>();

        int counter = 0;
        bool positive = true;

        #region IRegionModule interface

        public void Initialise(Scene scene, IConfigSource config)
        {
            m_log.Info("[HELLOWORLD] Initializing...");

            m_scenes.Add(scene);
        }

        public void PostInitialise()
        {
            m_scenes[0].EventManager.OnFrame += new EventManager.OnFrameDelegate(OnTick);
            foreach (Scene s in m_scenes)
                DoHelloWorld(s);
        }

        public void Close()
        {
        }

        public string Name
        {
            get { return "Hello World Module"; }
        }

        public bool IsSharedModule
        {
            get { return true; }
        }

        #endregion


        void DoHelloWorld(Scene scene)
        {
            // We're going to write HELLO with prims

            List<SceneObjectGroup> prims = new List<SceneObjectGroup>();
            // First prim: |
            Vector3 pos = new Vector3(120, 128, 30);
            SceneObjectGroup sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(0.3f, 0.3f, 2f);
            prims.Add(sog);

            // Second prim: -
            pos = new Vector3(120.5f, 128f, 30f);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(1, 0.3f, 0.3f);
            prims.Add(sog);

            // Third prim: |
            pos = new Vector3(121, 128, 30);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(0.3f, 0.3f, 2);
            prims.Add(sog);

            // Fourth prim: |
            pos = new Vector3(122, 128, 30);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(0.3f, 0.3f, 2);
            prims.Add(sog);

            // Fifth prim: - (up)
            pos = new Vector3(122.5f, 128, 31);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(1, 0.3f, 0.3f);
            prims.Add(sog);

            // Sixth prim: - (middle)
            pos = new Vector3(122.5f, 128, 30);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(1, 0.3f, 0.3f);
            prims.Add(sog);

            // Seventh prim: - (low)
            pos = new Vector3(122.5f, 128, 29);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(1, 0.3f, 0.3f);
            prims.Add(sog);

            // Eighth prim: | 
            pos = new Vector3(124, 128, 30);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(0.3f, 0.3f, 2);
            prims.Add(sog);

            // Ninth prim: _
            pos = new Vector3(124.5f, 128, 29);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(1, 0.3f, 0.3f);
            prims.Add(sog);

            // Tenth prim: | 
            pos = new Vector3(126, 128, 30);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(0.3f, 0.3f, 2);
            prims.Add(sog);

            // Eleventh prim: _
            pos = new Vector3(126.5f, 128, 29);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(1, 0.3f, 0.3f);
            prims.Add(sog);

            // Twelveth prim: O
            pos = new Vector3(129, 128, 30);
            sog = new SceneObjectGroup(UUID.Zero, pos, PrimitiveBaseShape.CreateBox());
            sog.RootPart.Scale = new Vector3(2, 0.3f, 2); 
            prims.Add(sog);

            // Add these to the managed objects
            scene_prims.Add(scene, prims);

            // Now place them visibly on the scene
            foreach (SceneObjectGroup sogr in prims)
            {
                scene.AddNewSceneObject(sogr, false);
            }
        }

        void OnTick()
        {
            if (counter++ % 50 == 0)
            {
                // Uncomment if you want to see this on your console
                //m_log.Debug("[HELLOWORLD] Tick!");
                foreach (KeyValuePair<Scene, List<SceneObjectGroup>> kvp in scene_prims)
                {
                    foreach (SceneObjectGroup sog in kvp.Value)
                    {
                        if (positive)
                            sog.AbsolutePosition += new Vector3(5, 5, 0);
                        else
                            sog.AbsolutePosition += new Vector3(-5, -5, 0);
                        sog.ScheduleGroupForTerseUpdate();
                    }
                }
                positive = !positive;
            }
        }

    }
}
