from goody import irange

#Queries: return information about lists

def list_sum(alist):
    answer = 0
    for v in alist:
        answer += v
    return answer

def list_max(alist):
    answer = alist[0]
    for v in alist[1:]:
        if v > answer:
            answer = v
    return answer

def list_min_max(alist):  # note return two values by putting them in a list
    min_answer = max_answer = alist[0]
    for v in alist[1:]:
        if v < min_answer:
            min_answer = v
        if v > max_answer:
            max_answer = v
    return [min_answer,max_answer]

def count_predicate(alist,p):
    count = 0
    for v in alist:
        if p(v):
            count += 1
    return count

def sum_predicate(alist,p):
    answer = 0
    for v in alist:
        if p(v):
            answer += v
    return answer

def find_value_predicate(alist,p):
    for v in alist:
        if p(v):
            return v
    return None   # implicitly return None if not explicitly returned

def find_index_predicate(alist,p):
    for i in range(len(alist)):
        if p(alist[i]):
            return i
    return -1

def all_true(alist,p):
    for v in alist:
        if not p(v):
            return False
    return True

def any_true(alist,p):
    for v in alist:
        if p(v):
            return True
    return False

def rank(value,alist):
    return count_predicate(alist, lambda x : x > value)+1

def is_sorted(alist):
    #if len(alist) <= 1:
    #    return True
    
    for i in range(0,len(alist)-1):
        if alist[i] > alist[i+1]:
            return False
    return True



#Commands: return None but mutates/changes list
def list_reverse(alist):
    for i in range(len(alist)//2):
        alist[i], alist[-i-1] = alist[-i-1], alist[i]
    return None # implicitly return None if not explicitly returned


def list_sort(alist):
    def min_index(start):
        answer = start
        for i in range(start+1,len(alist)):
            if alist[i] < alist[answer]:
                answer = i
        return answer
    
    for i in range(len(alist)):
        mi = min_index(i)
        alist[i],alist[mi] = alist[mi],alist[i]
    
    return None # implicitly return None if not explicitly returned
  
    
if __name__ == '__main__':
    import prompt
    while True:
        try:
            exec(prompt.for_string('Command'))
        except Exception as report:
            import traceback
            traceback.print_exc()
