from collections import defaultdict

def count(alist):
    answer = defaultdict(int)
    for v in alist:
        answer[v] += 1
    return answer

def print_dict(adict,key=None,reverse=False):
#    max_len = 0
#    for k in adict:
#        if len(str(k)) > max_len:
#            max_len = len(str(k))
    max_len = max([len(str(k)) for k in adict])
            
    for k,v in sorted(adict.items(), key=key, reverse=reverse):
        print('{k: <{max_len}} -> {v}'.format(k=k, v=v, max_len=max_len))
                
 
def reverse(adict):
    answer = defaultdict(set)
    for k,k_vals in adict.items():
        for v in k_vals:
            answer[v].add(k)
    return answer
 
 
            
if __name__ == '__main__':
    
    # count actually works with anything iterable
    print('Letters by frequency alphabetized')
    print_dict(count('antidisestablishmentarianism'))
    
    words = 'how much wood can a woodchuck chuck if a woodchuck could chuck wood'
    print('\nWords alphabetized')
    print_dict(count(words.split(' ')))
    
    print('\nWords by frequency (decreasing)')
    print_dict(count(words.split(' ')), key=(lambda x : x[1]),reverse=True)
    
    print('\nWords by frequency (increasing, and alphabetized as a minor key)')
    print_dict(count(words.split(' ')), key=(lambda x : (x[1],x[0])))
    
    print('\nStates and residents (unique by set)')
    occupancy    = {'rich' :['IL','PA','CA','WA','PA','CA'],
                    'alex'  : ['WA','PA','AZ','CA','NY'],
                    'mark'  : ['WA','PA','CA','IN','CA'],
                    'ellen' : ['CA','OR','WA','PA','CA'],
                    'patty' : ['WA','PA','OR'],
                    'david' : ['NY','RI','PA','WA'] }
    
    print_dict(reverse(occupancy))
