# This example was taken from John Fox.

library(nlme)
library(lattice)
library(car)

data(Blackmoor)
?Blackmoor
head(Blackmoor)
summary(Blackmoor)

Blackmoor$sqrt.ex <- sqrt(Blackmoor$exercise)
Blackmoor$log.ex <- log(Blackmoor$exercise+5/60, 2)
Blackmoor$time <- Blackmoor$age - 8

time.break <- seq(0, 10, 2)
time.group <- rep(NA, length(time))
for(i in 2:length(time.break)){
	
	time.group[Blackmoor$time< time.break[i] & Blackmoor$time >= time.break[i-1] ] <- i-1
	
}

time.group <- factor(time.group)
levels(time.group) =  c('1', '3', '5', '7', '9')

Blackmoor$time.group <- time.group
rm(time.group)

attach(Blackmoor)

set.seed(10)

# Sampling 20 controls and 20 patients, and plotting their individual trajectories-- time plots. 

con <- sample(unique(subject[group=='control']), 20)
con.20 <- groupedData(sqrt.ex ~ time | subject, data=Blackmoor[is.element(subject, con), ])

pat <- sample(unique(subject[group=='patient']), 20)
pat.20 <- groupedData(sqrt.ex ~ time | subject, data=Blackmoor[is.element(subject, pat), ])

plot(con.20, main='Control Subjects', xlab='Time', ylab='sqrt(Exercise)', ylim=c(0, 5.5), layout=c(5, 4), aspect=0.8)

plot(pat.20, main='Patients', xlab='Time', ylab='sqrt(Exercise)', ylim=c(0, 5.5), layout=c(5, 4), aspect=0.8)

# Spagetti plot

xyplot(sqrt.ex~time | group, group=subject, type='l', xlab='Time', ylab='sqrt(Exercise)', ylim=c(0, 5.5), data=Blackmoor[is.element(subject, c(as.vector(con), as.vector(pat))), ])


# Plot of means

# You can write your own code using the following measurements
n.i <- table(time.group)
m <- by(sqrt.ex, time.group, mean)
se <- by(sqrt.ex, time.group, sd)/sqrt(n.i)


# However, it is easier to use the plotMeans function from Rcmdr package
#source('plotMeans.R')
#plotMeans(sqrt.ex, factor1 = time.group, factor2=group, error.bars='se', ylab='Mean of sqrt(Exercise)', xlab='Time')

# Fitting a seperate lm for each individual

con.list <- lmList(CORT ~ GA + I(GA^2)| subid, subset=group=='LOW', data = data) 

pat.list <- lmList(CORT ~ GA + I(GA^2)| subid, subset=group=='HIGH', data = data) 

con.coef <- coef(con.list)
pat.coef <- coef(pat.list)

par(mfrow=c(1, 2))
boxplot(con.coef[, 1], pat.coef[, 1], names=c('LOW', 'HIGH'), main='Intercepts')

boxplot(con.coef[, 2], pat.coef[, 2], names=c('LOW', 'HIGH'), main='Slopes')

boxplot(con.coef[, 3], pat.coef[, 3], names=c('LOW', 'HIGH'), main='Quad')


# Exploring correlation structure

lm.res <- lm(sqrt.ex~time, data=Blackmoor)

time.group <- ceiling(time)

r = resid(lm.res)
par(mfrow=c(5, 5), mar=c(0.5, 0.5, 0.5, 0.5))

l = unique(time.group)

cor.mat = matrix(NA, 5, 5)

for(i in 1:5){
	for(j in 1:5){
		
		ind1 = unique(subject[time.group==l[i]])
		ind2 = unique(subject[time.group==l[j]])
		
		ind = intersect(ind1, ind2)
		r.sel <- r[is.element(subject, ind)]
		g.sel <- time.group[is.element(subject, ind)]
		
		if(i < j){		
		plot(r.sel[g.sel==l[i]], r.sel[g.sel==l[j]], xlab=l[i], ylab=l[j], cex=0.3, xaxt='n', yaxt='n')
		cor.mat[i, j] = cor(r.sel[g.sel==l[i]], r.sel[g.sel==l[j]])
		}else{
		plot(r.sel[g.sel==l[i]], r.sel[g.sel==l[j]], xlab='', ylab='', type='n', axes=F, xaxt='n', yaxt='n')
		cor.mat[i, j] = cor(r.sel[g.sel==l[i]], r.sel[g.sel==l[j]])
		}
		
	}	
}

# Fitting lme

lme.full <- lme(sqrt.ex ~ time * group, random=~time | subject, method='ML', data = Blackmoor)
summary(lme.full)

# lme.reduced <- lme(sqrt.ex ~ time, random=~time | subject, method='ML', data = Blackmoor)
# summary(lme.reduced)


pdata <- expand.grid(time=seq(0, 10), group=c('control', 'patient'))

pdata$age = pdata$time + 8
pdata$sqrt.ex <- predict(lme.full, pdata, level=0)
pdata$exercise <- (pdata$sqrt.ex)^2



# Diagnosis

n.i <- table(time.group)
m1 <- by(sqrt.ex[group =='control'], time.group[group =='control'], mean)
m2 <- by(sqrt.ex[group =='patient'], time.group[group =='patient'], mean)

plot(pdata$age, pdata$sqrt.ex, type='n', xlab='Age', ylab='Mean of sqrt(Exercise)')
lines(seq(1, 9, 2)+7, m1, type='b', pch=22, lty=2, col='gray' )
lines(seq(1, 9, 2)+7, m2, type='b', pch=19, col='gray')

points(pdata$age[pdata$group=='control'], pdata$sqrt.ex[pdata$group=='control'], type='b', pch=22, lwd=3, lty=2 )
points(pdata$age[pdata$group=='patient'], pdata$sqrt.ex[pdata$group=='patient'], type='b', pch=19, lwd=3 )
legend('topleft', c('Controls', 'Patients'), pch=c(22, 19), lty=c(2, 1), lwd=2)





detach(Blackmoor)