library(mvtnorm)


# Sampling from the prior on y(x)

lambda = 2
eta2 = 2
rho2 = 0.2
sigma2 = 0.1

n = 100
x = runif(n, -3, 3)

diffMatAll = matrix(x, nrow=n, ncol=n) - matrix(x, nrow=n, ncol=n, byrow=TRUE)

# Covariance matrix

# Linear regression model
# C = eta2 + rho2*(x%*%t(x))+ sigma2*diag(1, nrow=n, ncol=n)

# Nonlinear regression model with a different covariance function
C = lambda + eta2*exp(-rho2*(diffMatAll^2))+ sigma2*diag(1, nrow=n, ncol=n)


# Another way of defining C for nonlinear regression models
#C = lambda*exp(-(diffMatAll^2)) + eta2*exp(-rho2*(diffMatAll^2))+ sigma2 *diag(1, nrow=n, ncol=n)



# Sampling from the prior
y = rmvnorm(1, mean = rep(0, n), sigma=C)

plot(x, y)


# Now we observe data and obtain the posterior distribution 

# Generating data

n = 100
x = runif(n, -3, 3)
#y = (1 + 2*x - 3*sin(x)) + rnorm(n, 0, .5)
y = .5*(x^3) - 3*x + 1 + rnorm(n, 0, .5)
plot(x, y)


# Dividing the data into training and test

ind.tr <- sample(n, 70)
ind.te <- setdiff(seq(1, n), ind.tr)

x.tr <- x[ind.tr]
y.tr <- y[ind.tr]
x.te <- x[ind.te]
y.te <- y[ind.te]

nTrain = length(x.tr);
nTest = length(x.te);

# Function to get the posterior predictive probabiltiy
gpReg = function(x.tr, y.tr, x.te, eta2, rho2, sigma2){

x = c(x.tr, x.te);

n = length(x);


diffMatAll = matrix(x, nrow=n, ncol=n) - matrix(x, nrow=n, ncol=n, byrow=TRUE)

C = lambda + eta2*exp(-rho2*(diffMatAll^2))+ sigma2*diag(1, nrow=n, ncol=n);

Ctrn = C[1:nTrain, 1:nTrain];
invCtrn = solve(Ctrn)

K = C[1:nTrain, (nTrain+1):n];
v = C[(nTrain+1):n, (nTrain+1):n];

# E(y.te | y.tr)
y.hat = t(K)%*%invCtrn%*%y.tr;

# Var(y.te | y.te)
v.hat = v - t(K)%*%invCtrn%*%K; 

return(list(y.hat=y.hat, v.hat=v.hat))

}


res = gpReg(x.tr, y.tr, x.te, eta2, rho2, sigma2)

y.hat = res$y.hat
v.hat = res$v.hat

mse = mean((y.te - y.hat)^2)



x.seq <- seq(-3, 3, .01)
res = gpReg(x.tr, y.tr, x.seq, eta2, rho2, sigma2)
y.hat = res$y.hat
v.hat = res$v.hat

lines(x.seq, y.hat)
