/* User:      jihyek
   Date:      Fri May 14 10:49:52 2004
   Target:    default-CGC
   Universe:  H263DecoderStream */

/* Define macro for prototyping functions on ANSI & non-ANSI compilers */
#ifndef ARGS
#if defined(__STDC__) || defined(__cplusplus)
#define ARGS(args) args
#else
#define ARGS(args) ()
#endif
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include "api.h"
//#include "paapi_dvs.h"

/* Define constants TRUE and FALSE for portability */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* Define a complex data type if one has not been defined */
#if !defined(COMPLEX_DATA)
#define COMPLEX_DATA 1
typedef struct complex_data { double real; double imag; } complex;
#endif

#define CGC_MOD(a,b) ((a)>=(b) ? (a-b):(a))

/* define NON_ANSI_COMPILER for compilers without function prototyping */
/* #define NON_ANSI_COMPILER */

#ifdef NON_ANSI_COMPILER
#define _ANSI_ARGS_(x) ()
#else
#define _ANSI_ARGS_(x) x
#endif

#ifndef O_BINARY
#define O_BINARY 0
#endif
/* Some macros */
#define mmax(a, b)        ((a) > (b) ? (a) : (b))
#define mmin(a, b)        ((a) < (b) ? (a) : (b))
#define mnint(a)        ((a) < 0 ? (int)(a - 0.5) : (int)(a + 0.5))
#define sign(a)         ((a) < 0 ? -1 : 1)
#define PSC        1
#define PSC_LENGTH        17
#define SE_CODE                         31

#define ESCAPE                          7167

#define PCT_INTER                       1
#define PCT_INTRA                       0
#define ON                              1
#define OFF                             0
int quiet_46=1;
static char errortext[256];
static void error(char *);
int pict_type_47,newgob_48;
int mv_outside_frame_49,syntax_arith_coding_50,adv_pred_mode_51,pb_frame_52;
int long_vectors_53;
int fault_54;
int verbose_55;
int temp_ref_56, prev_temp_ref_57, quant_58, source_format_59;
#ifdef USE_TIME
int framerate;
#ifndef WIN32
struct timeval tftarget;
#endif
#endif

int trd_60, trb_61, bquant_62;

/* output */
// int outtype;
#define T_YUV      0
#define T_SIF      1
#define T_TGA      2
#define T_PPM      3
#define T_X11      4
#define T_YUV_CONC 5
#define T_WIN      6

struct ld_63 {
  /* bit input */
  int infile;
  unsigned char rdbfr[10000];
  unsigned char *rdptr;
  unsigned char inbfr[16];
  int incnt;
  int bitcnt;
  /* block data */
  short block[12][64];
} base_64,*ld_63;
	int connectionId_65;
#define sign(a)        ((a) < 0 ? -1 : 1)
#define Int(a)          ((a) < 0 ? (int)(a-0.5) : (int)(a))
#define mnint(a)        ((a) < 0 ? (int)(a - 0.5) : (int)(a + 0.5))
#define mfloor(a)       ((a) < 0 ? (int)(a - 0.5) : (int)(a))
#define mmax(a, b)        ((a) > (b) ? (a) : (b))
#define mmin(a, b)        ((a) < (b) ? (a) : (b))
#define limit(x) \
{ \
    if (x > 255) x = 255; \
    if (x <   0)   x = 0; \
}
#define MODE_INTER                      0
#define MODE_INTER_Q                    1
#define MODE_INTER4V                    2
#define MODE_INTRA                      3
#define MODE_INTRA_Q                    4
                struct IntBlock {
                        int data[64];
                };
		static int     zigzag[8][8] = {
				{0, 1, 5, 6,14,15,27,28},
				{2, 4, 7,13,16,26,29,42},
				{3, 8,12,17,25,30,41,43},
				{9,11,18,24,31,40,44,53},
				{10,19,23,32,39,45,52,54},
				{20,22,33,38,46,51,55,60},
				{21,34,37,47,50,56,59,61},
				{35,36,48,49,57,58,62,63},
			};
/**********************************************************/
/* inverse two dimensional DCT, Chen-Wang algorithm       */
/* (cf. IEEE ASSP-32, pp. 803-816, Aug. 1984)             */
/* 32-bit integer arithmetic (8 bit coefficients)         */
/* 11 mults, 29 adds per DCT                              */
/*                                      sE, 18.8.91       */
/**********************************************************/
/* coefficients extended to 12 bit for IEEE1180-1990      */
/* compliance                           sE,  2.1.94       */
/**********************************************************/

/* this code assumes >> to be a two's-complement arithmetic */
/* right shift: (-2)>>1 == -1 , (-3)>>1 == -2               */

#define W1 2841 /* 2048*sqrt(2)*cos(1*pi/16) */
#define W2 2676 /* 2048*sqrt(2)*cos(2*pi/16) */
#define W3 2408 /* 2048*sqrt(2)*cos(3*pi/16) */
#define W5 1609 /* 2048*sqrt(2)*cos(5*pi/16) */
#define W6 1108 /* 2048*sqrt(2)*cos(6*pi/16) */
#define W7 565  /* 2048*sqrt(2)*cos(7*pi/16) */

/* global declarations */
static void init_idct (void);

/* private data */
static short iclip[1024]; /* clipping table */
static short *iclp;

/* private prototypes */
static void idctrow (int *blk);
static void idctcol (int *blk);

/* row (horizontal) IDCT
 *
 *           7                       pi         1
 * dst[k] = sum c[l] * src[l] * cos( -- * ( k + - ) * l )
 *          l=0                      8          2
 *
 * where: c[0]    = 128
 *        c[1..7] = 128*sqrt(2)
 */
		struct Frame {
			char data[MAX_WIDTH*MAX_HEIGHT];
		};
		struct HalfFrame {
			char data[MAX_WIDTH*MAX_HEIGHT/4];
		};
int expand_123 = 0;
int quiet_124 = 1;

int convmat_125[8][4]
=
{
  {117504, 138453, 13954, 34903}, /* no sequence_display_extension */
  {117504, 138453, 13954, 34903}, /* ITU-R Rec. 709 (1990) */
  {104597, 132201, 25675, 53279}, /* unspecified */
  {104597, 132201, 25675, 53279}, /* reserved */
  {104448, 132798, 24759, 53109}, /* FCC */
  {104597, 132201, 25675, 53279}, /* ITU-R Rec. 624-4 System B, G */
  {104597, 132201, 25675, 53279}, /* SMPTE 170M */
  {117579, 136230, 16907, 35559}  /* SMPTE 240M (1987) */
};
unsigned char *clp_126;
unsigned char clpGlobal_127[1024];
typedef struct {
  int val, len;
} VLCtab;

typedef struct {
  char run, level, len;
} DCTtab;


static VLCtab TMNMVtab0[] = {
{3,4}, {61,4}, {2,3}, {2,3}, {62,3}, {62,3},
{1,2}, {1,2}, {1,2}, {1,2}, {63,2}, {63,2}, {63,2}, {63,2}
};

static VLCtab TMNMVtab1[] = {
{12,10}, {52,10}, {11,10}, {53,10}, {10,9}, {10,9},
{54,9}, {54,9}, {9,9}, {9,9}, {55,9}, {55,9},
{8,9}, {8,9}, {56,9}, {56,9}, {7,7}, {7,7},
{7,7}, {7,7}, {7,7}, {7,7}, {7,7}, {7,7},
{57,7}, {57,7}, {57,7}, {57,7}, {57,7}, {57,7},
{57,7}, {57,7}, {6,7}, {6,7}, {6,7}, {6,7},
{6,7}, {6,7}, {6,7}, {6,7}, {58,7}, {58,7},
{58,7}, {58,7}, {58,7}, {58,7}, {58,7}, {58,7},
{5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7},
{5,7}, {5,7}, {59,7}, {59,7}, {59,7}, {59,7},
{59,7}, {59,7}, {59,7}, {59,7}, {4,6}, {4,6},
{4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6},
{4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6},
{4,6}, {4,6}, {60,6}, {60,6},{60,6},{60,6},
{60,6},{60,6},{60,6},{60,6},{60,6},{60,6},
{60,6},{60,6},{60,6},{60,6},{60,6},{60,6}
};

static VLCtab TMNMVtab2[] = {
{32,12}, {31,12}, {33,12}, {30,11}, {30,11}, {34,11},
{34,11}, {29,11}, {29,11}, {35,11}, {35,11}, {28,11},
{28,11}, {36,11}, {36,11}, {27,11}, {27,11}, {37,11},
{37,11}, {26,11}, {26,11}, {38,11}, {38,11}, {25,11},
{25,11}, {39,11}, {39,11}, {24,10}, {24,10}, {24,10},
{24,10}, {40,10}, {40,10}, {40,10}, {40,10}, {23,10},
{23,10}, {23,10}, {23,10}, {41,10}, {41,10}, {41,10},
{41,10}, {22,10}, {22,10}, {22,10}, {22,10}, {42,10},
{42,10}, {42,10}, {42,10}, {21,10}, {21,10}, {21,10},
{21,10}, {43,10}, {43,10}, {43,10}, {43,10}, {20,10},
{20,10}, {20,10}, {20,10}, {44,10}, {44,10}, {44,10},
{44,10}, {19,10}, {19,10}, {19,10}, {19,10}, {45,10},
{45,10}, {45,10}, {45,10}, {18,10}, {18,10}, {18,10},
{18,10}, {46,10}, {46,10}, {46,10}, {46,10}, {17,10},
{17,10}, {17,10}, {17,10}, {47,10}, {47,10}, {47,10},
{47,10}, {16,10}, {16,10}, {16,10}, {16,10}, {48,10},
{48,10}, {48,10}, {48,10}, {15,10}, {15,10}, {15,10},
{15,10}, {49,10}, {49,10}, {49,10}, {49,10}, {14,10},
{14,10}, {14,10}, {14,10}, {50,10}, {50,10}, {50,10},
{50,10}, {13,10}, {13,10}, {13,10}, {13,10}, {51,10},
{51,10}, {51,10}, {51,10}
};


static VLCtab MCBPCtab[] = {
{-1,0},
{255,9}, {52,9}, {36,9}, {20,9}, {49,9}, {35,8}, {35,8}, {19,8}, {19,8},
{50,8}, {50,8}, {51,7}, {51,7}, {51,7}, {51,7}, {34,7}, {34,7}, {34,7},
{34,7}, {18,7}, {18,7}, {18,7}, {18,7}, {33,7}, {33,7}, {33,7}, {33,7},
{17,7}, {17,7}, {17,7}, {17,7}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6},
{4,6}, {4,6}, {4,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6},
{48,6}, {48,6}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5},
{3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5},
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4},
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4},
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4},
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {16,4}, {16,4}, {16,4}, {16,4},
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4},
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4},
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4},
{16,4}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3},
};



static VLCtab MCBPCtabintra[] = {
{-1,0},
{20,6}, {36,6}, {52,6}, {4,4}, {4,4}, {4,4},
{4,4}, {19,3}, {19,3}, {19,3}, {19,3}, {19,3},
{19,3}, {19,3}, {19,3}, {35,3}, {35,3}, {35,3},
{35,3}, {35,3}, {35,3}, {35,3}, {35,3}, {51,3},
{51,3}, {51,3}, {51,3}, {51,3}, {51,3}, {51,3},
{51,3},
};



static VLCtab CBPYtab[48] =
{ {-1,0}, {-1,0}, {9,6}, {6,6}, {7,5}, {7,5}, {11,5}, {11,5},
  {13,5}, {13,5}, {14,5}, {14,5}, {15,4}, {15,4}, {15,4}, {15,4},
  {3,4}, {3,4}, {3,4}, {3,4}, {5,4},{5,4},{5,4},{5,4},
  {1,4}, {1,4}, {1,4}, {1,4}, {10,4}, {10,4}, {10,4}, {10,4},
  {2,4}, {2,4}, {2,4}, {2,4}, {12,4}, {12,4}, {12,4}, {12,4},
  {4,4}, {4,4}, {4,4}, {4,4}, {8,4}, {8,4}, {8,4}, {8,4},
};


static VLCtab DCT3Dtab0[] = {
{4225,7}, {4209,7}, {4193,7}, {4177,7}, {193,7}, {177,7},
{161,7}, {4,7}, {4161,6}, {4161,6}, {4145,6}, {4145,6},
{4129,6}, {4129,6}, {4113,6}, {4113,6}, {145,6}, {145,6},
{129,6}, {129,6}, {113,6}, {113,6}, {97,6}, {97,6},
{18,6}, {18,6}, {3,6}, {3,6}, {81,5}, {81,5},
{81,5}, {81,5}, {65,5}, {65,5}, {65,5}, {65,5},
{49,5}, {49,5}, {49,5}, {49,5}, {4097,4}, {4097,4},
{4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {17,3}, {17,3}, {17,3}, {17,3},
{17,3}, {17,3}, {17,3}, {17,3}, {17,3}, {17,3},
{17,3}, {17,3}, {17,3}, {17,3}, {17,3}, {17,3},
{33,4}, {33,4}, {33,4}, {33,4}, {33,4}, {33,4},
{33,4}, {33,4}, {2,4}, {2,4},{2,4},{2,4},
{2,4}, {2,4},{2,4},{2,4},
};


static VLCtab DCT3Dtab1[] = {
{9,10}, {8,10}, {4481,9}, {4481,9}, {4465,9}, {4465,9},
{4449,9}, {4449,9}, {4433,9}, {4433,9}, {4417,9}, {4417,9},
{4401,9}, {4401,9}, {4385,9}, {4385,9}, {4369,9}, {4369,9},
{4098,9}, {4098,9}, {353,9}, {353,9}, {337,9}, {337,9},
{321,9}, {321,9}, {305,9}, {305,9}, {289,9}, {289,9},
{273,9}, {273,9}, {257,9}, {257,9}, {241,9}, {241,9},
{66,9}, {66,9}, {50,9}, {50,9}, {7,9}, {7,9},
{6,9}, {6,9}, {4353,8}, {4353,8}, {4353,8}, {4353,8},
{4337,8}, {4337,8}, {4337,8}, {4337,8}, {4321,8}, {4321,8},
{4321,8}, {4321,8}, {4305,8}, {4305,8}, {4305,8}, {4305,8},
{4289,8}, {4289,8}, {4289,8}, {4289,8}, {4273,8}, {4273,8},
{4273,8}, {4273,8}, {4257,8}, {4257,8}, {4257,8}, {4257,8},
{4241,8}, {4241,8}, {4241,8}, {4241,8}, {225,8}, {225,8},
{225,8}, {225,8}, {209,8}, {209,8}, {209,8}, {209,8},
{34,8}, {34,8}, {34,8}, {34,8}, {19,8}, {19,8},
{19,8}, {19,8}, {5,8}, {5,8}, {5,8}, {5,8},
};

static VLCtab DCT3Dtab2[] = {
{4114,11}, {4114,11}, {4099,11}, {4099,11}, {11,11}, {11,11},
{10,11}, {10,11}, {4545,10}, {4545,10}, {4545,10}, {4545,10},
{4529,10}, {4529,10}, {4529,10}, {4529,10}, {4513,10}, {4513,10},
{4513,10}, {4513,10}, {4497,10}, {4497,10}, {4497,10}, {4497,10},
{146,10}, {146,10}, {146,10}, {146,10}, {130,10}, {130,10},
{130,10}, {130,10}, {114,10}, {114,10}, {114,10}, {114,10},
{98,10}, {98,10}, {98,10}, {98,10}, {82,10}, {82,10},
{82,10}, {82,10}, {51,10}, {51,10}, {51,10}, {51,10},
{35,10}, {35,10}, {35,10}, {35,10}, {20,10}, {20,10},
{20,10}, {20,10}, {12,11}, {12,11}, {21,11}, {21,11},
{369,11}, {369,11}, {385,11}, {385,11}, {4561,11}, {4561,11},
{4577,11}, {4577,11}, {4593,11}, {4593,11}, {4609,11}, {4609,11},
{22,12}, {36,12}, {67,12}, {83,12}, {99,12}, {162,12},
{401,12}, {417,12}, {4625,12}, {4641,12}, {4657,12}, {4673,12},
{4689,12}, {4705,12}, {4721,12}, {4737,12}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, };

/* to mask the n least significant bits of an integer */

static unsigned int msk[33] =
{
  0x00000000,0x00000001,0x00000003,0x00000007,
  0x0000000f,0x0000001f,0x0000003f,0x0000007f,
  0x000000ff,0x000001ff,0x000003ff,0x000007ff,
  0x00000fff,0x00001fff,0x00003fff,0x00007fff,
  0x0000ffff,0x0001ffff,0x0003ffff,0x0007ffff,
  0x000fffff,0x001fffff,0x003fffff,0x007fffff,
  0x00ffffff,0x01ffffff,0x03ffffff,0x07ffffff,
  0x0fffffff,0x1fffffff,0x3fffffff,0x7fffffff,
  0xffffffff
};


/* initialize buffer, call once before first getbits or showbits */
// #define _READ_OPTIMIZE
static void initbits()
{
  ld_63->incnt = 0;
  ld_63->rdptr = ld_63->rdbfr + 2048;
  ld_63->bitcnt = 0;
#ifdef _READ_OPTIMIZE
  ld_63->rdptr = ld_63->rdbfr;
#endif
}

static void fillbfr()
{
  int l;
  int remainedSize = 2048;
  void* bufAddress = ld_63->rdbfr;

  ld_63->inbfr[0] = ld_63->inbfr[8];
  ld_63->inbfr[1] = ld_63->inbfr[9];
  ld_63->inbfr[2] = ld_63->inbfr[10];
  ld_63->inbfr[3] = ld_63->inbfr[11];

  if (ld_63->rdptr>=ld_63->rdbfr+2048)
  {
//	usleep(5);

    while(remainedSize>0) {
    	l = read(connectionId_65,bufAddress+(2048-remainedSize),remainedSize);
	if(l>0)
		remainedSize -= l;
	else
		break;
    }
		
    l = 2048-remainedSize;

    if(l==0) {
	    exit(1);
    }

    //printf("read %d\n",l);
    
    ld_63->rdptr = ld_63->rdbfr;
    if (l<2048)
    {
      if (l<0)
        l = 0;

      while (l<2048)   /* Add recognizable sequence end code */
      {
        ld_63->rdbfr[l++] = 0;
        ld_63->rdbfr[l++] = 0;
        ld_63->rdbfr[l++] = (1<<7) | (SE_CODE<<2);
      }
    }
  }

  for (l=0; l<8; l++)
    ld_63->inbfr[l+4] = ld_63->rdptr[l];

  ld_63->rdptr+= 8;
  ld_63->incnt+= 64;
}


/* return next n bits (right adjusted) without advancing */


#ifdef _READ_OPTIMIZE
#define _SWAP(a) ((a[0] << 24) | (a[1] << 16) | (a[2] << 8) | a[3])

static unsigned int showbits (int n)
{
        unsigned char *v = ld_63->rdptr;
        int rbit = 32 - ld_63->bitcnt;
        unsigned int b;

        b = _SWAP(v);
        return ((b & msk[rbit]) >> (rbit-n));
}

#else 
static unsigned int showbits(int n)
{
  unsigned char *v;
  unsigned int b;
  int c;

  if (ld_63->incnt<n)
    fillbfr();

  v = ld_63->inbfr + ((96 - ld_63->incnt)>>3);
  b = (v[0]<<24) | (v[1]<<16) | (v[2]<<8) | v[3];
  c = ((ld_63->incnt-1) & 7) + 25;
  return (b>>(c-n)) & msk[n];
}
#endif 

/* advance by n bits */

#ifdef _READ_OPTIMIZE 
static void flushbits (int n)
{
        ld_63->bitcnt += n;
        if (ld_63->bitcnt >= 8) {
                ld_63->rdptr += ld_63->bitcnt / 8;
                ld_63->bitcnt = ld_63->bitcnt % 8;
        }
}

#else
static void flushbits(int n)
{

  ld_63->bitcnt+= n;
  ld_63->incnt-= n;
  if (ld_63->incnt < 0)
    fillbfr();
}
#endif

/* return next n bits (right adjusted) */

static unsigned int getbits(int n)
{
  unsigned int l;

  l = showbits(n);
  flushbits(n);

  return l;
}

/* return next bit (could_63 be made faster than getbits(1)) */

static unsigned int getbits1()
{
  return getbits(1);
}
static void error(char *text)
{
  fprintf(stderr,text);
  exit(1);
}

/* trace output */
static void printbits(int code,int bits,int len)
{
  int i;
  for (i=0; i<len; i++)
    printf("%d",(code>>(bits-1-i))&1);
}
static int getTMNMV()
{
  int code;

  if (0)
    printf("motion_code (");

  if (getbits1())
  {
    if (0)
      printf("1): 0\n");
    return 0;
  }

  if ((code = showbits(12))>=512)
  {
    code = (code>>8) - 2;
    flushbits(TMNMVtab0[code].len);

    if (0)
    {
      printf("0");
      printbits(code+2,4,TMNMVtab0[code].len);
      printf("): %d\n", TMNMVtab0[code].val);
    }

    return TMNMVtab0[code].val;
  }

  if (code>=128)
  {
    code = (code>>2) -32;
    flushbits(TMNMVtab1[code].len);

    if (0)
    {
      printf("0");
      printbits(code+32,10,TMNMVtab1[code].len);
      printf("): %d\n",TMNMVtab1[code].val);
    }

    return TMNMVtab1[code].val;
  }

  if ((code-=5)<0)
  {
    if (!quiet_46)
      fprintf(stderr,"Invalid motion_vector code\n");
    fault_54=1;
    return 0;
  }

  flushbits(TMNMVtab2[code].len);

  if (0)
  {
    printf("0");
    printbits(code+5,12,TMNMVtab2[code].len);
    printf("): %d\n",TMNMVtab2[code].val);
  }

  return TMNMVtab2[code].val;
}


static int getMCBPC()
{
  int code;

  if (0)
    printf("MCBPC (");

  code = showbits(9);

  if (code == 1) {
    /* macroblock stuffing */
    if (0)
      printf("000000001): stuffing\n");
    flushbits(9);
    return 255;
  }

  if (code == 0) {
    if (!quiet_46)
      fprintf(stderr,"Invalid MCBPC code\n");
    fault_54 = 1;
    return 0;
  }

  if (code>=256)
  {
    flushbits(1);
    if (0)
      printf("1): %d\n",0);
    return 0;
  }

  flushbits(MCBPCtab[code].len);

  if (0)
  {
    printbits(code,9,MCBPCtab[code].len);
    printf("): %d\n",MCBPCtab[code].val);
  }

  return MCBPCtab[code].val;
}

static int getMODB()
{
  int code;
  int MODB;

  if (0)
    printf("MODB (");

  code = showbits(2);

  if (code < 2) {
    if (0)
      printf("0): MODB = 0\n");
    MODB = 0;
    flushbits(1);
  }
  else if (code == 2) {
    if (0)
      printf("10): MODB = 1\n");
    MODB = 1;
    flushbits(2);
  }
  else { /* code == 3 */
    if (0)
      printf("11): MODB = 2\n");
    MODB = 2;
    flushbits(2);
  }
  return MODB;
}


static int getMCBPCintra()
{
  int code;

  if (0)
    printf("MCBPCintra (");

  code = showbits(9);

  if (code == 1) {
    /* macroblock stuffing */
    if (0)
      printf("000000001): stuffing\n");
    flushbits(9);
    return 255;
  }

  if (code < 8) {
    if (!quiet_46)
      fprintf(stderr,"Invalid MCBPCintra code\n");
    fault_54 = 1;
    return 0;
  }

  code >>= 3;

  if (code>=32)
  {
    flushbits(1);
    if (0)
      printf("1): %d\n",3);
    return 3;
  }

  flushbits(MCBPCtabintra[code].len);

  if (0)
  {
    printbits(code,6,MCBPCtabintra[code].len);
    printf("): %d\n",MCBPCtabintra[code].val);
  }

  return MCBPCtabintra[code].val;
}

static int getCBPY()
{
  int code;

  if (0)
    printf("CBPY (");

  code = showbits(6);
  if (code < 2) {
    if (!quiet_46)
      fprintf(stderr,"Invalid CBPY code\n");
    fault_54 = 1;
    return -1;
  }

  if (code>=48)
  {
    flushbits(2);
    if (0)
      printf("11): %d\n",0);
    return 0;
  }

  flushbits(CBPYtab[code].len);

  if (0)
  {
    printbits(code,6,CBPYtab[code].len);
    printf("): %d\n",CBPYtab[code].val);
  }

  return CBPYtab[code].val;
}
/* private prototypes */
static void getpicturehdr _ANSI_ARGS_((void));


/* align to start of next startcode */

static void startcode()
{
  /* search for new picture start code */
  while (showbits(PSC_LENGTH)!=1l)
         flushbits(1);
}

/* decode picture header */

static void getpicturehdr()
{
  int pos, pei, tmp;

  pos = ld_63->bitcnt;
  prev_temp_ref_57 = temp_ref_56;
  temp_ref_56 = getbits(8);
  trd_60 = temp_ref_56 - prev_temp_ref_57;

  if (trd_60 < 0)
    trd_60 += 256;

  tmp = getbits(1); /* always "1" */
  if (!tmp)
    if (!quiet_46)
      printf("warning: spare in picture header should_63 be \"1\"\n");
  tmp = getbits(1); /* always "0" */
  if (tmp)
    if (!quiet_46)
      printf("warning: H.261 distinction bit should_63 be \"0\"\n");
  tmp = getbits(1); /* split_screen_indicator */
  if (tmp) {
    if (!quiet_46)
      printf("error: split-screen not supported in this version\n");
    exit (-1);
  }
  tmp = getbits(1); /* document_camera_indicator */
  if (tmp)
    if (!quiet_46)
      printf("warning: document camera indicator not supported in this version\n");

  tmp = getbits(1); /* freeze_picture_release */
  if (tmp)
    if (!quiet_46)
      printf("warning: frozen picture not supported in this version\n");

  source_format_59 = getbits(3);
  pict_type_47 = getbits(1);
  mv_outside_frame_49 = getbits(1);
  long_vectors_53 = (mv_outside_frame_49 ? 1 : 0);
  syntax_arith_coding_50 = getbits(1);
  adv_pred_mode_51 = getbits(1);
  mv_outside_frame_49 = (adv_pred_mode_51 ? 1 : mv_outside_frame_49);
  pb_frame_52 = getbits(1);
  quant_58 = getbits(5);
  tmp = getbits(1);
  if (tmp) {
    if (!quiet_46)
      printf("error: CPM not supported in this version\n");
    exit(-1);
  }

  if (pb_frame_52) {
    trb_61 = getbits(3);
    bquant_62 = getbits(2);
  }
  else {
    trb_61 = 0;
  }

#ifdef USE_TIME
  if (framerate > 0 && trd_60 > 0)
    doframerate(0);
#endif

  pei = getbits(1);
pspare:
  if (pei) {
     /* extra info for possible future backward compatible additions */
    getbits(8);  /* not used */
    pei = getbits(1);
    if (pei) goto pspare; /* keep on reading pspare until pei=0 */
  }


  if (verbose_55>0) {
    /*printf("picture header (byte %d)\n",(pos>>3)-4);*/
    if (verbose_55>1) {
      printf("  temp_ref=%d\n",temp_ref_56);
      /*printf("  pict_type_47=%d\n",pict_type_47);
      printf("  source_format=%d\n", source_format_59);
      printf("  quant=%d\n",quant_58);
      if (syntax_arith_coding_50)
        printf("  SAC coding mode used \n");
      if (mv_outside_frame_49)
        printf("  unrestricted motion vector mode used\n");
      if (adv_pred_mode_51)
        printf("  advanced prediction mode used\n");*/
      if (pb_frame_52) {
        /*printf("  pb-frames mode used\n");*/
        printf("  trb=%d\n",trb_61);
        /*printf("  bquant=%d\n", bquant_62);*/
      }
    }
  }
}

/*
 * decode headers from one input stream
 * until an End of Sequence or picture start code
 * is found
 */

static int getheader()
{
  unsigned int code, gob;

  /* look for startcode */
  startcode();
  code = getbits(PSC_LENGTH);
  gob = getbits(5);
  if (gob == SE_CODE)
    return 0;
  if (gob == 0) {
    getpicturehdr();
  }
  return gob + 1;
}

	/* Modified by Hyunok Oh : 2002/02/04 */
/* private prototypes*/
static void clearblock _ANSI_ARGS_((int comp));
static int motion_decode _ANSI_ARGS_((int vec,int pmv));

/* set block to zero */

static void clearblock(int comp)
{
  int *bp;
  int i;

  bp = (int *)ld_63->block[comp];

  for (i=0; i<8; i++)
  {
    bp[0] = bp[1] = bp[2] = bp[3] = 0;
    bp += 4;
  }
}

static int motion_decode(int vec,int pmv)
{
  if (vec > 31) vec -= 64;
  vec += pmv;

  if (vec > 31)
    vec -= 64;
  if (vec < -32)
    vec += 64;

  return vec;
}
/* Modified by Hyunok Oh 2002/02/04 */
static void getblock(int comp, int mode)
{
  int val, i, j, sign;
  unsigned int code;
  VLCtab *tab;
  short *bp;
  int run, last, level, QP;
  short *qval;

  bp = ld_63->block[comp];

  /* decode AC coefficients */
  for (i=(mode==0); ; i++) {
    code = showbits(12);
    if (code>=512)
      tab = &DCT3Dtab0[(code>>5)-16];
    else if (code>=128)
      tab = &DCT3Dtab1[(code>>2)-32];
    else if (code>=8)
      tab = &DCT3Dtab2[(code>>0)-8];
    else {
      if (!quiet_46)
        fprintf(stderr,"invalid Huffman code in getblock()\n");
      fault_54 = 1;
      return;
    }

    flushbits(tab->len);

    run = (tab->val >> 4) & 255;
    level = tab->val & 15;
    last = (tab->val >> 12) & 1;

    if (0) {
      printf(" (");
      printbits(code,12,tab->len);
    }

   if (tab->val==ESCAPE) { /* escape */
      if (0) {
        putchar(' ');
        printbits(showbits(1),1,1);
      }
      last = getbits1();
      if (0) {
        putchar(' ');
        printbits(showbits(6),6,6);
      }
      i += run = getbits(6);
      if (0) {
        putchar(' ');
        printbits(showbits(8),8,8);
      }
      level = getbits(8);

      if ((sign = (level>=128)))
        val = 256 - level;
      else
        val = level;
    }
    else {
      i+= run;
      val = level;
      sign = getbits(1);
      if (0)
        printf("%d",sign);
    }

    if (i >= 64)
    {
      if (!quiet_46)
        fprintf(stderr,"DCT coeff index (i) out of bounds\n");
      fault_54 = 1;
      return;
    }

    if (0)
      printf("): %d/%d\n",run,sign ? -val : val);

    /* H. Oh modified */
    bp[i] = sign ? -val : val;

    if (last) { /* That's it */
      if (0)
        printf("last\n");
      return;
    }
  }
}
static void FindPMV(int dx1, int dy1, int dx2, int dy2, int dx3, int dy3,
int x, int y, int *pmv0, int *pmv1)
{
  if(x==0) { /* case 1: left GOB border */
     dx1 = dy1 = 0;
  }
  if(y==0) { /* case 2: upper GOB border */
     dx2 = dx3 = dx1;
     dy2 = dy3 = dy1;
  }
  if(x==gFrameWidth/16 - 1) { /* case 3: right GOB border */
     dx3 = dy3 = 0;
  }

  *pmv0 = dx1+dx2+dx3 - mmax(dx1,mmax(dx2,dx3)) - mmin(dx1,mmin(dx2,dx3));
  *pmv1 = dy1+dy2+dy3 - mmax(dy1,mmax(dy2,dy3)) - mmin(dy1,mmin(dy2,dy3));

  return;
}
		static void doDeQuantizer(int* rcoeff, int* qcoeff, int QP, int theMode){
  int i;

  if (QP) {
    for (i = 0; i < 64; i++) {
      if (qcoeff[i]) {
        if ((QP % 2) == 1)
          rcoeff[i] = QP * (2*abs(qcoeff[i]) + 1);
        else
          rcoeff[i] = QP * (2*abs(qcoeff[i]) + 1) - 1;
        rcoeff[i] = sign(qcoeff[i]) * rcoeff[i];
      }
      else
        rcoeff[i] = 0;
    }
    if (theMode == MODE_INTRA || theMode == MODE_INTRA_Q) { /* Intra */
      rcoeff[0] = qcoeff[0]*8;
    }
  }
  else {
    /* No quantizing at all */
    for (i = 0; i < 64; i++) {
      rcoeff[i] = qcoeff[i];
    }
  }
  return;
        }
		static void doInvZigzag(int* outImg, int* inImg)
		{
			int i,j;
			for(i=0; i<8; i++)
				for(j=0; j<8; j++)
					outImg[i*8+j] = inImg[zigzag[i][j]];
		}
static void idctrow(int* blk)
{
  int x0, x1, x2, x3, x4, x5, x6, x7, x8;

  /* shortcut */
  if (!((x1 = blk[4]<<11) | (x2 = blk[6]) | (x3 = blk[2]) |
        (x4 = blk[1]) | (x5 = blk[7]) | (x6 = blk[5]) | (x7 = blk[3])))
  {
    blk[0]=blk[1]=blk[2]=blk[3]=blk[4]=blk[5]=blk[6]=blk[7]=blk[0]<<3;
    return;
  }

  x0 = (blk[0]<<11) + 128; /* for proper rounding in the fourth stage */

  /* first stage */
  x8 = W7*(x4+x5);
  x4 = x8 + (W1-W7)*x4;
  x5 = x8 - (W1+W7)*x5;
  x8 = W3*(x6+x7);
  x6 = x8 - (W3-W5)*x6;
  x7 = x8 - (W3+W5)*x7;

  /* second stage */
  x8 = x0 + x1;
  x0 -= x1;
  x1 = W6*(x3+x2);
  x2 = x1 - (W2+W6)*x2;
  x3 = x1 + (W2-W6)*x3;
  x1 = x4 + x6;
  x4 -= x6;
  x6 = x5 + x7;
  x5 -= x7;

  /* third stage */
  x7 = x8 + x3;
  x8 -= x3;
  x3 = x0 + x2;
  x0 -= x2;
  x2 = (181*(x4+x5)+128)>>8;
  x4 = (181*(x4-x5)+128)>>8;

  /* fourth stage */
  blk[0] = (x7+x1)>>8;
  blk[1] = (x3+x2)>>8;
  blk[2] = (x0+x4)>>8;
  blk[3] = (x8+x6)>>8;
  blk[4] = (x8-x6)>>8;
  blk[5] = (x0-x4)>>8;
  blk[6] = (x3-x2)>>8;
  blk[7] = (x7-x1)>>8;
}

/* column (vertical) IDCT
 *
 *             7                         pi         1
 * dst[8*k] = sum c[l] * src[8*l] * cos( -- * ( k + - ) * l )
 *            l=0                        8          2
 *
 * where: c[0]    = 1/1024
 *        c[1..7] = (1/1024)*sqrt(2)
 */
static void idctcol(int *blk)
{
  int x0, x1, x2, x3, x4, x5, x6, x7, x8;

  /* shortcut */
  if (!((x1 = (blk[8*4]<<8)) | (x2 = blk[8*6]) | (x3 = blk[8*2]) |
        (x4 = blk[8*1]) | (x5 = blk[8*7]) | (x6 = blk[8*5]) | (x7 = blk[8*3])))
  {
    blk[8*0]=blk[8*1]=blk[8*2]=blk[8*3]=blk[8*4]=blk[8*5]=blk[8*6]=blk[8*7]=
      iclp[(blk[8*0]+32)>>6];
    return;
  }

  x0 = (blk[8*0]<<8) + 8192;

  /* first stage */
  x8 = W7*(x4+x5) + 4;
  x4 = (x8+(W1-W7)*x4)>>3;
  x5 = (x8-(W1+W7)*x5)>>3;
  x8 = W3*(x6+x7) + 4;
  x6 = (x8-(W3-W5)*x6)>>3;
  x7 = (x8-(W3+W5)*x7)>>3;

  /* second stage */
  x8 = x0 + x1;
  x0 -= x1;
  x1 = W6*(x3+x2) + 4;
  x2 = (x1-(W2+W6)*x2)>>3;
  x3 = (x1+(W2-W6)*x3)>>3;
  x1 = x4 + x6;
  x4 -= x6;
  x6 = x5 + x7;
  x5 -= x7;

  /* third stage */
  x7 = x8 + x3;
  x8 -= x3;
  x3 = x0 + x2;
  x0 -= x2;
  x2 = (181*(x4+x5)+128)>>8;
  x4 = (181*(x4-x5)+128)>>8;

  /* fourth stage */
  blk[8*0] = iclp[(x7+x1)>>14];
  blk[8*1] = iclp[(x3+x2)>>14];
  blk[8*2] = iclp[(x0+x4)>>14];
  blk[8*3] = iclp[(x8+x6)>>14];
  blk[8*4] = iclp[(x8-x6)>>14];
  blk[8*5] = iclp[(x0-x4)>>14];
  blk[8*6] = iclp[(x3-x2)>>14];
  blk[8*7] = iclp[(x7-x1)>>14];
}

/* two dimensional inverse discrete cosine transform */
static void doIDCT(int* outBlock, int* inBlock)
{
  int i;

  for (i=0; i<64; i++)
     outBlock[i] = inBlock[i];

  for (i=0; i<8; i++)
    idctrow(outBlock+8*i);

  for (i=0; i<8; i++)
    idctcol(outBlock+i);
}

static void init_idct()
{
  int i;

  iclp = iclip+512;
  for (i= -512; i<512; i++)
    iclp[i] = (i<-256) ? -256 : ((i>255) ? 255 : i);
}
static void reconBlockIntoImage(int x, int y, int dx, int dy, 
unsigned char *prevImage, int *data, 
unsigned char *outImage, int width)
{
  int m,n;
  int x_half = dx % 2;
  int y_half = dy % 2;
  unsigned char *outBlock;
  unsigned char *prevBlock;
  
  outBlock = outImage+y*width+x;
  prevBlock = prevImage+(y+dy/2)*width+x+dx/2;

  if(!x_half && !y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        int pixel = (int)prevBlock[width*n+m];
        pixel += data[8*n+m];
        pixel = mmin(255,mmax(0,pixel));
        outBlock[width*n+m] = (unsigned char)pixel;
      }
    }
  } else if(x_half && !y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        int pixel = ((int)prevBlock[width*n+m] + (int)prevBlock[width*n+m+x_half]+1)>>1;
        pixel += data[8*n+m];
        pixel = mmin(255,mmax(0,pixel));
        outBlock[width*n+m] = (unsigned char)pixel;
      }
    }
  } else if(!x_half && y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        int pixel = ((int)prevBlock[width*n+m] + (int)prevBlock[width*(n+y_half)+m]+1)>>1;
        pixel += data[8*n+m];
        pixel = mmin(255,mmax(0,pixel));
        outBlock[width*n+m] = (unsigned char)pixel;
      }
    }
  } else {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        int pixel = ((int)prevBlock[width*n+m] + (int)prevBlock[width*(n+y_half)+m] + (int)prevBlock[width*n+m+x_half] + (int)prevBlock[width*(n+y_half)+m+x_half]+2)>>2;
        pixel += data[8*n+m];
        pixel = mmin(255,mmax(0,pixel));
        outBlock[width*n+m] = (unsigned char)pixel;
      }
    }
  }
}
static void copyBlockIntoImage(int x, int y, int *data, unsigned char *outImage, int width)
{
  int m,n;
  unsigned char *outBlock;

  outBlock = outImage+y*width+x;

  for (n = 0; n < 8; n++) {
    for (m = 0; m < 8; m++) {
      outBlock[width*n+m] = (unsigned char)mmin(255,mmax(0,data[8*n+m]));
    }
  }
}
#ifdef WINDOWS

#include <windows.h>
#include <process.h>
#include <vfw.h>
#include <memory.h>


typedef struct
{
  HANDLE hThread;
  HANDLE hEvent;
  HWND hWnd;
  MSG msg;
  WNDCLASS wc;
  HDRAWDIB hDrawDib;
  HDC hDC;
  BITMAPINFOHEADER biHeader;
  char lpszAppName[15];
  DWORD dwThreadID;
  BOOL imageIsReady;
  unsigned char *bufRGB;
  RECT rect;
  unsigned char *src[3];

  int width, height;
  int zoom, oldzoom;
  int windowDismissed;

} T_VDWINDOW;


#define VIDEO_BEGIN                         (WM_USER + 0)
#define VIDEO_DRAW_FRAME          (WM_USER + 1)
#define VIDEO_REDRAW_FRAME      (WM_USER + 2)
#define VIDEO_END                             (WM_USER + 3)


int initDisplay (int pels, int lines);
int displayImage (unsigned char *lum, unsigned char *Cr, unsigned char *Cb);
int closeDisplay ();

void DisplayWinMain (void *);
LONG APIENTRY MainWndProc (HWND, UINT, UINT, LONG);
int DrawDIB ();
void init_dither_tab();
void ConvertYUVtoRGB(
  unsigned char *src0,
  unsigned char *src1,
  unsigned char *src2,
  unsigned char *dst_ori,
  int width,
  int height
);
int InitDisplayWindowThread ();

#endif
#ifdef WINDOWS

/* vdinit.c */

T_VDWINDOW vdWindow;

static int initDisplay (int pels, int lines)
{
  int errFlag = 0;

  init_dither_tab();
  errFlag |= InitDisplayWindowThread (pels, lines);

  return errFlag;
}


static int InitDisplayWindowThread (int width, int height)
{
  int errFlag = 0;

  /* now modify the couple that need it */
  vdWindow.width = width;
  vdWindow.height = height;
  vdWindow.biHeader.biWidth = vdWindow.width;
  vdWindow.biHeader.biHeight = vdWindow.height;
  vdWindow.biHeader.biSize = sizeof(BITMAPINFOHEADER);
  vdWindow.biHeader.biCompression = BI_RGB;
  vdWindow.biHeader.biPlanes = 1;
  vdWindow.biHeader.biBitCount = 24;


  vdWindow.biHeader.biSizeImage = 3 * vdWindow.width * vdWindow.height;
  vdWindow.imageIsReady = FALSE;

  /* allocate the memory needed to hold the RGB and visualization information */  vdWindow.bufRGB = (unsigned char *)malloc (3 * vdWindow.width * vdWindow.height);

  /* Create synchronization event */
  vdWindow.hEvent = CreateEvent(NULL,FALSE,FALSE,NULL);

  vdWindow.hThread =
    CreateThread (
      NULL,
      0,
      (LPTHREAD_START_ROUTINE) DisplayWinMain,
      (LPVOID) NULL,
      0,
      &(vdWindow.dwThreadID)
    );

  if (vdWindow.hThread == NULL) {
    errFlag = 1;
    return errFlag;
  }

  return errFlag;
}


/* vddraw.c */

static int displayImage (unsigned char *lum, unsigned char *Cr, unsigned char *Cb)
{
  int errFlag = 0;
  DWORD dwRetVal;

  /* wait until we have finished drawing the last frame */
  if (vdWindow.windowDismissed == FALSE) {
    vdWindow.src[0] = lum;
    vdWindow.src[1] = Cb;
    vdWindow.src[2] = Cr;

    /* wait until previous frame has been drawn */
    dwRetVal = WaitForSingleObject(vdWindow.hEvent,INFINITE);

    vdWindow.imageIsReady = TRUE;
    /* Post message to drawing thread's window to draw frame */
    PostMessage (vdWindow.hWnd, VIDEO_DRAW_FRAME, (WPARAM) NULL, (LPARAM) NULL);

        }

        return errFlag;
}
static int DrawDIB()
{                                                                                
  int errFlag = 0;

  errFlag |=
    DrawDibDraw (
      vdWindow.hDrawDib,
      vdWindow.hDC,
      0,
      0,
      vdWindow.zoom * vdWindow.width,
      vdWindow.zoom * vdWindow.height,
      &vdWindow.biHeader,
      vdWindow.bufRGB,
      0,
      0,
      vdWindow.width,
      vdWindow.height,
      DDF_SAME_DRAW
    );


        return errFlag;
}




/* vdwinman.c */

static void DisplayWinMain (void *dummy)
{
  int errFlag = 0;
  DWORD dwStyle;

  vdWindow.wc.style =  CS_BYTEALIGNWINDOW;
  vdWindow.wc.lpfnWndProc = MainWndProc;
  vdWindow.wc.cbClsExtra = 0;
  vdWindow.wc.cbWndExtra = 0;
  vdWindow.wc.hInstance = 0;
  vdWindow.wc.hIcon = LoadIcon (NULL, IDI_APPLICATION);
  vdWindow.wc.hCursor = LoadCursor (NULL, IDC_ARROW);
  vdWindow.wc.hbrBackground = GetStockObject (WHITE_BRUSH);
  vdWindow.wc.lpszMenuName = NULL;
  vdWindow.zoom = 1;
  strcpy (vdWindow.lpszAppName, "H.263 Display");
  vdWindow.wc.lpszClassName = vdWindow.lpszAppName;

  RegisterClass(&vdWindow.wc);

  dwStyle =  WS_DLGFRAME | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX;

  vdWindow.hWnd =
    CreateWindow (vdWindow.lpszAppName,
      vdWindow.lpszAppName,
      dwStyle,
      CW_USEDEFAULT,
      CW_USEDEFAULT,
      vdWindow.width + 6,
      vdWindow.height + 25,
      NULL,
      NULL,
      0,
      NULL
    );

  if (vdWindow.hWnd == NULL)
    ExitThread (errFlag = 1);

  ShowWindow(vdWindow.hWnd, SW_SHOWNOACTIVATE);
  UpdateWindow(vdWindow.hWnd);

  /* Message loop for display window's thread */
  while (GetMessage (&(vdWindow.msg), NULL, 0, 0)) {
    TranslateMessage (&(vdWindow.msg));
    DispatchMessage (&(vdWindow.msg));
  }

  ExitThread (0);
}


static LRESULT APIENTRY MainWndProc (HWND hWnd, UINT msg, UINT wParam, LONG lParam)
{
  LPMINMAXINFO lpmmi;

  switch (msg) {
    case VIDEO_BEGIN:
      vdWindow.hDC = GetDC (vdWindow.hWnd);
      vdWindow.hDrawDib = DrawDibOpen();
      vdWindow.zoom = 1;
      vdWindow.oldzoom = 0;
      DrawDibBegin (
        vdWindow.hDrawDib,
        vdWindow.hDC,
        2*vdWindow.width,
        2*vdWindow.height,
        &vdWindow.biHeader,
        vdWindow.width,
        vdWindow.height,
        0
      );
      SetEvent(vdWindow.hEvent);
      vdWindow.windowDismissed = FALSE;
      ReleaseDC (vdWindow.hWnd, vdWindow.hDC);
      break;
    case VIDEO_DRAW_FRAME:
      vdWindow.hDC = GetDC (vdWindow.hWnd);
      ConvertYUVtoRGB(
        vdWindow.src[0],
        vdWindow.src[1],
        vdWindow.src[2],
        vdWindow.bufRGB,
        vdWindow.width,
        vdWindow.height
      );
      /* draw the picture onto the screen*/
      DrawDIB();
      SetEvent(vdWindow.hEvent);
      ReleaseDC (vdWindow.hWnd, vdWindow.hDC);
      break;
    case VIDEO_END:
      /* Window has been closed.  The following lines handle the cleanup. */
      vdWindow.hDC = GetDC (vdWindow.hWnd);
      DrawDibEnd (vdWindow.hDrawDib);
      DrawDibClose (vdWindow.hDrawDib);
      ReleaseDC (vdWindow.hWnd, vdWindow.hDC);

      vdWindow.windowDismissed = TRUE;
      PostQuitMessage(0);
      break;

    case WM_CREATE:
      PostMessage(hWnd, VIDEO_BEGIN, 0, 0);
      break;
    case WM_SIZE:
      switch (wParam) {
        case SIZE_MAXIMIZED:
          vdWindow.zoom = 2;
          break;
        case SIZE_MINIMIZED:
          vdWindow.oldzoom = vdWindow.zoom;
                break;
        case SIZE_RESTORED:
          if (vdWindow.oldzoom) {
            vdWindow.zoom = vdWindow.oldzoom;
            vdWindow.oldzoom = 0;
          }
          else
            vdWindow.zoom = 1;
          break;
        case SIZE_MAXHIDE:
          break;
        case SIZE_MAXSHOW:
          break;
      }
      PostMessage(hWnd,WM_PAINT,0,0);
      break;
    case WM_GETMINMAXINFO:
      lpmmi = (LPMINMAXINFO) lParam;

      GetWindowRect (hWnd, &vdWindow.rect);
      lpmmi->ptMaxPosition.x = vdWindow.rect.left;
      lpmmi->ptMaxPosition.y = vdWindow.rect.top;

      lpmmi->ptMaxSize.x = 2 * (vdWindow.width) + 6;
      lpmmi->ptMaxSize.y = 2 * (vdWindow.height) + 25;
      break;
    case WM_DESTROY:
      /* Window has been closed.  The following lines handle the cleanup. */
      DrawDibEnd (vdWindow.hDrawDib);
      ReleaseDC (vdWindow.hWnd, vdWindow.hDC);
      DrawDibClose (vdWindow.hDrawDib);

      vdWindow.windowDismissed = TRUE;
      PostQuitMessage(0);
      break;
    case WM_PAINT:
      if (vdWindow.imageIsReady) {
        vdWindow.hDC = GetDC (vdWindow.hWnd);
        DrawDIB ();
        ReleaseDC (vdWindow.hWnd, vdWindow.hDC);
      }
      break;

  }
  return DefWindowProc (hWnd, msg, wParam, lParam);
}



/* vdclose.c */

static int closeDisplay ()
{
  int errFlag = 0;

  if (vdWindow.hWnd) {
    PostMessage (vdWindow.hWnd, VIDEO_END, (WPARAM) NULL, (LPARAM) NULL);
    while (vdWindow.windowDismissed == FALSE)
      ;
  }

  if (vdWindow.hEvent)
    CloseHandle(vdWindow.hEvent);

  if (vdWindow.hThread)
    CloseHandle (vdWindow.hThread);

  free (vdWindow.bufRGB);

  return errFlag;
}




#endif
/* Data for ConvertYUVtoRGB*/
#if (defined DISPLAY || defined WINDOWS)
long int crv_tab_128[256];
long int cbu_tab_129[256];
long int cgu_tab_130[256];

long int cgv_tab_131[256];
long int tab_76309_132[256];

static void init_dither_tab()
{
  long int crv,cbu,cgu,cgv;
  int i;

  crv = 104597; cbu = 132201;  /* fra matrise i global.h */
  cgu = 25675;  cgv = 53279;

  for (i = 0; i < 256; i++) {
    crv_tab_128[i] = (i-128) * crv;
    cbu_tab_129[i] = (i-128) * cbu;
    cgu_tab_130[i] = (i-128) * cgu;
    cgv_tab_131[i] = (i-128) * cgv;
    tab_76309_132[i] = 76309*(i-16);
  }
}




/**********************************************************************
 *
 *      Name:            ConvertYUVtoRGB
 *      Description:     Converts YUV image to RGB (packed mode)
 *
 *      Input:           pointer to source luma, Cr, Cb, destination,
 *                       image width and height
 *      Returns:
 *      Side effects:
 *
 *      Date: 951208    Author: Karl.Lillevold@nta.no
 *
 ***********************************************************************/



static void ConvertYUVtoRGB(unsigned char *src0,unsigned char *src1,unsigned char *src2,unsigned char *dst_ori,int width,int height)
{
  //extern long int crv_tab_128[];
  //extern long int cbu_tab_129[];
  //extern long int cgu_tab_130[];

  //extern long int cgv_tab_131[];
  //extern long int tab_76309_132[];

  int y11,y21;
        int y12,y22;
  int y13,y23;
        int y14,y24;
  int u,v;
  int i,j;
        int c11, c21, c31, c41;
        int c12, c22, c32, c42;
        unsigned int DW;
        unsigned int *id1, *id2;
  unsigned char *py1,*py2,*pu,*pv;
  unsigned char *d1, *d2;

  d1 = dst_ori;
  d1 += width*height*3 - width*3;
        d2 = d1 - width*3;

  py1 = src0; pu = src1; pv = src2;
        py2 = py1 + width;

        id1 = (unsigned int *)d1;
        id2 = (unsigned int *)d2;

  for (j = 0; j < height; j += 2) {
    /* line j + 0 */
    for (i = 0; i < width; i += 4) {
      u = *pu++;
      v = *pv++;
      c11 = crv_tab_128[v];
      c21 = cgu_tab_130[u];
      c31 = cgv_tab_131[v];
      c41 = cbu_tab_129[u];
      u = *pu++;
      v = *pv++;
      c12 = crv_tab_128[v];
      c22 = cgu_tab_130[u];
      c32 = cgv_tab_131[v];
      c42 = cbu_tab_129[u];

      y11 = tab_76309_132[*py1++]; /* (255/219)*65536 */
      y12 = tab_76309_132[*py1++];
      y13 = tab_76309_132[*py1++]; /* (255/219)*65536 */
      y14 = tab_76309_132[*py1++];

      y21 = tab_76309_132[*py2++];
      y22 = tab_76309_132[*py2++];
      y23 = tab_76309_132[*py2++];
      y24 = tab_76309_132[*py2++];

      /* RGBR*/
      DW = ((clp_126[(y11 + c41)>>16])) |
           ((clp_126[(y11 - c21 - c31)>>16])<<8) |
           ((clp_126[(y11 + c11)>>16])<<16) |
           ((clp_126[(y12 + c41)>>16])<<24);
      *id1++ = DW;

      /* GBRG*/
      DW = ((clp_126[(y12 - c21 - c31)>>16])) |
           ((clp_126[(y12 + c11)>>16])<<8) |
           ((clp_126[(y13 + c42)>>16])<<16) |
           ((clp_126[(y13 - c22 - c32)>>16])<<24);

      /* BRGB*/
      DW = ((clp_126[(y13 + c12)>>16])) |
           ((clp_126[(y14 + c42)>>16])<<8) |
           ((clp_126[(y14 - c22 - c32)>>16])<<16) |
           ((clp_126[(y14 + c12)>>16])<<24);
      *id1++ = DW;

      /* RGBR*/
      DW = ((clp_126[(y21 + c41)>>16])) |
           ((clp_126[(y21 - c21 - c31)>>16])<<8) |
           ((clp_126[(y21 + c11)>>16])<<16) |
           ((clp_126[(y22 + c41)>>16])<<24);
      *id2++ = DW;

      /* GBRG*/
      DW = ((clp_126[(y22 - c21 - c31)>>16])) |
           ((clp_126[(y22 + c11)>>16])<<8) |
           ((clp_126[(y23 + c42)>>16])<<16) |
           ((clp_126[(y23 - c22 - c32)>>16])<<24);
      *id2++ = DW;

      /* BRGB*/
      DW = ((clp_126[(y23 + c12)>>16])) |
           ((clp_126[(y24 + c42)>>16])<<8) |
           ((clp_126[(y24 - c22 - c32)>>16])<<16) |
           ((clp_126[(y24 + c12)>>16])<<24);
      *id2++ = DW;
    }
    id1 -= (9 * width)>>2;
    id2 -= (9 * width)>>2;
    py1 += width;
    py2 += width;
  }
}


#endif
#ifdef DISPLAY
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif


#ifdef DISPLAY

#undef INTERPOLATE

/*
 * Erik Corry's multi-byte dither routines.
 *
 * The basic idea is that the Init generates all the necessary tables.
 * The tables incorporate the information about the layout of pixels
 * in the XImage, so that it should be able to cope with 15-bit, 16-bit
 * 24-bit (non-packed) and 32-bit (10-11 bits per color!) screens.
 * At present it cannot cope with 24-bit packed mode, since this involves
 * getting down to byte level again. It is assumed that the bits for each
 * color are contiguous in the longword.
 *
 * Writing to memory is done in shorts or ints. (Unfortunately, short is not
 * very fast on Alpha, so there is room for improvement here). There is no
 * dither time check for overflow - instead the tables have slack at
 * each end. This is likely to be faster than an 'if' test as many modern
 * architectures are really bad at ifs. Potentially, each '&&' causes a
 * pipeline flush!
 *
 * There is no shifting and fixed point arithmetic, as I really doubt you
 * can see the difference, and it costs. This may be just my bias, since I
 * heard that Intel is really bad at shifting.
 */
/* Gamma correction stuff */

#define GAMMA_CORRECTION(x) ((int)(pow((x) / 255.0, 1.0 / gammaCorrect_133) * 255.0))
#define CHROMA_CORRECTION256(x) ((x) >= 128 \
                    ? 128 + mmin(127, (int)(((x) - 128.0) * chromaCorrect_134)) \
                    : 128 - mmin(128, (int)((128.0 - (x)) * chromaCorrect_134)))
#define CHROMA_CORRECTION128(x) ((x) >= 0 \
                    ? mmin(127,  (int)(((x) * chromaCorrect_134))) \
                    : mmax(-128, (int)(((x) * chromaCorrect_134))))
#define CHROMA_CORRECTION256D(x) ((x) >= 128 \
                    ? 128.0 + mmin(127.0, (((x) - 128.0) * chromaCorrect_134)) \
                    : 128.0 - mmin(128.0, (((128.0 - (x)) * chromaCorrect_134))))
#define CHROMA_CORRECTION128D(x) ((x) >= 0 \
                    ? mmin(127.0,  ((x) * chromaCorrect_134)) \
                    : mmax(-128.0, ((x) * chromaCorrect_134)))


/* Flag for gamma correction */
int gammaCorrectFlag_135 = 0;
double gammaCorrect_133 = 1.0;

/* Flag for chroma correction */
int chromaCorrectFlag_136 = 0;
double chromaCorrect_134 = 1.0;

/*
 * How many 1 bits are there in the longword.
 * Low performance, do not call often.
 */
static int
number_of_bits_set(unsigned long a)
{
    if(!a) return 0;
    if(a & 1) return 1 + number_of_bits_set(a >> 1);
    return(number_of_bits_set(a >> 1));
}

/*
 * Shift the 0s in the least significant end out of the longword.
 * Low performance, do not call often.
 */
static unsigned long
shifted_down(unsigned long a)
{
    if(!a) return 0;
    if(a & 1) return a;
    return a >> 1;
}
/*
 * How many 0 bits are there at most significant end of longword.
 * Low performance, do not call often.
 */
static int
free_bits_at_top(unsigned long a)
{
      /* assume char is 8 bits */
    if(!a) return sizeof(unsigned long) * 8;
        /* assume twos complement */
    if(((long)a) < 0l) return 0;
    return 1 + free_bits_at_top ( a << 1);
}

/*
 * How many 0 bits are there at least significant end of longword.
 * Low performance, do not call often.
 */
static int
free_bits_at_bottom(unsigned long a)
{
      /* assume char is 8 bits */
    if(!a) return sizeof(unsigned long) * 8;
    if(((long)a) & 1l) return 0;
    return 1 + free_bits_at_bottom ( a >> 1);
}

static int *L_tab, *Cr_r_tab, *Cr_g_tab, *Cb_g_tab, *Cb_b_tab;

/*
 * We define tables that convert a color value between -256 and 512
 * into the R, G and B parts of the pixel. The normal range is 0-255.
 */

static long *r_2_pix;
static long *g_2_pix;
static long *b_2_pix;
static long *r_2_pix_alloc;
static long *g_2_pix_alloc;
static long *b_2_pix_alloc;


/*
 *--------------------------------------------------------------
 *
 * InitColor16Dither --
 *
 *      To get rid of the multiply and other conversions in color
 *      dither, we use a lookup table.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      The lookup tables are initialized.
 *
 *--------------------------------------------------------------
 */

static void
InitColorDither(int thirty2)
{
    extern XImage *ximage_137;
    extern unsigned long wpixel_138[3];
    /*
     * misuse of the wpixel_138 array for the pixel masks. Note that this
     * implies that the window is created before this routine is called
     */


    unsigned long red_mask;
    unsigned long green_mask;
    unsigned long blue_mask;

    int CR, CB, i;

    red_mask = wpixel_138[0];
    green_mask = wpixel_138[1];
    blue_mask = wpixel_138[2];

    if (ximage_137->bits_per_pixel == 24) /* not necessary in non-packed mode */
      init_dither_tab();

    L_tab    = (int *)malloc(256*sizeof(int));
    Cr_r_tab = (int *)malloc(256*sizeof(int));
    Cr_g_tab = (int *)malloc(256*sizeof(int));
    Cb_g_tab = (int *)malloc(256*sizeof(int));
    Cb_b_tab = (int *)malloc(256*sizeof(int));

    r_2_pix_alloc = (long *)malloc(768*sizeof(long));
    g_2_pix_alloc = (long *)malloc(768*sizeof(long));
    b_2_pix_alloc = (long *)malloc(768*sizeof(long));

    if (L_tab == NULL ||
        Cr_r_tab == NULL ||
        Cr_g_tab == NULL ||
        Cb_g_tab == NULL ||
        Cb_b_tab == NULL ||
        r_2_pix_alloc == NULL ||
        g_2_pix_alloc == NULL ||
        b_2_pix_alloc == NULL) {
      fprintf(stderr, "Could not get enough memory in InitColorDither\n");
      exit(1);
    }

    for (i=0; i<256; i++) {
      L_tab[i] = i;
      if (gammaCorrectFlag_135) {
        L_tab[i] = GAMMA_CORRECTION(i);
      }

      CB = CR = i;

      if (chromaCorrectFlag_136) {
        CB -= 128;
        CB = CHROMA_CORRECTION128(CB);
        CR -= 128;
        CR = CHROMA_CORRECTION128(CR);
      } else {
        CB -= 128; CR -= 128;
      }
/* was
      Cr_r_tab[i] =  1.596 * CR;
      Cr_g_tab[i] = -0.813 * CR;
      Cb_g_tab[i] = -0.391 * CB;
      Cb_b_tab[i] =  2.018 * CB;
  but they were just messed up.
  Then was (_Video Deymstified_):
      Cr_r_tab[i] =  1.366 * CR;
      Cr_g_tab[i] = -0.700 * CR;
      Cb_g_tab[i] = -0.334 * CB;
      Cb_b_tab[i] =  1.732 * CB;
  but really should be:
   (from ITU-R BT.470-2 System B, G and SMPTE 170M )
*/
      Cr_r_tab[i] =  (0.419/0.299) * CR;
      Cr_g_tab[i] = -(0.299/0.419) * CR;
      Cb_g_tab[i] = -(0.114/0.331) * CB;
      Cb_b_tab[i] =  (0.587/0.331) * CB;

/*
  though you could argue for:
    SMPTE 240M
      Cr_r_tab[i] =  (0.445/0.212) * CR;
      Cr_g_tab[i] = -(0.212/0.445) * CR;
      Cb_g_tab[i] = -(0.087/0.384) * CB;
      Cb_b_tab[i] =  (0.701/0.384) * CB;
    FCC
      Cr_r_tab[i] =  (0.421/0.30) * CR;
      Cr_g_tab[i] = -(0.30/0.421) * CR;
      Cb_g_tab[i] = -(0.11/0.331) * CB;
      Cb_b_tab[i] =  (0.59/0.331) * CB;
    ITU-R BT.709
      Cr_r_tab[i] =  (0.454/0.2125) * CR;
      Cr_g_tab[i] = -(0.2125/0.454) * CR;
      Cb_g_tab[i] = -(0.0721/0.386) * CB;
      Cb_b_tab[i] =  (0.7154/0.386) * CB;
*/
    }

    /*
     * Set up entries 0-255 in rgb-to-pixel value tables.
     */
    for (i = 0; i < 256; i++) {
      r_2_pix_alloc[i + 256] = i >> (8 - number_of_bits_set(red_mask));
      r_2_pix_alloc[i + 256] <<= free_bits_at_bottom(red_mask);
      g_2_pix_alloc[i + 256] = i >> (8 - number_of_bits_set(green_mask));
      g_2_pix_alloc[i + 256] <<= free_bits_at_bottom(green_mask);
      b_2_pix_alloc[i + 256] = i >> (8 - number_of_bits_set(blue_mask));
      b_2_pix_alloc[i + 256] <<= free_bits_at_bottom(blue_mask);
      /*
       * If we have 16-bit output depth, then we double the value
       * in the top word. This means that we can write out both
       * pixels in the pixel doubling mode with one op. It is
       * harmless in the normal case as storing a 32-bit value
       * through a short pointer will lose the top bits anyway.
       * A similar optimisation for Alpha for 64 bit has been
       * prepared for, but is not yet implemented.
       */
      if(!thirty2) {

        r_2_pix_alloc[i + 256] |= (r_2_pix_alloc[i + 256]) << 16;
        g_2_pix_alloc[i + 256] |= (g_2_pix_alloc[i + 256]) << 16;
        b_2_pix_alloc[i + 256] |= (b_2_pix_alloc[i + 256]) << 16;

      }
#ifdef SIXTYFOUR_BIT
      if(thirty2) {

        r_2_pix_alloc[i + 256] |= (r_2_pix_alloc[i + 256]) << 32;
        g_2_pix_alloc[i + 256] |= (g_2_pix_alloc[i + 256]) << 32;
        b_2_pix_alloc[i + 256] |= (b_2_pix_alloc[i + 256]) << 32;

      }
#endif
    }

    /*
     * Spread out the values we have to the rest of the array so that
     * we do not need to check for overflow.
     */
    for (i = 0; i < 256; i++) {
      r_2_pix_alloc[i] = r_2_pix_alloc[256];
      r_2_pix_alloc[i+ 512] = r_2_pix_alloc[511];
      g_2_pix_alloc[i] = g_2_pix_alloc[256];
      g_2_pix_alloc[i+ 512] = g_2_pix_alloc[511];
      b_2_pix_alloc[i] = b_2_pix_alloc[256];
      b_2_pix_alloc[i+ 512] = b_2_pix_alloc[511];
    }

    r_2_pix = r_2_pix_alloc + 256;
    g_2_pix = g_2_pix_alloc + 256;
    b_2_pix = b_2_pix_alloc + 256;

}


/*
 *--------------------------------------------------------------
 *
 * Color16DitherImage --
 *
 *      Converts image into 16 bit color.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *--------------------------------------------------------------
 */

static void
Color16DitherImage(unsigned char *src[], unsigned char *out)
{
    unsigned char *lum = src[0];
    unsigned char *cb = src[1];
    unsigned char *cr = src[2];
    int cols;
    int rows;

    int L, CR, CB;
    unsigned short *row1, *row2;
    unsigned char *lum2;
    int x, y;
    int cr_r;
    int cr_g;
    int cb_g;
    int cb_b;
    int cols_2;

    cols = gFrameWidth;
    rows = gFrameHeight;
    if (expand_123) {
      cols *= 2;
      rows *= 2;
    }
    cols_2 = cols/2;

    row1 = (unsigned short *)out;
    row2 = row1 + cols_2 + cols_2;
    lum2 = lum + cols_2 + cols_2;

    for (y=0; y<rows; y+=2) {
        for (x=0; x<cols_2; x++) {
            int R, G, B;

            CR = *cr++;
            CB = *cb++;
            cr_r = Cr_r_tab[CR];
            cr_g = Cr_g_tab[CR];
            cb_g = Cb_g_tab[CB];
            cb_b = Cb_b_tab[CB];

            L = L_tab[(int) *lum++];

            R = L + cr_r;
            G = L + cr_g + cb_g;
            B = L + cb_b;

            *row1++ = (r_2_pix[R] | g_2_pix[G] | b_2_pix[B]);

#ifdef INTERPOLATE
            if(x != cols_2 - 1) {
              CR = (CR + *cr) >> 1;
              CB = (CB + *cb) >> 1;
              cr_r = Cr_r_tab[CR];
              cr_g = Cr_g_tab[CR];
              cb_g = Cb_g_tab[CB];
              cb_b = Cb_b_tab[CB];
            }
#endif

            L = L_tab[(int) *lum++];

            R = L + cr_r;
            G = L + cr_g + cb_g;
            B = L + cb_b;

            *row1++ = (r_2_pix[R] | g_2_pix[G] | b_2_pix[B]);

            /*
             * Now, do second row.
             */
#ifdef INTERPOLATE
            if(y != rows - 2) {
              CR = (CR + *(cr + cols_2 - 1)) >> 1;
              CB = (CB + *(cb + cols_2 - 1)) >> 1;
              cr_r = Cr_r_tab[CR];
              cr_g = Cr_g_tab[CR];
              cb_g = Cb_g_tab[CB];
              cb_b = Cb_b_tab[CB];
            }
#endif

            L = L_tab[(int) *lum2++];
            R = L + cr_r;
            G = L + cr_g + cb_g;
            B = L + cb_b;

            *row2++ = (r_2_pix[R] | g_2_pix[G] | b_2_pix[B]);

            L = L_tab[(int) *lum2++];
            R = L + cr_r;
            G = L + cr_g + cb_g;
            B = L + cb_b;

            *row2++ = (r_2_pix[R] | g_2_pix[G] | b_2_pix[B]);
        }
        /*
         * These values are at the start of the next line, (due
         * to the ++'s above),but they need to be at the start
         * of the line after that.
         */
        lum += cols_2 + cols_2;
        lum2 += cols_2 + cols_2;
        row1 += cols_2 + cols_2;
        row2 += cols_2 + cols_2;
    }
}


/*
 *--------------------------------------------------------------
 *
 * Color32DitherImage --
 *
 *      Converts image into 32 bit color (or 24-bit non-packed).
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *--------------------------------------------------------------
 */

/*
 * This is a copysoft version of the function above with ints instead
 * of shorts to cause a 4-byte pixel size
 */

static void
Color32DitherImage(unsigned char *src[], unsigned char *out)
{
    unsigned char *lum = src[0];
    unsigned char *cb = src[1];
    unsigned char *cr = src[2];
    int cols;
    int rows;

    int L, CR, CB;
    unsigned int *row1, *row2;
    unsigned char *lum2;
    int x, y;
    int cr_r;
    int cr_g;
    int cb_g;
    int cb_b;
    int cols_2;

    cols = gFrameWidth;
    rows = gFrameHeight;
    if (expand_123) {
      cols *= 2;
      rows *= 2;
    }
    cols_2 = cols/2;

    row1 = (unsigned int *)out;
    row2 = row1 + cols_2 + cols_2;
    lum2 = lum + cols_2 + cols_2;
    for (y=0; y<rows; y+=2) {
        for (x=0; x<cols_2; x++) {
            int R, G, B;

            CR = *cr++;
            CB = *cb++;
            cr_r = Cr_r_tab[CR];
            cr_g = Cr_g_tab[CR];
            cb_g = Cb_g_tab[CB];
            cb_b = Cb_b_tab[CB];

            L = L_tab[(int) *lum++];

            R = L + cr_r;
            G = L + cr_g + cb_g;
            B = L + cb_b;

            *row1++ = (r_2_pix[R] | g_2_pix[G] | b_2_pix[B]);

#ifdef INTERPOLATE
            if(x != cols_2 - 1) {
              CR = (CR + *cr) >> 1;
              CB = (CB + *cb) >> 1;
              cr_r = Cr_r_tab[CR];
              cr_g = Cr_g_tab[CR];
              cb_g = Cb_g_tab[CB];
              cb_b = Cb_b_tab[CB];
            }
#endif

            L = L_tab[(int) *lum++];

            R = L + cr_r;
            G = L + cr_g + cb_g;
            B = L + cb_b;

            *row1++ = (r_2_pix[R] | g_2_pix[G] | b_2_pix[B]);

            /*
             * Now, do second row.
             */

#ifdef INTERPOLATE
            if(y != rows - 2) {
              CR = (CR + *(cr + cols_2 - 1)) >> 1;
              CB = (CB + *(cb + cols_2 - 1)) >> 1;
              cr_r = Cr_r_tab[CR];
              cr_g = Cr_g_tab[CR];
              cb_g = Cb_g_tab[CB];
              cb_b = Cb_b_tab[CB];
            }
#endif

            L = L_tab [(int) *lum2++];
            R = L + cr_r;
            G = L + cr_g + cb_g;
            B = L + cb_b;

            *row2++ = (r_2_pix[R] | g_2_pix[G] | b_2_pix[B]);

            L = L_tab [(int) *lum2++];
            R = L + cr_r;
            G = L + cr_g + cb_g;
            B = L + cb_b;

            *row2++ = (r_2_pix[R] | g_2_pix[G] | b_2_pix[B]);
        }
        lum += cols_2 + cols_2;
        lum2 += cols_2 + cols_2;
        row1 += cols_2 + cols_2;
        row2 += cols_2 + cols_2;
    }
}

#endif
#ifdef DISPLAY
extern unsigned char pixel_139[256];

static unsigned char ytab[16 * (256 + 16)];
static unsigned char uvtab[256 * 269 + 270];

/****************************************************************************

  4x4 ordered dither

  Threshold pattern:

     0  8  2 10
    12  4 14  6
     3 11  1  9
    15  7 13  5

 ****************************************************************************/
static void
ord4x4_dither_init (void)
{
  int i, j, v;
  unsigned char ctab[256 + 32];

  for (i = 0; i < 256 + 16; i++)
    {
      v = (i - 8) >> 4;
      if (v < 2)
        v = 2;
      else if (v > 14)
        v = 14;
      for (j = 0; j < 16; j++)
        ytab[16 * i + j] = pixel_139[(v << 4) + j];
    }

  for (i = 0; i < 256 + 32; i++)
    {
      v = (i + 48 - 128) >> 5;
      if (v < 0)
        v = 0;
      else if (v > 3)
        v = 3;
      ctab[i] = v;
    }

  for (i = 0; i < 255 + 15; i++)
    for (j = 0; j < 255 + 15; j++)
      uvtab[256 * i + j] = (ctab[i + 16] << 6) | (ctab[j + 16] << 4) | (ctab[i] << 2) | ctab[j];
}



static void
ord4x4_dither_frame (unsigned char *src[], unsigned char *dst)
{
  int i, j;
  unsigned char *py = src[0];
  unsigned char *pu = src[1];
  unsigned char *pv = src[2];

  int width, height, cwidth;

  if (expand_123)
    {
      width = 2 * gFrameWidth;
      height = 2 * gFrameHeight;
      cwidth = 2 * (gFrameWidth>>1);
    }
  else
    {
      width = gFrameWidth;
      height = gFrameHeight;
      cwidth = (gFrameWidth>>1);
    }

  for (j = 0; j < height; j += 4)
    {
      register unsigned int uv;

      /* line j + 0 */
      for (i = 0; i < width; i += 8)
        {
          uv = uvtab[(*pu++ << 8) | *pv++];
          *dst++ = ytab[((*py++) << 4) | (uv & 15)];
          *dst++ = ytab[((*py++ + 8) << 4) | (uv >> 4)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 1028];
          *dst++ = ytab[((*py++ + 2) << 4) | (uv & 15)];
          *dst++ = ytab[((*py++ + 10) << 4) | (uv >> 4)];
          uv = uvtab[(*pu++ << 8) | *pv++];
          *dst++ = ytab[((*py++) << 4) | (uv & 15)];
          *dst++ = ytab[((*py++ + 8) << 4) | (uv >> 4)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 1028];
          *dst++ = ytab[((*py++ + 2) << 4) | (uv & 15)];
          *dst++ = ytab[((*py++ + 10) << 4) | (uv >> 4)];
        }

      pu -= cwidth;
      pv -= cwidth;

      /* line j + 1 */
      for (i = 0; i < width; i += 8)
        {
          uv = uvtab[((*pu++ << 8) | *pv++) + 2056];
          *dst++ = ytab[((*py++ + 12) << 4) | (uv >> 4)];
          *dst++ = ytab[((*py++ + 4) << 4) | (uv & 15)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 3084];
          *dst++ = ytab[((*py++ + 14) << 4) | (uv >> 4)];
          *dst++ = ytab[((*py++ + 6) << 4) | (uv & 15)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 2056];
          *dst++ = ytab[((*py++ + 12) << 4) | (uv >> 4)];
          *dst++ = ytab[((*py++ + 4) << 4) | (uv & 15)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 3084];
          *dst++ = ytab[((*py++ + 14) << 4) | (uv >> 4)];
          *dst++ = ytab[((*py++ + 6) << 4) | (uv & 15)];
        }

      /* line j + 2 */
      for (i = 0; i < width; i += 8)
        {
          uv = uvtab[((*pu++ << 8) | *pv++) + 1542];
          *dst++ = ytab[((*py++ + 3) << 4) | (uv & 15)];
          *dst++ = ytab[((*py++ + 11) << 4) | (uv >> 4)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 514];
          *dst++ = ytab[((*py++ + 1) << 4) | (uv & 15)];
          *dst++ = ytab[((*py++ + 9) << 4) | (uv >> 4)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 1542];
          *dst++ = ytab[((*py++ + 3) << 4) | (uv & 15)];
          *dst++ = ytab[((*py++ + 11) << 4) | (uv >> 4)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 514];
          *dst++ = ytab[((*py++ + 1) << 4) | (uv & 15)];
          *dst++ = ytab[((*py++ + 9) << 4) | (uv >> 4)];
        }

      pu -= cwidth;
      pv -= cwidth;

      /* line j + 3 */
      for (i = 0; i < width; i += 8)
        {
          uv = uvtab[((*pu++ << 8) | *pv++) + 3598];
          *dst++ = ytab[((*py++ + 15) << 4) | (uv >> 4)];
          *dst++ = ytab[((*py++ + 7) << 4) | (uv & 15)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 2570];
          *dst++ = ytab[((*py++ + 13) << 4) | (uv >> 4)];
          *dst++ = ytab[((*py++ + 5) << 4) | (uv & 15)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 3598];
          *dst++ = ytab[((*py++ + 15) << 4) | (uv >> 4)];
          *dst++ = ytab[((*py++ + 7) << 4) | (uv & 15)];
          uv = uvtab[((*pu++ << 8) | *pv++) + 2570];
          *dst++ = ytab[((*py++ + 13) << 4) | (uv >> 4)];
          *dst++ = ytab[((*py++ + 5) << 4) | (uv & 15)];
        }
    }
}
#endif
#ifdef DISPLAY

#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>


/* private prototypes */
static void display_image _ANSI_ARGS_((XImage *, unsigned char *));

/* display related data */
unsigned long wpixel_138[3];
static unsigned char *dithered_image;

/* X11 related variables */
static Display *display;
static Window window;
static GC gc;
static int dpy_depth;

XImage *ximage_137;

unsigned char pixel_139[256];

#ifdef SH_MEM

#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>

extern int XShmQueryExtension _ANSI_ARGS_((Display *dpy));
extern int XShmGetEventBase _ANSI_ARGS_((Display *dpy));

static int HandleXError _ANSI_ARGS_((Display *dpy, XErrorEvent *event));
static void InstallXErrorHandler _ANSI_ARGS_((void));
static void DeInstallXErrorHandler _ANSI_ARGS_((void));

static int shmem_flag;
static XShmSegmentInfo shminfo1, shminfo2;
static int gXErrorFlag;
static int CompletionType = -1;

static int HandleXError(Display *dpy, XErrorEvent *event)
{
  gXErrorFlag = 1;

  return 0;
}

static void InstallXErrorHandler()
{
  XSetErrorHandler(HandleXError);
  XFlush(display);
}

static void DeInstallXErrorHandler()
{
  XSetErrorHandler(NULL);
  XFlush(display);
}

#endif

/* connect to server, create and map window,
 * allocate colors and (shared) memory
 */
static void init_display(char *name)
{
  int crv, cbu, cgu, cgv;
  int y, u, v, r, g, b;
  int i;
  char dummy;
  int screen;
  Visual *visual;
  int dpy_class;
  Colormap cmap;
  int _private;
  XColor xcolor;
  unsigned int fg, bg;
  char *hello = "H.263 Display";
  XSizeHints hint;
  XEvent xev;
  XSetWindowAttributes xswa;
  unsigned long tmp_pixel;
  unsigned int mask;
  int matrix_coefficients = 0;

  clp_126 = clpGlobal_127;
  clp_126 += 384;
  { int i;
  for (i=-384; i<640; i++)
    clp_126[i] = (i<0) ? 0 : ((i>255) ? 255 : i);
  }

  display = XOpenDisplay(name);

  if (display == NULL)
    error("Can not open display\n");

  screen = DefaultScreen(display);

  visual = DefaultVisual (display, screen);
  dpy_depth = DefaultDepth (display, screen);
#ifdef CC
  dpy_class = visual->c_class;
#else
  dpy_class = visual->class;
#endif

  if (!((dpy_class == TrueColor && dpy_depth == 32)
        || (dpy_class == TrueColor && dpy_depth == 24)
        || (dpy_class == TrueColor && dpy_depth == 16)
        || (dpy_class == PseudoColor && dpy_depth == 8)))
    error ("requires 8 bit PseudoColor or 16/24/32 bit TrueColor display\n");

  if (dpy_class == TrueColor && dpy_depth == 32)
    printf("TrueColor : 32 bit colordepth\n");
  if (dpy_class == TrueColor && dpy_depth == 24)
    printf("TrueColor : 24 bit colordepth\n");
  if (dpy_class == TrueColor && dpy_depth == 16)
    printf("TrueColor : 16 bit colordepth\n");
  if (dpy_class == PseudoColor && dpy_depth == 8)
    printf("PseudoColor : 8 bit colordepth, 4x4 ordered dither\n");

  /* width and height of the display window */
  if (expand_123) {
    hint.min_width = hint.max_width = hint.width = 2*gFrameWidth;
    hint.min_height = hint.max_height = hint.height = 2*gFrameHeight;
  }
  else {
    hint.min_width = hint.max_width = hint.width = gFrameWidth;
    hint.min_height = hint.max_height = hint.height = gFrameHeight;
  }

  hint.flags = PSize | PMinSize | PMaxSize;

  /* Get some colors */

  bg = WhitePixel (display, screen);
  fg = BlackPixel (display, screen);

  /* Make the window */
  mask = CWBackPixel | CWBorderPixel;
  if (dpy_depth == 32 || dpy_depth == 24 || dpy_depth == 16) {
    mask |= CWColormap;
    xswa.colormap = XCreateColormap (display, DefaultRootWindow (display),
             visual, AllocNone);
  }
  xswa.background_pixel = bg;
  xswa.border_pixel = fg;
  window = XCreateWindow (display, DefaultRootWindow (display),
          hint.x, hint.y, hint.width, hint.height,
          1, dpy_depth, InputOutput, visual, mask, &xswa);


  XSelectInput(display, window, StructureNotifyMask);

  /* Tell other applications about this window */

  XSetStandardProperties (display, window, hello, hello, None, NULL, 0, &hint);

  /* Map window. */

  XMapWindow(display, window);

  /* Wait for map. */
  do
  {
    XNextEvent(display, &xev);
  }
  while (xev.type != MapNotify || xev.xmap.event != window);

  XSelectInput(display, window, NoEventMask);

  /* allocate colors */

  gc = DefaultGC(display, screen);

  if (dpy_depth == 8) {
    XWindowAttributes xwa;

    cmap = DefaultColormap(display, screen);
    _private = 0;

    /* matrix coefficients */
    crv = convmat_125[matrix_coefficients][0];
    cbu = convmat_125[matrix_coefficients][1];
    cgu = convmat_125[matrix_coefficients][2];
    cgv = convmat_125[matrix_coefficients][3];

    /* color allocation:
     * i is the (internal) 8 bit color number, it consists of separate
     * bit fields for Y, U and V: i = (yyyyuuvv), we don't use yyyy=0000
     * yyyy=0001 and yyyy=1111, this leaves 48 colors for other applications
     *
     * the allocated colors correspond to the following Y, U and V values:
     * Y:   40, 56, 72, 88, 104, 120, 136, 152, 168, 184, 200, 216, 232
     * U,V: -48, -16, 16, 48
     *
     * U and V values span only about half the color space; this gives
     * usually much better quality, although highly saturated colors can
     * not be displayed properly
     *
     * translation to R,G,B is implicitly done by the color look-up table
     */
    for (i=32; i<240; i++) {
      /* color space conversion */
      y = 16*((i>>4)&15) + 8;
      u = 32*((i>>2)&3)  - 48;
      v = 32*(i&3)       - 48;

      y = 76309 * (y - 16); /* (255/219)*65536 */

      r = clp_126[(y + crv*v + 32768)>>16];
      g = clp_126[(y - cgu*u -cgv*v + 32768)>>16];
      b = clp_126[(y + cbu*u + 32786)>>16];

      /* X11 colors are 16 bit */
      xcolor.red   = r << 8;
      xcolor.green = g << 8;
      xcolor.blue  = b << 8;

      if (XAllocColor(display, cmap, &xcolor) != 0)
        pixel_139[i] = xcolor.pixel;
      else {
        /* allocation failed, have to use a private colormap */

        if (_private)
          error("Couldn't allocate private colormap");

        _private = 1;

        if (!quiet_124)
          fprintf(stderr, "Using private colormap (%d colors were "
          "available).\n", i-32);

        /* Free colors. */
        while (--i >= 32)
        {
          tmp_pixel = pixel_139[i]; /* because XFreeColors expects unsigned long */
          XFreeColors(display, cmap, &tmp_pixel, 1, 0);
        }

        /* i is now 31, this restarts the outer loop */

        /* create private colormap */

        XGetWindowAttributes(display, window, &xwa);
        cmap = XCreateColormap(display, window, xwa.visual, AllocNone);
        XSetWindowColormap(display, window, cmap);
      }
    }
  }

#ifdef SH_MEM
  if (XShmQueryExtension(display))
    shmem_flag = 1;
  else
  {
    shmem_flag = 0;
    if (!quiet_124)
      fprintf(stderr, "Shared memory not supported\nReverting to normal "
              "Xlib\n");
  }

  if (shmem_flag)
    CompletionType = XShmGetEventBase(display) + ShmCompletion;

  InstallXErrorHandler();

  if (shmem_flag)
  {

    if (expand_123)
      ximage_137 = XShmCreateImage(display, visual, dpy_depth, ZPixmap, NULL,
               &shminfo1,
               2*gFrameWidth, 2*gFrameHeight);
    else
      ximage_137 = XShmCreateImage(display, visual, dpy_depth, ZPixmap, NULL,
               &shminfo1,
               gFrameWidth, gFrameHeight);


    /* If no go, then revert to normal Xlib calls. */

    if (ximage_137==NULL)
    {
      if (ximage_137!=NULL)
        XDestroyImage(ximage_137);
      if (!quiet_124)
        fprintf(stderr, "Shared memory error, disabling (Ximage error)\n");
      goto shmemerror;
    }

    /* Success here, continue. */

    shminfo1.shmid = shmget(IPC_PRIVATE,
                            ximage_137->bytes_per_line * ximage_137->height,
                            IPC_CREAT | 0777);

    if (shminfo1.shmid<0)
    {
      XDestroyImage(ximage_137);
      if (!quiet_124)
        fprintf(stderr, "Shared memory error, disabling (seg id error)\n");
      goto shmemerror;
    }

    shminfo1.shmaddr = (char *) shmat(shminfo1.shmid, 0, 0);
    shminfo2.shmaddr = (char *) shmat(shminfo2.shmid, 0, 0);

    if (shminfo1.shmaddr==((char *) -1))
    {
      XDestroyImage(ximage_137);
      if (shminfo1.shmaddr!=((char *) -1))
        shmdt(shminfo1.shmaddr);
      if (!quiet_124)
      {
        fprintf(stderr, "Shared memory error, disabling (address error)\n");
      }
      goto shmemerror;
    }

    ximage_137->data = shminfo1.shmaddr;
    dithered_image = (unsigned char *)ximage_137->data;
    shminfo1.readOnly = False;
    XShmAttach(display, &shminfo1);

    XSync(display, False);

    if (gXErrorFlag)
    {
      /* Ultimate failure here. */
      XDestroyImage(ximage_137);
      shmdt(shminfo1.shmaddr);
      if (!quiet_124)
        fprintf(stderr, "Shared memory error, disabling.\n");
      gXErrorFlag = 0;
      goto shmemerror;
    }
    else
    {
      shmctl(shminfo1.shmid, IPC_RMID, 0);
    }

    if (!quiet_124)
    {
      fprintf(stderr, "Sharing memory.\n");
    }
  }
  else
  {
shmemerror:
    shmem_flag = 0;
#endif


    if (expand_123) {
      ximage_137 = XCreateImage(display,visual,dpy_depth,ZPixmap,0,&dummy,
            2*gFrameWidth,2*gFrameHeight,8,0);
      if (!(dithered_image =
            (unsigned char *)malloc(gFrameWidth*gFrameHeight*
            (dpy_depth > 8 ? sizeof (int)*4 :
             sizeof (unsigned char))*4)))
        error("malloc failed");
    }
    else {
      ximage_137 = XCreateImage(display,visual,dpy_depth,ZPixmap,0,&dummy,
            gFrameWidth,gFrameHeight,8,0);
      if (!(dithered_image =
            (unsigned char *)malloc(gFrameWidth*gFrameHeight*
            (dpy_depth > 8 ? sizeof (int) :
             sizeof (unsigned char)))))
        error("malloc failed");
    }

#ifdef SH_MEM
  }

  DeInstallXErrorHandler();
#endif


  if (dpy_depth == 32 || dpy_depth == 24 || dpy_depth == 16) {
    XWindowAttributes xwa;

    XGetWindowAttributes(display, window, &xwa);


    wpixel_138[0] = xwa.visual->red_mask;
    wpixel_138[1] = xwa.visual->green_mask;
    wpixel_138[2] = xwa.visual->blue_mask;

    /* If the colors in 16/24/32-bit mode are wrong, try this instead
       of the above three lines */
    /*
    wpixel_138[2] = xwa.visual->red_mask;
    wpixel_138[1] = xwa.visual->green_mask;
    wpixel_138[0] = xwa.visual->blue_mask;
    */

    InitColorDither(dpy_depth == 24 || dpy_depth == 32);
  }
  else {
    ord4x4_dither_init ();
  }
}

static void exit_display()
{
#ifdef SH_MEM
  if (shmem_flag)
  {
    XShmDetach(display, &shminfo1);
    XDestroyImage(ximage_137);
    shmdt(shminfo1.shmaddr);
  }
#endif
}

static void display_image(XImage *ximage_137,unsigned char *dithered_image)
{
  int t = 1;

 /* Always work in native bit and byte order. This tells Xlib to
    reverse bit and byte order if necessary when crossing a
    network. Frankly, this part of XImages is somewhat
    underdocumented, so this may not be exactly correct.  */

  if (*(char *)&t == 1) {
    ximage_137->byte_order = LSBFirst;
    ximage_137->bitmap_bit_order = LSBFirst;
  }
  else {
    ximage_137->byte_order = MSBFirst;
    ximage_137->bitmap_bit_order = MSBFirst;
  }

  /* display dithered image */
#ifdef SH_MEM
  if (shmem_flag)
  {
    XShmPutImage(display, window, gc, ximage_137,
                 0, 0, 0, 0, ximage_137->width, ximage_137->height, True);
    XFlush(display);

    while (1)
    {
      XEvent xev;

      XNextEvent(display, &xev);
      if (xev.type == CompletionType)
        break;
    }
  }
  else
#endif
  {
    ximage_137->data = (char *) dithered_image;
    XPutImage(display, window, gc, ximage_137, 0, 0, 0, 0, ximage_137->width, ximage_137->height);
  }
}


static void dither(unsigned char *src[])
{
  if (dpy_depth == 24 || dpy_depth == 32) {
    if (ximage_137->bits_per_pixel == 24)
      ConvertYUVtoRGB(src[0],src[1],src[2], dithered_image,
                      gFrameWidth,
                      gFrameHeight);
    else
      Color32DitherImage(src, dithered_image);
  }
  else if (dpy_depth == 16) {
    Color16DitherImage(src, dithered_image);
  }
  else {
    ord4x4_dither_frame (src, dithered_image);
  }

  display_image (ximage_137, dithered_image);
}

#endif
/* main function */

void playerRuntime(void *);

#if 0
int player(int argc, char *argv[]);

int main(int argc, char *argv[]) {
	player(argc,argv);
}
#endif

struct IntBlock YBlock_0[4*MAX_WIDTH*MAX_HEIGHT/256];
struct IntBlock UBlock_1[MAX_WIDTH*MAX_HEIGHT>>8];
struct IntBlock VBlock_2[MAX_WIDTH*MAX_HEIGHT>>8];
struct Frame outputY_33[2];
struct HalfFrame outputU_34[2];
struct HalfFrame outputV_35[2];

void playerRuntime(void *y) {
  int comp_66;
  int MBA_67, MBAmax_68;
  int bx_69, by_70;

  int COD_71=0,MCBPC_72, CBPY_73, DQUANT_74;
  int pmv0_75, pmv1_76, xpos_77, ypos_78, gob_79;
  int k_80;
  int gfid_81, gobheader_read_82;
  int offset_83,bsize_84,last_done_85=0;
  int DQ_tab_86[4] = {-1,-2,1,2};
  short *bp_87;
  int x_88,y_89;
  static int first=1;
  static int framenum=0;
  int dx_index_90=0, dy_index_91=0;
  int dx_array_92[11], dy_array_93[11];
int dx_3[MAX_WIDTH*MAX_HEIGHT>>8];
int dy_4[MAX_WIDTH*MAX_HEIGHT>>8];
int mode_5[MAX_WIDTH*MAX_HEIGHT>>8];
int CBP_6[MAX_WIDTH*MAX_HEIGHT>>8];
int QP_7[MAX_WIDTH*MAX_HEIGHT>>8];
int type_8;
int input_94;
int output_9[4];
int input_95;
int DeQP_96;
int mode_97;
struct IntBlock output_10;
struct IntBlock output_11;
int mode_98;
int enable_99;
struct IntBlock output_14[4];
int output_100;
int input_101;
int DeQP_102;
int mode_103;
struct IntBlock output_15;
struct IntBlock output_16;
int mode_104;
struct IntBlock output_19;
int input_105;
int DeQP_106;
int mode_107;
struct IntBlock output_20;
struct IntBlock output_21;
int mode_108;
struct IntBlock output_24;
int input_109;
int output_28[4];
int prevY_110_phase = 0;
int prevY_110;
int prevU_111_phase = 0;
int prevU_111;
int prevV_112_phase = 0;
int prevV_112;
int dx_113;
int dy_114;
int mode_115;
int type_145_phase = 0;
int outputY_116_phase = 0;
int outputY_116;
int outputU_117_phase = 0;
int outputU_117;
int outputV_118_phase = 0;
int outputV_118;
int input_119;
int CBPY_42[4];
int CBPU_43;
int CBPV_44;
int output_45;
int Y_120;
int U_121;
int V_122;
//struct paapi_thread_data_t *th_data = (struct paapi_thread_data_t *)y; 
unsigned change = 0;

mainInit:
{int i; for(i=0;i<((gFrameWidth*gFrameHeight)>>8);i++) dx_3[i] = 0;}
{int i; for(i=0;i<((gFrameWidth*gFrameHeight)>>8);i++) dy_4[i] = 0;}
{int i; for(i=0;i<((gFrameWidth*gFrameHeight)>>8);i++) mode_5[i] = 0;}
{int i; for(i=0;i<((gFrameWidth*gFrameHeight)>>8);i++) CBP_6[i] = 0;}
{int i; for(i=0;i<((gFrameWidth*gFrameHeight)>>8);i++) QP_7[i] = 0;}
type_8 = 0;
	{
	int timeout;
	struct sockaddr_in addr;

  //paapi_dvs_app_associate((struct paapi_thread_data_t *)y);
	printf("creating sock"); fflush(stdout);
	/* connect to the server */
	for (timeout = 0; ; timeout++) {
	       /* Open a TCP socket (an Internet stream socket */
	       // if ((connectionId_65 = socket(AF_INET, SOCK_DGRAM, 0)) < 0) {
	       if ((connectionId_65 = socket(AF_INET, CONNECTION_METHOD, 0)) < 0) {
		       printf("cannot open socket for %d.\n", gServerPort);
		       exit(1);
	       }

	       /* Fill in the structure addr with the address of the server
		  that we want to connect with */
	       memset((char*) &addr, 0, sizeof(addr));
	       addr.sin_family = AF_INET;
	       addr.sin_addr.s_addr = inet_addr(gServerIP);
	       addr.sin_port = htons(gServerPort);

	       if (!connect(connectionId_65, (struct sockaddr*) &addr, sizeof(addr)))
		       break;
	       sleep(1);
	}
	}
	/*  options(&argc,&argv); */

	  /* pointer to name of output files */
	 /*   outputname = argv[argc-1]; */
         
	  ld_63 = &base_64; 
	  /* open MPEG input file(s) */

	  initbits();
	  temp_ref_56 = 0;
	  prev_temp_ref_57 -1; 
input_94 = 0;
{int i; for(i=0;i<4;i++) output_9[i] = 0;}
input_95 = 0;
DeQP_96 = 0;
mode_97 = 0;
mode_98 = 0;
enable_99 = 0;
output_100 = 0;
	init_idct();
input_101 = 0;
DeQP_102 = 0;
mode_103 = 0;
mode_104 = 0;
	init_idct();
input_105 = 0;
DeQP_106 = 0;
mode_107 = 0;
mode_108 = 0;
	init_idct();
input_109 = 0;
{int i; for(i=0;i<4;i++) output_28[i] = 0;}
prevY_110 = 1;
prevU_111 = 1;
prevV_112 = 1;
dx_113 = 0;
dy_114 = 0;
mode_115 = 0;
outputY_116 = 0;
outputU_117 = 0;
outputV_118 = 0;
input_119 = 0;
{int i; for(i=0;i<4;i++) CBPY_42[i] = 0;}
CBPU_43 = 0;
CBPV_44 = 0;
output_45 = 0;
Y_120 = 0;
U_121 = 0;
V_122 = 0;
#ifdef DISPLAY
    init_display("");
#endif
#ifdef WINDOWS
    initDisplay(gFrameWidth, gFrameHeight);
#endif
while(1) {
	{  /* star H263DecoderStream.ConstIntI25 (class CGCConstInt) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 0);
#endif
	output_45 = 0.0;
	}
	{  /* star H263DecoderStream.H263FrameDecodeNetworkI0 (class CGCH263FrameDecodeNetwork) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 1);
#endif
  int phase;
#ifdef _READ_OPTIMIZE
//  phase = available(connectionId_65);
  //paapi_dvs_app_start();
  read(connectionId_65,(char *)ld_63->rdbfr,phase);
  ld_63->rdbfr[phase++] = 0;
  ld_63->rdbfr[phase++] = 0;
  ld_63->rdbfr[phase++] = (1 << 7) | (SE_CODE << 2);
  initbits();
#endif 
  for(phase=0; phase<gFrameWidth*gFrameHeight/(16*16); phase++) {
    int index = gFrameWidth*gFrameHeight/(16*16)-1 -phase;  

  if(phase==0) {
    getheader();
    if (first) {
/*	initdecoder(); */
        first = 0; 
    }

  /* number of macroblocks per picture */
  MBAmax_68 = gFrameWidth*gFrameHeight/(16*16);

  MBA_67 = 0; /* macroblock address */
  newgob_48 = 0;

  fault_54 = 0;
  gobheader_read_82 = 0;
    } 

  /* loop start : produce blocks */

    if (0)
      printf("frame %d, MB %d\n",framenum,phase);
  resync_140:

    /* This version of the decoder does not resync on every possible
       error, and it does not do all possible error checks. It is not
       difficult to make it much more error robust, but I do not think
       it is necessary to include this in the freely available
       version. */

    if (fault_54) {
      printf("Warning: A Fault Condition Has Occurred - Resyncing \n");
	return;
      startcode();  /* sync on new startcode */
      fault_54 = 0;
    }

    /* reset motion vectors */
    dx_3[(98-(index))] = 0;
    dy_4[(98-(index))] = 0;

    if (!(showbits(22)>>6)) { /* startcode */

      startcode();  
      /* in case of byte aligned start code, ie. PSTUF, GSTUF or ESTUF
         is used */
      
      if (showbits(22) == (32|SE_CODE)) { /* end of sequence */
        if (!(phase < MBAmax_68)) {
          printf("end of sequence!\n");
          return;
        }
      }
      else if ((showbits(22) == PSC<<5) ) { /* new picture */
        if (!(phase < MBAmax_68)) {
//          return;
            break;

        }
      }
      else {
        if (!(phase%(gFrameWidth/16))) {

          gob_79 = getheader() - 1;
          if (gob_79 > gFrameHeight) {
            if (!quiet_46)
              printf("GN out of range\n");
            return;
          }
          
          /* GFID is not allowed to change unless PTYPE in picture header 
             changes */
          gfid_81 = getbits(2);
          /* NB: in error-prone environments the decoder can use this
             value to determine whether a picture header where the PTYPE
             has changed, has been lost */
          
          quant_58 = getbits(5);
          if (0)
            printf("GQUANT: %d\n", quant_58);
          xpos_77 = 0;
          ypos_78 = gob_79;
    //    MBA = ypos_78 * gFrameWidth;
          
          newgob_48 = 1;
          gobheader_read_82 = 1;
        }
      }
    }

    if (!gobheader_read_82) {
      xpos_77 = phase%(gFrameWidth/16);
      ypos_78 = phase/(gFrameWidth/16);
      if (xpos_77 == 0 && ypos_78 > 0)
        newgob_48 = 0;
    }
    else 
      gobheader_read_82 = 0;

  read_cod_141:
    if (pict_type_47 == PCT_INTER) 
        COD_71 = showbits(1);
    else
        COD_71 = 0; /* Intra picture -> not skipped */
  
    if (!COD_71) {  /* COD == 0 --> not skipped */    

        if (pict_type_47 == PCT_INTER)
          flushbits(1); /* flush COD bit */
        if (pict_type_47 == PCT_INTRA) 
          MCBPC_72 = getMCBPCintra();
        else
          MCBPC_72 = getMCBPC();
 
      if (fault_54) goto resync_140;
      
      if (MCBPC_72 == 255) { /* stuffing */
        goto read_cod_141;   /* read next COD without advancing MB count */
      }

      else {             /* normal MB data */

       mode_5[(98-(index))] = MCBPC_72 & 7;
 
       CBPY_73 = getCBPY();
 
        /* Decode Mode and CBP */
        
          if (mode_5[(98-(index))] == MODE_INTRA || mode_5[(98-(index))] == MODE_INTRA_Q)
          {/* Intra */
             CBPY_73 = CBPY_73^15;        /* needed in huffman coding only */
          }
           CBP_6[(98-(index))] = (CBPY_73 << 2) | (MCBPC_72 >> 4);
      }

      if (mode_5[(98-(index))] == MODE_INTER_Q || mode_5[(98-(index))] == MODE_INTRA_Q) {
        /* Read DQUANT if necessary */

          DQUANT_74 = getbits(2);
          quant_58 += DQ_tab_86[DQUANT_74];
          if (0) {
            printf("DQUANT (");
            printbits(DQUANT_74,2,2);
            printf("): %d = %d\n",DQUANT_74,DQ_tab_86[DQUANT_74]);
          }
        if (quant_58 > 31 || quant_58 < 1) {
          if (!quiet_46)
            printf("Quantizer out of range: clipping\n");
          quant_58 = mmax(1,mmin(31,quant_58));
          /* could set fault-flag and resync here */
        }
      }

      /* motion vectors */
      if (mode_5[(98-(index))] == MODE_INTER || mode_5[(98-(index))] == MODE_INTER_Q) {

          dx_3[(98-(index))] = getTMNMV();
          dy_4[(98-(index))] = getTMNMV();
          k_80 = 0;

          FindPMV(dx_array_92[(dx_index_90-1+11)%11],dy_array_93[(dy_index_91-1+11)%11],dx_array_92[dx_index_90],dy_array_93[dy_index_91],dx_array_92[(dx_index_90-10+11)%11],dy_array_93[(dy_index_91-10+11)%11],xpos_77,ypos_78,&pmv0_75,&pmv1_76);

          dx_3[(98-(index))] = motion_decode(dx_3[(98-(index))], pmv0_75);
          dy_4[(98-(index))] = motion_decode(dy_4[(98-(index))], pmv1_76);

          dx_array_92[dx_index_90] = dx_3[(98-(index))];
          dy_array_93[dy_index_91] = dy_4[(98-(index))];

          if (0) {
            printf("mvx: %d\n", dx_3[(98-(index))]);
            printf("mvy: %d\n", dy_4[(98-(index))]);
          }
          /* Check mv's to prevent seg.faults when error rate is high */
       
            bsize_84 = k_80 ? 8 : 16;
            offset_83 = k_80 ? (((k_80-1)&1)<<3) : 0;
            /* checking only integer component */
            if ((xpos_77<<4) + (dx_3[(98-(index))]/2) + offset_83 < 0 || (xpos_77<<4) + (dx_3[(98-(index))]/2) + offset_83 > (gFrameWidth<<4) - bsize_84) {
              if (!quiet_46)
    		 printf("mvx out of range: searching for sync\n");
              fault_54 = 1;
            }
            offset_83 = k_80 ? (((k_80-1)&2)<<2) : 0;
            if ((ypos_78<<4) + (dy_4[(98-(index))]/2) + offset_83 < 0 ||(ypos_78<<4) + (dy_4[(98-(index))]/2) + offset_83 > (gFrameHeight<<4) - bsize_84) {
              if (!quiet_46)   printf("mvy out of range: searching for sync\n");
              fault_54 = 1;
            }
       }


      if (fault_54) goto resync_140;

    }
    else { /* COD == 1 --> skipped MB */
      if (1)
        if (pict_type_47 == PCT_INTER)
          flushbits(1);

      mode_5[(98-(index))] = MODE_INTER;
      
      /* Reset CBP */
      CBP_6[(98-(index))] = 0;

      /* reset motion vectors */
      dx_3[(98-(index))] = 0;
      dy_4[(98-(index))] = 0;
    }

  reconstruct_mb_142:

    /* pixel coordinates of top left corner of current macroblock */
    /* one delayed because of OBMC */
    if (xpos_77 > 0) {
      bx_69 = 16*(xpos_77-1);
      by_70 = 16*ypos_78;
    }
    else {
      bx_69 = gFrameWidth-16;
      by_70 = 16*(ypos_78-1);
    }

    if (phase > 0) {

      x_88 = bx_69/16+1;
      y_89 = by_70/16+1;

      /* motion compensation for P-frame */
      if (mode_5[(98-(index))] == MODE_INTER || mode_5[(98-(index))] == MODE_INTER_Q)
      {
        // reconstruct(bx_69,by_70,1,0,0);
	if (0)
         printf(" (bx, by) = (%d,%d), (dx,dy) = (%d,%d) \n",bx_69,by_70,dx_3[(98-(index))],dy_4[(98-(index))]);
      }

     
    } /* end : macro block decoding */

    if (!COD_71) {


      /* decode blocks */
      for (comp_66=0; comp_66<6; comp_66++) {

        clearblock(comp_66);
        if (mode_5[(98-(index))] == MODE_INTRA || mode_5[(98-(index))] == MODE_INTRA_Q) { /* Intra */
          bp_87 = ld_63->block[comp_66];
          bp_87[0] = getbits(8);
          if (0) {
              printf("DC[%d]: (",comp_66);
              printbits((int)bp_87[0],8,8);
              printf("): %d\n",(int)bp_87[0]);
          }

          if (bp_87[0] == 128)
            if (!quiet_46)
              fprintf(stderr,"Illegal DC-coeff: 1000000\n");
          if (bp_87[0] == 255)  /* Spec. in H.26P, not in TMN4 */
            bp_87[0] = 128;
          if ( (CBP_6[(98-(index))] & (1<<(6-1-comp_66))) ) {
		  getblock(comp_66,0);
          }
        }
        else { /* Inter */
          if ( (CBP_6[(98-(index))] & (1<<(6-1-comp_66))) ) {
		getblock(comp_66,1);
          }

        }
        if (fault_54) goto resync_140;
      }
    }

    /* advance to next macroblock */
    fflush(stdout);

    if (phase >= MBAmax_68 && !last_done_85) {
      COD_71 = 1;
      xpos_77 = 0;
      ypos_78++;
      last_done_85 = 1;
      goto reconstruct_mb_142;
    }

      /* copy or add block data into P-picture */
      /* inverse DCT */
      for(comp_66=0; comp_66<6; comp_66++) {
	int i;	
        if (mode_5[(98-(index))] == MODE_INTRA || mode_5[(98-(index))] == MODE_INTRA_Q) {
          if (comp_66 <4) { 
            for (i=0;i<64;i++) { 
              YBlock_0[(395-(4*index+3-comp_66))].data[i] = (int)ld_63->block[comp_66][i];
	    }
          } else if (comp_66 == 4) {
            for (i=0;i<64;i++){
		UBlock_1[(98-(index))].data[i] = (int)ld_63->block[comp_66][i];
	    }
          } else { 
            for (i=0;i<64;i++) {
		VBlock_2[(98-(index))].data[i] = (int)ld_63->block[comp_66][i];
	    }
          }
        } else if ( (CBP_6[(98-(index))] & (1<<(6-1-comp_66))) ) {
          /* No need to to do this for blocks with no coeffs */
          if (comp_66 <4) { 
            for (i=0;i<64;i++) {
              YBlock_0[(395-(4*index+3-comp_66))].data[i] = (int)ld_63->block[comp_66][i];
            }
          }
          else if (comp_66 == 4) {
            for (i=0;i<64;i++) {
              UBlock_1[(98-(index))].data[i] = (int)ld_63->block[comp_66][i];
            }
          }
	  else { 
            for (i=0;i<64;i++) {
              VBlock_2[(98-(index))].data[i] = (int)ld_63->block[comp_66][i];
            }
          }
        } else {
          /* CBP == 0 */
          if (comp_66 <4) {
            for (i=0;i<64;i++) {
              YBlock_0[(395-(4*index+3-comp_66))].data[i] = 0;
            }
          }
          else if (comp_66 == 4) {
            for (i=0;i<64;i++) {
              UBlock_1[(98-(index))].data[i] = 0;
            }
          }
          else {
            for (i=0;i<64;i++) {
              VBlock_2[(98-(index))].data[i] = 0;
            }
          }
        }
      } //end  for 

   /* update dx,dy index */
   dx_array_92[dx_index_90] = dx_3[(98-(index))];
   dy_array_93[dy_index_91] = dy_4[(98-(index))];

   dx_index_90++; dy_index_91++;
   if(dx_index_90>=11)
     dx_index_90-=11;

   if(dy_index_91>=11)
     dy_index_91-=11;

   /* end of getMBs */

    QP_7[(98-(index))] = quant_58; 	

    if(phase==0) {
      if (pict_type_47 == PCT_INTER) 
        type_8 = 1;
      else
        type_8 = 0;
     }

     if (0 && phase==98)
       framenum++;
	}
	}
	{  /* star H263DecoderStream.FRDecForDecI10.ForkI31 (class CGCFork) */
	}
	{  /* star H263DecoderStream.BlackHoleI23 (class CGCBlackHole) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 2);
#endif
/* This star generates no code */
	}
	{  /* star H263DecoderStream.FRDecForDecI10.ForkI77 (class CGCFork) */
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI25.ForkI18 (class CGCFork) */
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI19.ForkI18 (class CGCFork) */
	}
        { int sdfLoopCounter_143;for (sdfLoopCounter_143 = 0; sdfLoopCounter_143 < ((gFrameWidth*gFrameHeight)>>8); sdfLoopCounter_143++) {
	{  /* star H263DecoderStream.FRDecForDecI10.RepeatI36 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 3);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_28[(3-(i))] = mode_5[input_109];
	}
	input_109 += 1;
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI25.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 4);
#endif
		doDeQuantizer(output_20.data,VBlock_2[input_105].data,QP_7[DeQP_106],mode_5[mode_107]);
	input_105 += 1;
	DeQP_106 += 1;
	mode_107 += 1;
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI25.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 5);
#endif
		doInvZigzag(output_21.data,output_20.data);
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI19.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 6);
#endif
		doDeQuantizer(output_15.data,UBlock_1[input_101].data,QP_7[DeQP_102],mode_5[mode_103]);
	input_101 += 1;
	DeQP_102 += 1;
	mode_103 += 1;
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI19.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 7);
#endif
		doInvZigzag(output_16.data,output_15.data);
	}
	{  /* star H263DecoderStream.FRDecForDecI10.H263UnpackCBPI82 (class CGCH263UnpackCBP) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 8);
#endif
		if(CBP_6[input_119]&32) CBPY_42[(3-(3))] = 1;
		else CBPY_42[(3-(3))] = 0;
		if(CBP_6[input_119]&16) CBPY_42[(3-(2))] = 1;
		else CBPY_42[(3-(2))] = 0;
		if(CBP_6[input_119]&8) CBPY_42[(3-(1))] = 1;
		else CBPY_42[(3-(1))] = 0;
		if(CBP_6[input_119]&4) CBPY_42[(3-(0))] = 1;
		else CBPY_42[(3-(0))] = 0;
		if(CBP_6[input_119]&2) CBPU_43 = 1;
		else CBPU_43 = 0;
		if(CBP_6[input_119]&1) CBPV_44 = 1;
		else CBPV_44 = 0;
	input_119 += 1;
	}
	{  /* star H263DecoderStream.FRDecForDecI10.RepeatI0 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 9);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_9[(3-(i))] = QP_7[input_94];
	}
	input_94 += 1;
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI13.ForkI18 (class CGCFork) */
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI25.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 10);
#endif
		if(CBPV_44)
                	doIDCT(output_24.data,output_21.data);
		else if(mode_5[mode_108]==MODE_INTRA || mode_5[mode_108]==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_24.data[i] = output_21.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_24.data[i] = 0;
		}
	mode_108 += 1;
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI19.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 11);
#endif
		if(CBPU_43)
                	doIDCT(output_19.data,output_16.data);
		else if(mode_5[mode_104]==MODE_INTRA || mode_5[mode_104]==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_19.data[i] = output_16.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_19.data[i] = 0;
		}
	mode_104 += 1;
	}
            { int sdfLoopCounter_144;for (sdfLoopCounter_144 = 0; sdfLoopCounter_144 < 4; sdfLoopCounter_144++) {
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI13.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 12);
#endif
		doDeQuantizer(output_10.data,YBlock_0[input_95].data,output_9[DeQP_96],output_28[mode_97]);
	input_95 += 1;
	DeQP_96 += 1;
	if (DeQP_96 >= 4)
		DeQP_96 -= 4;
	mode_97 += 1;
	if (mode_97 >= 4)
		mode_97 -= 4;
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI13.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 13);
#endif
		doInvZigzag(output_11.data,output_10.data);
	}
	{  /* star H263DecoderStream.FRDecForDecI10.BlkDecI13.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 14);
#endif
		if(CBPY_42[enable_99])
                	doIDCT(output_14[output_100].data,output_11.data);
		else if(output_28[mode_98]==MODE_INTRA || output_28[mode_98]==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_14[output_100].data[i] = output_11.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_14[output_100].data[i] = 0;
		}
	mode_98 += 1;
	if (mode_98 >= 4)
		mode_98 -= 4;
	enable_99 += 1;
	if (enable_99 >= 4)
		enable_99 -= 4;
	output_100 += 1;
	if (output_100 >= 4)
		output_100 -= 4;
	}
}} /* end repeat, depth 3*/
	{  /* star H263DecoderStream.FRDecForDecI10.H263FRReconI55 (class CGCH263FRRecon) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 15);
#endif
		int x_curr = (outputY_116_phase*16)%gFrameWidth;
		int y_curr = 16*((outputY_116_phase*16)/gFrameWidth);
		int dx, dy;

		if(mode_5[mode_115] == MODE_INTER || mode_5[mode_115] == MODE_INTER_Q) {
			// reconstruct luminance  
      			reconBlockIntoImage(x_curr,y_curr,dx_3[dx_113],dy_4[dy_114],
				(unsigned char *)outputY_33[prevY_110].data,output_14[(3-(3))].data,
				outputY_33[outputY_116].data,gFrameWidth);
      			reconBlockIntoImage(x_curr+8,y_curr,dx_3[dx_113],dy_4[dy_114],
				(unsigned char *)outputY_33[prevY_110].data,output_14[(3-(2))].data,
				outputY_33[outputY_116].data,gFrameWidth);
      			reconBlockIntoImage(x_curr,y_curr+8,dx_3[dx_113],dy_4[dy_114],
				(unsigned char *)outputY_33[prevY_110].data,output_14[(3-(1))].data,
				outputY_33[outputY_116].data,gFrameWidth);
      			reconBlockIntoImage(x_curr+8,y_curr+8,dx_3[dx_113],dy_4[dy_114],
				(unsigned char *)outputY_33[prevY_110].data,output_14[(3-(0))].data,
				outputY_33[outputY_116].data,gFrameWidth);

			// reconstruct chrominance
			dx = dx_3[dx_113];
			dy = dy_4[dy_114];
			dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
			dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );
      			reconBlockIntoImage(x_curr/2,y_curr/2,dx,dy,
				(unsigned char *)outputU_34[prevU_111].data,output_19.data,
				outputU_34[outputU_117].data,gFrameWidth/2);
      			reconBlockIntoImage(x_curr/2,y_curr/2,dx,dy,
				(unsigned char *)outputV_35[prevV_112].data,output_24.data,
				outputV_35[outputV_118].data,gFrameWidth/2);
		} else {
			// copy
			copyBlockIntoImage(x_curr,y_curr,output_14[(3-(3))].data,
				(unsigned char *)outputY_33[outputY_116].data,gFrameWidth);
			copyBlockIntoImage(x_curr+8,y_curr,output_14[(3-(2))].data,
				(unsigned char *)outputY_33[outputY_116].data,gFrameWidth);
			copyBlockIntoImage(x_curr,y_curr+8,output_14[(3-(1))].data,
				(unsigned char *)outputY_33[outputY_116].data,gFrameWidth);
			copyBlockIntoImage(x_curr+8,y_curr+8,output_14[(3-(0))].data,
				(unsigned char *)outputY_33[outputY_116].data,gFrameWidth);
			copyBlockIntoImage(x_curr/2,y_curr/2,output_19.data,
				(unsigned char *)outputU_34[outputU_117].data,gFrameWidth/2);
			copyBlockIntoImage(x_curr/2,y_curr/2,output_24.data,
				(unsigned char *)outputV_35[outputV_118].data,gFrameWidth/2);
		}
prevY_110_phase = (prevY_110_phase+1)%((gFrameWidth*gFrameHeight)>>8);
prevU_111_phase = (prevU_111_phase+1)%((gFrameWidth*gFrameHeight)>>8);
prevV_112_phase = (prevV_112_phase+1)%((gFrameWidth*gFrameHeight)>>8);
type_145_phase = (type_145_phase+1)%((gFrameWidth*gFrameHeight)>>8);
outputY_116_phase = (outputY_116_phase+1)%((gFrameWidth*gFrameHeight)>>8);
outputU_117_phase = (outputU_117_phase+1)%((gFrameWidth*gFrameHeight)>>8);
outputV_118_phase = (outputV_118_phase+1)%((gFrameWidth*gFrameHeight)>>8);
	if (prevY_110_phase == 0)
		prevY_110 += 1;
	if (prevY_110 >= 2)
		prevY_110 -= 2;
	if (prevU_111_phase == 0)
		prevU_111 += 1;
	if (prevU_111 >= 2)
		prevU_111 -= 2;
	if (prevV_112_phase == 0)
		prevV_112 += 1;
	if (prevV_112 >= 2)
		prevV_112 -= 2;
	dx_113 += 1;
	dy_114 += 1;
	mode_115 += 1;
	if (outputY_116_phase == 0)
		outputY_116 += 1;
	if (outputY_116 >= 2)
		outputY_116 -= 2;
	if (outputU_117_phase == 0)
		outputU_117 += 1;
	if (outputU_117 >= 2)
		outputU_117 -= 2;
	if (outputV_118_phase == 0)
		outputV_118 += 1;
	if (outputV_118 >= 2)
		outputV_118 -= 2;
	}
}} /* end repeat, depth 2*/
	{  /* star H263DecoderStream.FRDecForDecI10.ForkI43 (class CGCFork) */
	}
	{  /* star H263DecoderStream.FRDecForDecI10.ForkI71 (class CGCFork) */
	}
	{  /* star H263DecoderStream.FRDecForDecI10.ForkI39 (class CGCFork) */
	}
	{  /* star H263DecoderStream.H263DisplayFrameI27 (class CGCH263DisplayFrame) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 16);
#endif
#ifdef DISPLAY
  unsigned char* frame[3];

  frame[0] = (unsigned char *)outputY_33[Y_120].data;
  frame[1] = (unsigned char *)outputU_34[U_121].data;
  frame[2] = (unsigned char *)outputV_35[V_122].data;

  dither(frame);
#endif
#ifdef WINDOWS
  displayImage(outputY_33[Y_120].data,outputU_34[U_121].data,outputV_35[V_122].data);
#endif
	Y_120 += 1;
	if (Y_120 >= 2)
		Y_120 -= 2;
	U_121 += 1;
	if (U_121 >= 2)
		U_121 -= 2;
	V_122 += 1;
	if (V_122 >= 2)
		V_122 -= 2;
	}
input_109 = 0;
input_105 = 0;
DeQP_106 = 0;
mode_107 = 0;
input_101 = 0;
DeQP_102 = 0;
mode_103 = 0;
input_119 = 0;
input_94 = 0;
mode_108 = 0;
mode_104 = 0;
input_95 = 0;
dx_113 = 0;
dy_114 = 0;
mode_115 = 0;
//paapi_dvs_app_done();
if ( change++ == 10 ) {
  //struct thread_type_t th_type_info;
  //th_type_info.wcet = 6;
  //th_type_info.deadline = 8;
  //th_type_info.period = 8;
  //paapi_dvs_change_thread_type(&th_type_info);
}
//paapi_dvs_app_sleep_until_next_period(); 
} /* end while, depth 0*/
close(base_64.infile);
#ifdef DISPLAY
    exit_display();
#endif
#ifdef WINDOWS
    closeDisplay();
#endif
//paapi_dvs_app_leave();
return 1;
}
