/* User:      jihyek
   Date:      Fri May 14 10:57:57 2004
   Target:    default-CGC
   Universe:  H263Trans */

/* Define macro for prototyping functions on ANSI & non-ANSI compilers */
#ifndef ARGS
#if defined(__STDC__) || defined(__cplusplus)
#define ARGS(args) args
#else
#define ARGS(args) ()
#endif
#endif

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <limits.h>
#include "api.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

/* Define constants TRUE and FALSE for portability */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* Define a complex data type if one has not been defined */
#if !defined(COMPLEX_DATA)
#define COMPLEX_DATA 1
typedef struct complex_data { double real; double imag; } complex;
#endif

#define CGC_MOD(a,b) ((a)>=(b) ? (a-b):(a))

/* define NON_ANSI_COMPILER for compilers without function prototyping */
/* #define NON_ANSI_COMPILER */

#ifdef NON_ANSI_COMPILER
#define _ANSI_ARGS_(x) ()
#else
#define _ANSI_ARGS_(x) x
#endif

#ifndef O_BINARY
#define O_BINARY 0
#endif
/* Some macros */
#define mmax(a, b)        ((a) > (b) ? (a) : (b))
#define mmin(a, b)        ((a) < (b) ? (a) : (b))
#define mnint(a)        ((a) < 0 ? (int)(a - 0.5) : (int)(a + 0.5))
#define sign(a)         ((a) < 0 ? -1 : 1)
#define PSC        1
#define PSC_LENGTH        17
#define SE_CODE                         31

#define ESCAPE                          7167

#define PCT_INTER                       1
#define PCT_INTRA                       0
#define ON                              1
#define OFF                             0
int quiet_169;
static char errortext[256];
unsigned char *clp_170;
int pict_type_171,newgob_172;
int mv_outside_frame_173,syntax_arith_coding_174,adv_pred_mode_175,pb_frame_176;
int long_vectors_177;
int fault_178;
int verbose_179;
int temp_ref_180, prev_temp_ref_181, quant_182, source_format_183;
#ifdef USE_TIME
int framerate;
#ifndef WIN32
struct timeval tftarget;
#endif
#endif

int trd_184, trb_185, bquant_186;

/* output */
// int outtype;
#define T_YUV      0
#define T_SIF      1
#define T_TGA      2
#define T_PPM      3
#define T_X11      4
#define T_YUV_CONC 5
#define T_WIN      6

struct ld_187 {
  /* bit input */
  int infile;
  unsigned char rdbfr[2051];
  unsigned char *rdptr;
  unsigned char inbfr[16];
  int incnt;
  int bitcnt;
  /* block data */
  short block[6][64];
} base_188,*ld_187;
#define sign(a)        ((a) < 0 ? -1 : 1)
#define Int(a)          ((a) < 0 ? (int)(a-0.5) : (int)(a))
#define mnint(a)        ((a) < 0 ? (int)(a - 0.5) : (int)(a + 0.5))
#define mfloor(a)       ((a) < 0 ? (int)(a - 0.5) : (int)(a))
#define mmax(a, b)        ((a) > (b) ? (a) : (b))
#define mmin(a, b)        ((a) < (b) ? (a) : (b))
#define limit(x) \
{ \
    if (x > 255) x = 255; \
    if (x <   0)   x = 0; \
}
#define MODE_INTER                      0
#define MODE_INTER_Q                    1
#define MODE_INTER4V                    2
#define MODE_INTRA                      3
#define MODE_INTRA_Q                    4
                struct IntBlock {
                        int data[64];
                };
		static int     zigzag[8][8] = {
				{0, 1, 5, 6,14,15,27,28},
				{2, 4, 7,13,16,26,29,42},
				{3, 8,12,17,25,30,41,43},
				{9,11,18,24,31,40,44,53},
				{10,19,23,32,39,45,52,54},
				{20,22,33,38,46,51,55,60},
				{21,34,37,47,50,56,59,61},
				{35,36,48,49,57,58,62,63},
			};
/**********************************************************/
/* inverse two dimensional DCT, Chen-Wang algorithm       */
/* (cf. IEEE ASSP-32, pp. 803-816, Aug. 1984)             */
/* 32-bit integer arithmetic (8 bit coefficients)         */
/* 11 mults, 29 adds per DCT                              */
/*                                      sE, 18.8.91       */
/**********************************************************/
/* coefficients extended to 12 bit for IEEE1180-1990      */
/* compliance                           sE,  2.1.94       */
/**********************************************************/

/* this code assumes >> to be a two's-complement arithmetic */
/* right shift: (-2)>>1 == -1 , (-3)>>1 == -2               */

#define W1 2841 /* 2048*sqrt(2)*cos(1*pi/16) */
#define W2 2676 /* 2048*sqrt(2)*cos(2*pi/16) */
#define W3 2408 /* 2048*sqrt(2)*cos(3*pi/16) */
#define W5 1609 /* 2048*sqrt(2)*cos(5*pi/16) */
#define W6 1108 /* 2048*sqrt(2)*cos(6*pi/16) */
#define W7 565  /* 2048*sqrt(2)*cos(7*pi/16) */

/* global declarations */
static void init_idct (void);

/* private data */
static short iclip[1024]; /* clipping table */
static short *iclp;

/* private prototypes */
static void idctrow (int *blk);
static void idctcol (int *blk);

/* row (horizontal) IDCT
 *
 *           7                       pi         1
 * dst[k] = sum c[l] * src[l] * cos( -- * ( k + - ) * l )
 *          l=0                      8          2
 *
 * where: c[0]    = 128
 *        c[1..7] = 128*sqrt(2)
 */
		struct Frame {
			char data[MAX_WIDTH*MAX_HEIGHT];
		};
		struct HalfFrame {
			char data[MAX_WIDTH*MAX_HEIGHT/4];
		};
// The followings are my definitions
#define I_FRAME                         0
#define P_FRAME                         1
#define B_FRAME                         2

#define PP_FRAME                        0
#define PB_FRAME                        4
#define MODE_INTER                      0
#define MODE_INTER_Q                    1
#define MODE_INTER4V                    2
#define MODE_INTRA                      3
#define MODE_INTRA_Q                    4
#define I_FRAME                         0
#define P_FRAME                         1
#define B_FRAME                         2
#define PP_FRAME                        0
#define PB_FRAME                        4
#define NO_VEC                          999
/* Parameters from TMN */
#define PREF_NULL_VEC 0
#define PREF_16_VEC 200
#define PREF_PBDELTA_NULL_VEC 50
#define DEF_SEEK_DIST   15

/* default integer search window for 8x8 search centered
   around 16x16 vector. When it is zero only half pel estimation
   around the integer 16x16 vector will be performed */
/* for best performance, keep this small, preferably zero,
   but do your own simulations if you want to try something else */
#define DEF_8X8_WIN     0

/* default search window for PB delta vectors */
/* keep this small also */
#define DEF_PBDELTA_WIN   2
		struct IntFrame {
			int data[MAX_WIDTH*MAX_HEIGHT];
		};
		struct IntHalfFrame {
			int data[MAX_WIDTH*MAX_HEIGHT/4];
		};
		struct DoubleFrame {
			unsigned char data[MAX_WIDTH*MAX_HEIGHT*4];
		};
typedef struct motionvector {
int x;        /* Horizontal comp. of mv         */
int y;        /* Vertical comp. of mv         */
int x_half;        /* Horizontal half-pel acc.         */
int y_half;        /* Vertical half-pel acc.   */
int min_error;        /* Min error for this vector     */
int Mode;                     /* Necessary for adv. pred. mode */
} MotionVector;
typedef struct point {
  int x;
  int y;
} Point;
typedef int	DIFFPixel;
typedef unsigned char	Pixel;
#define SF_SQCIF                        1  /* 001 */
#define SF_QCIF                         2  /* 010 */
#define SF_CIF                          3  /* 011 */
#define SF_4CIF                         4  /* 100 */
#define SF_16CIF                        5  /* 101 */

/* default coding format
   choose one of SF_SQCIF, SF_QCIF, SF_CIF, SF_4CIF, SF_16CIF */
#define DEF_CODING_FORMAT   SF_QCIF
/* default reference frame rate, 25 or 30 Hz
 * (also option "-Z <n>") */
#define DEF_REF_FRAME_RATE   30.0

/* default number of skipped frames in original sequence compared to */
/* the reference picture rate ( also option "-O <n>" ) */
/* 3 means that the original sequence is grabbed at 6.25/7.5 Hz */
/* 0 means that the original sequence is grabbed at 25.0/30.0 Hz */
#define DEF_ORIG_SKIP      0

/* default skipped frames between encoded frames (P or B) */
/* reference is original sequence */
/* 2 means 8.33/10.0 fps encoded frame rate with 25.0/30.0 fps original */
/* 0 means 8.33/10.0 fps encoded frame rate with 8.33/10.0 fps original */
#define DEF_FRAMESKIP      0
/* default integer pel search seek distance ( also option "-s <n> " ) */
#define DEF_SEEK_DIST   15
/* Frame numbers to start and stop encoding at */

/* default frame number to start at (also option "-a <n>") */
#define DEF_START_FRAME   0

/* default frame number to stop at (also option "-b <n>") */
#define DEF_STOP_FRAME    0

/*************************************************************************/

#ifdef OFFLINE_RATE_CONTROL
/* start rate control after DEF_START_RATE_CONTROL % of sequence
 * has been encoded. Can be changed at run-time with option "-R <n>" */
#define DEF_START_RATE_CONTROL   0
#else
/* default target frame rate when rate control is used */
#define DEF_TARGET_FRAME_RATE 10.0
#endif
/* headerlength on concatenated 4:1:1 YUV input file
 * Can be changed at run-time with option -e <headerlength> */
#define DEF_HEADERLENGTH   0

/* insert sync after each DEF_INSERT_SYNC for increased error robustness
 * 0 means do not insert extra syncs */
#define DEF_INSERT_SYNC   0
typedef struct pict {
  int prev;
  int curr;
  int TR;             /* Time reference */
  int bit_rate;
  int src_frame_rate;
  float target_frame_rate;
  int source_format;
  int picture_coding_type;
  int spare;
  int unrestricted_mv_mode;
  int PB;
  int QUANT;
  int DQUANT;
  int MB;
  int seek_dist;        /* Motion vector search window */
  int use_gobsync;      /* flag for gob_sync */
  int MODB;             /* B-frame mode */
  int BQUANT;           /* which quantizer to use for B-MBs in PB-frame */
  int TRB;              /* Time reference for B-picture */
  float QP_mean;        /* mean quantizer */
} Pict;

typedef struct bits_counted {
  int Y;
  int C;
  int vec;
  int CBPY;
  int CBPCM;
  int MODB;
  int CBPB;
  int COD;
  int header;
  int DQUANT;
  int total;
  int no_inter;
  int no_inter4v;
  int no_intra;
/* NB: Remember to change AddBits(), ZeroBits() and AddBitsPicture()
   when entries are added here */
} Bits;

  int tr=0;	// time reference

  FILE* tf_260;
  FILE* streamfile_261;

  Pict globalPic_262;
  Bits globalBits_263;
  Bits globalTotalBits_264;

  Bits* total_bits = &globalTotalBits_264;

  Pict *pic = & globalPic_262;

  int connectionId_265;

  /* buffer control vars */
  float QP_cumulative = (float)0.0;
  int abs_mb_num = 0, QuantChangePostponed = 0;

  float mean_frame_rate, ref_frame_rate, frame_rate, seconds;
  int first_loop_finished=0;
  int total_frames_passed, PPFlag = 0, targetrate;
  int frames,bframes,pframes,wcopies,icopies, write_repeated,pdist=0,bdist=0;
  int start, end, frame_no, writediff;
  int first_frameskip, chosen_frameskip, orig_frameskip, frameskip;

#ifndef OFFLINE_RATE_CONTROL
  float DelayBetweenFramesInSeconds;
  int CommBacklog;
#else
  PictImage *stored_image = NULL;
  int start_rate_control;
#endif
unsigned char* outputBit_266;
		int QP_new_271,QP_prev_272,QP_xmitted_273;
typedef struct {
  int val, len;
} VLCtab;

typedef struct {
  char run, level, len;
} DCTtab;


static VLCtab TMNMVtab0[] = {
{3,4}, {61,4}, {2,3}, {2,3}, {62,3}, {62,3},
{1,2}, {1,2}, {1,2}, {1,2}, {63,2}, {63,2}, {63,2}, {63,2}
};

static VLCtab TMNMVtab1[] = {
{12,10}, {52,10}, {11,10}, {53,10}, {10,9}, {10,9},
{54,9}, {54,9}, {9,9}, {9,9}, {55,9}, {55,9},
{8,9}, {8,9}, {56,9}, {56,9}, {7,7}, {7,7},
{7,7}, {7,7}, {7,7}, {7,7}, {7,7}, {7,7},
{57,7}, {57,7}, {57,7}, {57,7}, {57,7}, {57,7},
{57,7}, {57,7}, {6,7}, {6,7}, {6,7}, {6,7},
{6,7}, {6,7}, {6,7}, {6,7}, {58,7}, {58,7},
{58,7}, {58,7}, {58,7}, {58,7}, {58,7}, {58,7},
{5,7}, {5,7}, {5,7}, {5,7}, {5,7}, {5,7},
{5,7}, {5,7}, {59,7}, {59,7}, {59,7}, {59,7},
{59,7}, {59,7}, {59,7}, {59,7}, {4,6}, {4,6},
{4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6},
{4,6}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6},
{4,6}, {4,6}, {60,6}, {60,6},{60,6},{60,6},
{60,6},{60,6},{60,6},{60,6},{60,6},{60,6},
{60,6},{60,6},{60,6},{60,6},{60,6},{60,6}
};

static VLCtab TMNMVtab2[] = {
{32,12}, {31,12}, {33,12}, {30,11}, {30,11}, {34,11},
{34,11}, {29,11}, {29,11}, {35,11}, {35,11}, {28,11},
{28,11}, {36,11}, {36,11}, {27,11}, {27,11}, {37,11},
{37,11}, {26,11}, {26,11}, {38,11}, {38,11}, {25,11},
{25,11}, {39,11}, {39,11}, {24,10}, {24,10}, {24,10},
{24,10}, {40,10}, {40,10}, {40,10}, {40,10}, {23,10},
{23,10}, {23,10}, {23,10}, {41,10}, {41,10}, {41,10},
{41,10}, {22,10}, {22,10}, {22,10}, {22,10}, {42,10},
{42,10}, {42,10}, {42,10}, {21,10}, {21,10}, {21,10},
{21,10}, {43,10}, {43,10}, {43,10}, {43,10}, {20,10},
{20,10}, {20,10}, {20,10}, {44,10}, {44,10}, {44,10},
{44,10}, {19,10}, {19,10}, {19,10}, {19,10}, {45,10},
{45,10}, {45,10}, {45,10}, {18,10}, {18,10}, {18,10},
{18,10}, {46,10}, {46,10}, {46,10}, {46,10}, {17,10},
{17,10}, {17,10}, {17,10}, {47,10}, {47,10}, {47,10},
{47,10}, {16,10}, {16,10}, {16,10}, {16,10}, {48,10},
{48,10}, {48,10}, {48,10}, {15,10}, {15,10}, {15,10},
{15,10}, {49,10}, {49,10}, {49,10}, {49,10}, {14,10},
{14,10}, {14,10}, {14,10}, {50,10}, {50,10}, {50,10},
{50,10}, {13,10}, {13,10}, {13,10}, {13,10}, {51,10},
{51,10}, {51,10}, {51,10}
};


static VLCtab MCBPCtab[] = {
{-1,0},
{255,9}, {52,9}, {36,9}, {20,9}, {49,9}, {35,8}, {35,8}, {19,8}, {19,8},
{50,8}, {50,8}, {51,7}, {51,7}, {51,7}, {51,7}, {34,7}, {34,7}, {34,7},
{34,7}, {18,7}, {18,7}, {18,7}, {18,7}, {33,7}, {33,7}, {33,7}, {33,7},
{17,7}, {17,7}, {17,7}, {17,7}, {4,6}, {4,6}, {4,6}, {4,6}, {4,6},
{4,6}, {4,6}, {4,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6}, {48,6},
{48,6}, {48,6}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5},
{3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5}, {3,5},
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4},
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4},
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {32,4},
{32,4}, {32,4}, {32,4}, {32,4}, {32,4}, {16,4}, {16,4}, {16,4}, {16,4},
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4},
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4},
{16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4}, {16,4},
{16,4}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3}, {2,3},
{2,3}, {2,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3}, {1,3},
{1,3}, {1,3}, {1,3},
};



static VLCtab MCBPCtabintra[] = {
{-1,0},
{20,6}, {36,6}, {52,6}, {4,4}, {4,4}, {4,4},
{4,4}, {19,3}, {19,3}, {19,3}, {19,3}, {19,3},
{19,3}, {19,3}, {19,3}, {35,3}, {35,3}, {35,3},
{35,3}, {35,3}, {35,3}, {35,3}, {35,3}, {51,3},
{51,3}, {51,3}, {51,3}, {51,3}, {51,3}, {51,3},
{51,3},
};



static VLCtab CBPYtab[48] =
{ {-1,0}, {-1,0}, {9,6}, {6,6}, {7,5}, {7,5}, {11,5}, {11,5},
  {13,5}, {13,5}, {14,5}, {14,5}, {15,4}, {15,4}, {15,4}, {15,4},
  {3,4}, {3,4}, {3,4}, {3,4}, {5,4},{5,4},{5,4},{5,4},
  {1,4}, {1,4}, {1,4}, {1,4}, {10,4}, {10,4}, {10,4}, {10,4},
  {2,4}, {2,4}, {2,4}, {2,4}, {12,4}, {12,4}, {12,4}, {12,4},
  {4,4}, {4,4}, {4,4}, {4,4}, {8,4}, {8,4}, {8,4}, {8,4},
};


static VLCtab DCT3Dtab0[] = {
{4225,7}, {4209,7}, {4193,7}, {4177,7}, {193,7}, {177,7},
{161,7}, {4,7}, {4161,6}, {4161,6}, {4145,6}, {4145,6},
{4129,6}, {4129,6}, {4113,6}, {4113,6}, {145,6}, {145,6},
{129,6}, {129,6}, {113,6}, {113,6}, {97,6}, {97,6},
{18,6}, {18,6}, {3,6}, {3,6}, {81,5}, {81,5},
{81,5}, {81,5}, {65,5}, {65,5}, {65,5}, {65,5},
{49,5}, {49,5}, {49,5}, {49,5}, {4097,4}, {4097,4},
{4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4}, {4097,4},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {1,2}, {1,2}, {1,2}, {1,2},
{1,2}, {1,2}, {17,3}, {17,3}, {17,3}, {17,3},
{17,3}, {17,3}, {17,3}, {17,3}, {17,3}, {17,3},
{17,3}, {17,3}, {17,3}, {17,3}, {17,3}, {17,3},
{33,4}, {33,4}, {33,4}, {33,4}, {33,4}, {33,4},
{33,4}, {33,4}, {2,4}, {2,4},{2,4},{2,4},
{2,4}, {2,4},{2,4},{2,4},
};


static VLCtab DCT3Dtab1[] = {
{9,10}, {8,10}, {4481,9}, {4481,9}, {4465,9}, {4465,9},
{4449,9}, {4449,9}, {4433,9}, {4433,9}, {4417,9}, {4417,9},
{4401,9}, {4401,9}, {4385,9}, {4385,9}, {4369,9}, {4369,9},
{4098,9}, {4098,9}, {353,9}, {353,9}, {337,9}, {337,9},
{321,9}, {321,9}, {305,9}, {305,9}, {289,9}, {289,9},
{273,9}, {273,9}, {257,9}, {257,9}, {241,9}, {241,9},
{66,9}, {66,9}, {50,9}, {50,9}, {7,9}, {7,9},
{6,9}, {6,9}, {4353,8}, {4353,8}, {4353,8}, {4353,8},
{4337,8}, {4337,8}, {4337,8}, {4337,8}, {4321,8}, {4321,8},
{4321,8}, {4321,8}, {4305,8}, {4305,8}, {4305,8}, {4305,8},
{4289,8}, {4289,8}, {4289,8}, {4289,8}, {4273,8}, {4273,8},
{4273,8}, {4273,8}, {4257,8}, {4257,8}, {4257,8}, {4257,8},
{4241,8}, {4241,8}, {4241,8}, {4241,8}, {225,8}, {225,8},
{225,8}, {225,8}, {209,8}, {209,8}, {209,8}, {209,8},
{34,8}, {34,8}, {34,8}, {34,8}, {19,8}, {19,8},
{19,8}, {19,8}, {5,8}, {5,8}, {5,8}, {5,8},
};

static VLCtab DCT3Dtab2[] = {
{4114,11}, {4114,11}, {4099,11}, {4099,11}, {11,11}, {11,11},
{10,11}, {10,11}, {4545,10}, {4545,10}, {4545,10}, {4545,10},
{4529,10}, {4529,10}, {4529,10}, {4529,10}, {4513,10}, {4513,10},
{4513,10}, {4513,10}, {4497,10}, {4497,10}, {4497,10}, {4497,10},
{146,10}, {146,10}, {146,10}, {146,10}, {130,10}, {130,10},
{130,10}, {130,10}, {114,10}, {114,10}, {114,10}, {114,10},
{98,10}, {98,10}, {98,10}, {98,10}, {82,10}, {82,10},
{82,10}, {82,10}, {51,10}, {51,10}, {51,10}, {51,10},
{35,10}, {35,10}, {35,10}, {35,10}, {20,10}, {20,10},
{20,10}, {20,10}, {12,11}, {12,11}, {21,11}, {21,11},
{369,11}, {369,11}, {385,11}, {385,11}, {4561,11}, {4561,11},
{4577,11}, {4577,11}, {4593,11}, {4593,11}, {4609,11}, {4609,11},
{22,12}, {36,12}, {67,12}, {83,12}, {99,12}, {162,12},
{401,12}, {417,12}, {4625,12}, {4641,12}, {4657,12}, {4673,12},
{4689,12}, {4705,12}, {4721,12}, {4737,12}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7}, {7167,7},
{7167,7}, };

/* to mask the n least significant bits of an integer */

static unsigned int msk[33] =
{
  0x00000000,0x00000001,0x00000003,0x00000007,
  0x0000000f,0x0000001f,0x0000003f,0x0000007f,
  0x000000ff,0x000001ff,0x000003ff,0x000007ff,
  0x00000fff,0x00001fff,0x00003fff,0x00007fff,
  0x0000ffff,0x0001ffff,0x0003ffff,0x0007ffff,
  0x000fffff,0x001fffff,0x003fffff,0x007fffff,
  0x00ffffff,0x01ffffff,0x03ffffff,0x07ffffff,
  0x0fffffff,0x1fffffff,0x3fffffff,0x7fffffff,
  0xffffffff
};


/* initialize buffer, call once before first getbits or showbits */

static void initbitsForDec()
{
  ld_187->incnt = 0;
  ld_187->rdptr = ld_187->rdbfr + 2048;
  ld_187->bitcnt = 0;
}

static void fillbfr()
{
  int l;

  ld_187->inbfr[0] = ld_187->inbfr[8];
  ld_187->inbfr[1] = ld_187->inbfr[9];
  ld_187->inbfr[2] = ld_187->inbfr[10];
  ld_187->inbfr[3] = ld_187->inbfr[11];

  if (ld_187->rdptr>=ld_187->rdbfr+2048)
  {
    l = read(ld_187->infile,ld_187->rdbfr,2048);
    ld_187->rdptr = ld_187->rdbfr;
    if (l<2048)
    {
      if (l<0)
        l = 0;

      while (l<2048)   /* Add recognizable sequence end code */
      {
        ld_187->rdbfr[l++] = 0;
        ld_187->rdbfr[l++] = 0;
        ld_187->rdbfr[l++] = (1<<7) | (SE_CODE<<2);
      }
    }
  }

  for (l=0; l<8; l++)
    ld_187->inbfr[l+4] = ld_187->rdptr[l];

  ld_187->rdptr+= 8;
  ld_187->incnt+= 64;
}


/* return next n bits (right adjusted) without advancing */

static unsigned int showbits(n)
int n;
{
  unsigned char *v;
  unsigned int b;
  int c;

  if (ld_187->incnt<n)
    fillbfr();

  v = ld_187->inbfr + ((96 - ld_187->incnt)>>3);
  b = (v[0]<<24) | (v[1]<<16) | (v[2]<<8) | v[3];
  c = ((ld_187->incnt-1) & 7) + 25;
  return (b>>(c-n)) & msk[n];
}

/* advance by n bits */

static void flushbits(n)
int n;
{

  ld_187->bitcnt+= n;
  ld_187->incnt-= n;
  if (ld_187->incnt < 0)
    fillbfr();
}

/* return next n bits (right adjusted) */

static unsigned int getbits(n)
int n;
{
  unsigned int l;

  l = showbits(n);
  flushbits(n);

  return l;
}

/* return next bit (could_187 be made faster than getbits(1)) */

static unsigned int getbits1()
{
  return getbits(1);
}
static void error(char *text)
{
  fprintf(stderr,text);
  exit(1);
}

/* trace output */
static void printbits(int code,int bits,int len)
{
  int i;
  for (i=0; i<len; i++)
    printf("%d",(code>>(bits-1-i))&1);
}
static int getTMNMV()
{
  int code;

  if (0)
    printf("motion_code (");

  if (getbits1())
  {
    if (0)
      printf("1): 0\n");
    return 0;
  }

  if ((code = showbits(12))>=512)
  {
    code = (code>>8) - 2;
    flushbits(TMNMVtab0[code].len);

    if (0)
    {
      printf("0");
      printbits(code+2,4,TMNMVtab0[code].len);
      printf("): %d\n", TMNMVtab0[code].val);
    }

    return TMNMVtab0[code].val;
  }

  if (code>=128)
  {
    code = (code>>2) -32;
    flushbits(TMNMVtab1[code].len);

    if (0)
    {
      printf("0");
      printbits(code+32,10,TMNMVtab1[code].len);
      printf("): %d\n",TMNMVtab1[code].val);
    }

    return TMNMVtab1[code].val;
  }

  if ((code-=5)<0)
  {
    if (!quiet_169)
      fprintf(stderr,"Invalid motion_vector code\n");
    fault_178=1;
    return 0;
  }

  flushbits(TMNMVtab2[code].len);

  if (0)
  {
    printf("0");
    printbits(code+5,12,TMNMVtab2[code].len);
    printf("): %d\n",TMNMVtab2[code].val);
  }

  return TMNMVtab2[code].val;
}


static int getMCBPC()
{
  int code;

  if (0)
    printf("MCBPC (");

  code = showbits(9);

  if (code == 1) {
    /* macroblock stuffing */
    if (0)
      printf("000000001): stuffing\n");
    flushbits(9);
    return 255;
  }

  if (code == 0) {
    if (!quiet_169)
      fprintf(stderr,"Invalid MCBPC code\n");
    fault_178 = 1;
    return 0;
  }

  if (code>=256)
  {
    flushbits(1);
    if (0)
      printf("1): %d\n",0);
    return 0;
  }

  flushbits(MCBPCtab[code].len);

  if (0)
  {
    printbits(code,9,MCBPCtab[code].len);
    printf("): %d\n",MCBPCtab[code].val);
  }

  return MCBPCtab[code].val;
}

static int getMODB()
{
  int code;
  int MODB;

  if (0)
    printf("MODB (");

  code = showbits(2);

  if (code < 2) {
    if (0)
      printf("0): MODB = 0\n");
    MODB = 0;
    flushbits(1);
  }
  else if (code == 2) {
    if (0)
      printf("10): MODB = 1\n");
    MODB = 1;
    flushbits(2);
  }
  else { /* code == 3 */
    if (0)
      printf("11): MODB = 2\n");
    MODB = 2;
    flushbits(2);
  }
  return MODB;
}


static int getMCBPCintra()
{
  int code;

  if (0)
    printf("MCBPCintra (");

  code = showbits(9);

  if (code == 1) {
    /* macroblock stuffing */
    if (0)
      printf("000000001): stuffing\n");
    flushbits(9);
    return 255;
  }

  if (code < 8) {
    if (!quiet_169)
      fprintf(stderr,"Invalid MCBPCintra code\n");
    fault_178 = 1;
    return 0;
  }

  code >>= 3;

  if (code>=32)
  {
    flushbits(1);
    if (0)
      printf("1): %d\n",3);
    return 3;
  }

  flushbits(MCBPCtabintra[code].len);

  if (0)
  {
    printbits(code,6,MCBPCtabintra[code].len);
    printf("): %d\n",MCBPCtabintra[code].val);
  }

  return MCBPCtabintra[code].val;
}

static int getCBPY()
{
  int code;

  if (0)
    printf("CBPY (");

  code = showbits(6);
  if (code < 2) {
    if (!quiet_169)
      fprintf(stderr,"Invalid CBPY code\n");
    fault_178 = 1;
    return -1;
  }

  if (code>=48)
  {
    flushbits(2);
    if (0)
      printf("11): %d\n",0);
    return 0;
  }

  flushbits(CBPYtab[code].len);

  if (0)
  {
    printbits(code,6,CBPYtab[code].len);
    printf("): %d\n",CBPYtab[code].val);
  }

  return CBPYtab[code].val;
}
/* private prototypes */
static void getpicturehdr _ANSI_ARGS_((void));


/* align to start of next startcode */

static void startcode()
{
  /* search for new picture start code */
  while (showbits(PSC_LENGTH)!=1l)
         flushbits(1);
}

/* decode picture header */

static void getpicturehdr()
{
  int pos, pei, tmp;

  pos = ld_187->bitcnt;
  prev_temp_ref_181 = temp_ref_180;
  temp_ref_180 = getbits(8);
  trd_184 = temp_ref_180 - prev_temp_ref_181;

  if (trd_184 < 0)
    trd_184 += 256;

  tmp = getbits(1); /* always "1" */
  if (!tmp)
    if (!quiet_169)
      printf("warning: spare in picture header should_187 be \"1\"\n");
  tmp = getbits(1); /* always "0" */
  if (tmp)
    if (!quiet_169)
      printf("warning: H.261 distinction bit should_187 be \"0\"\n");
  tmp = getbits(1); /* split_screen_indicator */
  if (tmp) {
    if (!quiet_169)
      printf("error: split-screen not supported in this version\n");
    exit (-1);
  }
  tmp = getbits(1); /* document_camera_indicator */
  if (tmp)
    if (!quiet_169)
      printf("warning: document camera indicator not supported in this version\n");

  tmp = getbits(1); /* freeze_picture_release */
  if (tmp)
    if (!quiet_169)
      printf("warning: frozen picture not supported in this version\n");

  source_format_183 = getbits(3);
  pict_type_171 = getbits(1);
  mv_outside_frame_173 = getbits(1);
  long_vectors_177 = (mv_outside_frame_173 ? 1 : 0);
  syntax_arith_coding_174 = getbits(1);
  adv_pred_mode_175 = getbits(1);
  mv_outside_frame_173 = (adv_pred_mode_175 ? 1 : mv_outside_frame_173);
  pb_frame_176 = getbits(1);
  quant_182 = getbits(5);
  tmp = getbits(1);
  if (tmp) {
    if (!quiet_169)
      printf("error: CPM not supported in this version\n");
    exit(-1);
  }

  if (pb_frame_176) {
    trb_185 = getbits(3);
    bquant_186 = getbits(2);
  }
  else {
    trb_185 = 0;
  }

#ifdef USE_TIME
  if (framerate > 0 && trd_184 > 0)
    doframerate(0);
#endif

  pei = getbits(1);
pspare:
  if (pei) {
     /* extra info for possible future backward compatible additions */
    getbits(8);  /* not used */
    pei = getbits(1);
    if (pei) goto pspare; /* keep on reading pspare until pei=0 */
  }


  if (verbose_179>0) {
    /*printf("picture header (byte %d)\n",(pos>>3)-4);*/
    if (verbose_179>1) {
      printf("  temp_ref=%d\n",temp_ref_180);
      /*printf("  pict_type_171=%d\n",pict_type_171);
      printf("  source_format=%d\n", source_format_183);
      printf("  quant=%d\n",quant_182);
      if (syntax_arith_coding_174)
        printf("  SAC coding mode used \n");
      if (mv_outside_frame_173)
        printf("  unrestricted motion vector mode used\n");
      if (adv_pred_mode_175)
        printf("  advanced prediction mode used\n");*/
      if (pb_frame_176) {
        /*printf("  pb-frames mode used\n");*/
        printf("  trb=%d\n",trb_185);
        /*printf("  bquant=%d\n", bquant_186);*/
      }
    }
  }
}

/*
 * decode headers from one input stream
 * until an End of Sequence or picture start code
 * is found
 */

static int getheader()
{
  unsigned int code, gob;

  /* look for startcode */
  startcode();
  code = getbits(PSC_LENGTH);
  gob = getbits(5);
  if (gob == SE_CODE)
    return 0;
  if (gob == 0) {
    getpicturehdr();
  }
  return gob + 1;
}

	/* Modified by Hyunok Oh : 2002/02/04 */
/* private prototypes*/
static void clearblock _ANSI_ARGS_((int comp));
static int motion_decode _ANSI_ARGS_((int vec,int pmv));

/* set block to zero */

static void clearblock(int comp)
{
  int *bp;
  int i;

  bp = (int *)ld_187->block[comp];

  for (i=0; i<8; i++)
  {
    bp[0] = bp[1] = bp[2] = bp[3] = 0;
    bp += 4;
  }
}

static int motion_decode(int vec,int pmv)
{
  if (vec > 31) vec -= 64;
  vec += pmv;

  if (vec > 31)
    vec -= 64;
  if (vec < -32)
    vec += 64;

  return vec;
}
/* Modified by Hyunok Oh 2002/02/04 */
static void getblock(int comp, int mode)
{
  int val, i, j, sign;
  unsigned int code;
  VLCtab *tab;
  short *bp;
  int run, last, level, QP;

  bp = ld_187->block[comp];

  /* decode AC coefficients */
  for (i=(mode==0); ; i++) {
    code = showbits(12);
    if (code>=512)
      tab = &DCT3Dtab0[(code>>5)-16];
    else if (code>=128)
      tab = &DCT3Dtab1[(code>>2)-32];
    else if (code>=8)
      tab = &DCT3Dtab2[(code>>0)-8];
    else {
      if (!quiet_169)
        fprintf(stderr,"invalid Huffman code in getblock()\n");
      fault_178 = 1;
      return;
    }

    flushbits(tab->len);

    run = (tab->val >> 4) & 255;
    level = tab->val & 15;
    last = (tab->val >> 12) & 1;

    if (0) {
      printf(" (");
      printbits(code,12,tab->len);
    }

   if (tab->val==ESCAPE) { /* escape */
      if (0) {
        putchar(' ');
        printbits(showbits(1),1,1);
      }
      last = getbits1();
      if (0) {
        putchar(' ');
        printbits(showbits(6),6,6);
      }
      i += run = getbits(6);
      if (0) {
        putchar(' ');
        printbits(showbits(8),8,8);
      }
      level = getbits(8);

      if ((sign = (level>=128)))
        val = 256 - level;
      else
        val = level;
    }
    else {
      i+= run;
      val = level;
      sign = getbits(1);
      if (0)
        printf("%d",sign);
    }

    if (i >= 64)
    {
      if (!quiet_169)
        fprintf(stderr,"DCT coeff index (i) out of bounds\n");
      fault_178 = 1;
      return;
    }

    if (0)
      printf("): %d/%d\n",run,sign ? -val : val);

    /* H. Oh modified */
    bp[i] = sign ? -val : val;

    if (last) { /* That's it */
      if (0)
        printf("last\n");
      return;
    }
  }
}
static void FindPMVForDec(int dx1, int dy1, int dx2, int dy2, int dx3, int dy3,
int x, int y, int *pmv0, int *pmv1)
{
  if(x==0) { /* case 1: left GOB border */
     dx1 = dy1 = 0;
  }
  if(y==0) { /* case 2: upper GOB border */
     dx2 = dx3 = dx1;
     dy2 = dy3 = dy1;
  }
  if(x==gFrameWidth/16 - 1) { /* case 3: right GOB border */
     dx3 = dy3 = 0;
  }

  *pmv0 = dx1+dx2+dx3 - mmax(dx1,mmax(dx2,dx3)) - mmin(dx1,mmin(dx2,dx3));
  *pmv1 = dy1+dy2+dy3 - mmax(dy1,mmax(dy2,dy3)) - mmin(dy1,mmin(dy2,dy3));

  return;
}
		static void doDeQuantizer(int* rcoeff, int* qcoeff, int QP, int theMode){
  int i;

  if (QP) {
    for (i = 0; i < 64; i++) {
      if (qcoeff[i]) {
        if ((QP % 2) == 1)
          rcoeff[i] = QP * (2*abs(qcoeff[i]) + 1);
        else
          rcoeff[i] = QP * (2*abs(qcoeff[i]) + 1) - 1;
        rcoeff[i] = sign(qcoeff[i]) * rcoeff[i];
      }
      else
        rcoeff[i] = 0;
    }
    if (theMode == MODE_INTRA || theMode == MODE_INTRA_Q) { /* Intra */
      rcoeff[0] = qcoeff[0]*8;
    }
  }
  else {
    /* No quantizing at all */
    for (i = 0; i < 64; i++) {
      rcoeff[i] = qcoeff[i];
    }
  }
  return;
        }
		static void doInvZigzag(int* outImg, int* inImg)
		{
			int i,j;
			for(i=0; i<8; i++)
				for(j=0; j<8; j++)
					outImg[i*8+j] = inImg[zigzag[i][j]];
		}
static void idctrow(int* blk)
{
  int x0, x1, x2, x3, x4, x5, x6, x7, x8;

  /* shortcut */
  if (!((x1 = blk[4]<<11) | (x2 = blk[6]) | (x3 = blk[2]) |
        (x4 = blk[1]) | (x5 = blk[7]) | (x6 = blk[5]) | (x7 = blk[3])))
  {
    blk[0]=blk[1]=blk[2]=blk[3]=blk[4]=blk[5]=blk[6]=blk[7]=blk[0]<<3;
    return;
  }

  x0 = (blk[0]<<11) + 128; /* for proper rounding in the fourth stage */

  /* first stage */
  x8 = W7*(x4+x5);
  x4 = x8 + (W1-W7)*x4;
  x5 = x8 - (W1+W7)*x5;
  x8 = W3*(x6+x7);
  x6 = x8 - (W3-W5)*x6;
  x7 = x8 - (W3+W5)*x7;

  /* second stage */
  x8 = x0 + x1;
  x0 -= x1;
  x1 = W6*(x3+x2);
  x2 = x1 - (W2+W6)*x2;
  x3 = x1 + (W2-W6)*x3;
  x1 = x4 + x6;
  x4 -= x6;
  x6 = x5 + x7;
  x5 -= x7;

  /* third stage */
  x7 = x8 + x3;
  x8 -= x3;
  x3 = x0 + x2;
  x0 -= x2;
  x2 = (181*(x4+x5)+128)>>8;
  x4 = (181*(x4-x5)+128)>>8;

  /* fourth stage */
  blk[0] = (x7+x1)>>8;
  blk[1] = (x3+x2)>>8;
  blk[2] = (x0+x4)>>8;
  blk[3] = (x8+x6)>>8;
  blk[4] = (x8-x6)>>8;
  blk[5] = (x0-x4)>>8;
  blk[6] = (x3-x2)>>8;
  blk[7] = (x7-x1)>>8;
}

/* column (vertical) IDCT
 *
 *             7                         pi         1
 * dst[8*k] = sum c[l] * src[8*l] * cos( -- * ( k + - ) * l )
 *            l=0                        8          2
 *
 * where: c[0]    = 1/1024
 *        c[1..7] = (1/1024)*sqrt(2)
 */
static void idctcol(int *blk)
{
  int x0, x1, x2, x3, x4, x5, x6, x7, x8;

  /* shortcut */
  if (!((x1 = (blk[8*4]<<8)) | (x2 = blk[8*6]) | (x3 = blk[8*2]) |
        (x4 = blk[8*1]) | (x5 = blk[8*7]) | (x6 = blk[8*5]) | (x7 = blk[8*3])))
  {
    blk[8*0]=blk[8*1]=blk[8*2]=blk[8*3]=blk[8*4]=blk[8*5]=blk[8*6]=blk[8*7]=
      iclp[(blk[8*0]+32)>>6];
    return;
  }

  x0 = (blk[8*0]<<8) + 8192;

  /* first stage */
  x8 = W7*(x4+x5) + 4;
  x4 = (x8+(W1-W7)*x4)>>3;
  x5 = (x8-(W1+W7)*x5)>>3;
  x8 = W3*(x6+x7) + 4;
  x6 = (x8-(W3-W5)*x6)>>3;
  x7 = (x8-(W3+W5)*x7)>>3;

  /* second stage */
  x8 = x0 + x1;
  x0 -= x1;
  x1 = W6*(x3+x2) + 4;
  x2 = (x1-(W2+W6)*x2)>>3;
  x3 = (x1+(W2-W6)*x3)>>3;
  x1 = x4 + x6;
  x4 -= x6;
  x6 = x5 + x7;
  x5 -= x7;

  /* third stage */
  x7 = x8 + x3;
  x8 -= x3;
  x3 = x0 + x2;
  x0 -= x2;
  x2 = (181*(x4+x5)+128)>>8;
  x4 = (181*(x4-x5)+128)>>8;

  /* fourth stage */
  blk[8*0] = iclp[(x7+x1)>>14];
  blk[8*1] = iclp[(x3+x2)>>14];
  blk[8*2] = iclp[(x0+x4)>>14];
  blk[8*3] = iclp[(x8+x6)>>14];
  blk[8*4] = iclp[(x8-x6)>>14];
  blk[8*5] = iclp[(x0-x4)>>14];
  blk[8*6] = iclp[(x3-x2)>>14];
  blk[8*7] = iclp[(x7-x1)>>14];
}

/* two dimensional inverse discrete cosine transform */
static void doIDCT(int* outBlock, int* inBlock)
{
  int i;

  for (i=0; i<64; i++)
     outBlock[i] = inBlock[i];

  for (i=0; i<8; i++)
    idctrow(outBlock+8*i);

  for (i=0; i<8; i++)
    idctcol(outBlock+i);
}

static void init_idct()
{
  int i;

  iclp = iclip+512;
  for (i= -512; i<512; i++)
    iclp[i] = (i<-256) ? -256 : ((i>255) ? 255 : i);
}
static void reconBlockIntoImage(int x, int y, int dx, int dy, 
unsigned char *prevImage, int *data, 
unsigned char *outImage, int width)
{
  int m,n;
  int x_half = dx % 2;
  int y_half = dy % 2;
  unsigned char *outBlock;
  unsigned char *prevBlock;
  
  outBlock = outImage+y*width+x;
  prevBlock = prevImage+(y+dy/2)*width+x+dx/2;

  if(!x_half && !y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        int pixel = (int)prevBlock[width*n+m];
        pixel += data[8*n+m];
        pixel = mmin(255,mmax(0,pixel));
        outBlock[width*n+m] = (unsigned char)pixel;
      }
    }
  } else if(x_half && !y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        int pixel = ((int)prevBlock[width*n+m] + (int)prevBlock[width*n+m+x_half]+1)>>1;
        pixel += data[8*n+m];
        pixel = mmin(255,mmax(0,pixel));
        outBlock[width*n+m] = (unsigned char)pixel;
      }
    }
  } else if(!x_half && y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        int pixel = ((int)prevBlock[width*n+m] + (int)prevBlock[width*(n+y_half)+m]+1)>>1;
        pixel += data[8*n+m];
        pixel = mmin(255,mmax(0,pixel));
        outBlock[width*n+m] = (unsigned char)pixel;
      }
    }
  } else {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        int pixel = ((int)prevBlock[width*n+m] + (int)prevBlock[width*(n+y_half)+m] + (int)prevBlock[width*n+m+x_half] + (int)prevBlock[width*(n+y_half)+m+x_half]+2)>>2;
        pixel += data[8*n+m];
        pixel = mmin(255,mmax(0,pixel));
        outBlock[width*n+m] = (unsigned char)pixel;
      }
    }
  }
}
static void copyBlockIntoImage(int x, int y, int *data, unsigned char *outImage, int width)
{
  int m,n;
  unsigned char *outBlock;

  outBlock = outImage+y*width+x;

  for (n = 0; n < 8; n++) {
    for (m = 0; m < 8; m++) {
      outBlock[width*n+m] = (unsigned char)mmin(255,mmax(0,data[8*n+m]));
    }
  }
}
int ChooseMode(Pixel*curr, int x_pos, int y_pos, int min_SAD)
{
  int i,j;
  int MB_mean = 0, A = 0;
  int y_off;

  for (j = 0; j < 16; j++) {
    y_off = (y_pos + j) * gFrameWidth;
    for (i = 0; i < 16; i++) {
      MB_mean += *(curr + x_pos + i + y_off);
    }
  }
  MB_mean /= (16*16);
  for (j = 0; j < 16; j++) {
    y_off = (y_pos + j) * gFrameWidth;
    for (i = 0; i < 16; i++) {
      A += abs( *(curr + x_pos + i + y_off) - MB_mean );
    }
  }

  if (A < (min_SAD - 500)) 
    return MODE_INTRA;
  else
    return MODE_INTER;
}
void ZeroVec (MotionVector *MV)
{
   MV->x = 0;
   MV->y = 0;
   MV->x_half = 0;
   MV->y_half = 0;
   return;
}
void FindMB(int x, int y,  Pixel* image, int MB[16][16])
{
  int n;
  register int m;

  for(n=0; n<16; n++)
       for(m=0; m<16; m++)
	    // NB : Can I substitute 16 with some other?
	    MB[n][m] = *(image + x+m + (y+n)*gFrameWidth);

  return;
}
void FindHalfPel(int x, int y, MotionVector *fr, Pixel *prev, int *curr, int bs, int comp)
{
  int i, m, n;
  int half_pel;
  int start_x, start_y, stop_x, stop_y, new_x, new_y, lx;
  int min_pos;
  int AE, AE_min;
  Point search[9];
  
  start_x = -1;
  stop_x = 1;
  start_y = -1;
  stop_y = 1;

  new_x = x + fr->x;
  new_y = y + fr->y;

  new_x += ((comp&1)<<3);
  new_y += ((comp&2)<<2);

  lx = gFrameWidth;

  /* Make sure that no addressing is outside the frame */
    if ((new_x) <= 0) 
      start_x = 0;
    if ((new_y) <= 0) 
      start_y = 0;
    if ((new_x) >= (gFrameWidth-bs)) 
      stop_x = 0;
    if ((new_y) >= (gFrameHeight-bs)) 
      stop_y = 0;

  search[0].x = 0;        search[0].y = 0;
  search[1].x = start_x;        search[1].y = start_y; /*   1 2 3   */
  search[2].x = 0;        search[2].y = start_y; /*   4 0 5   */
  search[3].x = stop_x;        search[3].y = start_y; /*   6 7 8   */
  search[4].x = start_x;        search[4].y = 0;
  search[5].x = stop_x;        search[5].y = 0;
  search[6].x = start_x;        search[6].y = stop_y;
  search[7].x = 0;        search[7].y = stop_y;
  search[8].x = stop_x;        search[8].y = stop_y;

  AE_min = INT_MAX;
  min_pos = 0;
  for (i = 0; i < 9; i++) {
    AE = 0;
    for (n = 0; n < bs; n++) {
      for (m = 0; m < bs; m++) {
        /* Find absolute error */
	   half_pel = *(prev + 2*new_x + 2*m + search[i].x +
             (2*new_y + 2*n + search[i].y)*lx*2);
        AE += abs(half_pel - *(curr + m + n*16));
	}
    }
    /*
     * if (i == 0 && fr->x == 0 && fr->y == 0 && bs == 16) 
     * AE -= PREF_NULL_VEC;
     */
    if (AE < AE_min) {
      AE_min = AE;
      min_pos = i;
    }
  }

  /* Store optimal values */
  fr->min_error = AE_min;
  fr->x_half = search[min_pos].x;
  fr->y_half = search[min_pos].y;
        
  return;
}
void LoadArea(Pixel* res, Pixel *im, int x, int y, int x_size, int y_size, int lx)
{  
	Pixel *in;
	Pixel *out;
	int i = x_size;
	int j = y_size;

	in = im + (y*lx) + x;
	out = res;

	while (j--) {
		while (i--)
		  *out++ = *in++;
		i = x_size;
		in += lx - x_size;
	};
}
int SAD_Macroblock(Pixel *ii, Pixel *act_block,int h_length, int Min_FRAME)
{
  int i;
  int sad = 0;
  Pixel *kk;

  kk = act_block;
  i = 16;
  while (i--) {
    sad += (abs(*ii     - *kk     ) +abs(*(ii+1 ) - *(kk+1) )
            +abs(*(ii+2) - *(kk+2) ) +abs(*(ii+3 ) - *(kk+3) )
            +abs(*(ii+4) - *(kk+4) ) +abs(*(ii+5 ) - *(kk+5) )
            +abs(*(ii+6) - *(kk+6) ) +abs(*(ii+7 ) - *(kk+7) )
            +abs(*(ii+8) - *(kk+8) ) +abs(*(ii+9 ) - *(kk+9) )
            +abs(*(ii+10)- *(kk+10)) +abs(*(ii+11) - *(kk+11))
            +abs(*(ii+12)- *(kk+12)) +abs(*(ii+13) - *(kk+13))
            +abs(*(ii+14)- *(kk+14)) +abs(*(ii+15) - *(kk+15)) );

    ii += h_length;
    kk += 16;
    if (sad > Min_FRAME)
      return INT_MAX;
  } 
  return sad;
}

/* Full search */
void MotionEstimation_Full(Pixel *curr, Pixel *prev, int x_curr, int y_curr, 
	int xoff, int yoff, int seek_dist, 
	MotionVector* MV, int *SAD_0)
{
  int Min_FRAME[1];
  MotionVector MV_FRAME[1];
  Pixel act_block[16*16],*aa,*ii;
  Pixel search_area[16*16*9], zero_area[16*16];
  int sxy,i,k,j,l;
  int ihigh,ilow,jhigh,jlow,h_length,v_length;
  int xmax,ymax,block,sad,lx;

  xmax = gFrameWidth;
  ymax = gFrameHeight;
  sxy = seek_dist;
    /* Maximum normal search range centered around _zero-vector_ */
    sxy = mmin(15, sxy);

  lx = gFrameWidth;

  ilow = x_curr + xoff - sxy;
  ihigh = x_curr + xoff + sxy;

  jlow = y_curr + yoff - sxy;
  jhigh = y_curr + yoff + sxy;

  if (ilow<0) ilow = 0;
  if (ihigh>xmax-16) ihigh = xmax-16;
  if (jlow<0) jlow = 0;
  if (jhigh>ymax-16) jhigh = ymax-16;

  h_length = ihigh - ilow + 16;
  v_length = jhigh - jlow + 16;
  LoadArea(act_block,curr, x_curr, y_curr, 16, 16, gFrameWidth);
  LoadArea(search_area, prev, ilow, jlow, h_length, v_length, lx);

  Min_FRAME[0] = INT_MAX;
  MV_FRAME[0].x = 0;
  MV_FRAME[0].y = 0;
  MV_FRAME[0].x_half = 0;
  MV_FRAME[0].y_half = 0;


  /* Zero vector search*/
  if (x_curr-ilow         < 0        || y_curr-jlow         < 0        ||
      x_curr-ilow+16 > h_length || y_curr-jlow+16 > v_length) {
    /* in case the zero vector is outside the loaded area in search_area */
    LoadArea(zero_area, prev, x_curr, y_curr, 16, 16, lx);
    *SAD_0 = SAD_Macroblock(zero_area, act_block, 16, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }
  else {
    /* the zero vector is within search_area */
    ii = search_area + (x_curr-ilow) + (y_curr-jlow)*h_length;
    *SAD_0 = SAD_Macroblock(ii, act_block, h_length, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }

  if (xoff == 0 && yoff == 0) {
    Min_FRAME[0] = *SAD_0;
    MV_FRAME[0].x = 0;
    MV_FRAME[0].y = 0;
  }
  /* NB: if xoff or yoff != 0, the Extended MV Range is used. If we
     allow the zero vector to be chosen prior to the half pel search
     in this case, the half pel search might lead to a
     non-transmittable vector (on the wrong side of zero). If SAD_0
     turns out to be the best SAD, the zero-vector will be chosen
     after half pel search instead.  The zero-vector can be
     transmitted in all modes, no matter what the MV predictor is */

  /* Spiral search */
  for (l = 1; l <= sxy; l++) {
    i = x_curr + xoff - l;
    j = y_curr + yoff - l;
    for (k = 0; k < 8*l; k++) {
      if (i>=ilow && i<=ihigh && j>=jlow && j<=jhigh) {

        /* 16x16 integer pel MV */
        ii = search_area + (i-ilow) + (j-jlow)*h_length;
        sad = SAD_Macroblock(ii, act_block, h_length, Min_FRAME[0]);
        if (sad < Min_FRAME[0]) {
          MV_FRAME[0].x = i - x_curr;
          MV_FRAME[0].y = j - y_curr;
          Min_FRAME[0] = sad;
        }

      }
      if      (k<2*l) i++;
      else if (k<4*l) j++;
      else if (k<6*l) i--;
      else            j--;
    }
  }

  MV->x = MV_FRAME[0].x;
  MV->y = MV_FRAME[0].y;
  MV->min_error = Min_FRAME[0];

 // printf("SAD %d, (x,y) = (%d,%d)\n",MV->min_error,MV->x,MV->y);

  return;
}
/* Diamond Search */
void MotionEstimation_Diamond(Pixel *curr, Pixel *prev, int x_curr, int y_curr, 
	int xoff, int yoff, int seek_dist, 
	MotionVector* MV, int *SAD_0)
{
  int Min_FRAME[1];
  MotionVector MV_FRAME[1];
  Pixel act_block[16*16],*aa,*ii;
  Pixel search_area[16*16*9], zero_area[16*16];
  int sxy,i,k,j,l;
  int ihigh,ilow,jhigh,jlow,h_length,v_length;
  int xmax,ymax,block,sad,lx;

  static int htp[4] = {-1, 0, 1, 0};
  static int vtp[4] = {0, 1, 0, -1};
  int j_min_now, i_min_now, i_min_next, j_min_next, sad_layr;
  int distortion_0, distortion_1, distortion_2;
  int m;


  xmax = gFrameWidth;
  ymax = gFrameHeight;
  sxy = seek_dist;
    /* Maximum normal search range centered around _zero-vector_ */
    sxy = mmin(15, sxy);  

  lx = gFrameWidth;

  ilow = x_curr + xoff - sxy;
  ihigh = x_curr + xoff + sxy;

  jlow = y_curr + yoff - sxy;
  jhigh = y_curr + yoff + sxy;

  if (ilow<0) ilow = 0;
  if (ihigh>xmax-16) ihigh = xmax-16;
  if (jlow<0) jlow = 0;
  if (jhigh>ymax-16) jhigh = ymax-16;

  h_length = ihigh - ilow + 16;
  v_length = jhigh - jlow + 16;
  LoadArea(act_block,curr, x_curr, y_curr, 16, 16, gFrameWidth);
  LoadArea(search_area, prev, ilow, jlow, h_length, v_length, lx);

  Min_FRAME[0] = INT_MAX;
  MV_FRAME[0].x = 0;
  MV_FRAME[0].y = 0;
  MV_FRAME[0].x_half = 0;
  MV_FRAME[0].y_half = 0;


  /* Zero vector search*/
  if (x_curr-ilow         < 0        || y_curr-jlow         < 0        ||
      x_curr-ilow+16 > h_length || y_curr-jlow+16 > v_length) {
    /* in case the zero vector is outside the loaded area in search_area */
    LoadArea(zero_area, prev, x_curr, y_curr, 16, 16, lx);
    *SAD_0 = SAD_Macroblock(zero_area, act_block, 16, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }
  else {
    /* the zero vector is within search_area */
    ii = search_area + (x_curr-ilow) + (y_curr-jlow)*h_length;
    *SAD_0 = SAD_Macroblock(ii, act_block, h_length, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }

  if (xoff == 0 && yoff == 0) {
    Min_FRAME[0] = *SAD_0;
    MV_FRAME[0].x = 0;
    MV_FRAME[0].y = 0;
  }
  /* NB: if xoff or yoff != 0, the Extended MV Range is used. If we
     allow the zero vector to be chosen prior to the half pel search
     in this case, the half pel search might lead to a
     non-transmittable vector (on the wrong side of zero). If SAD_0
     turns out to be the best SAD, the zero-vector will be chosen
     after half pel search instead.  The zero-vector can be
     transmitted in all modes, no matter what the MV predictor is */

  /* Spiral search */
/* Fast search motion estimation */
  i_min_now = x_curr + xoff;
  j_min_now = y_curr + yoff;

  distortion_0 = distortion_1 = distortion_2 = 65536;

  for (l = 1; l <= 2 * sxy; l++)
  {
    sad_layr = 65536;

    for (m = 0; m < 4; m++)
    {

      i = i_min_now + htp[m];
      j = j_min_now + vtp[m];

      if (i >= ilow && i <= ihigh && j >= jlow && j <= jhigh)
      {
        /* 16x16 integer pel MV */
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        sad = SAD_Macroblock (ii, act_block, h_length, sad_layr);

        /* set search map to 1 for this location */
        if (sad < Min_FRAME[0])
        {
          MV_FRAME[0].x = i - x_curr;
          MV_FRAME[0].y = j - y_curr;
          Min_FRAME[0] = sad;
        }
        if (sad < sad_layr)
        {
          sad_layr = sad;
          i_min_next = i;
          j_min_next = j;
        }
      }
    }

    i_min_now = i_min_next;
    j_min_now = j_min_next;


    distortion_2 = distortion_1;
    distortion_1 = distortion_0;
    distortion_0 = sad_layr;
    if (distortion_1 <= distortion_0 && distortion_2 <= distortion_0)
    {
      break;
    }
  }

  MV->x = MV_FRAME[0].x;
  MV->y = MV_FRAME[0].y;
  MV->min_error = Min_FRAME[0];

  return;
}
/* three step search */
void MotionEstimation_ThreeStep(Pixel *curr, Pixel *prev, int x_curr, int y_curr, 
	int xoff, int yoff, int seek_dist, 
	MotionVector* MV, int *SAD_0)
{
  int Min_FRAME[1];
  MotionVector MV_FRAME[1];
  Pixel act_block[16*16],*aa,*ii;
  Pixel search_area[16*16*9], zero_area[16*16];
  int sxy,i,k,j,l;
  int ihigh,ilow,jhigh,jlow,h_length,v_length;
  int xmax,ymax,block,sad,lx;

  static htp[8] = {-1, -1, 0, 1, 1, 1, 0, -1};
  static vtp[8] = {0, 1, 1, 1, 0, -1, -1, -1};
  int j_min_now, i_min_now, i_min_next, j_min_next, sad_layr;
  int distortion_0, distortion_1, distortion_2;
  int m;
  int step_size;

  xmax = gFrameWidth;
  ymax = gFrameHeight;
  sxy = seek_dist;
    /* Maximum normal search range centered around _zero-vector_ */
    sxy = mmin(15, sxy);

  lx = gFrameWidth;

  ilow = x_curr + xoff - sxy;
  ihigh = x_curr + xoff + sxy;

  jlow = y_curr + yoff - sxy;
  jhigh = y_curr + yoff + sxy;

  if (ilow<0) ilow = 0;
  if (ihigh>xmax-16) ihigh = xmax-16;
  if (jlow<0) jlow = 0;
  if (jhigh>ymax-16) jhigh = ymax-16;

  h_length = ihigh - ilow + 16;
  v_length = jhigh - jlow + 16;
  LoadArea(act_block,curr, x_curr, y_curr, 16, 16, gFrameWidth);
  LoadArea(search_area, prev, ilow, jlow, h_length, v_length, lx);

  Min_FRAME[0] = INT_MAX;
  MV_FRAME[0].x = 0;
  MV_FRAME[0].y = 0;
  MV_FRAME[0].x_half = 0;
  MV_FRAME[0].y_half = 0;


  /* Zero vector search*/
  if (x_curr-ilow         < 0        || y_curr-jlow         < 0        ||
      x_curr-ilow+16 > h_length || y_curr-jlow+16 > v_length) {
    /* in case the zero vector is outside the loaded area in search_area */
    LoadArea(zero_area, prev, x_curr, y_curr, 16, 16, lx);
    *SAD_0 = SAD_Macroblock(zero_area, act_block, 16, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }
  else {
    /* the zero vector is within search_area */
    ii = search_area + (x_curr-ilow) + (y_curr-jlow)*h_length;
    *SAD_0 = SAD_Macroblock(ii, act_block, h_length, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }

  if (xoff == 0 && yoff == 0) {
    Min_FRAME[0] = *SAD_0;
    MV_FRAME[0].x = 0;
    MV_FRAME[0].y = 0;
  }
  /* NB: if xoff or yoff != 0, the Extended MV Range is used. If we
     allow the zero vector to be chosen prior to the half pel search
     in this case, the half pel search might lead to a
     non-transmittable vector (on the wrong side of zero). If SAD_0
     turns out to be the best SAD, the zero-vector will be chosen
     after half pel search instead.  The zero-vector can be
     transmitted in all modes, no matter what the MV predictor is */

  /* Spiral search */
/* Fast search motion estimation */
  i_min_now = x_curr + xoff;
  j_min_now = y_curr + yoff;

  distortion_0 = distortion_1 = distortion_2 = 65536;

  step_size = seek_dist/2;

  //for (l = 1; l <= 2 * sxy; l++)
  while (step_size >= 1)
  {
    sad_layr = 65536;

    for (m = 0; m < 8; m++)
    {

      i = i_min_now + htp[m] * step_size;
      j = j_min_now + vtp[m] * step_size;

      if (i >= ilow && i <= ihigh && j >= jlow && j <= jhigh)
      {
        /* 16x16 integer pel MV */
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        sad = SAD_Macroblock (ii, act_block, h_length, sad_layr);

        /* set search map to 1 for this location */
        if (sad < Min_FRAME[0])
        {
          MV_FRAME[0].x = i - x_curr;
          MV_FRAME[0].y = j - y_curr;
          Min_FRAME[0] = sad;
        }
        if (sad < sad_layr)
        {
          sad_layr = sad;
          i_min_next = i;
          j_min_next = j;
        }
      }
    }

    i_min_now = i_min_next;
    j_min_now = j_min_next;


    distortion_2 = distortion_1;
    distortion_1 = distortion_0;
    distortion_0 = sad_layr;

    step_size = (int)(step_size / 2);

    if (distortion_1 <= distortion_0 && distortion_2 <= distortion_0)
    {
      break;
    }
  }

  MV->x = MV_FRAME[0].x;
  MV->y = MV_FRAME[0].y;
  MV->min_error = Min_FRAME[0];

  return;
}
/* two dimensional logarithmic search */
void MotionEstimation_TwoDimLog(Pixel *curr, Pixel *prev, int x_curr, int y_curr, 
	int xoff, int yoff, int seek_dist, 
	MotionVector* MV, int *SAD_0)
{
  int Min_FRAME[1];
  MotionVector MV_FRAME[1];
  Pixel act_block[16*16],*aa,*ii;
  Pixel search_area[16*16*9], zero_area[16*16];
  int sxy,i,k,j,l,m;
  int ihigh,ilow,jhigh,jlow,h_length,v_length,i_min_now,j_min_now;
  int xmax,ymax,block,sad,lx;
  static int htp[4] = {-1, 0, 1, 0};
  static int vtp[4] = {0, 1, 0, -1};

  xmax = gFrameWidth;
  ymax = gFrameHeight;
  sxy = seek_dist;
    /* Maximum normal search range centered around _zero-vector_ */
    sxy = mmin(15, sxy);

  lx = gFrameWidth;

  ilow = x_curr + xoff - sxy;
  ihigh = x_curr + xoff + sxy;

  jlow = y_curr + yoff - sxy;
  jhigh = y_curr + yoff + sxy;

  if (ilow<0) ilow = 0;
  if (ihigh>xmax-16) ihigh = xmax-16;
  if (jlow<0) jlow = 0;
  if (jhigh>ymax-16) jhigh = ymax-16;

  h_length = ihigh - ilow + 16;
  v_length = jhigh - jlow + 16;
  LoadArea(act_block,curr, x_curr, y_curr, 16, 16, gFrameWidth);
  LoadArea(search_area, prev, ilow, jlow, h_length, v_length, lx);

  Min_FRAME[0] = INT_MAX;
  MV_FRAME[0].x = 0;
  MV_FRAME[0].y = 0;
  MV_FRAME[0].x_half = 0;
  MV_FRAME[0].y_half = 0;


  /* Zero vector search*/
  if (x_curr-ilow         < 0        || y_curr-jlow         < 0        ||
      x_curr-ilow+16 > h_length || y_curr-jlow+16 > v_length) {
    /* in case the zero vector is outside the loaded area in search_area */
    LoadArea(zero_area, prev, x_curr, y_curr, 16, 16, lx);
    *SAD_0 = SAD_Macroblock(zero_area, act_block, 16, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }
  else {
    /* the zero vector is within search_area */
    ii = search_area + (x_curr-ilow) + (y_curr-jlow)*h_length;
    *SAD_0 = SAD_Macroblock(ii, act_block, h_length, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }

  if (xoff == 0 && yoff == 0) {
    Min_FRAME[0] = *SAD_0;
    MV_FRAME[0].x = 0;
    MV_FRAME[0].y = 0;
  }

  /* Since the search area is +-15, 3 steps are required and initial step size is 8 */
  i_min_now = x_curr + xoff;
  j_min_now = y_curr + yoff;

  for(l=(sxy+1)/2; l>=1; l=l/2) {
   int centerFlag = 0;
   while(!centerFlag) {
      centerFlag = 1;
      for(m=0; m<4; m++) {
        i = i_min_now + htp[m];
        j = j_min_now + vtp[m];
      
        if (i>=ilow && i<=ihigh && j>=jlow && j<=jhigh) {
          /* 16x16 integer pel MV */
          ii = search_area + (i-ilow) + (j-jlow)*h_length;
          sad = SAD_Macroblock(ii, act_block, h_length, Min_FRAME[0]);

          if (sad < Min_FRAME[0]) {
            MV_FRAME[0].x = i - x_curr;
            MV_FRAME[0].y = j - y_curr;
            Min_FRAME[0] = sad;
            centerFlag = 0;
          }
        }
      }
      i_min_now = MV_FRAME[0].x + x_curr;
      j_min_now = MV_FRAME[0].y + y_curr;
    }
  }

  MV->x = MV_FRAME[0].x;
  MV->y = MV_FRAME[0].y;
  MV->min_error = Min_FRAME[0];

  return;
}
/* one at a time search */
void MotionEstimation_OneTime(Pixel *curr, Pixel *prev, int x_curr, int y_curr, 
	int xoff, int yoff, int seek_dist, 
	MotionVector* MV, int *SAD_0)
{
  int Min_FRAME[1];
  MotionVector MV_FRAME[1];
  Pixel act_block[16*16],*aa,*ii;
  Pixel search_area[16*16*9], zero_area[16*16];
  int sxy,i,k,j,l;
  int ihigh,ilow,jhigh,jlow,h_length,v_length;
  int xmax,ymax,block,sad,lx;
  int leftSAD, rightSAD, middleSAD;

  static int htp[4] = {-1, 0, 1, 0};
  static int vtp[4] = {0, 1, 0, -1};
  int j_min_now, i_min_now, i_min_next, j_min_next, sad_layr;
  int distortion_0, distortion_1, distortion_2;
  int m;


  xmax = gFrameWidth;
  ymax = gFrameHeight;
  sxy = seek_dist;
    /* Maximum normal search range centered around _zero-vector_ */
    sxy = mmin(15, sxy);  

  lx = gFrameWidth;

  ilow = x_curr + xoff - sxy;
  ihigh = x_curr + xoff + sxy;

  jlow = y_curr + yoff - sxy;
  jhigh = y_curr + yoff + sxy;

  if (ilow<0) ilow = 0;
  if (ihigh>xmax-16) ihigh = xmax-16;
  if (jlow<0) jlow = 0;
  if (jhigh>ymax-16) jhigh = ymax-16;

  h_length = ihigh - ilow + 16;
  v_length = jhigh - jlow + 16;
  LoadArea(act_block,curr, x_curr, y_curr, 16, 16, gFrameWidth);
  LoadArea(search_area, prev, ilow, jlow, h_length, v_length, lx);

  Min_FRAME[0] = INT_MAX;
  MV_FRAME[0].x = 0;
  MV_FRAME[0].y = 0;
  MV_FRAME[0].x_half = 0;
  MV_FRAME[0].y_half = 0;


  /* Zero vector search*/
  if (x_curr-ilow         < 0        || y_curr-jlow         < 0        ||
      x_curr-ilow+16 > h_length || y_curr-jlow+16 > v_length) {
    /* in case the zero vector is outside the loaded area in search_area */
    LoadArea(zero_area, prev, x_curr, y_curr, 16, 16, lx);
    *SAD_0 = SAD_Macroblock(zero_area, act_block, 16, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }
  else {
    /* the zero vector is within search_area */
    ii = search_area + (x_curr-ilow) + (y_curr-jlow)*h_length;
    *SAD_0 = SAD_Macroblock(ii, act_block, h_length, Min_FRAME[0]) -
       PREF_NULL_VEC;
  }

  if (xoff == 0 && yoff == 0) {
    Min_FRAME[0] = *SAD_0;
    MV_FRAME[0].x = 0;
    MV_FRAME[0].y = 0;
  }
  /* NB: if xoff or yoff != 0, the Extended MV Range is used. If we
     allow the zero vector to be chosen prior to the half pel search
     in this case, the half pel search might lead to a
     non-transmittable vector (on the wrong side of zero). If SAD_0
     turns out to be the best SAD, the zero-vector will be chosen
     after half pel search instead.  The zero-vector can be
     transmitted in all modes, no matter what the MV predictor is */

  /* Spiral search */
/* Fast search motion estimation */
  i_min_now = x_curr + xoff;
  j_min_now = y_curr + yoff;

  distortion_0 = distortion_1 = distortion_2 = 65536;

  /* horizontal first */
  middleSAD = *SAD_0;

  i = i_min_now - 1;
  j = j_min_now;
  if (i >= ilow) {
    ii = search_area + (i - ilow) + (j - jlow) * h_length;
    leftSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
  } else 
    leftSAD = 65536;

  i = i_min_now + 1;
  if (i <= ihigh) {
    ii = search_area + (i - ilow) + (j - jlow) * h_length;
    rightSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
  } else 
    rightSAD = 65536;

  /* horizontal search */
  if(leftSAD < middleSAD && leftSAD < rightSAD) {
    /* left search */
    i = i_min_now - 1;

    do {
      rightSAD = leftSAD;
      i--;
      if (i >= ilow) {
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        middleSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
      } else
        middleSAD = 65536;

      i--;
      if (i >= ilow) {
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        leftSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
      } else
        leftSAD = 65536;
    } while(leftSAD < middleSAD && leftSAD < rightSAD && i>=i_min_now-sxy/2);

    if(middleSAD < rightSAD && i+1>=i_min_now-sxy/2)
      i_min_now = i+1;
    else {
      i_min_now = i+2;
      middleSAD = rightSAD;
    }
  } else if(rightSAD < middleSAD && rightSAD < leftSAD) {
    /* right search */
    i = i_min_now + 1;

    do {
      rightSAD = leftSAD;
      i++;
      if (i <= ihigh) {
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        middleSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
      } else
        middleSAD = 65536;

      i++;
      if (i <= ihigh) {
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        leftSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
      } else
        leftSAD = 65536;
    } while(rightSAD < middleSAD && rightSAD < leftSAD && i<=i_min_now+sxy/2);

    if(middleSAD < leftSAD && i-1<=i_min_now+sxy/2)
      i_min_now = i-1;
    else {
      i_min_now = i-2;
      middleSAD = leftSAD;
    }
  } else {
    /* center */
  }

  /* vertical search */
  i = i_min_now;
  j = j_min_now-1;
  if (j >= jlow) {
    ii = search_area + (i - ilow) + (j - jlow) * h_length;
    leftSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
  } else 
    leftSAD = 65536;

  j = j_min_now + 1;
  if (j <= jhigh) {
    ii = search_area + (i - ilow) + (j - jlow) * h_length;
    rightSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
  } else 
    rightSAD = 65536;

  /* horizontal search */
  if(leftSAD < middleSAD && leftSAD < rightSAD) {
    /* left search */
    j = j_min_now - 1;

    do {
      rightSAD = leftSAD;
      j--;
      if (j >= ilow) {
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        middleSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
      } else
        middleSAD = 65536;

      j--;
      if (j >= ilow) {
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        leftSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
      } else
        leftSAD = 65536;
    } while(leftSAD < middleSAD && leftSAD < rightSAD && j>=j_min_now-sxy/2);
    if(middleSAD < rightSAD && j+1>=j_min_now-sxy/2)
      j_min_now = j+1;
    else {
      j_min_now = j+2;
      middleSAD = rightSAD;
    }
  } else if (rightSAD < middleSAD && rightSAD < leftSAD) {
    /* right search */
    j = j_min_now + 1;

    do {
      rightSAD = leftSAD;
      j++;
      if (j <= jhigh) {
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        middleSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
      } else
        middleSAD = 65536;

      j++;
      if (j <= jhigh) {
        ii = search_area + (i - ilow) + (j - jlow) * h_length;
        leftSAD = SAD_Macroblock (ii, act_block, h_length, sad_layr);
      } else
        leftSAD = 65536;
    } while(rightSAD < middleSAD && rightSAD < leftSAD && j<=j_min_now+sxy/2);
    if(middleSAD < leftSAD && j-1<=j_min_now+sxy/2)
      j_min_now = j-1;
    else {
      j_min_now = j-2;
      middleSAD = leftSAD;
   }
  } else {
    /* center */
  }


  MV->x = i_min_now - x_curr;
  MV->y = j_min_now - y_curr;
  MV->min_error = middleSAD;

  return;
}
void MotionEstimation_MJPEG(Pixel *curr, Pixel *prev, int x_curr, int y_curr, 
	int xoff, int yoff, int seek_dist, 
	MotionVector* MV, int *SAD_0)
{
  int Min_FRAME[1];
  MotionVector MV_FRAME[1];
  Pixel act_block[16*16],*aa,*ii;
  Pixel search_area[16*16*9], zero_area[16*16];
  int sxy,i,k,j,l;
  int ihigh,ilow,jhigh,jlow,h_length,v_length;
  int xmax,ymax,block,sad,lx;

  xmax = gFrameWidth;
  ymax = gFrameHeight;
  sxy = seek_dist;
    /* Maximum normal search range centered around _zero-vector_ */
    sxy = mmin(15, sxy);  

  lx = gFrameWidth;

  ilow = x_curr + xoff - sxy;
  ihigh = x_curr + xoff + sxy;

  jlow = y_curr + yoff - sxy;
  jhigh = y_curr + yoff + sxy;

  if (ilow<0) ilow = 0;
  if (ihigh>xmax-16) ihigh = xmax-16;
  if (jlow<0) jlow = 0;
  if (jhigh>ymax-16) jhigh = ymax-16;

  h_length = ihigh - ilow + 16;
  h_length = ihigh - ilow + 16;
  v_length = jhigh - jlow + 16;
  LoadArea(act_block,curr, x_curr, y_curr, 16, 16, gFrameWidth);
  LoadArea(search_area, prev, ilow, jlow, h_length, v_length, lx);

  /* the zero vector is within search_area */
  ii = search_area + (x_curr-ilow) + (y_curr-jlow)*h_length;
  *SAD_0 = SAD_Macroblock(ii, act_block, h_length, Min_FRAME[0]) -
       PREF_NULL_VEC;

  Min_FRAME[0] = *SAD_0;
  MV_FRAME[0].x = 0;
  MV_FRAME[0].y = 0;
  
  return;
}
/* no search always produces intra coding */
void MotionEstimation_No(Pixel *curr, Pixel *prev, int x_curr, int y_curr, 
	int xoff, int yoff, int seek_dist, 
	MotionVector* MV, int *SAD_0)
{
	MV->x = 0;
	MV->y = 0;
	MV->min_error = 65536;

	return;
}

void MotionEstimation(Pixel *curr, Pixel *prev, int x_curr, int y_curr, 
	int xoff, int yoff, int seek_dist, 
	MotionVector* MV, int *SAD_0) {
	// api call : ctr_ME() which is control for motion estimation
	int me_algorithm = ctr_ME();	// choose motion estimation algorithm
	switch(me_algorithm) {
		case FULL_SEARCH : MotionEstimation_Full(curr,prev,x_curr,y_curr,xoff,yoff,seek_dist,MV,SAD_0);
				break;
		case DIAMOND_SEARCH : MotionEstimation_Diamond(curr,prev,x_curr,y_curr,xoff,yoff,seek_dist,MV,SAD_0);
				break;
		case THREE_STEP_SEARCH : MotionEstimation_ThreeStep(curr,prev,x_curr,y_curr,xoff,yoff,seek_dist,MV,SAD_0);
				break;
		case TWO_DIM_LOG_SEARCH : MotionEstimation_TwoDimLog(curr,prev,x_curr,y_curr,xoff,yoff,seek_dist,MV,SAD_0);
				break;
		case ONE_TIME_SEARCH : MotionEstimation_OneTime(curr,prev,x_curr,y_curr,xoff,yoff,seek_dist,MV,SAD_0);
				break;
		case MJPEG_SEARCH : MotionEstimation_MJPEG(curr,prev,x_curr,y_curr,xoff,yoff,seek_dist,MV,SAD_0);
				break;
		case NO_SEARCH : MotionEstimation_No(curr,prev,x_curr,y_curr,xoff,yoff,seek_dist,MV,SAD_0);
				break;
	}
}
void MotionEstimationPicture (Pixel *curr, Pixel *prev, Pixel *prev_ipol, 
	int seek_dist, MotionVector* MV, int gobsync, int j, int i)
{
  int xoff,yoff;
  int curr_mb[16][16];
  int sad8 = INT_MAX, sad16, sad0;
  int newgob;

  /* Do motion estimation and store result in array */
  newgob = 0;
  if (gobsync && j%gobsync == 0 && i==0) {
    newgob = 1;
  }

  MotionEstimation(curr, prev, i*16, j*16, 
    0, 0, seek_dist, MV, &sad0);

  sad16 = MV->min_error;
  MV->Mode = ChooseMode(curr,i*16,j*16, mmin(sad8,sad16));

/*  if(MV->Mode==MODE_INTRA)
    printf("mode intra\n");
*/ 
  /* Half pel search */
  if (MV->Mode != MODE_INTRA) {
    FindMB(i*16,j*16 ,curr, curr_mb);
    FindHalfPel(i*16,j*16,MV, prev_ipol, &curr_mb[0][0],16,0);
    sad16 = MV->min_error;
 
    /* Choose Zero Vector or 16x16 vectors */
    if (sad0 < sad16) {
      ZeroVec(MV);
    }
  } else {
      ZeroVec(MV);
  }
}
void InterpolateImage(unsigned char* ipol_image, unsigned char *image, int width, int height)
{
  unsigned char *ii, *oo;
  int i,j;

//  ipol_image = (unsigned char *)malloc(sizeof(char)*width*height*4);
  ii = ipol_image;
  oo = image;

  /* main image */
  for (j = 0; j < height-1; j++) {
    for (i = 0; i  < width-1; i++) {
      *(ii + (i<<1)) = *(oo + i);
      *(ii + (i<<1)+1) = (*(oo + i) + *(oo + i + 1) + 1)>>1;
      *(ii + (i<<1)+(width<<1)) = (*(oo + i) + *(oo + i + width) + 1)>>1;
      *(ii + (i<<1)+1+(width<<1)) = (*(oo+i) + *(oo+i+1) +
         *(oo+i+width) + *(oo+i+1+width) + 2)>>2;
    }
    /* last pels on each line */
    *(ii+ (width<<1) - 2) = *(oo + width - 1);
    *(ii+ (width<<1) - 1) = *(oo + width - 1);
    *(ii+ (width<<1)+ (width<<1)-2) = (*(oo+width-1)+*(oo+width+width-1)+1)>>1;
    *(ii+ (width<<1)+ (width<<1)-1) = (*(oo+width-1)+*(oo+width+width-1)+1)>>1;
    ii += (width<<2);
    oo += width;
  }

  /* last lines */
  for (i = 0; i < width-1; i++) {
    *(ii+ (i<<1)) = *(oo + i);
    *(ii+ (i<<1)+1) = (*(oo + i) + *(oo + i + 1) + 1)>>1;
    *(ii+ (width<<1)+ (i<<1)) = *(oo + i);
    *(ii+ (width<<1)+ (i<<1)+1) = (*(oo + i) + *(oo + i + 1) + 1)>>1;

  }

  /* bottom right corner pels */
  *(ii + (width<<1) - 2) = *(oo + width -1);
  *(ii + (width<<1) - 1) = *(oo + width -1);
  *(ii + (width<<2) - 2) = *(oo + width -1);
  *(ii + (width<<2) - 1) = *(oo + width -1);
}
void diffBlockFromImage(int x, int y, int dx, int dy,
	unsigned char *currImage, unsigned char *prevImage, int *data,int width)
{
  int m,n;
  int x_half = dx % 2;
  int y_half = dy % 2;
  unsigned char *currBlock;
  unsigned char *prevBlock;

  currBlock = currImage+y*width+x;
  prevBlock = prevImage+(y+dy/2)*width+x+dx/2;

  if(!x_half && !y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        data[8*n+m] = (int)currBlock[width*n+m] - prevBlock[width*n+m];
      }
    }
  } else if(x_half && !y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        data[8*n+m] = (int)currBlock[width*n+m] - ((prevBlock[width*n+m]+prevBlock[width*n+m+x_half]+1)>>1);
      }
    }
  } else if(!x_half && y_half) {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        data[8*n+m] = (int)currBlock[width*n+m] - ((prevBlock[width*n+m]+prevBlock[width*(n+y_half)+m]+1)>>1);
      }
    }
  } else {
    for (n = 0; n < 8; n++) {
      for (m = 0; m < 8; m++) {
        data[8*n+m] = (int)currBlock[width*n+m] - ((prevBlock[width*n+m]+prevBlock[width*n+m+x_half]+ prevBlock[width*(n+y_half)+m]+prevBlock[width*(n+y_half)+m+x_half]+2)>>2);
      }
    }
  }
}
void copyBlockFromImage(int x, int y, unsigned char *currImage, int *data, int width)
{
  int m,n;
  unsigned char *currBlock;

  currBlock = currImage+y*width+x;

  for (n = 0; n < 8; n++) {
    for (m = 0; m < 8; m++) {
      data[8*n+m] = (int)currBlock[width*n+m];
    }
  }
} 
/* private data */
static unsigned char outbfr;
static int outcnt;
static int bytecnt;

/* initialize buffer, call once before first putbits or alignbits */
static void
initbits()
{
  outcnt = 8;
  bytecnt = 0;
}

/* convert to binary number */
void
BitPrint(int length, int val, char *bit)
{
  int m;

  m = length;
  bit[0] = '"';
  while (m--) {
    bit[length-m] = (val & (1<<m)) ? '1' : '0';
  }
  bit[length+1] = '"';
  bit[length+2] = '\n';
  bit[length+3] = '\0';
  return;
}

// 2k buffering
unsigned char netBuffer[1024*2];
int bufferCount = 0;

void sendToClient(unsigned char theBuffer)
{
	int len;
        if(bufferCount==1024*2-1) { // flushing
                netBuffer[bufferCount] = theBuffer;
		//usleep(5);
                len = write(connectionId_265,netBuffer, sizeof(unsigned char)*(bufferCount+1));
                bufferCount = 0;

		//printf("send %d\n",len);
        } else {
                netBuffer[bufferCount] = theBuffer;
                bufferCount++;
        }
}

void flushToClient()
{
        write(connectionId_265,netBuffer, sizeof(unsigned char)*bufferCount);
        bufferCount = 0;
}


/* write rightmost n (0<=n<=32) bits of val to outfile */

void
putbits (int n, int val)
{
  int i;
  unsigned int mask;
  char bitstring[32];

  if (0) {
    if (n > 0) {
      BitPrint(n,val,bitstring);
      fprintf(tf_260,bitstring);
    }
  }

  mask = 1 << (n-1); /* selects first (leftmost) bit */

  for (i=0; i<n; i++) {
    outbfr <<= 1;

    if (val & mask)
      outbfr|= 1;

    mask >>= 1; /* select next bit */
    outcnt--;

    if (outcnt==0) /* 8 bit buffer full */ {
      //putc(outbfr,streamfile_261);
      sendToClient(outbfr);
      outcnt = 8;
      bytecnt++;
    }
  }
}
/* zero bit stuffing to next byte boundary (5.2.3, 6.2.1) */

int
alignbits ()
{
  int ret_value;

  if (outcnt!=8) {
    ret_value = outcnt; /* outcnt is reset in call to putbits () */
    putbits (outcnt, 0);

//    if(bufferCount>0)
//	flushToClient();
    return ret_value;
  }
  else
    return 0;
}

/* return total number of generated bits */
int
bitcount()
{
  return 8*bytecnt + (8-outcnt);
}

/* type definitions for variable length code table entries */

typedef struct
{
  unsigned int code; /* right justified */
  int len;
} VLCtable;


/* Motion vectors */

static VLCtable mvtab[33] =
{
  {1,1}, {1,2}, {1,3}, {1,4}, {3,6}, {5,7}, {4,7}, {3,7},
  {11,9}, {10,9}, {9,9}, {17,10}, {16,10}, {15,10}, {14,10}, {13,10},
  {12,10}, {11,10}, {10,10}, {9,10}, {8,10}, {7,10}, {6,10}, {5,10},
  {4,10}, {7,11}, {6,11}, {5,11}, {4,11}, {3,11}, {2,11}, {3,12},
  {2,12}
};


/* CBPCM (MCBPC) Indexing by cbpc in first two bits, mode in last two.
 CBPC as in table 4/H.263, MB type (mode): 3 = 01, 4 = 10.
 Example: cbpc = 01 and mode = 4 gives index = 0110 = 6. */

static VLCtable cbpcm_intra_tab[15] =
{
  {0x01,9}, {0x01,1}, {0x01,4}, {0x00,0},
  {0x00,0}, {0x01,3}, {0x01,6}, {0x00,0},
  {0x00,0}, {0x02,3}, {0x02,6}, {0x00,0},
  {0x00,0}, {0x03,3}, {0x03,6}
};


/* CBPCM inter.
   Addressing: 5 bit ccmmm (cc = CBPC, mmm = mode (1-4 binary)) */

static VLCtable cbpcm_inter_tab[29] =
{
  {1,1}, {3,3}, {2,3}, {3,5}, {4,6}, {1,9}, {0,0}, {0,0},
  {3,4}, {7,7}, {5,7}, {4,8}, {4,9}, {0,0}, {0,0}, {0,0},
  {2,4}, {6,7}, {4,7}, {3,8}, {3,9}, {0,0}, {0,0}, {0,0},
  {5,6}, {5,9}, {5,8}, {3,7}, {2,9}
};


/* CBPY. Straightforward indexing */

static VLCtable cbpy_tab[16] =
{
  {3,4}, {5,5}, {4,5}, {9,4}, {3,5}, {7,4}, {2,6}, {11,4},
  {2,5}, {3,6}, {5,4}, {10,4}, {4,4}, {8,4}, {6,4}, {3,2}
};


/* DCT coefficients. Four tables, two for last = 0, two for last = 1.
   the sign bit must be added afterwards. */

/* first part of coeffs for last = 0. Indexed by [run][level-1] */

static VLCtable coeff_tab0[2][12] =
{
  /* run = 0 */
  {
    {0x02, 2}, {0x0f, 4}, {0x15, 6}, {0x17, 7},
    {0x1f, 8}, {0x25, 9}, {0x24, 9}, {0x21,10},
    {0x20,10}, {0x07,11}, {0x06,11}, {0x20,11}
  },
  /* run = 1 */
  {
    {0x06, 3}, {0x14, 6}, {0x1e, 8}, {0x0f,10},
    {0x21,11}, {0x50,12}, {0x00, 0}, {0x00, 0},
    {0x00, 0}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  }
};

/* rest of coeffs for last = 0. indexing by [run-2][level-1] */

static VLCtable coeff_tab1[25][4] =
{
  /* run = 2 */
  {
    {0x0e, 4}, {0x1d, 8}, {0x0e,10}, {0x51,12}
  },
  /* run = 3 */
  {
    {0x0d, 5}, {0x23, 9}, {0x0d,10}, {0x00, 0}
  },
  /* run = 4-26 */
  {
    {0x0c, 5}, {0x22, 9}, {0x52,12}, {0x00, 0}
  },
  {
    {0x0b, 5}, {0x0c,10}, {0x53,12}, {0x00, 0}
  },
  {
    {0x13, 6}, {0x0b,10}, {0x54,12}, {0x00, 0}
  },
  {
    {0x12, 6}, {0x0a,10}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x11, 6}, {0x09,10}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x10, 6}, {0x08,10}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x16, 7}, {0x55,12}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x15, 7}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x14, 7}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x1c, 8}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x1b, 8}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x21, 9}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x20, 9}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x1f, 9}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x1e, 9}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x1d, 9}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x1c, 9}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x1b, 9}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x1a, 9}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x22,11}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x23,11}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x56,12}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  },
  {
    {0x57,12}, {0x00, 0}, {0x00, 0}, {0x00, 0}
  }
};

/* first coeffs of last = 1. indexing by [run][level-1] */

static VLCtable coeff_tab2[2][3] =
{
  /* run = 0 */
  {
    {0x07, 4}, {0x19, 9}, {0x05,11}
  },
  /* run = 1 */
  {
    {0x0f, 6}, {0x04,11}, {0x00, 0}
  }
};

/* rest of coeffs for last = 1. indexing by [run-2] */

static VLCtable coeff_tab3[40] =
{
  {0x0e, 6}, {0x0d, 6}, {0x0c, 6},
  {0x13, 7}, {0x12, 7}, {0x11, 7}, {0x10, 7},
  {0x1a, 8}, {0x19, 8}, {0x18, 8}, {0x17, 8},
  {0x16, 8}, {0x15, 8}, {0x14, 8}, {0x13, 8},
  {0x18, 9}, {0x17, 9}, {0x16, 9}, {0x15, 9},
  {0x14, 9}, {0x13, 9}, {0x12, 9}, {0x11, 9},
  {0x07,10}, {0x06,10}, {0x05,10}, {0x04,10},
  {0x24,11}, {0x25,11}, {0x26,11}, {0x27,11},
  {0x58,12}, {0x59,12}, {0x5a,12}, {0x5b,12},
  {0x5c,12}, {0x5d,12}, {0x5e,12}, {0x5f,12},
  {0x00, 0}
};


int
put_mv (int mvint)
{
  int sign = 0;
  int absmv;

  if (mvint >= 32) {
    absmv = -mvint + 64;
    sign = 1;
  }
  else
    absmv = mvint;

  putbits (mvtab[absmv].len, mvtab[absmv].code);

  if (mvint != 0) {
    putbits (1, sign);
    return mvtab[absmv].len + 1;
  }
  else
    return mvtab[absmv].len;
}

int
put_cbpcm_intra (int cbpc, int mode)
{
  int index;

  index = ((mode & 3) >> 1) | ((cbpc & 3) << 2);

  putbits (cbpcm_intra_tab[index].len, cbpcm_intra_tab[index].code);

  return cbpcm_intra_tab[index].len;
}
int
put_cbpcm_inter (int cbpc, int mode)
{
  int index;

  index = (mode & 7) | ((cbpc & 3) << 3);

  putbits (cbpcm_inter_tab[index].len, cbpcm_inter_tab[index].code);

  return cbpcm_inter_tab[index].len;
}


int
put_cbpy (int cbp, int mode)
{
  int index;

  index = cbp >> 2;

  if (mode < 3)
    index ^= 15;

  putbits (cbpy_tab[index].len, cbpy_tab[index].code);

  return cbpy_tab[index].len;
}

#include <assert.h>

int
put_coeff (int run, int level, int last)
{
  int length = 0;

  assert (last >= 0 && last < 2);
  assert (run >= 0 && run < 64);
  assert (level > 0 && level < 128);

  if (last == 0) {
    if (run < 2 && level < 13 ) {
      putbits (coeff_tab0[run][level-1].len,
               coeff_tab0[run][level-1].code);

      length = coeff_tab0[run][level-1].len;
    }
    else if (run > 1 && run < 27 && level < 5) {
      putbits (coeff_tab1[run-2][level-1].len,
               coeff_tab1[run-2][level-1].code);

      length = coeff_tab1[run-2][level-1].len;
    }
  }
  else if (last == 1) {
    if (run < 2 && level < 4) {
      putbits (coeff_tab2[run][level-1].len,
               coeff_tab2[run][level-1].code);

      length = coeff_tab2[run][level-1].len;
    }
    else if (run > 1 && run < 42 && level == 1) {
      putbits (coeff_tab3[run-2].len,
               coeff_tab3[run-2].code);

      length = coeff_tab3[run-2].len;
    }
  }
  return length;
}
void CountBitsMB(int Mode, int COD, int CBP, int dquant, int type, Bits *bits,int MB)
{
  int cbpy, cbpcm, length;

  /* COD */
  if (0) {
    fprintf(tf_260,"MB-nr: %d",MB);
    if (type == P_FRAME)
      fprintf(tf_260,"  COD: %d\n",COD);
  }
  if (type == P_FRAME) {
    putbits(1,COD);
    bits->COD++;
  }

  if (COD)
    return;    /* not coded */

  /* CBPCM */
  cbpcm = Mode | ((CBP&3)<<4);
  if (0) {
    fprintf(tf_260,"CBPCM (CBP=%d) (cbpcm=%d): ",CBP,cbpcm);
  }
  if (type == I_FRAME)
    length = put_cbpcm_intra (CBP, Mode);
  else
    length = put_cbpcm_inter (CBP, Mode);
  bits->CBPCM += length;

  /* CBPY */
  cbpy = CBP>>2;
  if (Mode == MODE_INTRA || Mode == MODE_INTRA_Q) /* Intra */
    cbpy = cbpy^15;
  if (0) {
    fprintf(tf_260,"CBPY (CBP=%d) (cbpy=%d): ",CBP,cbpy);
  }
  length = put_cbpy (CBP, Mode);

  bits->CBPY += length;

  /* DQUANT */
  if ((Mode == MODE_INTER_Q) || (Mode == MODE_INTRA_Q)) {
    if (0) {
      fprintf(tf_260,"DQUANT: ");
    }
    switch (dquant) {
    case -1:
      putbits(2,0);
      break;
    case -2:
      putbits(2,1);
      break;
    case 1:
      putbits(2,2);
      break;
    case 2:
      putbits(2,3);
      break;
    default:
      fprintf(stderr,"Invalid DQUANT\n");
      exit(-1);
    }
    bits->DQUANT += 2;
  }
  return;
}

static void FindPMV(int dx1, int dy1, int dx2, int dy2, int dx3, int dy3, 
int x, int y, int *pmv0, int *pmv1)
{
  if(x==0) { /* case 1: left GOB border */
     dx1 = dy1 = 0;
  }
  if(y==0) { /* case 2: upper GOB border */
     dx2 = dx3 = dx1;
     dy2 = dy3 = dy1;
  }
  if(x==gFrameWidth/16-1) { /* case 3: right GOB border */
     dx3 = dy3 = 0;
  }

  *pmv0 = dx1+dx2+dx3 - mmax(dx1,mmax(dx2,dx3)) - mmin(dx1,mmin(dx2,dx3));
  *pmv1 = dy1+dy2+dy3 - mmax(dy1,mmax(dy2,dy3)) - mmin(dy1,mmin(dy2,dy3));

  return;
}

void CountBitsVectors(int dx, int dy, 
int dx1, int dy1, int dx2, int dy2, int dx3, int dy3,
Bits* bits, int x, int y)
{
  int y_vec, x_vec;
  int pmv0, pmv1;

  FindPMV(dx1,dy1,dx2,dy2,dx3,dy3,x,y,&pmv0,&pmv1);
  x_vec = dx - pmv0;
  y_vec = dy - pmv1;

  if (x_vec < -32) x_vec += 64;
  else if (x_vec > 31) x_vec -= 64;

  if (y_vec < -32) y_vec += 64;
  else if (y_vec > 31) y_vec -= 64;

  if (0) {
    fprintf(tf_260,"Vectors:\n");
  }

  if (x_vec < 0) x_vec += 64;
  if (y_vec < 0) y_vec += 64;

  bits->vec += put_mv (x_vec);
  bits->vec += put_mv (y_vec);

  if (0) {
    if (x_vec > 31) x_vec -= 64;
    if (y_vec > 31) y_vec -= 64;
    fprintf(tf_260,"(x,y) = (%d,%d) - ",dx,dy);
    fprintf(tf_260,"(Px,Py) = (%d,%d)\n", pmv0,pmv1);
    fprintf(tf_260,"(x_diff,y_diff) = (%d,%d)\n",x_vec,y_vec);
  }
}

void CountBitsCoeff(int *qcoeff, int Mode, int CBP, Bits *bits, int ncoeffs,int i)
{

  if (Mode == MODE_INTRA || Mode == MODE_INTRA_Q) {
    if(i<4) {
      bits->Y += CodeCoeff(Mode, qcoeff,i,ncoeffs);
    } else {
      bits->C += CodeCoeff(Mode, qcoeff,i,ncoeffs);
    }
  }
  else {
    if(i<4) {
      if ((i==0 && CBP&32) ||
          (i==1 && CBP&16) ||
          (i==2 && CBP&8) ||
          (i==3 && CBP&4) ||
          (i==4 && CBP&2) ||
          (i==5 && CBP&1)) {
        bits->Y += CodeCoeff(Mode, qcoeff, i, ncoeffs);
      }
    } else {
      if ((i==0 && CBP&32) ||
          (i==1 && CBP&16) ||
          (i==2 && CBP&8) ||
          (i==3 && CBP&4) ||
          (i==4 && CBP&2) ||
          (i==5 && CBP&1)) {
        bits->C += CodeCoeff(Mode, qcoeff, i, ncoeffs);
      }
    }
  }
  return;
}

int CodeCoeff(int Mode, int *qcoeff, int block, int ncoeffs)
{
  int j, bits;
  int prev_run, run, prev_level, level, first;
  int prev_s, s, length;

  run = bits = 0;
  first = 1;
  prev_run = prev_level = level = s = prev_s = 0;

  if (0) {
    fprintf(tf_260,"Coeffs block %d:\n",block);
  }

  for (j = 0; j< ncoeffs; j++) {
    /* Do this block's DC-coefficient first */
    if (!(j) && (Mode == MODE_INTRA || Mode == MODE_INTRA_Q)) {
      /* DC coeff */
      if (0) {
        fprintf(tf_260,"DC: ");
      }
      if (qcoeff[0] != 128)

        putbits(8,qcoeff[0]);
      else
        putbits(8,255);
      bits += 8;
    }
    else {
      /* AC coeff */
      s = 0;
      /* Increment run if coeff is zero */
      if ((level = qcoeff[j]) == 0) {
        run++;
      }
      else {
        /* code run & level and count bits */
        if (level < 0) {
          s = 1;
          level = -level;
        }

        if (!first) {
          /* Encode the previous coefficient */
          if (prev_level  < 13 && prev_run < 64)
            length = put_coeff (prev_run, prev_level, 0);
          else
            length = 0;
          if (length == 0) {  /* Escape coding */
            if (0) {
              fprintf(tf_260,"Escape code: ");
            }
            if (prev_s == 1) {prev_level = (prev_level^0xff)+1;}
            putbits(7,3);       /* Escape code */
            if (0)
              fprintf(tf_260,"last: ");
            putbits(1,0);
            if (0)
              fprintf(tf_260,"run: ");
            putbits(6,prev_run);
            if (0)
              fprintf(tf_260,"level: ");
            putbits(8,prev_level);
            bits += 22;
          }
          else {
            putbits(1,prev_s);
            bits += length + 1;
          }
        }
        prev_run = run; prev_s = s;
        prev_level = level;

        run = first = 0;
      }
    }
  }
  /* Encode the last coeff */
  if (!first) {
    if (0) {
      fprintf(tf_260,"Last coeff: ");
    }
    if (prev_level  < 13 && prev_run < 64)
      length = put_coeff (prev_run, prev_level, 1);
    else
      length = 0;
    if (length == 0) {  /* Escape coding */
      if (0) {
        fprintf(tf_260,"Escape code: ");
      }
      if (prev_s == 1) {prev_level = (prev_level^0xff)+1;}
      putbits (7,3);    /* Escape code */
      if (0)
        fprintf(tf_260,"last: ");
      putbits(1,1);
      if (0)
        fprintf(tf_260,"run: ");
      putbits(6,prev_run);
      if (0)
        fprintf(tf_260,"level: ");
      putbits(8,prev_level);
      bits += 22;
    }
    else {
      putbits(1,prev_s);
      bits += length + 1;
    }
  }
  return bits;
}
void ZeroBits(Bits *bits)
{
  bits->Y = 0;
  bits->C = 0;
  bits->vec = 0;
  bits->CBPY = 0;
  bits->CBPCM = 0;
  bits->MODB = 0;
  bits->CBPB = 0;
  bits->COD = 0;
  bits->DQUANT = 0;
  bits->header = 0;
  bits->total = 0;
  bits->no_inter = 0;
  bits->no_inter4v = 0;
  bits->no_intra = 0;
  return;
}
void AddBits(Bits *total, Bits *bits)
{
  total->Y += bits->Y;
  total->C += bits->C;
  total->vec += bits->vec;
  total->CBPY += bits->CBPY;
  total->CBPCM += bits->CBPCM;
  total->MODB += bits->MODB;
  total->CBPB += bits->CBPB;
  total->COD += bits->COD;
  total->DQUANT += bits->DQUANT;
  total->header += bits->header;
  total->total += bits->total;
  total->no_inter += bits->no_inter;
  total->no_inter4v += bits->no_inter4v;
  total->no_intra += bits->no_intra;
  return;
}

void AddBitsPicture(Bits *bits)
{
  bits->total =
    bits->Y +
    bits->C +
    bits->vec +
    bits->CBPY +
    bits->CBPCM +
    bits->MODB +
    bits->CBPB +
    bits->COD +
    bits->DQUANT +
    bits->header ;
}
int CountBitsSlice(int slice, int quant)
{
  int bits = 0;

  /* Picture Start Code */
  if (0)
    fprintf(tf_260,"GOB sync (GBSC): ");
  putbits(PSC_LENGTH,PSC); /* PSC */
  bits += PSC_LENGTH;

  /* Group Number */
  if (0)
    fprintf(tf_260,"GN: ");
  putbits(5,slice);
  bits += 5;

  /* GOB Sub Bitstream Indicator */
  /* if CPM == 1: read 2 bits GSBI */
  /* not supported in this version */

  /* GOB Frame ID */
  if (0)
    fprintf(tf_260,"GFID: ");
  putbits(2, 0);
  /* NB: in error-prone environments this value should change if
     PTYPE in picture header changes. In this version of the encoder
     PTYPE only changes when PB-frames are used in the following cases:
     (i) after the first intra frame
     (ii) if the distance between two P-frames is very large
     Therefore I haven't implemented this GFID change */
  /* GFID is not allowed to change unless PTYPE changes */
  bits += 2;

  /* Gquant */
  if (0)
    fprintf(tf_260,"GQUANT: ");
  putbits(5,quant);
  bits += 5;

  return bits;
}

int CountBitsPicture(Pict *pic)
{
  int bits = 0;

  /* in case of arithmetic coding, encoder_flush() has been called before
     zeroflush() in main.c */

  /* Picture start code */
  if (0) {
    fprintf(tf_260,"picture_start_code: ");
  }
  putbits(PSC_LENGTH,PSC);
  bits += PSC_LENGTH;

  /* Group number */
  if (0) {
    fprintf(tf_260,"Group number in picture header: ");
  }
  putbits(5,0);
  bits += 5;

  /* Time reference */
  if (0) {
    fprintf(tf_260,"Time reference: ");
  }
  putbits(8,pic->TR);
  bits += 8;

 /* bit 1 */
  if (0) {
    fprintf(tf_260,"spare: ");
  }
  pic->spare = 1; /* always 1 to avoid start code emulation */
  putbits(1,pic->spare);
  bits += 1;

  /* bit 2 */
  if (0) {
    fprintf(tf_260,"always zero for distinction with H.261\n");
  }
  putbits(1,0);
  bits += 1;

  /* bit 3 */
  if (0) {
    fprintf(tf_260,"split_screen_indicator: ");
  }
  putbits(1,0);     /* no support for split-screen in this software */
  bits += 1;

  /* bit 4 */
  if (0) {
    fprintf(tf_260,"document_camera_indicator: ");
  }
  putbits(1,0);
  bits += 1;

  /* bit 5 */
  if (0) {
    fprintf(tf_260,"freeze_picture_release: ");
  }
  putbits(1,0);
  bits += 1;

  /* bit 6-8 */
  if (0) {
    fprintf(tf_260,"source_format: ");
  }
  putbits(3,pic->source_format);
  bits += 3;

  /* bit 9 */
  if (0) {
    fprintf(tf_260,"picture_coding_type: ");
  }
  putbits(1,pic->picture_coding_type);
  bits += 1;

  /* bit 10 */
  if (0) {
    fprintf(tf_260,"mv_outside_frame: ");
  }
  putbits(1,pic->unrestricted_mv_mode);  /* Unrestricted Motion Vector mode */
  bits += 1;

  /* bit 11 */
  if (0) {
    fprintf(tf_260,"sac_coding: ");
  }
  putbits(1,0); /* Syntax-based Arithmetic Coding mode */
  bits += 1;

  /* bit 12 */
  if (0) {
    fprintf(tf_260,"adv_pred_mode: ");
  }
  putbits(1,0); /* Advanced Prediction mode */
  bits += 1;

  /* bit 13 */
  if (0) {
    fprintf(tf_260,"PB-coded: "); /* PB-frames mode */
  }
  putbits(1,0);
  bits += 1;


  /* QUANT */
  if (0) {
    fprintf(tf_260,"QUANT: ");
  }
  putbits(5,pic->QUANT);
  bits += 5;

  /* Continuous Presence Multipoint (CPM) */
  putbits(1,0); /* CPM is not supported in this software */
  bits += 1;

  /* Picture Sub Bitstream Indicator (PSBI) */
  /* if CPM == 1: 2 bits PSBI */
  /* not supported */

  /* extra information for PB-frames */
  if (pic->PB) {
    if (0) {
      fprintf(tf_260,"TRB: ");
    }
    putbits(3,pic->TRB);
    bits += 3;

    if (0) {
      fprintf(tf_260,"BQUANT: ");
    }
    putbits(2,pic->BQUANT);
    bits += 2;

  }

  /* PEI (extra information) */
  if (0) {
    fprintf(tf_260,"PEI: ");
  }
  /* "Encoders shall not insert PSPARE until specified by the ITU" */
  putbits(1,0);
  bits += 1;

  /* PSPARE */
  /* if PEI == 1: 8 bits PSPARE + another PEI bit */
  /* not supported */

  return bits;
}



#ifdef OFFLINE_RATE_CONTROL

/* ABOUT THE OFFLINE RATE CONTROL:

   If you compile the TMN encoder with OFFLINE_RATE_CONTROL, you will
   get the same rate control as was used to generate the MPEG-4
   anchors. This rate control does not skip any extra pictures after
   the first frame, and it uses a fixed frame rate. It is possible to
   start the rate control after a certain percentage of the sequence
   has been encoded with a fixed quantization parameter. Its purpose
   is to achieve the target bitrate as a mean bitrate for the whole
   sequence. In other words, it is a rate control method optimized for
   offline compression.

   If oyu use the offline rate control, you will risk not achieving
   the target rate under one or more of the following conditions :

   (i)   too high frame rate
   (ii)  too low start value for the quantization parameter
   (iii) the rate control is started too late
   (iv)  the sequence encoded is too short

*/




/**********************************************************************
 *
 *      Name:           FrameUpdateQP
 *      Description:    updates quantizer once per frame for
 *                      simplified rate control
 *
 *      Returns:        new quantizer
 *      Side effects:
 *
 *      Date: 950910    Author: Karl.Lillevold@nta.no
 *
 ***********************************************************************/

int FrameUpdateQP(int buf, int bits, int frames_left, int QP, int B,
          float seconds)
{
  int newQP, dQP;
  float buf_rest, buf_rest_pic;

  buf_rest = seconds * B - (float)buf;

  newQP = QP;

  if (frames_left > 0) {
    buf_rest_pic = buf_rest / (float)frames_left;

    printf("\n");
    printf("  Simplified rate control for %d remaining pictures:\n",
           frames_left);
    printf("  Bits spent / left       : %8d / %d (%d per picture)\n",
           buf, mnint(buf_rest), mnint(buf_rest_pic));

    dQP = mmax(1,QP*0.1);

    printf("  Limits                  : %8.0f / %.0f\n",
           buf_rest_pic / 1.15, buf_rest_pic * 1.15);
    printf("  Bits spent on last frame: %8d\n", bits);

    if (bits > buf_rest_pic * 1.15) {
      newQP = mmin(31,QP+dQP);
      printf("  QP -> new QP            : %2d -> %2d\n", QP, newQP);
    }
    else if (bits < buf_rest_pic / 1.15) {
      newQP = mmax(1,QP-dQP);
      printf("  QP -> new QP            : %2d -> %2d\n", QP, newQP);
    }
    else {
      printf("  QP not changed\n");
    }
  }
  printf("\n");
  return newQP;
}

#else

/*

   These routines are needed for the low-delay , variable frame rate,
   rate control specified in the TMN5 document

*/


/* rate control static variables */

static float B_prev;     /* number of bits spent for the previous frame */
static float B_target;   /* target number of bits/picture               */
static float global_adj; /* due to bits spent for the previous frame    */


void InitializeRateControl()
{
  B_prev = (float)0.0;
}

void UpdateRateControl(int bits)
{
  B_prev = (float)bits;
}

int InitializeQuantizer(int pict_type, float bit_rate,
        float target_frame_rate, float QP_mean)

/* QP_mean = mean quantizer parameter for the previous picture */
/* bitcount = current total bit count                          */
/* To calculate bitcount in coder.c, do something like this :  */
/* int bitcount;                                               */
/* AddBitsPicture(bits);                                       */
/* bitcount = bits->total;                                     */

{
  int newQP;

  if (pict_type == PCT_INTER) {

    B_target = bit_rate / target_frame_rate;

    /* compute picture buffer descrepency as of the previous picture */

    if (B_prev != 0.0) {
      global_adj = (B_prev - B_target) / (2*B_target);
    }
    else {
      global_adj = (float)0.0;
    }
    newQP = (int)(QP_mean * (1 + global_adj) + (float)0.5);
    newQP = mmax(1,mmin(31,newQP));
  }
  else if (pict_type == PCT_INTRA) {
    fprintf(stderr,"No need to call InititializeQuantizer() for Intra picture\n");
    exit(-1);
  }
  else  {
    fprintf(stderr,"Error (InitializePictureRate): picture type unkown.\n");
    exit(-1);
  }
#if 1
  printf("Global adj = %.2f\n", global_adj);
  printf("meanQP = %.2f   newQP = %d\n", QP_mean, newQP);
#endif
  fprintf(stdout,"Target no. of bits: %.2f\n", B_target);

  return newQP;
}


/*********************************************************************
*   Name:          UpdateQuantizer
*
*
* Description: This function generates a new quantizer step size based
*                  on bits spent up until current macroblock and bits
*                  spent from the previous picture.  Note: this
*                  routine should be called at the beginning of each
*                  macroblock line as specified by TMN4. However, this
*                  can be done at any macroblock if so desired.
*
*  Input: current macroblock number (raster scan), mean quantizer
*  paramter for previous picture, bit rate, source frame rate,
*  hor. number of macroblocks, vertical number of macroblocks, total #
*  of bits used until now in the current picture.
*
*  Returns: Returns a new quantizer step size for the use of current
*  macroblock Note: adjustment to fit with 2-bit DQUANT should be done
*  in the calling program.
*
*  Side Effects:
*
*  Date: 1/5/95    Author: Anurag Bist
*
**********************************************************************/


int UpdateQuantizer(int mb, float QP_mean, int pict_type, float bit_rate,
                    int mb_width, int mb_height, int bitcount)

/* mb = macroblock index number */
/* QP_mean = mean quantizer parameter for the previous picture */
/* bitcount = total # of bits used until now in the current picture */

{
  int newQP=16;
  float local_adj, descrepency, projection;

  if (pict_type == PCT_INTRA) {
    newQP = 16;
  }
  else if (pict_type == PCT_INTER) {
    /* compute expected buffer fullness */

    projection = mb * (B_target / (mb_width*mb_height));

    /* measure descrepency between current fullness and projection */
    descrepency= (bitcount - projection);

    /* scale */

    local_adj = 12 * descrepency / bit_rate;

#if 0
    printf("mb = %d\n",mb);
    printf("bit_count = %d projection = %.2f \n",bitcount,projection);
    printf("B_target = %.2f local_adj = %.2f \n",B_target,local_adj);
#endif

    newQP = (int)(QP_mean * (1 + global_adj + local_adj) + 0.5);

  /* the update equation for newQP in TMN4 document section 3.7 */

  }
  else  {
    fprintf(stderr,"Error (UpdateQuantizer): picture type unkown.\n");
  }
#if 0
  printf("mb = %d  newQP = %d \n",mb,newQP);
#endif

  newQP = mmax(1,mmin(31,newQP));
  return newQP;
}

#endif
		void doZigzag(int* outImg, int* inImg)
		{
			int i,j;
			for(i=0; i<8; i++)
				for(j=0; j<8; j++)
					outImg[zigzag[i][j]] = inImg[i*8+j];
		}
void doQuantizer(int* qcoeff, int* coeff, int QP, int theMode){
  int i;
  int level;

  if (QP) {
    if (theMode == MODE_INTRA || theMode == MODE_INTRA_Q) { /* Intra */
      qcoeff[0] = mmax(1,mmin(254,coeff[0]/8));

      for (i = 1; i < 64; i++) {
        level = (abs(coeff[i])) / (2*QP);
        qcoeff[i] =  mmin(127,mmax(-127,sign(coeff[i]) * level));
      }
    }
    else { /* non Intra */
      for (i = 0; i < 64; i++) {
        level = (abs(coeff[i])-QP/2)  / (2*QP);
        qcoeff[i] = mmin(127,mmax(-127,sign(coeff[i]) * level));
      }
    }
  }
  else {
    /* No quantizing.
       Used only for testing. Bitstream will not be decodable
       whether clipping is performed or not */
    for (i = 0; i < 64; i++) {
      qcoeff[i] = coeff[i];
    }
  }
}
	void doDCT(int* outBlock, int* inBlock)
	{	

                const int f0=46340;
                const int f1=32138;
                const int f2=30273;
                const int f3=27245;
                const int f4=23170;
                const int f5=18204;
                const int f6=12539;
                const int f7=6392;

		  int        j1, i, j;
		  int b[8];
		  int        b1[8];
		  int        d[8][8];

		  for (i = 0; i < 8; i++) {
		    for (j = 0; j < 8; j++) {
		      b[j] = (int)inBlock[i*8+j]<<4;
		    } 

		    /* Horizontal transform */
		    for (j = 0; j < 4; j++) {
		      j1 = 7 - j;
		      b1[j] = b[j] + b[j1];
		      b1[j1] = b[j] - b[j1];
		    }
		    b[0] = b1[0] + b1[3];
		    b[1] = b1[1] + b1[2];
		    b[2] = b1[1] - b1[2];
		    b[3] = b1[0] - b1[3];
		    b[4] = b1[4];
                    b[5] = ((b1[6] - b1[5]) * f0)>>16;
                    b[6] = ((b1[6] + b1[5]) * f0)>>16;
                    b[7] = b1[7];
                    d[i][0] = ((b[0] + b[1]) * f4)>>16;
                    d[i][4] = ((b[0] - b[1]) * f4)>>16;
                    d[i][2] = (b[2] * f6 + b[3] * f2)>>16;
                    d[i][6] = (b[3] * f6 - b[2] * f2)>>16;
                    b1[4] = b[4] + b[5];
                    b1[7] = b[7] + b[6];
                    b1[5] = b[4] - b[5];
                    b1[6] = b[7] - b[6];
                    d[i][1] = (b1[4] * f7 + b1[7] * f1)>>16;
                    d[i][5] = (b1[5] * f3 + b1[6] * f5)>>16;
                    d[i][7] = (b1[7] * f7 - b1[4] * f1)>>16;
                    d[i][3] = (b1[6] * f3 - b1[5] * f5)>>16;
                  }
                  /* Vertical transform */
                  for (i = 0; i < 8; i++) {
                    for (j = 0; j < 4; j++) {
                      j1 = 7 - j;
                      b1[j] = d[j][i] + d[j1][i];
                      b1[j1] = d[j][i] - d[j1][i];
                    }
                    b[0] = b1[0] + b1[3];
                    b[1] = b1[1] + b1[2];
                    b[2] = b1[1] - b1[2];
                    b[3] = b1[0] - b1[3];
                    b[4] = b1[4];
                    b[5] = ((b1[6] - b1[5]) * f0)>>16;
                    b[6] = ((b1[6] + b1[5]) * f0)>>16;
                    b[7] = b1[7];
                    d[0][i] = ((b[0] + b[1]) * f4)>>16;
                    d[4][i] = ((b[0] - b[1]) * f4)>>16;
                    d[2][i] = (b[2] * f6 + b[3] * f2)>>16;
                    d[6][i] = (b[3] * f6 - b[2] * f2)>>16;
                    b1[4] = b[4] + b[5];
                    b1[7] = b[7] + b[6];
                    b1[5] = b[4] - b[5];
                    b1[6] = b[7] - b[6];
                    d[1][i] = (b1[4] * f7 + b1[7] * f1)>>16;
                    d[5][i] = (b1[5] * f3 + b1[6] * f5)>>16;
                    d[7][i] = (b1[7] * f7 - b1[4] * f1)>>16;
                    d[3][i] = (b1[6] * f3 - b1[5] * f5)>>16;
                  }

                  for (i = 0; i < 8; i++)
                    for (j = 0; j < 8; j++)
                      outBlock[i*8+j] = d[i][j]>>4;
	}
	    int modifyMode(int mode, int dquant)
	    {
		if (mode == MODE_INTRA) {
			if(dquant!=0)
				return MODE_INTRA_Q;
			else
				return MODE_INTRA;
		} else {
			if(dquant!=0)
				return MODE_INTER_Q;
			else
				return mode;
		}
	    }
int  doDquant(int Mode)
{
  int dquant;

  /* Update of dquant, check and correct its limit */
  dquant = QP_new_271 - QP_prev_272;
  QP_xmitted_273 = QP_new_271;

  if (dquant > 2)  { dquant =  2; QP_xmitted_273 = QP_prev_272 + dquant;}
  if (dquant < -2) { dquant = -2; QP_xmitted_273 = QP_prev_272 + dquant;}

  QP_prev_272 = QP_xmitted_273;

  return dquant;
}
int isCBP(int* qcoeff,int intra)
{
  int i;
  for (i = intra; i < 64; i++) {
    if (qcoeff[i]) {
      return 1;
    }
  }

  return 0;
}
/* main function */
int transcoder(int argc, char *argv[]);

int transcoderRuntime(void *arg) {
	int argc = 0;
	char* argv[0];
	//printf("started transcoder runtime\n");
	transcoder(argc,argv);
}

int transcoder(int argc, char *argv[]) {
  int skipFrameFlag;
  int comp_189;
  int MBA_190, MBAmax_191;
  int bx_192, by_193;

  int COD=0,MCBPC, CBPY, DQUANT_194;
  int pmv0_195, pmv1_196, xpos_197, ypos_198, gob_199;
  int k_200;
  int gfid_201, gobheader_read_202;
  int offset_203,bsize_204,last_done_205=0;
  int DQ_tab_206[4] = {-1,-2,1,2};
  short *bp_207;
  int x_208, y_209;
  static int first=1;
  static int framenum=0;
  unsigned char clpGlobal_210[1024];
  int dx_index=0, dy_index=0;
  int dx_array_211[MAX_WIDTH/16], dy_array_212[MAX_HEIGHT/16];
		int iterType_225 = 0;
struct IntBlock YBlock_0[4];
struct IntBlock UBlock_1;
struct IntBlock VBlock_2;
int dx_3;
int dy_4;
int mode_5;
int CBP_6;
int QP_7;
int type_8;
int type_279_phase = 0;
int output_9[4];
int input_213;
int DeQP_214;
int mode_215;
struct IntBlock output_10;
struct IntBlock output_11;
int mode_216;
int enable_217;
struct IntBlock output_14[4];
int output_218;
struct IntBlock output_15;
struct IntBlock output_16;
struct IntBlock output_19;
struct IntBlock output_20;
struct IntBlock output_21;
struct IntBlock output_24;
int output_28[4];
int prevY_219_phase = 0;
int prevY_219;
int prevU_220_phase = 0;
int prevU_220;
int prevV_221_phase = 0;
int prevV_221;
int type_284_phase = 0;
struct Frame outputY_33[2];
int outputY_222_phase = 0;
int outputY_222;
struct HalfFrame outputU_34[2];
int outputU_223_phase = 0;
int outputU_223;
struct HalfFrame outputV_35[2];
int outputV_224_phase = 0;
int outputV_224;
int CBPY_42[4];
int CBPU_43;
int CBPV_44;
int output_45;
int output_46;
int image_226_phase = 0;
int image_226;
int prevImage_227_phase = 0;
int prevImage_227;
int prevIpolImage_286_phase = 0;
int type_287_phase = 0;
int dx_47[33];
int dx_228;
int dy_48[33];
int dy_229;
int mode_49;
int output_50[4];
int output_54[4];
int input_230;
struct DoubleFrame output_55;
int prevY_231_phase = 0;
int prevY_231;
int prevU_232_phase = 0;
int prevU_232;
int prevV_233_phase = 0;
int prevV_233;
int dx_234;
int dy_235;
int type_290_phase = 0;
struct Frame outputY_63[2];
int outputY_236_phase = 0;
int outputY_236;
struct HalfFrame outputU_64[2];
int outputU_237_phase = 0;
int outputU_237;
struct HalfFrame outputV_65[2];
int outputV_238_phase = 0;
int outputV_238;
struct IntBlock output_70;
struct IntBlock output_71;
struct IntBlock output_74;
struct IntBlock output_75;
struct IntBlock output_76;
struct IntBlock output_79;
int input_239;
int DeQP_240;
int mode_241;
struct IntBlock output_80;
struct IntBlock output_81;
int mode_242;
int enable_243;
struct IntBlock output_84[4];
int output_244;
int image_245_phase = 0;
int image_245;
int prevImage_246_phase = 0;
int prevImage_246;
int dx_247;
int dy_248;
struct IntBlock dBlock_85[4];
int image_249_phase = 0;
int image_249;
int prevImage_250_phase = 0;
int prevImage_250;
int dx_251;
int dy_252;
struct IntBlock dBlock_86;
int image_253_phase = 0;
int image_253;
int prevImage_254_phase = 0;
int prevImage_254;
int dx_255;
int dy_256;
struct IntBlock dBlock_87;
int dx_257;
int dy_258;
int type_291_phase = 0;
int QP_97[2];
int QP_259_phase = 0;
int QP_259;
int output_98[4];
int output_99[4];
struct IntBlock output_100;
int QP_267;
int mode_268;
struct IntBlock output_101[4];
int output_269;
int input_270;
struct IntBlock output_102;
struct IntBlock output_103;
struct IntBlock output_104;
struct IntBlock output_105;
struct IntBlock output_106;
struct IntBlock output_107;
struct IntBlock output_108;
int output_115;
int Q_288_phase = 0;
int dQuant_116;
int Qxmitted_117;
int input_274;
int output_120;
int input_275;
int mode_276;
int output_127[4];
int output_277;
int output_128;
int output_129;
int output_130[4];
int output_131;

	//printf("started transcoder\n");
mainInit:
dx_3 = 0;
dy_4 = 0;
mode_5 = 0;
CBP_6 = 0;
QP_7 = 0;
type_8 = 0;
	/*  options(&argc,&argv); */

	  /* pointer to name of output files */
	 /*   outputname = argv[argc-1]; */
         
	  ld_187 = &base_188; 

	  /* open MPEG input file(s) */
	  if ((base_188.infile=open(gVideoFileName,O_RDONLY|O_BINARY))<0) {
	    sprintf(errortext,"Input file %s not found\n",argv[1]);
	    error(errortext);
	  }

	  if (base_188.infile!=0)
	      lseek(base_188.infile,0l,0);
	  initbitsForDec();
	  temp_ref_180 = 0;
	  prev_temp_ref_181 -1; 
	
	  /* clip table */
  clp_170 = clpGlobal_210;

  clp_170 += 384;
  { int i;
  for (i=-384; i<640; i++)
    clp_170[i] = (i<0) ? 0 : ((i>255) ? 255 : i);
  }
{int i; for(i=0;i<4;i++) output_9[i] = 0;}
input_213 = 0;
DeQP_214 = 0;
mode_215 = 0;
mode_216 = 0;
enable_217 = 0;
output_218 = 0;
	init_idct();
	init_idct();
	init_idct();
{int i; for(i=0;i<4;i++) output_28[i] = 0;}
prevY_219 = 1;
prevU_220 = 1;
prevV_221 = 1;
outputY_222 = 0;
outputU_223 = 0;
outputV_224 = 0;
{int i; for(i=0;i<4;i++) CBPY_42[i] = 0;}
CBPU_43 = 0;
CBPV_44 = 0;
output_45 = 0;
output_46 = 0;
image_226 = 0;
prevImage_227 = 1;
{int i; for(i=0;i<33;i++) dx_47[i] = 0;}
dx_228 = 0;
{int i; for(i=0;i<33;i++) dy_48[i] = 0;}
dy_229 = 0;
mode_49 = 0;
{int i; for(i=0;i<4;i++) output_50[i] = 0;}
{int i; for(i=0;i<4;i++) output_54[i] = 0;}
input_230 = 1;
prevY_231 = 1;
prevU_232 = 1;
prevV_233 = 1;
dx_234 = 0;
dy_235 = 0;
outputY_236 = 0;
outputU_237 = 0;
outputV_238 = 0;
	init_idct();
	init_idct();
input_239 = 0;
DeQP_240 = 0;
mode_241 = 0;
mode_242 = 0;
enable_243 = 0;
output_244 = 0;
	init_idct();
image_245 = 0;
prevImage_246 = 1;
dx_247 = 0;
dy_248 = 0;
image_249 = 0;
prevImage_250 = 1;
dx_251 = 0;
dy_252 = 0;
image_253 = 0;
prevImage_254 = 1;
dx_255 = 0;
dy_256 = 0;
dx_257 = 0;
dy_258 = 0;
{int i; for(i=0;i<2;i++) QP_97[i] = 0;}
QP_259 = 0;
  ZeroBits(total_bits);

  initbits();
  QP_97[CGC_MOD(QP_259-(1)+2,2)] = 5;
  QP_97[QP_259] = 5;

  pic->source_format = DEF_CODING_FORMAT;

  ref_frame_rate = (float)DEF_REF_FRAME_RATE;
  chosen_frameskip = 0;/* DEF_FRAMESKIP + 1; */
  orig_frameskip = DEF_ORIG_SKIP + 1;
#ifdef OFFLINE_RATE_CONTROL
  start_rate_control = DEF_START_RATE_CONTROL;
#else
  pic->target_frame_rate = (float)DEF_TARGET_FRAME_RATE;
#endif
  start = DEF_START_FRAME;
  end = DEF_STOP_FRAME;
  frames = 0;
  pframes = 0;
  bframes = 0;
  total_frames_passed = 0;
  wcopies = icopies = 1;

#ifndef OFFLINE_RATE_CONTROL
  /* rate control variables */
  pic->bit_rate = targetrate = 0;
  pic->src_frame_rate = (int)(ref_frame_rate / orig_frameskip);
  DelayBetweenFramesInSeconds = (float) 1.0/(float)pic->src_frame_rate;
  InitializeRateControl();
#endif
	{
	int len, sId, newSId;
	struct sockaddr_in addr, far_addr;

	/* Open a TCP socket (an Internet stream socket) */
	if ((sId = socket(AF_INET, CONNECTION_METHOD, 0)) < 0) {
		printf("cannot open stream socket for %d.\n", gServerPort);
		exit(1);
	}

	/* Bind local address */
	memset((char*) &addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_addr.s_addr = htonl(INADDR_ANY);
	addr.sin_port = htons(gServerPort);

	if (bind(sId,(struct sockaddr*) &addr,sizeof(addr)) < 0) {
		printf("bind on port %d failed.\n",gServerPort);
		exit(1);
	}

	listen(sId, 5);
	/* wait for connection from a sender */
	len = sizeof(far_addr);
	connectionId_265 = accept(sId, (struct sockaddr*) &far_addr, &len);
	if (newSId < 0) {
		printf("accept error on port %d.\n", gServerPort);
		exit(1);
	}
	printf("accept connection on port %d.\n", gServerPort);
	}
{int i; for(i=0;i<4;i++) output_98[i] = 0;}
{int i; for(i=0;i<4;i++) output_99[i] = 0;}
QP_267 = 0;
mode_268 = 0;
output_269 = 0;
input_270 = 0;
output_115 = 0;
dQuant_116 = 0;
Qxmitted_117 = 0;
input_274 = 1;
output_120 = 0;
input_275 = 0;
mode_276 = 0;
{int i; for(i=0;i<4;i++) output_127[i] = 0;}
output_277 = 0;
output_128 = 0;
output_129 = 0;
{int i; for(i=0;i<4;i++) output_130[i] = 0;}
output_131 = 0;
{ int sdfLoopCounter_292;for (sdfLoopCounter_292 = 0; sdfLoopCounter_292 < gNumFrames; sdfLoopCounter_292 = (sdfLoopCounter_292+1)%gNumFrames) {
	if(sdfLoopCounter_292==0) {
		lseek(base_188.infile,0l,SEEK_SET);
		initbitsForDec();
	}

	skipFrameFlag = !ctr_doesEncode();
	{  /* star H263Trans.H263TransDecoderI0.ConstIntI25 (class CGCConstInt) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 0);
#endif
	output_45 = 0.0;
	}
	{  /* star H263Trans.H263TransEncI4.H263TypeI0 (class CGCH263Type) */ 
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 1);
#endif
	if(!skipFrameFlag) {
		if(iterType_225==0)
			output_46 = I_FRAME;
		else	output_46 = P_FRAME;

		iterType_225 = (iterType_225+1)%1000; 
	}
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2491 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.ImageUpsampleI21 (class CGCImageUpsample) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 2);
#endif
	if(!skipFrameFlag) {
		// Do interpolate.
		InterpolateImage(output_55.data, outputY_63[input_230].data,gFrameWidth,gFrameHeight);
	input_230 += 1;
	if (input_230 >= 2)
		input_230 -= 2;
	}
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.GainIntI68 (class CGCGainInt) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 3);
#endif

	if(!skipFrameFlag) {
	QP_97[input_274] = ctr_Q();
	output_120 = QP_97[input_274];
	input_274 += 1;
	if (input_274 >= 2)
		input_274 -= 2;
	}
	}

        { int sdfLoopCounter_278;for (sdfLoopCounter_278 = 0; sdfLoopCounter_278 < ((gFrameWidth*gFrameHeight)>>8); sdfLoopCounter_278++) {
	{  /* star H263Trans.H263TransDecoderI0.H263FRFrameDecodeI0 (class CGCH263FRFrameDecode) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 4);
#endif
  if(type_279_phase==0) {
    getheader();
    if (first) {
/*	initdecoder(); */
        first = 0; 
    }

  /* number of macroblocks per picture */
  MBAmax_191 = gFrameWidth*gFrameHeight/(16*16);

  MBA_190 = 0; /* macroblock address */
  newgob_172 = 0;

  fault_178 = 0;
  gobheader_read_202 = 0;
    } 

  /* loop start : produce blocks */

    if (0)
      printf("frame %d, MB %d\n",framenum,type_279_phase);
  resync_280:

    /* This version of the decoder does not resync on every possible
       error, and it does not do all possible error checks. It is not
       difficult to make it much more error robust, but I do not think
       it is necessary to include this in the freely available
       version. */

    if (fault_178) {
      printf("Warning: A Fault Condition Has Occurred - Resyncing \n");
	return;
      startcode();  /* sync on new startcode */
      fault_178 = 0;
    }

    /* reset motion vectors */
    dx_3 = 0;
    dy_4 = 0;

    if (!(showbits(22)>>6)) { /* startcode */

      startcode();  
      /* in case of byte aligned start code, ie. PSTUF, GSTUF or ESTUF
         is used */
      
      if (showbits(22) == (32|SE_CODE)) { /* end of sequence */
        if (!(type_279_phase < MBAmax_191)) {
          printf("end of sequence!\n");
          return;
        }
      }
      else if ((showbits(22) == PSC<<5) ) { /* new picture */
        if (!(type_279_phase < MBAmax_191)) {
//          return;
            break;

        }
      }
      else {
        if (!(type_279_phase%(gFrameWidth/16))) {

          gob_199 = getheader() - 1;
          if (gob_199 > gFrameHeight) {
            if (!quiet_169)
              printf("GN out of range\n");
            return;
          }
          
          /* GFID is not allowed to change unless PTYPE in picture header 
             changes */
          gfid_201 = getbits(2);
          /* NB: in error-prone environments the decoder can use this
             value to determine whether a picture header where the PTYPE
             has changed, has been lost */
          
          quant_182 = getbits(5);
          if (0)
            printf("GQUANT: %d\n", quant_182);
          xpos_197 = 0;
          ypos_198 = gob_199;
    //    MBA_190 = ypos_198 * gFrameWidth;
          
          newgob_172 = 1;
          gobheader_read_202 = 1;
        }
      }
    }

    if (!gobheader_read_202) {
      xpos_197 = type_279_phase%(gFrameWidth/16);
      ypos_198 = type_279_phase/(gFrameWidth/16);
      if (xpos_197 == 0 && ypos_198 > 0)
        newgob_172 = 0;
    }
    else 
      gobheader_read_202 = 0;

  read_cod_281:
    if (pict_type_171 == PCT_INTER) 
        COD = showbits(1);
    else
        COD = 0; /* Intra picture -> not skipped */
  
    if (!COD) {  /* COD == 0 --> not skipped */    

        if (pict_type_171 == PCT_INTER)
          flushbits(1); /* flush COD bit */
        if (pict_type_171 == PCT_INTRA) 
          MCBPC = getMCBPCintra();
        else
          MCBPC = getMCBPC();
 
      if (fault_178) goto resync_280;
      
      if (MCBPC == 255) { /* stuffing */
        goto read_cod_281;   /* read next COD without advancing MB count */
      }

      else {             /* normal MB data */

       mode_5 = MCBPC & 7;
 
       CBPY = getCBPY();
 
        /* Decode Mode and CBP */
        
          if (mode_5 == MODE_INTRA || mode_5 == MODE_INTRA_Q)
          {/* Intra */
             CBPY = CBPY^15;        /* needed in huffman coding only */
          }
           CBP_6 = (CBPY << 2) | (MCBPC >> 4);
      }

      if (mode_5 == MODE_INTER_Q || mode_5 == MODE_INTRA_Q) {
        /* Read DQUANT if necessary */

          DQUANT_194 = getbits(2);
          quant_182 += DQ_tab_206[DQUANT_194];
          if (0) {
            printf("DQUANT (");
            printbits(DQUANT_194,2,2);
            printf("): %d = %d\n",DQUANT_194,DQ_tab_206[DQUANT_194]);
          }
        if (quant_182 > 31 || quant_182 < 1) {
          if (!quiet_169)
            printf("Quantizer out of range: clipping\n");
          quant_182 = mmax(1,mmin(31,quant_182));
          /* could set fault-flag and resync here */
        }
      }

      /* motion vectors */
      if (mode_5 == MODE_INTER || mode_5 == MODE_INTER_Q) {

          dx_3 = getTMNMV();
          dy_4 = getTMNMV();
          k_200 = 0;

        /*  FindPMVForDec(dx_3,dy_4,dx_3,dy_4,dx_3,dy_4,xpos_197,ypos_198,&pmv0_195,&pmv1_196); */


          FindPMVForDec(dx_array_211[(dx_index-1+gFrameWidth/16)%(gFrameWidth/16)],dy_array_212[(dy_index-1+gFrameWidth/16)%(gFrameWidth/16)],dx_array_211[dx_index],dy_array_212[dy_index],dx_array_211[(dx_index+1+gFrameWidth/16)%(gFrameWidth/16)],dy_array_212[(dy_index+1+gFrameWidth/16)%(gFrameWidth/16)],xpos_197,ypos_198,&pmv0_195,&pmv1_196);

          dx_3 = motion_decode(dx_3, pmv0_195);
          dy_4 = motion_decode(dy_4, pmv1_196);

          dx_array_211[dx_index] = dx_3;
          dy_array_212[dy_index] = dy_4;

          if (0) {
            printf("mvx: %d\n", dx_3);
            printf("mvy: %d\n", dy_4);
          }
          /* Check mv's to prevent seg.faults when error rate is high */
       
            bsize_204 = k_200 ? 8 : 16;
            offset_203 = k_200 ? (((k_200-1)&1)<<3) : 0;
            /* checking only integer component */
            if ((xpos_197<<4) + (dx_3/2) + offset_203 < 0 || (xpos_197<<4) + (dx_3/2) + offset_203 > (gFrameWidth<<4) - bsize_204) {
              if (!quiet_169)
    		 printf("mvx out of range: searching for sync\n");
              fault_178 = 1;
            }
            offset_203 = k_200 ? (((k_200-1)&2)<<2) : 0;
            if ((ypos_198<<4) + (dy_4/2) + offset_203 < 0 ||(ypos_198<<4) + (dy_4/2) + offset_203 > (gFrameHeight<<4) - bsize_204) {
              if (!quiet_169)   printf("mvy out of range: searching for sync\n");
              fault_178 = 1;
            }
       }


      if (fault_178) goto resync_280;

    }
    else { /* COD == 1 --> skipped MB */
      if (1)
        if (pict_type_171 == PCT_INTER)
          flushbits(1);

      mode_5 = MODE_INTER;
      
      /* Reset CBP */
      CBP_6 = 0;

      /* reset motion vectors */
      dx_3 = 0;
      dy_4 = 0;
    }

  reconstruct_mb_282:

    /* pixel coordinates of top left corner of current macroblock */
    /* one delayed because of OBMC */
    if (xpos_197 > 0) {
      bx_192 = 16*(xpos_197-1);
      by_193 = 16*ypos_198;
    }
    else {
      bx_192 = gFrameWidth-16;
      by_193 = 16*(ypos_198-1);
    }

    if (type_279_phase > 0) {

      x_208 = bx_192/16+1;
      y_209 = by_193/16+1;

      /* motion compensation for P-frame */
      if (mode_5 == MODE_INTER || mode_5 == MODE_INTER_Q)
      {
        // reconstruct(bx_192,by_193,1,0,0);
	if (0)
         printf(" (bx, by_193) = (%d,%d), (dx,dy) = (%d,%d) \n",bx_192,by_193,dx_3,dy_4);
      }

     
    } /* end : macro block decoding */

    if (!COD) {


      /* decode blocks */
      for (comp_189=0; comp_189<6; comp_189++) {

        clearblock(comp_189);
        if (mode_5 == MODE_INTRA || mode_5 == MODE_INTRA_Q) { /* Intra */
          bp_207 = ld_187->block[comp_189];
          bp_207[0] = getbits(8);
          if (0) {
              printf("DC[%d]: (",comp_189);
              printbits((int)bp_207[0],8,8);
              printf("): %d\n",(int)bp_207[0]);
          }

          if (bp_207[0] == 128)
            if (!quiet_169)
              fprintf(stderr,"Illegal DC-coeff: 1000000\n");
          if (bp_207[0] == 255)  /* Spec. in H.26P, not in TMN4 */
            bp_207[0] = 128;
          if ( (CBP_6 & (1<<(6-1-comp_189))) ) {
		  getblock(comp_189,0);
          }
        }
        else { /* Inter */
          if ( (CBP_6 & (1<<(6-1-comp_189))) ) {
		getblock(comp_189,1);
          }

        }
        if (fault_178) goto resync_280;
      }
    }

    /* advance to next macroblock */
    fflush(stdout);

    if (type_279_phase >= MBAmax_191 && !last_done_205) {
      COD = 1;
      xpos_197 = 0;
      ypos_198++;
      last_done_205 = 1;
      goto reconstruct_mb_282;
    }

      /* copy or add block data into P-picture */
      /* inverse DCT */

      for(comp_189=0; comp_189<6; comp_189++) {
        int i;
        if (mode_5 == MODE_INTRA || mode_5 == MODE_INTRA_Q) {
          if (comp_189 <4) { 
            for (i=0;i<64;i++) { 
              YBlock_0[(3-(3-comp_189))].data[i] = (int)ld_187->block[comp_189][i];
	    }
          } else if (comp_189 == 4) {
            for (i=0;i<64;i++){
		UBlock_1.data[i] = (int)ld_187->block[comp_189][i];
	    }
          } else { 
            for (i=0;i<64;i++) {
		VBlock_2.data[i] = (int)ld_187->block[comp_189][i];
	    }
          }
        } else if ( (CBP_6 & (1<<(6-1-comp_189))) ) {
          // No need to to do this for blocks with no coeffs
          if (comp_189 <4) { 
            for (i=0;i<64;i++) {
              YBlock_0[(3-(3-comp_189))].data[i] = (int)ld_187->block[comp_189][i];
            }
          }
          else if (comp_189 == 4) {
            for (i=0;i<64;i++) {
              UBlock_1.data[i] = (int)ld_187->block[comp_189][i];
            }
          }
	  else { 
            for (i=0;i<64;i++) {
              VBlock_2.data[i] = (int)ld_187->block[comp_189][i];
            }
          }
/*        } else {
          // CBP == 0 : just skip

          if (comp_189 <4) {
            for (i=0;i<64;i++) {
              YBlock_0[(3-(3-comp_189))].data[i] = 0;
            }
          }
          else if (comp_189 == 4) {
            for (i=0;i<64;i++) {
              UBlock_1.data[i] = 0;
            }
          }
          else {
            for (i=0;i<64;i++) {
              VBlock_2.data[i] = 0;
            }
          }
*/
        }
      } //end  for 

   /* update dx,dy index */
   dx_array_211[dx_index] = dx_3;
   dy_array_212[dy_index] = dy_4;

   dx_index++; dy_index++;
   if(dx_index>=gFrameWidth/16)
     dx_index-=gFrameWidth/16;

   if(dy_index>=gFrameWidth/16)
     dy_index-=gFrameWidth/16;

   /* end of getMBs */

    QP_7 = quant_182; 	

    if(type_279_phase==0) {
      if (pict_type_171 == PCT_INTER) 
        type_8 = 1;
      else
        type_8 = 0;
     }

     if (0 && type_279_phase==gFrameWidth*gFrameHeight/(16*16)-1)
       framenum++;

type_279_phase = (type_279_phase+1)%(((gFrameWidth*gFrameHeight)>>8));

	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.H263UnpackCBPI82 (class CGCH263UnpackCBP) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 5);
#endif
		if(CBP_6&32) CBPY_42[(3-(3))] = 1;
		else CBPY_42[(3-(3))] = 0;
		if(CBP_6&16) CBPY_42[(3-(2))] = 1;
		else CBPY_42[(3-(2))] = 0;
		if(CBP_6&8) CBPY_42[(3-(1))] = 1;
		else CBPY_42[(3-(1))] = 0;
		if(CBP_6&4) CBPY_42[(3-(0))] = 1;
		else CBPY_42[(3-(0))] = 0;
		if(CBP_6&2) CBPU_43 = 1;
		else CBPU_43 = 0;
		if(CBP_6&1) CBPV_44 = 1;
		else CBPV_44 = 0;
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.ForkI77 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.ForkI31 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI19.ForkI18 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI25.ForkI18 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI25.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 6);
#endif
		doDeQuantizer(output_20.data,VBlock_2.data,QP_7,mode_5);
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI25.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 7);
#endif
		doInvZigzag(output_21.data,output_20.data);
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI25.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 8);
#endif
		if(CBPV_44)
                	doIDCT(output_24.data,output_21.data);
		else if(mode_5==MODE_INTRA || mode_5==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_24.data[i] = output_21.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_24.data[i] = 0;
		}
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI19.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 9);
#endif
		doDeQuantizer(output_15.data,UBlock_1.data,QP_7,mode_5);
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI19.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 10);
#endif
		doInvZigzag(output_16.data,output_15.data);
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI19.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 11);
#endif
		if(CBPU_43)
                	doIDCT(output_19.data,output_16.data);
		else if(mode_5==MODE_INTRA || mode_5==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_19.data[i] = output_16.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_19.data[i] = 0;
		}
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.RepeatI36 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 12);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_28[(3-(i))] = mode_5;
	}
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.RepeatI0 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 13);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_9[(3-(i))] = QP_7;
	}
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI13.ForkI18 (class CGCFork) */
	}
            { int sdfLoopCounter_283;for (sdfLoopCounter_283 = 0; sdfLoopCounter_283 < 4; sdfLoopCounter_283++) {
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI13.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 14);
#endif
		doDeQuantizer(output_10.data,YBlock_0[input_213].data,output_9[DeQP_214],output_28[mode_215]);
	input_213 += 1;
	if (input_213 >= 4)
		input_213 -= 4;
	DeQP_214 += 1;
	if (DeQP_214 >= 4)
		DeQP_214 -= 4;
	mode_215 += 1;
	if (mode_215 >= 4)
		mode_215 -= 4;
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI13.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 15);
#endif
		doInvZigzag(output_11.data,output_10.data);
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.BlkDecI13.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 16);
#endif
		if(CBPY_42[enable_217])
                	doIDCT(output_14[output_218].data,output_11.data);
		else if(output_28[mode_216]==MODE_INTRA || output_28[mode_216]==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_14[output_218].data[i] = output_11.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_14[output_218].data[i] = 0;
		}
	mode_216 += 1;
	if (mode_216 >= 4)
		mode_216 -= 4;
	enable_217 += 1;
	if (enable_217 >= 4)
		enable_217 -= 4;
	output_218 += 1;
	if (output_218 >= 4)
		output_218 -= 4;
	}
}} /* end repeat, depth 3*/
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.H263FRReconI55 (class CGCH263FRRecon) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 17);
#endif
		int x_curr = (outputY_222_phase*16)%gFrameWidth;
		int y_curr = 16*((outputY_222_phase*16)/gFrameWidth);
		int dx, dy;

		if(mode_5 == MODE_INTER || mode_5 == MODE_INTER_Q) {
			// reconstruct luminance  
      			reconBlockIntoImage(x_curr,y_curr,dx_3,dy_4,
				(unsigned char *)outputY_33[prevY_219].data,output_14[(3-(3))].data,
				outputY_33[outputY_222].data,gFrameWidth);
      			reconBlockIntoImage(x_curr+8,y_curr,dx_3,dy_4,
				(unsigned char *)outputY_33[prevY_219].data,output_14[(3-(2))].data,
				outputY_33[outputY_222].data,gFrameWidth);
      			reconBlockIntoImage(x_curr,y_curr+8,dx_3,dy_4,
				(unsigned char *)outputY_33[prevY_219].data,output_14[(3-(1))].data,
				outputY_33[outputY_222].data,gFrameWidth);
      			reconBlockIntoImage(x_curr+8,y_curr+8,dx_3,dy_4,
				(unsigned char *)outputY_33[prevY_219].data,output_14[(3-(0))].data,
				outputY_33[outputY_222].data,gFrameWidth);

			// reconstruct chrominance
			dx = dx_3;
			dy = dy_4;
			dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
			dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );
      			reconBlockIntoImage(x_curr/2,y_curr/2,dx,dy,
				(unsigned char *)outputU_34[prevU_220].data,output_19.data,
				outputU_34[outputU_223].data,gFrameWidth/2);
      			reconBlockIntoImage(x_curr/2,y_curr/2,dx,dy,
				(unsigned char *)outputV_35[prevV_221].data,output_24.data,
				outputV_35[outputV_224].data,gFrameWidth/2);
		} else {
			// copy
			copyBlockIntoImage(x_curr,y_curr,output_14[(3-(3))].data,
				(unsigned char *)outputY_33[outputY_222].data,gFrameWidth);
			copyBlockIntoImage(x_curr+8,y_curr,output_14[(3-(2))].data,
				(unsigned char *)outputY_33[outputY_222].data,gFrameWidth);
			copyBlockIntoImage(x_curr,y_curr+8,output_14[(3-(1))].data,
				(unsigned char *)outputY_33[outputY_222].data,gFrameWidth);
			copyBlockIntoImage(x_curr+8,y_curr+8,output_14[(3-(0))].data,
				(unsigned char *)outputY_33[outputY_222].data,gFrameWidth);
			copyBlockIntoImage(x_curr/2,y_curr/2,output_19.data,
				(unsigned char *)outputU_34[outputU_223].data,gFrameWidth/2);
			copyBlockIntoImage(x_curr/2,y_curr/2,output_24.data,
				(unsigned char *)outputV_35[outputV_224].data,gFrameWidth/2);
		}
prevY_219_phase = (prevY_219_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevU_220_phase = (prevU_220_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevV_221_phase = (prevV_221_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
type_284_phase = (type_284_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
outputY_222_phase = (outputY_222_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
outputU_223_phase = (outputU_223_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
outputV_224_phase = (outputV_224_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
	if (prevY_219_phase == 0)
		prevY_219 += 1;
	if (prevY_219 >= 2)
		prevY_219 -= 2;
	if (prevU_220_phase == 0)
		prevU_220 += 1;
	if (prevU_220 >= 2)
		prevU_220 -= 2;
	if (prevV_221_phase == 0)
		prevV_221 += 1;
	if (prevV_221 >= 2)
		prevV_221 -= 2;
	if (outputY_222_phase == 0)
		outputY_222 += 1;
	if (outputY_222 >= 2)
		outputY_222 -= 2;
	if (outputU_223_phase == 0)
		outputU_223 += 1;
	if (outputU_223 >= 2)
		outputU_223 -= 2;
	if (outputV_224_phase == 0)
		outputV_224 += 1;
	if (outputV_224 >= 2)
		outputV_224 -= 2;
	}
}} /* end repeat, depth 2*/

	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.ForkI43 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransDecoderI0.BlackHoleI23 (class CGCBlackHole) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 18);
#endif
/* This star generates no code */
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.ForkI71 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransDecoderI0.FRDecForDecI10.ForkI39 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.ForkI89 (class CGCFork) */
	}
	if(skipFrameFlag)
		continue;
        { int sdfLoopCounter_285;for (sdfLoopCounter_285 = 0; sdfLoopCounter_285 < (((gFrameWidth*gFrameHeight)>>8)); sdfLoopCounter_285++) {
	{  /* star H263Trans.H263TransEncI4.H263FRDynMEI2 (class CGCH263FRDynME) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 19);
#endif
		int x_curr = (image_226_phase*16)%gFrameWidth;
		int y_curr = 16*(image_226_phase*16/gFrameWidth);

		// Do reconstruction.
		if(output_46 == I_FRAME){
			// There is nothing special to do 
			dx_47[dx_228] = 0;
			dy_48[dy_229] = 0;
			mode_49 = MODE_INTRA;
		} else {	
			// P frame
			MotionVector mv;
		        MotionEstimationPicture(outputY_33[image_226].data,
				outputY_63[prevImage_227].data,
				output_55.data,16,&mv,0,
				y_curr/16,x_curr/16);
			dx_47[dx_228] = 2*mv.x+mv.x_half;
			dy_48[dy_229] = 2*mv.y+mv.y_half;
			mode_49 = mv.Mode;
		}
image_226_phase = (image_226_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevImage_227_phase = (prevImage_227_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevIpolImage_286_phase = (prevIpolImage_286_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
type_287_phase = (type_287_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
	if (image_226_phase == 0)
		image_226 += 1;
	if (image_226 >= 2)
		image_226 -= 2;
	if (prevImage_227_phase == 0)
		prevImage_227 += 1;
	if (prevImage_227 >= 2)
		prevImage_227 -= 2;
	dx_228 += 1;
	if (dx_228 >= 33)
		dx_228 -= 33;
	dy_229 += 1;
	if (dy_229 >= 33)
		dy_229 -= 33;
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2544 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2527 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2509 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.ForkI49 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.H263FRDQuantI57 (class CGCH263FRDQuant) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 20);
#endif
		int i,j,d,k=0;

		if(Q_288_phase==0) {
			if(output_120)
				QP_xmitted_273 = QP_prev_272 = QP_new_271 = output_120;
			else
				QP_xmitted_273 = QP_prev_272 = QP_new_271 = 10;
		}

		dQuant_116 = doDquant(mode_49);
		Qxmitted_117 = QP_xmitted_273;
Q_288_phase = (Q_288_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.ForkI62 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.H263ModeI53 (class CGCH263Mode) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 21);
#endif
		output_115 = modifyMode(mode_49,dQuant_116);
	}
	{  /* star H263Trans.H263TransEncI4.FRDiffImageI26.ForkI49 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDiffImageI26.ForkI44 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDiffImageI26.ForkI39 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.ForkI35 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDiffImageI26.H263FRDiffImageI2 (class CGCH263FRDiffImage) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 22);
#endif
		int x_curr = ((image_245_phase*16)%gFrameWidth);
		int y_curr = 16*((image_245_phase*16)/gFrameWidth);

		int ratio = 16/8;
		int dx, dy;
		dx = dx_47[dx_247];
		dy = dy_48[dy_248];
		if(ratio==1) {
			dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
			dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );
		}

		if(mode_49 == MODE_INTER || mode_49 == MODE_INTER_Q) {
			int i;
			for(i=0; i<ratio*ratio; i++) {
				diffBlockFromImage(x_curr+8*(i%2),
					y_curr+8*(i/2),
					dx,dy,
					outputY_33[image_245].data,outputY_63[prevImage_246].data,
					dBlock_85[(3-(ratio*ratio-1-i))].data,
					gFrameWidth);
				}
		} else {
			int i;
			for(i=0; i<ratio*ratio; i++) {
				copyBlockFromImage(x_curr+8*(i%2),
					y_curr+8*(i/2),
					outputY_33[image_245].data,
					dBlock_85[(3-(ratio*ratio-1-i))].data,
					gFrameWidth);
			}
		}
image_245_phase = (image_245_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevImage_246_phase = (prevImage_246_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
	if (image_245_phase == 0)
		image_245 += 1;
	if (image_245 >= 2)
		image_245 -= 2;
	if (prevImage_246_phase == 0)
		prevImage_246 += 1;
	if (prevImage_246 >= 2)
		prevImage_246 -= 2;
	dx_247 += 1;
	if (dx_247 >= 33)
		dx_247 -= 33;
	dy_248 += 1;
	if (dy_248 >= 33)
		dy_248 -= 33;
	}
	{  /* star H263Trans.H263TransEncI4.FRDiffImageI26.H263FRDiffImageI30 (class CGCH263FRDiffImage) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 23);
#endif
		int x_curr = ((image_253_phase*8)%88);
		int y_curr = 8*((image_253_phase*8)/88);

		int ratio = 8/8;
		int dx, dy;
		dx = dx_47[dx_255];
		dy = dy_48[dy_256];
		if(ratio==1) {
			dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
			dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );
		}

		if(mode_49 == MODE_INTER || mode_49 == MODE_INTER_Q) {
			int i;
			for(i=0; i<ratio*ratio; i++) {
				diffBlockFromImage(x_curr+8*(i%2),
					y_curr+8*(i/2),
					dx,dy,
					outputV_35[image_253].data,outputV_65[prevImage_254].data,
					dBlock_87.data,
					88);
				}
		} else {
			int i;
			for(i=0; i<ratio*ratio; i++) {
				copyBlockFromImage(x_curr+8*(i%2),
					y_curr+8*(i/2),
					outputV_35[image_253].data,
					dBlock_87.data,
					88);
			}
		}
image_253_phase = (image_253_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevImage_254_phase = (prevImage_254_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
	if (image_253_phase == 0)
		image_253 += 1;
	if (image_253 >= 2)
		image_253 -= 2;
	if (prevImage_254_phase == 0)
		prevImage_254 += 1;
	if (prevImage_254 >= 2)
		prevImage_254 -= 2;
	dx_255 += 1;
	if (dx_255 >= 33)
		dx_255 -= 33;
	dy_256 += 1;
	if (dy_256 >= 33)
		dy_256 -= 33;
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI22.FixDCTBlockI16 (class CGCFixDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 24);
#endif
		doDCT(output_108.data,dBlock_87.data);
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI22.ZigzagBlockI0 (class CGCZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 25);
#endif
		doZigzag(output_106.data,output_108.data);
	}
	{  /* star H263Trans.H263TransEncI4.FRDiffImageI26.H263FRDiffImageI23 (class CGCH263FRDiffImage) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 26);
#endif
		int x_curr = ((image_249_phase*8)%88);
		int y_curr = 8*((image_249_phase*8)/88);

		int ratio = 8/8;
		int dx, dy;
		dx = dx_47[dx_251];
		dy = dy_48[dy_252];
		if(ratio==1) {
			dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
			dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );
		}

		if(mode_49 == MODE_INTER || mode_49 == MODE_INTER_Q) {
			int i;
			for(i=0; i<ratio*ratio; i++) {
				diffBlockFromImage(x_curr+8*(i%2),
					y_curr+8*(i/2),
					dx,dy,
					outputU_34[image_249].data,outputU_64[prevImage_250].data,
					dBlock_86.data,
					88);
				}
		} else {
			int i;
			for(i=0; i<ratio*ratio; i++) {
				copyBlockFromImage(x_curr+8*(i%2),
					y_curr+8*(i/2),
					outputU_34[image_249].data,
					dBlock_86.data,
					88);
			}
		}
image_249_phase = (image_249_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevImage_250_phase = (prevImage_250_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
	if (image_249_phase == 0)
		image_249 += 1;
	if (image_249 >= 2)
		image_249 -= 2;
	if (prevImage_250_phase == 0)
		prevImage_250 += 1;
	if (prevImage_250 >= 2)
		prevImage_250 -= 2;
	dx_251 += 1;
	if (dx_251 >= 33)
		dx_251 -= 33;
	dy_252 += 1;
	if (dy_252 >= 33)
		dy_252 -= 33;
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI17.FixDCTBlockI16 (class CGCFixDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 27);
#endif
		doDCT(output_105.data,dBlock_86.data);
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI17.ZigzagBlockI0 (class CGCZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 28);
#endif
		doZigzag(output_103.data,output_105.data);
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.ForkI31 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.ForkI2464 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2585 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.ForkI2445 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2659 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.RepeatI75 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 29);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_130[(3-(i))] = output_115;
	}
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.RepeatI9 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 30);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_99[(3-(i))] = Qxmitted_117;
	}
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.ForkI13 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI22.H263QI3 (class CGCH263Q) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 31);
#endif
		doQuantizer(output_107.data,output_106.data,Qxmitted_117,output_115);
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2603 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.H263FindCBPI71 (class CGCH263FindCBP) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 32);
#endif
  int intra = (output_115 == MODE_INTRA || output_115 == MODE_INTRA_Q);
  output_129 = isCBP(output_107.data,intra);
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2711 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI17.H263QI3 (class CGCH263Q) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 33);
#endif
		doQuantizer(output_104.data,output_103.data,Qxmitted_117,output_115);
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2621 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.H263FindCBPI67 (class CGCH263FindCBP) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 34);
#endif
  int intra = (output_115 == MODE_INTRA || output_115 == MODE_INTRA_Q);
  output_128 = isCBP(output_104.data,intra);
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2694 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.RepeatI6 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 35);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_98[(3-(i))] = output_115;
	}
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.ForkI65 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI74.ForkI18 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI80.ForkI18 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.RepeatI0 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 36);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_50[(3-(i))] = Qxmitted_117;
	}
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI80.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 37);
#endif
		doDeQuantizer(output_75.data,output_104.data,Qxmitted_117,output_115);
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI80.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 38);
#endif
		doInvZigzag(output_76.data,output_75.data);
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI80.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 39);
#endif
		if(output_128)
                	doIDCT(output_79.data,output_76.data);
		else if(output_115==MODE_INTRA || output_115==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_79.data[i] = output_76.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_79.data[i] = 0;
		}
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI74.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 40);
#endif
		doDeQuantizer(output_70.data,output_107.data,Qxmitted_117,output_115);
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI74.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 41);
#endif
		doInvZigzag(output_71.data,output_70.data);
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI74.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 42);
#endif
		if(output_129)
                	doIDCT(output_74.data,output_71.data);
		else if(output_115==MODE_INTRA || output_115==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_74.data[i] = output_71.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_74.data[i] = 0;
		}
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.RepeatI18 (class CGCRepeat) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 43);
#endif
	int i;
	for (i = 0; i < 4; i++) {
		output_54[(3-(i))] = output_115;
	}
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI86.ForkI18 (class CGCFork) */
	}
            { int sdfLoopCounter_289;for (sdfLoopCounter_289 = 0; sdfLoopCounter_289 < 4; sdfLoopCounter_289++) {
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI12.FixDCTBlockI16 (class CGCFixDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 44);
#endif
		doDCT(output_102.data,dBlock_85[input_270].data);
	input_270 += 1;
	if (input_270 >= 4)
		input_270 -= 4;
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI12.ZigzagBlockI0 (class CGCZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 45);
#endif
		doZigzag(output_100.data,output_102.data);
	}
	{  /* star H263Trans.H263TransEncI4.FREncI51.BlkEncI12.H263QI3 (class CGCH263Q) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 46);
#endif
		doQuantizer(output_101[output_269].data,output_100.data,output_99[QP_267],output_98[mode_268]);
	QP_267 += 1;
	if (QP_267 >= 4)
		QP_267 -= 4;
	mode_268 += 1;
	if (mode_268 >= 4)
		mode_268 -= 4;
	output_269 += 1;
	if (output_269 >= 4)
		output_269 -= 4;
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2639 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.H263FindCBPI63 (class CGCH263FindCBP) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 47);
#endif
  int intra = (output_130[mode_276] == MODE_INTRA || output_130[mode_276] == MODE_INTRA_Q);
  output_127[output_277] = isCBP(output_101[input_275].data,intra);
	input_275 += 1;
	if (input_275 >= 4)
		input_275 -= 4;
	mode_276 += 1;
	if (mode_276 >= 4)
		mode_276 -= 4;
	output_277 += 1;
	if (output_277 >= 4)
		output_277 -= 4;
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2677 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI86.H263DeQI6 (class CGCH263DeQ) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 48);
#endif
		doDeQuantizer(output_80.data,output_101[input_239].data,output_50[DeQP_240],output_54[mode_241]);
	input_239 += 1;
	if (input_239 >= 4)
		input_239 -= 4;
	DeQP_240 += 1;
	if (DeQP_240 >= 4)
		DeQP_240 -= 4;
	mode_241 += 1;
	if (mode_241 >= 4)
		mode_241 -= 4;
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI86.InvZigzagBlockI11 (class CGCInvZigzagBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 49);
#endif
		doInvZigzag(output_81.data,output_80.data);
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.BlkDecI86.FixCBPIDCTBlockI22 (class CGCFixCBPIDCTBlock) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 50);
#endif
		if(output_127[enable_243])
                	doIDCT(output_84[output_244].data,output_81.data);
		else if(output_54[mode_242]==MODE_INTRA || output_54[mode_242]==MODE_INTRA_Q) {
			int i;
			for(i=0; i<64; i++)
				output_84[output_244].data[i] = output_81.data[0]>>3;
		} else {
			int i;
			for(i=0; i<64; i++)
				output_84[output_244].data[i] = 0;
		}
	mode_242 += 1;
	if (mode_242 >= 4)
		mode_242 -= 4;
	enable_243 += 1;
	if (enable_243 >= 4)
		enable_243 -= 4;
	output_244 += 1;
	if (output_244 >= 4)
		output_244 -= 4;
	}
}} /* end repeat, depth 3*/
	{  /* star H263Trans.H263TransEncI4.FRDecI10.H263FRReconI49 (class CGCH263FRRecon) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 51);
#endif
		int x_curr = (outputY_236_phase*16)%gFrameWidth;
		int y_curr = 16*((outputY_236_phase*16)/gFrameWidth);
		int dx, dy;

		if(output_115 == MODE_INTER || output_115 == MODE_INTER_Q) {
			// reconstruct luminance  
      			reconBlockIntoImage(x_curr,y_curr,dx_47[dx_234],dy_48[dy_235],
				(unsigned char *)outputY_63[prevY_231].data,output_84[(3-(3))].data,
				outputY_63[outputY_236].data,gFrameWidth);
      			reconBlockIntoImage(x_curr+8,y_curr,dx_47[dx_234],dy_48[dy_235],
				(unsigned char *)outputY_63[prevY_231].data,output_84[(3-(2))].data,
				outputY_63[outputY_236].data,gFrameWidth);
      			reconBlockIntoImage(x_curr,y_curr+8,dx_47[dx_234],dy_48[dy_235],
				(unsigned char *)outputY_63[prevY_231].data,output_84[(3-(1))].data,
				outputY_63[outputY_236].data,gFrameWidth);
      			reconBlockIntoImage(x_curr+8,y_curr+8,dx_47[dx_234],dy_48[dy_235],
				(unsigned char *)outputY_63[prevY_231].data,output_84[(3-(0))].data,
				outputY_63[outputY_236].data,gFrameWidth);

			// reconstruct chrominance
			dx = dx_47[dx_234];
			dy = dy_48[dy_235];
			dx = ( dx % 4 == 0 ? dx >> 1 : (dx>>1)|1 );
			dy = ( dy % 4 == 0 ? dy >> 1 : (dy>>1)|1 );
      			reconBlockIntoImage(x_curr/2,y_curr/2,dx,dy,
				(unsigned char *)outputU_64[prevU_232].data,output_79.data,
				outputU_64[outputU_237].data,gFrameWidth/2);
      			reconBlockIntoImage(x_curr/2,y_curr/2,dx,dy,
				(unsigned char *)outputV_65[prevV_233].data,output_74.data,
				outputV_65[outputV_238].data,gFrameWidth/2);
		} else {
			// copy
			copyBlockIntoImage(x_curr,y_curr,output_84[(3-(3))].data,
				(unsigned char *)outputY_63[outputY_236].data,gFrameWidth);
			copyBlockIntoImage(x_curr+8,y_curr,output_84[(3-(2))].data,
				(unsigned char *)outputY_63[outputY_236].data,gFrameWidth);
			copyBlockIntoImage(x_curr,y_curr+8,output_84[(3-(1))].data,
				(unsigned char *)outputY_63[outputY_236].data,gFrameWidth);
			copyBlockIntoImage(x_curr+8,y_curr+8,output_84[(3-(0))].data,
				(unsigned char *)outputY_63[outputY_236].data,gFrameWidth);
			copyBlockIntoImage(x_curr/2,y_curr/2,output_79.data,
				(unsigned char *)outputU_64[outputU_237].data,gFrameWidth/2);
			copyBlockIntoImage(x_curr/2,y_curr/2,output_74.data,
				(unsigned char *)outputV_65[outputV_238].data,gFrameWidth/2);
		}
prevY_231_phase = (prevY_231_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevU_232_phase = (prevU_232_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
prevV_233_phase = (prevV_233_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
type_290_phase = (type_290_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
outputY_236_phase = (outputY_236_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
outputU_237_phase = (outputU_237_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
outputV_238_phase = (outputV_238_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
	if (prevY_231_phase == 0)
		prevY_231 += 1;
	if (prevY_231 >= 2)
		prevY_231 -= 2;
	if (prevU_232_phase == 0)
		prevU_232 += 1;
	if (prevU_232 >= 2)
		prevU_232 -= 2;
	if (prevV_233_phase == 0)
		prevV_233 += 1;
	if (prevV_233 >= 2)
		prevV_233 -= 2;
	dx_234 += 1;
	if (dx_234 >= 33)
		dx_234 -= 33;
	dy_235 += 1;
	if (dy_235 >= 33)
		dy_235 -= 33;
	if (outputY_236_phase == 0)
		outputY_236 += 1;
	if (outputY_236 >= 2)
		outputY_236 -= 2;
	if (outputU_237_phase == 0)
		outputU_237 += 1;
	if (outputU_237 >= 2)
		outputU_237 -= 2;
	if (outputV_238_phase == 0)
		outputV_238 += 1;
	if (outputV_238 >= 2)
		outputV_238 -= 2;
	}
	{  /* star H263Trans.H263TransEncI4.H263PackCBPI78 (class CGCH263PackCBP) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 52);
#endif
		output_131 = 0;
		if(output_127[(3-(3))]) 
			output_131 |= 32;
		if(output_127[(3-(2))]) 
			output_131 |= 16;
		if(output_127[(3-(1))]) 
			output_131 |= 8;
		if(output_127[(3-(0))]) 
			output_131 |= 4;
		if(output_128) 
			output_131 |= 2;
		if(output_129) 
			output_131 |= 1;
	}
	{  /* star H263Trans.H263TransEncI4.H263FRVLCNetworkI39 (class CGCH263FRVLCNetwork) */
#ifdef PROFILE_BLOCK
checkBlockTime(_task_info.task_id, 53);
#endif
  // phase
  int i = type_291_phase%(gFrameWidth/16);
  int j = type_291_phase/(gFrameWidth/16);

  int newgob;

  // global
  Bits *bits = & globalBits_263;

  /* others */

  /* phase setup */
  if(type_291_phase == 0) {
    ZeroBits(bits);

    pic->bit_rate = 0;
  }


  if(i==0) {
#ifndef OFFLINE_RATE_CONTROL
    if (pic->bit_rate != 0) {
      /* QP updated at the beginning of each row */
      AddBitsPicture(bits);

      QP_97[QP_259] =  UpdateQuantizer(abs_mb_num, pic->QP_mean, PCT_INTER,
           (float)pic->bit_rate, gFrameWidth/16, gFrameHeight/16,
           bits->total);
    }
#endif

    newgob = 0;

    if (j == 0) {
      pic->QUANT = QP_97[CGC_MOD(QP_259-(1)+2,2)];	/* use previous QP since there is a delay */
      pic->picture_coding_type = output_46;
      pic->TR = tr;
      tr++;
      bits->header += CountBitsPicture(pic);
    }
    else if (0 
      && (output_46==I_FRAME && j != 0)
      && (output_46==P_FRAME && j%0 == 0)) {
      bits->header += CountBitsSlice(j,Qxmitted_117); /* insert gob sync */
      newgob = 1;
    }
  }

  QuantChangePostponed = 0;

  if ((output_131==0) && dx_47[dx_257]==0 && dy_48[dy_258]==0 &&
      (output_115 == MODE_INTER || output_115 == MODE_INTER_Q)) {
    /* Skipped MB : both CBP and CBPB are zero, 16x16 vector is zero,
      PB delta vector is zero and Mode = MODE_INTER */
    if (output_115 == MODE_INTER_Q) {
      /* DQUANT != 0 but not coded anyway */
      pic->DQUANT = 0;
      output_115 = MODE_INTER;
    }  
      CountBitsMB(output_115,1,output_131,dQuant_116,output_46,bits,type_291_phase);
  } else {
    /* Normal MB */
    CountBitsMB(output_115,0,output_131,dQuant_116,output_46,bits,type_291_phase);

    if (output_115 == MODE_INTER  || output_115 == MODE_INTER_Q) {
      bits->no_inter++;
      CountBitsVectors(dx_47[dx_257],dy_48[dy_258],
        dx_47[CGC_MOD(dx_257-(1)+33,33)],dy_48[CGC_MOD(dy_258-(1)+33,33)],
        dx_47[CGC_MOD(dx_257-(gFrameWidth/16)+33,33)],dy_48[CGC_MOD(dy_258-(gFrameWidth/16)+33,33)],
        dx_47[CGC_MOD(dx_257-(gFrameWidth/16-1)+33,33)],dy_48[CGC_MOD(dy_258-(gFrameWidth/16-1)+33,33)],
        bits,i,j);
    } else {
      /* MODE_INTRA or MODE_INTRA_Q */
      bits->no_intra++;
    }

    if (output_131 || output_115 == MODE_INTRA || output_115 == MODE_INTRA_Q) {
      CountBitsCoeff(output_101[(3-(3))].data, output_115, output_131, bits, 64,0);
      CountBitsCoeff(output_101[(3-(2))].data, output_115, output_131, bits, 64,1);
      CountBitsCoeff(output_101[(3-(1))].data, output_115, output_131, bits, 64,2);
      CountBitsCoeff(output_101[(3-(0))].data, output_115, output_131, bits, 64,3);
      CountBitsCoeff(output_104.data, output_115, output_131, bits, 64,4);
      CountBitsCoeff(output_107.data, output_115, output_131, bits, 64,5);
    }
    /* end VLC */
  }

  abs_mb_num++;
  QP_cumulative += Qxmitted_117;

  /* wrapup */
  if(type_291_phase==gFrameWidth*gFrameHeight/(16*16)-1) {
    bits->header += alignbits (); /* pictures shall be byte aligned */
    AddBitsPicture(bits);
    AddBits(total_bits, bits);

#ifndef OFFLINE_RATE_CONTROL
    if (pic->bit_rate != 0) {
      UpdateRateControl(bits->total);
#else
    /* Aim for the targetrate with a once per frame rate control scheme */
    if (targetrate != 0)
      if (frame_no - start > (end - start) * start_rate_control/100.0)
        /* when generating the MPEG-4 anchors, rate control was started
           after 70% of the sequence was finished.
           Set start_rate_control with option "-R <n>" */

        pic->QUANT = FrameUpdateQP(total_bits->total + intra_bits->total,
          bits->total / (pic->PB?2:1),
           (end-frame_no) / chosen_frameskip + PPFlag,
           QP, targetrate, seconds);
    frameskip = chosen_frameskip;
#endif

#ifndef OFFLINE_RATE_CONTROL
  if (targetrate != 0) {
    /* Initialization routine for Rate Control */
    QP_97[QP_259] = InitializeQuantizer(PCT_INTER, (float)pic->bit_rate,
               (pic->PB ? pic->target_frame_rate/2 : pic->target_frame_rate),
               pic->QP_mean);
  } else {
    QP_97[QP_259] = QP_97[CGC_MOD(QP_259-(1)+2,2)]; /* Copy the passed value of QP */
  }
#else
    QP_97[QP_259] = QP_97[CGC_MOD(QP_259-(1)+2,2)]; /* Copy the passed value of QP */
#endif

	monitor_bitrate(pic->bit_rate);
        //QP_97[QP_259] = ctr_Q();

  ZeroBits(total_bits);
/*  ZeroRes(total_res);
  ZeroRes(b_res); */

  /* number of seconds to encode */
  seconds = (end - start + chosen_frameskip) * orig_frameskip/ ref_frame_rate;
  }
}
type_291_phase = (type_291_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
QP_259_phase = (QP_259_phase+1)%(((gFrameWidth*gFrameHeight)>>8));
	dx_257 += 1;
	if (dx_257 >= 33)
		dx_257 -= 33;
	dy_258 += 1;
	if (dy_258 >= 33)
		dy_258 -= 33;
	if (QP_259_phase == 0)
		QP_259 += 1;
	if (QP_259 >= 2)
		QP_259 -= 2;
	}
}} /* end repeat, depth 2*/
	{  /* star H263Trans.H263TransEncI4.FRDecI10.ForkI29 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.ForkI33 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.FRDecI10.ForkI24 (class CGCFork) */
	}
	{  /* star H263Trans.H263TransEncI4.ForkI2561 (class CGCFork) */
	}
}} /* end repeat, depth 0*/
close(base_188.infile);
	close(connectionId_265);
	if(bufferCount>0) flushToClient();

return 1;
}
