#include <time.h>
#include "libDynamoMiddleware.h"

#define FULL_SEARCH 0
#define DIAMOND_SEARCH 1
#define THREE_STEP_SEARCH 2
#define TWO_DIM_LOG_SEARCH 3
#define ONE_TIME_SEARCH 4
#define MJPEG_SEARCH 5
#define NO_SEARCH 6

int targetBitrate = 5000; // this value is updated by netwrok condition
int currentBitrate = 0;
int currentQP=10;
int accTime = 0;
clock_t startClock,endClock;

// You can choose SOCK_STREAM or SOCK_DGRAM
#define CONNECTION_METHOD SOCK_STREAM

// Actually you can change the video file name by user input
char* gVideoFileName = "FOREMAN.263";
int gNumFrames = 299;
//char* gVideoFileName = "SAMPLE.263";
//int gNumFrames = 2493;
char* gServerIP = "128.195.11.163";
//char* gServerIP = "192.168.1.105";
int gServerPort = 2939;
// char* gClientIP = "forge.ics.uci.edu";
// int gClientPort = 6725;

// maybe the frame width and frame height are determined at the first step
// max size is 16CIF
#define MAX_WIDTH (176*4)
#define MAX_HEIGHT (144*4)

int gFrameWidth = 176;
int gFrameHeight = 144;
int shm_ptr = 0;
int sem_ptr;
// transcoder main function is transcoder()
// and player main function is player()

struct TransCodeInfo
{
	int Q;
	int numDroppedFrames;
	//int frameSize;
	int frame_width;
	int frame_height;
};

int getInfo(struct TransCodeInfo* theInfo)
{
	struct TransCodeInfo temp;
	//
	// Read shared memory

	//printf("getting shared memory\n");fflush(stdout);
	P(sem_ptr);
	readSharedMemory(shm_ptr, &temp, sizeof(temp));
	V(sem_ptr);
	//printf("got shared memory\n");fflush(stdout);
	if(!theInfo)
	{
		perror("getInfo: input parameter NULL");
		exit(1);
	}
	
	if(temp.Q == theInfo->Q && temp.numDroppedFrames == theInfo->numDroppedFrames && 
		temp.frame_width == theInfo->frame_width && temp.frame_height == theInfo->frame_height)
		return 0;
		
	theInfo->Q = temp.Q;
	theInfo->numDroppedFrames = temp.numDroppedFrames;
	//	theInfo->frameSize = 176*144;
	
	//printf("finished setting quality\n");
	return 1;
}

int ctr_Q()
{
	/*
	if(currentBitrate < targetBitrate) {
		currentQP++;
	} else if(currentBitrate > targetBitrate) {
		currentQP--;
	}
		
	return currentQP;
	*/

	// using middleware thread
	struct TransCodeInfo info;
	getInfo(&info);
	
	//info.Q = 10;
	return info.Q;
}

int ctr_doesEncode()
{
	static int numRemainedDroppedFrames = 0;

	if(numRemainedDroppedFrames>0) {
		numRemainedDroppedFrames--;
		return 0;
	} else {
		struct TransCodeInfo info;
		getInfo(&info);
		//info.numDroppedFrames = 0;
		numRemainedDroppedFrames = info.numDroppedFrames;
		return 1;
	}
}

void monitor_start(const char* theName)
{
	startClock = clock();	
}

void monitor_end(const char* theName)
{
	accTime += clock()-startClock; 
}

void monitor_bitrate(int theValue)
{
	currentBitrate = theValue;
}

int ctr_ME()
{
	static int me = 0;

	float ellapsedTime = accTime/CLOCKS_PER_SEC;

	// accTime = 0;

// printf("accTime = %d, ellapsedTime = %f\n",accTime, ellapsedTime);

	if(ellapsedTime>0.06)
		return NO_SEARCH;
	if(ellapsedTime>0.05)
		return MJPEG_SEARCH;
	if(ellapsedTime>0.04)
		return ONE_TIME_SEARCH;
	if(ellapsedTime>0.03)
		return THREE_STEP_SEARCH;
	if(ellapsedTime>0.025) 
		return TWO_DIM_LOG_SEARCH;

	if(ellapsedTime<0.01)
		return FULL_SEARCH;

	//return DIAMOND_SEARCH;
	return FULL_SEARCH;
}

//
// Mphilpot added
void setSharedPtrs(int shm, int sem)
{
	printf("api.h: setting shared memory pointers\n");
	shm_ptr = shm;
	sem_ptr = sem;
}

