/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Group
*
* version 0.5
*
* Authors: Michael Philpott, Shivajit Mohapatra 
*
* This library (soon to be) is to be used to retreive the iPaqs backlight, 
* battery, cpu, memory and network information.  It retrieves the network,
* memory and cpu utilization from the kernels /proc directory.  The backlight
* and battery information are obtained though the system devices using a
* system specific datastructure.
* 
************************************************************************/
#ifndef _DEVICE_H
#define _DEVICE_H

#include <unistd.h>
#include <stdio.h>
#include <string.h> 
#include <stdlib.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

#include "libDynamoMiddlewareARM.h"
#include "dyncommunication.h"
#include "h263player.h"

//#define KEY 57363

//
//Structures

struct Dyn_Player_Comm
{
	int worstQuality;			//Worst quality allowed by the player
	//int negotiatedQuality;		//Current quality nagotiated too
};

struct Dyn_Thread_Comm
{
	int sock_ptr;				//pointer to the socket
	int sem_ptr;				//pointer to the semaphore
	int shm_ptr;				//pointer to the shared memory
};

//
// Globals
int sem_ptr;
int shm_ptr;

//
// Set to your application Thread (Device Side) applicationThread = (void*) &threadName
void* applicatonThread = (void*) &playerRuntime;

//
//Helper function

void mwSendThreadFunction(void* val)
{
  int rc, size;
  struct Dyn_Device2Proxy_Comm shared_info;
  struct Dyn_Player_Comm player_info;
  struct Dyn_Thread_Comm thread_comm = *(struct Dyn_Thread_Comm*)val;
  
  while(1)
  {
    //
    // Gather system information
    get_backlight_info(&shared_info.system_status.backlight);
    get_battery_info(&shared_info.system_status.battery);
    get_cpu_info(&shared_info.system_status.cpu);
    get_memory_info(&shared_info.system_status.memory);
    get_network_info(&shared_info.system_status.network);
    
    //
    // Get player quality level
    P(sem_ptr);
    readSharedMemory(shm_ptr, &player_info, sizeof(player_info));
    V(sem_ptr);
    
    shared_info.quality = player_info.worstQuality;
    
    //
    // Send Dyn_Device2Proxy_Comm to the proxy
    if( (rc = UDP_Send(thread_comm.sock_ptr, PROXYIP, PROXYPORT, MOBILEPORT,
                    (void *) &shared_info, (size=sizeof(shared_info)))) != size)
    {
        perror("mware: sending datagram message");
            pthread_exit((void *)NULL);
    }
    
    //
    // Sleep till the next send time
    sleep(SEND_SLEEP_TIME);
  }
}

void mwReciveThreadFunction(void* val)
{
  int rc, size;
  struct Dyn_Proxy2Device_Comm recv_info;
  struct Dyn_Thread_Comm thread_comm = *(struct Dyn_Thread_Comm*)val;
  
  while(1)
  {
    //
    // recive the information from the proxy
    if( (rc = UDP_Recv(thread_comm.sock_ptr, &recv_info, (size=sizeof(recv_info)))) != size)
    {
        perror("recvfrom mwrecv");
        pthread_exit((void *)NULL);
    }
    
    //
    // Get recived information and perform action

  }
}
#endif
