/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Group
*
* version 0.5
*
* Authors: Michael Philpott, Shivajit Mohapatra 
*
* This library (soon to be) is to be used to retreive the iPaqs backlight, 
* battery, cpu, memory and network information.  It retrieves the network,
* memory and cpu utilization from the kernels /proc directory.  The backlight
* and battery information are obtained though the system devices using a
* system specific datastructure.
* 
************************************************************************/

#ifndef _DYNCOMMUNICATION_H_
#define _DYNCOMMUNICATION_H_

/**
* @def SEND_SLEEP_TIME
* @brief The pause between sending information
*/
#define SEND_SLEEP_TIME 6

/**
 * @def MOBILEIP
 * @brief IP Address of the mobile device
 */
//#define MOBILEIP "128.195.31.172"
#define MOBILEIP "128.195.31.115"
/**
 * @def MOBILEPORT
 * @brief the port on the mobile device to use
 */
#define MOBILEPORT 2939

/**
 * @def PROXYIP
 * @brief IP Address of the proxy
 */
#define PROXYIP "128.195.11.163"
/**
 * @def PROXYPORT
 * @brief the port on the proxy to use
 */
#define PROXYPORT 2939

/**
* @def KEY
* @brief the key to be used for the shared memory and semaphores
*
* This key is used to create the shared memory and semaphores to have
* the middleware and application communicate
*/
#define KEY 57363

#define QUALITY_LEVELS 5

//
//Structures


struct Dyn_Device2Proxy_Comm
{
	int quality;
	struct
	{
		struct dynamo_backlight 	backlight;
		struct dynamo_battery 		battery;
		struct dynamo_cpu 			cpu;
		struct dynamo_memory		memory;
		struct dynamo_network		network;
	} system_status; 
};

struct Dyn_Proxy2Device_Comm
{
	int quality;
	
};

struct Dyn_Video
{
	int vidQual;
};

#endif //_DYNCOMMUNICATION_H_
