/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <linux/ioctl.h>
#include <linux/h3600_ts.h>
#include "backlight.h"

#define DEV_NODE "/dev/touchscreen/0"

int set_backlight( int fd, struct h3600_ts_backlight *bl )
{
	if ( ioctl( fd, TS_SET_BACKLIGHT, bl ) < 0 )
		return 0;
	return 1;
}

int get_backlight_status()
{
	struct h3600_ts_backlight bl;
	int fd;

	fd = open(DEV_NODE,O_RDWR);
	if( fd < 0 ) {
		return -1;
	}

	if ( ioctl( fd, TS_GET_BACKLIGHT, &bl ) < 0 ) {
		return -1;
	}
	close(fd);
	
	return (bl.power == FLITE_PWR_OFF ? FLITE_PWR_OFF : FLITE_PWR_ON);
}

int set_backlight_status(int status)
{
	struct h3600_ts_backlight bl;
	int fd;

	fd = open(DEV_NODE,O_RDWR);
	if( fd < 0 ) {
		return -1;
	}

	if ( ioctl( fd, TS_GET_BACKLIGHT, &bl ) < 0 ) {
		return -1;
	}
	
	
	bl.power = (status)? FLITE_PWR_ON : FLITE_PWR_OFF;;
	
	set_backlight(fd, &bl);
	
	//close(bl);
	close(fd);
	
	return 1;
}

int get_backlight_level()
{
	struct h3600_ts_backlight bl;
	int fd;

	fd = open(DEV_NODE,O_RDWR);
	if( fd < 0 ) {
		return -1;
	}

	if ( ioctl( fd, TS_GET_BACKLIGHT, &bl ) < 0 ) {
		return -1;
	}
	close(fd);
	
	return bl.brightness;
}

int set_backlight_level(int lvl)
{
	struct h3600_ts_backlight bl;
	int fd;
	
	if(lvl > 255 || lvl < 0)
		return -1;
	
	fd = open(DEV_NODE,O_RDWR);
	
	if( fd < 0 ) {
		return -1;
	}

	if ( ioctl( fd, TS_GET_BACKLIGHT, &bl ) < 0 ) {
		return -1;
	}
	
	bl.power = FLITE_PWR_ON;
	bl.brightness = lvl;
	set_backlight(fd, &bl);
	
	//close(bl);
	close(fd);
	
	return 1;
}

int get_backlight_info(struct dynamo_backlight* backlight)
{
	backlight->level = get_backlight_level();
	backlight->status = get_backlight_status();
	
	//
	// need to implament a return of true or false for these
	return 1;
}

