/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#ifndef _BACKLIGHT_H_
#define _BACKLIGHT_H_

struct dynamo_backlight 
{
	int level;
	int status;
};

/***
* Returns the backlight level 0 - 255
* it returns -1 if there was an error reading the touchscreen
***/
extern int get_backlight_level();

/***
* Allows the caller to set the backlight intensity
***/
extern int set_backlight_level(int lvl);

/***
* Returns a number 0 or 1 representing if the backlight is on or off
* it returns -1 if there was an error reading the touchscreen
***/
extern int get_backlight_status();

/***
* Allows the caller to set the status of the backlight 1 for on 0 for off
***/
extern int set_backlight_status(int status);

extern int get_backlight_info(struct dynamo_backlight* backlight);

#endif
