/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "battery.h"
#include "procread.h"

#define PROC_APM "/proc/apm"
#define PROC_HAL_BATTERY "/proc/hal/battery"

int get_battery_ac_status()
{
	FILE* file_ptr = fopen(PROC_APM, "r");
	char* temp = read_table(file_ptr, 1, 4);
	fclose(file_ptr);
	
	if(temp)
	{
		int ac_val = !strcmp("0x01", temp);
		free(temp);
		return !strcmp("0x01", temp);
	}
	else
		return -1;
}

int get_battery_power_level()
{
	FILE* file_ptr = fopen(PROC_APM, "r");
	char* temp = read_table(file_ptr, 1, 7);
	fclose(file_ptr);
	
	if(temp)
	{
		int pow_lvl = atoi(temp);
		free(temp);
		return pow_lvl;
	}
	else
		return -1;
}

int get_battery_min_remaining()
{
	FILE* file_ptr = fopen(PROC_APM, "r");
	char* temp = read_table(file_ptr, 1, 8);
	fclose(file_ptr);
	
	if(temp)
	{
		int min = atoi(temp);
		free(temp);
		return min;
	}
	else
		return -1;
}

int get_battery_info(struct dynamo_battery* battery)
{
	battery->ac_status = get_battery_ac_status();
	battery->level = get_battery_power_level();
	battery->min_remaining = get_battery_min_remaining();
	
	//
	// need to implament a return of true or false for these
	return 1;
}

