/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#ifndef _CPU_H_
#define _CPU_H_

struct dynamo_cpu 
{
	char model[40];
	float load;
	int total_process;
	int active_process;
};

/***
* Returns a char* of the processors model information
* this will have to be freed by the caller
***/
extern char* get_cpu_model();

/***
* Returns the average load of the last minute of the cpu
***/
extern float get_cpu_load();

/***
* Returns the amount of processes that have been started (active or passive)
***/
extern int get_cpu_total_process();

/***
* Returns the amount of active tasks
***/
extern int get_cpu_running_process();

extern int get_cpu_info(struct dynamo_cpu* cpu);

#endif //CPU
