/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h> 
#include <stdlib.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

//
// Shared Memory Operations
int createSharedMemory(int key, int size)
{
	/*
     * Create the segment.
     */
    return shmget(key, size, IPC_CREAT | 0666);	
}

int readSharedMemory(int shmid, void* data, int size)
{
	void* share;
	/*
     * Now we attach the segment to our data space.
     */
    if ((share = shmat(shmid, NULL, 0)) == NULL) {
        return -1;
    }
	memcpy (data, share, size);
	
	shmdt(share);

	return data; 
}

int writeSharedMemory(int shmid, void* data, int size)
{
	void* share;
	/*
     * Now we attach the segment to our data space.
     */
    if ((share = shmat(shmid, NULL, 0)) == NULL) {
        return -1;
    }
	memcpy (share, data, size);
	shmdt(share);
	return 1;
}

int freeSharedMemory(int shmid)
{
	return shmctl (shmid, IPC_RMID, 0);
}
