/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "memory.h"
#include "procread.h"

#define PROC_MEM_INFO "/proc/meminfo"

int get_mem_total()
{
	FILE* file_ptr = fopen(PROC_MEM_INFO,"r");
	char* temp = read_row_named(file_ptr, "MemTotal");
	fclose(file_ptr);

	if(temp)
	{
		char* num = strtok(temp, " ");
		int mem_tot = atoi(num);
		free(temp);
		return mem_tot;
	}
	else
		return -1;
}

int get_mem_free()
{
	FILE* file_ptr = fopen(PROC_MEM_INFO,"r");
	char* temp = read_row_named(file_ptr, "MemFree");
	fclose(file_ptr);

	if(temp)
	{
		char* num = strtok(temp, " ");
		int mem_free = atoi(num);
		free(temp);
		return mem_free;
	}
	else
		return -1;
}

int get_mem_total_swap()
{
	FILE* file_ptr = fopen(PROC_MEM_INFO,"r");
	char* temp = read_row_named(file_ptr, "SwapTotal");
	fclose(file_ptr);

	if(temp)
	{
		char* num = strtok(temp, " ");
		int swap_tot = atoi(num);
		free(temp);
		return swap_tot;
	}
	else
		return -1;
}

int get_mem_free_swap()
{
	FILE* file_ptr = fopen(PROC_MEM_INFO,"r");
	char* temp = read_row_named(file_ptr, "SwapFree");
	fclose(file_ptr);

	if(temp)
	{
		char* num = strtok(temp, " ");
		int swap_free = atoi(num);
		free(temp);
		return swap_free;
	}
	else
		return -1;
}

int get_memory_info(struct dynamo_memory* memory)
{
	memory->total_mem = get_mem_total();
	memory->free_mem = get_mem_free();
	memory->total_swap = get_mem_total_swap();
	memory->free_swap = get_mem_free_swap();
	
	//
	// need to implament a return of true or false for these
	return 1;
}
