/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "network.h"
#include "procread.h"

#define PROC_NET_DEV "/proc/net/dev"
#define PROC_NET_WIRELESS "/proc/net/wireless"

//
// This function is currently bound to eth0 should change to seek what
// ever eth is actully connected
int get_net_is_connected()
{
	FILE* file_ptr = fopen(PROC_NET_DEV, "r");
	char* temp = read_row_named(file_ptr, "eth0");
	fclose(file_ptr);

	if(temp)
	{
		free(temp);
		return 1;
	}
	else
		return 0;
}

int get_net_is_wireless()
{
	FILE* file_ptr = fopen(PROC_NET_WIRELESS, "r");
	char* temp = read_row_named(file_ptr, "eth0");
	fclose(file_ptr);

	if(temp)
	{
		free(temp);
		return 1;
	}
	else
		return 0;
}

int get_net_link_quality()
{
	//
	// Need to double check the collum link is in pretty sure this is correct
	FILE* file_ptr = fopen(PROC_NET_WIRELESS, "r");
	char* temp = read_table_row_named(file_ptr, "eth0", 3);
	fclose(file_ptr);

	if(temp)
	{
		int link_qal = atoi(temp);
		free(temp);
		return link_qal;
	}
	else
		return -1;
}

int get_net_sig_strength()
{
	//
	// Need to double check the collum sig str is in pretty sure this is correct
	FILE* file_ptr = fopen(PROC_NET_WIRELESS, "r");
	char* temp = read_table_row_named(file_ptr, "eth0", 4);
	fclose(file_ptr);

	if(temp)
	{
		int sig_str = atoi(temp);
		free(temp);
		return sig_str;
	}
	else
		return -1;
}

int get_network_info(struct dynamo_network* network)
{
	
	network->connected = get_net_is_connected();
	network->wireless = get_net_is_wireless();
	network->link = get_net_link_quality();
	network->signal = get_net_sig_strength();
	//
	// need to implament a return of true or false for these
	return 1;
}

