/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "procread.h"

#define BUFFER_SIZE 300


/**
* read tables w/ rows labled
**/
char* read_row_named(FILE* file, char* row)
{
	if(file)
	{
		//
		// Create the buffer
		char* line_buffer = malloc(sizeof(char)*BUFFER_SIZE);
		char* temp_line;
		char* return_string;
		//
		// Pull information in but if it equals the row i'm looking for pop out
		while(fgets(line_buffer, BUFFER_SIZE, file) != NULL && !(temp_line = strstr(line_buffer,row)));
		
		//
		// If we found a match take it to the : and then clear the extra space
		if(temp_line != NULL)
		{
			
			temp_line = strrchr(line_buffer, ':');
			
			//
			//clear extra white space
			while(*temp_line == ' '||*temp_line == ':'||*temp_line == '\t')
				++temp_line;
			
			return_string = strdup(temp_line);
			
			//
			//clean-up
			temp_line = NULL;
			free(line_buffer);
			
			return return_string;
		}
	}
	else
	{
		perror("read_row_named: fopen");
		return NULL;
	}
}

/**
* read tables
**/
char* read_table(FILE* file, int row, int collumn)
{
	if(file)
	{
		//
		// Create the buffer
		char* line_buffer = malloc(sizeof(char)*BUFFER_SIZE);
		char* temp_string;
		char* return_string;
		
		int i;
		//
		// Pull information in but if it equals the row i'm looking for pop out
		for(i = 0; i < row && fgets(line_buffer, BUFFER_SIZE, file) != NULL; i++);
		
		temp_string = strtok(line_buffer, " \n");
		if(temp_string != NULL)
		{
			for(i = 1; i < collumn; ++i)
				temp_string = strtok(NULL, " \n");
		}
		
		return_string = strdup(temp_string);
		
		//
		//clear up memory
		temp_string = NULL;
		free(line_buffer);
		
		return return_string;
	}
	else
	{
		perror("read_table: fopen");
		return NULL;
	}
}

/**
* reade tables w/ both collums and rows labeled
**/
char* read_table_row_named(FILE* file, char* row, int collumn)
{
	if(file)
	{
		//
		// Create the buffer
		char* line_buffer = malloc(sizeof(char)*BUFFER_SIZE);
		char* temp_string;
		char* return_string;
		
		//
		// Pull information in but if it equals the row i'm looking for pop out
		while(fgets(line_buffer, BUFFER_SIZE, file) != NULL && !strstr(line_buffer,row));
		
		temp_string = strtok(line_buffer, " \n");
		if(temp_string != NULL)
		{
			int i;
			for(i = 1; i < collumn; ++i)
				temp_string = strtok(NULL, " \n");
		}
		
		return_string = strdup(temp_string);
		
		//
		// clean memory
		temp_string = NULL;
		free(line_buffer);
		
		return return_string;
	}
	else
	{
		perror("read_table_row_named: fopen");
		return NULL;
	}
}
