/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Group
*
* version 0.5
*
* Authors: Michael Philpott, Shivajit Mohapatra 
*
* This library (soon to be) is to be used to retreive the iPaqs backlight, 
* battery, cpu, memory and network information.  It retrieves the network,
* memory and cpu utilization from the kernels /proc directory.  The backlight
* and battery information are obtained though the system devices using a
* system specific datastructure.
* 
************************************************************************/
#ifndef _PROXY_H
#define _PROXY_H

#include <string.h> 
#include <stdlib.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <math.h>
#include <time.h>
#include <unistd.h>
#include <stdio.h>

#include "libDynamoMiddleware.h"
#include "dyncommunication.h"
#include "h263transcoder.h"

//#define KEY 57364
#define CLIP_LENGTH 5555

/*
//Structures
*/

struct Dyn_Thread_Comm
{
	int sock_ptr;
	int loop_count;
};

struct Dyn_Quality_Profile
{
	struct TransCodeInfo qlevel;
	float avgpower;
};

struct Dyn_Quality_Profile quality_level[QUALITY_LEVELS+1] = {{{10,3,320,240},6.07},
															  {{10,3,240,160},5.81},
															  {{10,3,240,160},5.63}};

//
// Globals
time_t total_time, start_time;
int sem_ptr;
int shm_ptr;
int stepCount;

//
// Update to application thread 
// ie void* applicationThread = (void*) &transcoderRuntime;
void* applicationThread = (void*) &transcoderRuntime;

//Recive Globals
struct TransCodeInfo transcode_info;
int curr_stream_qual = 0;

//
//Helper function

void mwSendThreadFunction(void* val)
{
	int rc, size;
	struct Dyn_Proxy2Device_Comm shared_info;
	struct TransCodeInfo transcode_info;
	struct Dyn_Thread_Comm thread_comm = *(struct Dyn_Thread_Comm*)val;
	
	//printf("mwsend: enteredi\n");
    while(1)
	{
      sleep(SEND_SLEEP_TIME);
      /*
        //printf("mwsend: looped\n");
        //
        // Read shared memory
        P(sem_ptr);
        readSharedMemory(shm_ptr, &transcode_info, sizeof(transcode_info));
        V(sem_ptr);
        
        //
        // Set the quality to be sent to the device to the value in the shared memory
        shared_info.quality = transcode_info.Q;
      */
      
      /*
      //
      // Send the information to the proxy
      if( (rc = UDP_Send(thread_comm.sock_ptr, MOBILEIP, MOBILEPORT, PROXYPORT,
                      (void *) &shared_info, (size=sizeof(shared_info)))) != size)
      {
          perror("mware: sending datagram message");
          pthread_exit((void *)NULL);
      }
      */
	}
}

void mwReciveThreadFunction(void* val)
{
  struct Dyn_Device2Proxy_Comm recv_info;
  struct Dyn_Thread_Comm thread_comm = *(struct Dyn_Thread_Comm*)val;
  time_t remaining_time;
  int eRes;
  int rc, size, i = 0;

  size = sizeof(recv_info);
  stepCount = 1;
  //printf("mwrecv: entered\n");

  while(1)
  {
    //
    // recive the information from the proxy
    if( (rc = UDP_Recv(thread_comm.sock_ptr, &recv_info, (size=sizeof(recv_info)))) != size)
    {
        printf("%d", thread_comm.sock_ptr);fflush(stdout);
        perror("recvfrom proxy:");
        pthread_exit((void *)NULL);
    }

    if(((stepCount++)%10) == 0)
    {
      P(sem_ptr);
      readSharedMemory(shm_ptr, &transcode_info, sizeof(transcode_info));                
      V(sem_ptr);
        transcode_info.Q += 9;
        transcode_info.numDroppedFrames =0;
        if(transcode_info.Q > 30)
            transcode_info.Q = 1;
        if(transcode_info.numDroppedFrames > 15)
            transcode_info.numDroppedFrames = 1;

        printf("proxy changing video quality to: %d %d\n", transcode_info.Q, transcode_info.numDroppedFrames); fflush(stdout);
        
        stepCount=1;
      P(sem_ptr);
      writeSharedMemory(shm_ptr, &transcode_info, sizeof(transcode_info));
      V(sem_ptr);
    }
    
      /*	
        //
        // Perform calculations
        remaining_time = CLIP_LENGTH - (start_time - time(NULL)); 
        eRes = recv_info.system_status.battery.min_remaining * ( (curr_stream_qual == 0)? 4.5 : quality_level[curr_stream_qual].avgpower );
        // end of calculations
        
        //
        // Find and select the appropreate power level
        for(i=1; i <= QUALITY_LEVELS; i++)
            if(eRes < (quality_level[i].avgpower * remaining_time)) break;
        
        transcode_info = quality_level[i].qlevel;
      */	
    printf("backlight_lvl = %d\n", 
        recv_info.system_status.backlight.level);
#if 0
    printf("recv:\nBacklight Info:\n backlight_lvl = %d\n", 
        recv_info.system_status.backlight.level);
    printf("Battery Info:\n min battery remaining = %d\n percentage remaining = %d\n", 
        recv_info.system_status.battery.min_remaining, 
        recv_info.system_status.battery.level);
    printf("CPU Info:\n load avg = %f\n process running = %d\n total processes = %d\n", 
        recv_info.system_status.cpu.load, 
        recv_info.system_status.cpu.active_process, 
        recv_info.system_status.cpu.total_process);
    printf("Mem Info:\n mem = %d / %d \n swap = %d / %d\n", 
        recv_info.system_status.memory.free_mem, 
        recv_info.system_status.memory.total_mem, 
        recv_info.system_status.memory.free_swap, 
        recv_info.system_status.memory.total_swap);
    printf("Net Info:\n connected = %d\n wireless = %d\n signal = %d\n link = %d\n", 
        recv_info.system_status.network.connected, 
        recv_info.system_status.network.wireless, 
        recv_info.system_status.network.signal, 
        recv_info.system_status.network.link);
#endif
  }    
}
#endif
