#ifndef __PAAPI_USERLEVEL_H
#define __PAAPI_USERLEVEL_H

/*--------------------------------------------------------------------*/
/* Contants */

#define MIN_PRIORITY  2
#define MAX_PRIORITY 99

#define PAAPI_DVS_APP_START 1
#define PAAPI_DVS_APP_DONE  2
#define PAAPI_DVS_APP_START_PERIOD  3

/* paapi_dvs_control_taskset()  */
#define PAAPI_CTRL_GET_NUM_INSTANCES 1
#define PAAPI_CTRL_GET_TASKSET_INFO  2
#define PAAPI_CTRL_SET_TASKSET_INFO  3
#define PAAPI_CTRL_GET_TASK_INFO     4
#define PAAPI_CTRL_SET_POLICY        5
#define PAAPI_CTRL_GET_POLICY        6
#define PAAPI_CTRL_START_TASKSET     7
#define PAAPI_CTRL_GET_SLOWDOWN_INFO 8
#define PAAPI_CTRL_CHANGE_TYPE       9
#define PAAPI_PRINT_LOG             10

/* DVS policies */
#define PAAPI_DVS_SHUTDOWN           0x1
#define PAAPI_DVS_STATIC_SLOWDOWN    0x2
#define PAAPI_DVS_DYNAMIC_PREDICTIVE 0x4
#define PAAPI_DVS_DYNAMIC_ADAPTIVE   0x8

/*--------------------------------------------------------------------*/
/* Types and data structures */

/* static information about a thread type */
struct thread_type_t {

  /* worst case execution time */
  unsigned wcet;      

  /* deadline */
  unsigned deadline;  

  /* period */
  unsigned period;

  /* denotes whether the task is hard or not */
  unsigned char hard;            
};

/* handle of a thread type */
struct thread_type_handle_t {

  /* index to the type info table */
  short type_info_index;
};

/* handle of a thread instance used to access run-time info about the task */
struct thread_instance_handle_t {

  /* index to the table of type info */
  unsigned short type_info_index;     

  /* index to the table of run time info */
  unsigned short instance_info_index; 
};

struct instance_t {
  struct thread_type_t type_info;
  unsigned instance_index;
  unsigned rt_priority;
  unsigned sfactor;
};

struct slowdown_info_t {
  unsigned dvs_policy;
  unsigned sfactor;
  unsigned dfactor;
  unsigned adaptive;
  unsigned max_speed;
};

#endif
