#ifndef __PAAPI_SYSCALL_H
#define __PAAPI_SYSCALL_H

#include <errno.h>
#ifdef PAAPI_IPAQ_LINUX
#include "asm/unistd.h"
#endif
#ifdef PAAPI_UML_LINUX
#include "asm/arch/unistd.h"
#endif

#include "linux/paapi-user.h"

static 
_syscall2(void, paapi_create_type, 
	  struct thread_type_t *, th_type_info,
	  struct thread_type_handle_t *, type_handle);

static 
_syscall3(void, paapi_create_instance,
	  struct thread_type_handle_t *, type_handle,
	  struct thread_instance_handle_t *, instance_handle,
	  int, instance_index);

static
_syscall1(void, paapi_app_status, int, status);

static  
_syscall1(void, paapi_associate, int, index);

static
_syscall2(int, paapi_control_taskset, int, cmd, void *, data);

static
_syscall0(void, paapi_sleep_until_next_period);

static 
_syscall0(void, paapi_destroy_task);

#endif
