/*
* Driver interface to the ASIC Complasion chip on the iPAQ H3800
*
* Copyright 2001 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Andrew Christian
*          <Andrew.Christian@compaq.com>
*          October 2001
*
* Restrutured June 2002, Sept 2002
*/

#ifndef H3600_ASIC_BATTERY_H
#define H3600_ASIC_BATTERY_H

struct pt_regs;
struct ctl_table;

extern struct ctl_table h3600_asic_battery_table[];

void h3600_asic_ac_in_isr(int irq, void *dev_id, struct pt_regs *regs);

extern unsigned char *owm_state_names[];

int h3600_asic_proc_battery(char *, char **, off_t, int, int *, void *);
int h3600_asic_proc_battery_ds2760(char *, char **, off_t, int, int *, void *);
int h3600_asic_proc_battery_raw(char *, char **, off_t, int, int *, void *);

enum charging_state {
	CHARGING_STATE_INIT = 0,
	CHARGING_STATE_NO_AC,      /* No AC */
	CHARGING_STATE_ACTIVE,     /* Actively charging the battery */
	CHARGING_STATE_FULL        /* The battery is fully charged */
};

int  h3600_asic_battery_get_state(void);
void h3600_asic_battery_set_led( enum charging_state state );
int  h3600_asic_battery_read( struct h3600_battery *query );
int  h3600_asic_thermal_sensor( unsigned short *result );

/* common initialization/cleanup functions */

int  h3600_asic_owm_init(void); 
void h3600_asic_owm_cleanup(void);
int  h3600_asic_owm_suspend(void); 
void h3600_asic_owm_resume (void);

int  h3600_asic_battery_init(void); 
void h3600_asic_battery_cleanup(void);
int  h3600_asic_battery_suspend(void); 
void h3600_asic_battery_resume (void);


#endif /* H3600_ASIC_BATTERY_H */
