/*
* Driver interface to the ASIC Complasion chip on the iPAQ H3800
*
* Copyright 2001 Compaq Computer Corporation.
*
* Use consistent with the GNU GPL is permitted,
* provided that this copyright notice is
* preserved in its entirety in all copies and derived works.
*
* COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
* AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
* FITNESS FOR ANY PARTICULAR PURPOSE.
*
* Author:  Andrew Christian
*          <Andrew.Christian@compaq.com>
*          October 2001
*
* Restrutured June 2002
*/

#ifndef H3600_ASIC_IO_H
#define H3600_ASIC_IO_H

#include <asm/arch/h3600_asic.h>
#include <linux/h3600_ts.h>

struct pt_regs;

void h3600_asic_power_isr(int irq, void *dev_id, struct pt_regs *regs);
void h3600_asic_sleeve_isr(int irq, void *dev_id, struct pt_regs *regs);

int h3600_asic_spi_read(unsigned short address, unsigned char *data, unsigned short len);
int h3600_asic_get_version( struct h3600_ts_version *version );
int h3600_asic_spi_read_pcmcia_battery( unsigned char *chem, unsigned char *percent, unsigned char *flag );
int h3600_asic_spi_set_ebat( void );

int h3600_asic_adc_read_channel( int mux );

int h3600_asic_audio_clock( long samplerate );
int h3600_asic_audio_power( long samplerate );
int h3600_asic_audio_mute( int mute );
int h3600_asic_backlight_control( enum flite_pwr power, unsigned char level );
int h3600_asic_asset_read( struct h3600_asset *asset );

/* LED control */

enum led_color {
	BLUE_LED    = 0,
	GREEN_LED   = 1,
	YELLOW_LED  = 2
};

void h3600_asic_set_led( enum led_color color, int tbs, int pts, int dts );
int h3600_asic_notify_led( unsigned char mode, unsigned char duration, 
			   unsigned char ontime, unsigned char offtime );

#define h3600_asic_led_on(color)  \
        h3600_asic_set_led(color, LEDTBS_BLINK | LEDTBS_AUTOSTOP | LEDTBS_ALWAYS, 4, 4 )

#define h3600_asic_led_off(color)  \
        h3600_asic_set_led(color, 0, 0, 0)

#define h3600_asic_led_blink(color,rate,pts,dts)  \
        h3600_asic_set_led(color, LEDTBS_BLINK | LEDTBS_AUTOSTOP | LEDTBS_ALWAYS | rate, pts, dts )


/* common initialization/cleanup functions */

int  h3600_asic_adc_init(void);
void h3600_asic_adc_cleanup(void);
int  h3600_asic_adc_suspend(void);
void h3600_asic_adc_resume(void);

int  h3600_asic_key_init(void);
void h3600_asic_key_cleanup(void);
int  h3600_asic_key_suspend(void);
void h3600_asic_key_resume(void);

int  h3600_asic_spi_init(void);
void h3600_asic_spi_cleanup(void);
int  h3600_asic_spi_suspend(void);
void h3600_asic_spi_resume (void);

int  h3600_asic_backlight_init(void);   
void h3600_asic_backlight_cleanup(void);

int  h3600_asic_touchscreen_init(void); 
void h3600_asic_touchscreen_cleanup(void);
int  h3600_asic_touchscreen_suspend(void); 
void h3600_asic_touchscreen_resume (void);

int  h3600_asic_audio_init(void); 
void h3600_asic_audio_cleanup(void);
int  h3600_asic_audio_suspend(void); 
void h3600_asic_audio_resume  (void);

int  h3600_asic_asset_init(void);   
void h3600_asic_asset_cleanup(void);

int  h3600_asic_bluetooth_init(void);
void h3600_asic_bluetooth_cleanup(void);
int  h3600_asic_bluetooth_suspend(void);
void h3600_asic_bluetooth_resume(void);



#endif /* H3600_ASIC_IO_H */
