/*
 * Header for MultiMediaCard (MMC)
 *
 * Copyright 2002 Hewlett-Packard Company
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * HEWLETT-PACKARD COMPANY MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Many thanks to Alessandro Rubini and Jonathan Corbet!
 *
 * Based strongly on code by:
 *
 * Author: Yong-iL Joh <tolkien@mizi.com>
 * Date  : $Date: 2002/06/18 12:38:40 $ 
 *
 * Author:  Andrew Christian
 *          15 May 2002
 */

#ifndef MMC_MMC_CORE_H
#define MMC_MMC_CORE_H

#include <linux/mmc/mmc_ll.h>
#include "mmc_media.h"

#define ID_TO_RCA(x) ((x)+1)

struct mmc_dev {
	struct mmc_slot_driver   *sdrive;
	struct mmc_slot           slot[MMC_MAX_SLOTS];
	struct mmc_request        request;               // Active request to the low-level driver
	struct mmc_io_request    *io_request;            // Active transfer request from the high-level media io
	struct tasklet_struct     task;
	int    num_slots;                 // Copied from the slot driver; used when slot driver shuts down

	/* State maintenance */
	int    state;  
	int    suspended;
	void (*protocol)(struct mmc_dev *, int);
};

char * mmc_result_to_string( int );
int    mmc_unpack_csd( struct mmc_request *request, struct mmc_csd *csd );
int    mmc_unpack_r1( struct mmc_request *request, struct mmc_response_r1 *r1, enum card_state state );
int    mmc_unpack_cid( struct mmc_request *request, struct mmc_cid *cid );
int    mmc_unpack_r3( struct mmc_request *request, struct mmc_response_r3 *r3 );

void   mmc_send_cmd( struct mmc_dev *dev, int cmd, u32 arg, 
		     u16 nob, u16 block_len, enum mmc_rsp_t rtype );
void   mmc_finish_io_request( struct mmc_dev *dev, int result );
int    mmc_check_eject( struct mmc_dev *dev );
int    mmc_check_insert( struct mmc_dev *dev );
u32    mmc_tran_speed( u8 ts );
int    mmc_match_media_driver( struct mmc_slot *slot );
void   run_sbin_mmc_hotplug(struct mmc_dev *dev, int id, int insert);

static inline void mmc_simple_cmd( struct mmc_dev *dev, int cmd, u32 arg, enum mmc_rsp_t rtype )
{
	mmc_send_cmd( dev, cmd, arg, 0, 0, rtype );
}

#endif  /* MMC_MMC_CORE_H */

