/*
 *	Header file for memory management module
 *
 *	Authors:
 *	Sami Kivisaari		<skivisaa@cc.hut.fi>	
 *
 *	$Id: mempool.h,v 1.3 2002/01/15 15:19:45 antti Exp $
 *
 *	This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _MEMPOOL_H
#define _MEMPOOL_H

struct mipv6_allocation_pool;

/**
 * mipv6_create_allocation_pool - create memory allocation pool
 * @max_elements: number of elements
 * @element_size: size of element
 * @allocation: priority
 *
 * Creates a memory allocation pool with @max_elements number of
 * @element_size elements available.  @allocation can be any priority
 * accepted by kmalloc().  Returns allocation pool.
 **/
struct mipv6_allocation_pool *
mipv6_create_allocation_pool(
	int max_elements, int element_size, int allocation);

/**
 * mipv6_free_allocation_pool - free allocation pool
 * @pool: pool to free
 *
 * Frees element allocation pool.
 **/
void
mipv6_free_allocation_pool(struct mipv6_allocation_pool *pool);

/**
 * mipv6_allocate_element - get free element
 * @pool: allocation pool
 *
 * Returns an element from allocation pool ready to use.
 **/
void *
mipv6_allocate_element(struct mipv6_allocation_pool *pool);

/**
 * mipv6_free_element - return element to pool
 * @pool: allocation pool
 * @el: element
 *
 * Returns @el back to @pool to be reused.
 **/
void
mipv6_free_element(struct mipv6_allocation_pool *pool, void *el);


#endif

