/**
 * Generic icmp routines
 *
 * Authors:
 * Jaakko Laine <medved@iki.fi>
 *
 * $Id: mipv6_icmp.h,v 1.5 2002/08/16 08:25:09 jola Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#ifndef _MIPV6_ICMP
#define _MIPV6_ICMP

#include <linux/in6.h>

/**
 * mipv6_icmpv6_send - generic icmpv6 message send
 * @daddr: destination address
 * @saddr: source address
 * @type: icmp type
 * @code: icmp code
 * @id: packet identifier. If null, uses internal counter to get new id
 * @data: packet data
 * @datalen: length of data in bytes
 */
void mipv6_icmpv6_send(struct in6_addr *daddr, struct in6_addr *saddr, int type,
		       int code,  __u16 *id, void *data, int datalen);

int mipv6_initialize_icmpv6(void);
void mipv6_shutdown_icmpv6(void);

#endif
