#define _MULTI_THREADED

#include <pthread.h>
#include "paapi_dvs.h"
#include "device.h"

#define PAAPI_KEY (KEY+1)
#define DEBUG 0

int paapi_shm_ptr;
int paapi_sem_ptr;

void MWARE_Runtime(void *val)
{
  pthread_t sendThread;
  pthread_t reciveThread;
  int  retr, rets;
  struct Dyn_Thread_Comm *thread_comm = (struct Dyn_Thread_Comm*)val;
  
  if(DEBUG) printf("mware runtime: started"); fflush(stdout);

  if((thread_comm->sock_ptr = CreateUDPSocket(MOBILEIP, MOBILEPORT)) < 0)
  {
      perror("MWRuntime: opening datagram socket");
      exit(1);
  }
  
  retr = pthread_create( &sendThread, NULL, (void*)&mwSendThreadFunction, (void*) thread_comm);
  rets = pthread_create( &reciveThread, NULL, (void*)&mwReciveThreadFunction, (void*) thread_comm);
  
  /* Wait till threads are complete before main continues. Unless we  */
  /* wait we run the risk of executing an exit which will terminate   */
  /* the process and all threads before the threads have completed.   */
  
  pthread_join( sendThread, NULL);
  pthread_join( reciveThread, NULL);
  
  exit(0);
}

//
// main
#define NUM_TASKS 1
int main(int argc, char *argv[])
{
	pthread_t appThread;
	pthread_t mwareThread;
	int  retr, rets;
	struct Dyn_Thread_Comm thread_comm;
	
	struct thread_type_t th_type_info;
	struct thread_type_handle_t type_handle[NUM_TASKS];
	struct thread_instance_handle_t instance_handle[NUM_TASKS];
	
	paapi_dvs_init();
	paapi_dvs_select_policy(PAAPI_DVS_STATIC_SLOWDOWN |
				PAAPI_DVS_DYNAMIC_PREDICTIVE);

	/* thead type info */
	th_type_info.wcet = 55; 
	th_type_info.deadline = 120;
	th_type_info.period = 120;
	paapi_dvs_create_thread_type(&th_type_info, &type_handle[0]);
	
	//
	// Create shared memory & semaphore 
	/*
	if ((sem_ptr = createSemaphore(KEY)) < 0) 
		{
		perror("shmget");
		exit(1);
		}
	
	if ((shm_ptr = createSharedMemory(KEY, sizeof(struct Dyn_Player_Comm))) < 0) 
		{
		perror("shmget");
		exit(1);
        }  
	*/
	if ((paapi_sem_ptr = createSemaphore(PAAPI_KEY)) < 0)
		{
		perror("paapi create semaphore");
		exit(1);
        }  
	
	if ((paapi_shm_ptr = createSharedMemory(PAAPI_KEY, sizeof(struct thread_type_t)*NUM_TASKS))
	    < 0 ) {
		perror("paapi shmget");
		exit(1);
	}
	
	//
	// Increment semaphore
	V(sem_ptr);
	V(paapi_sem_ptr);
	
  	paapi_dvs_create_thread_type(&th_type_info, &type_handle[0]);
	
	paapi_dvs_create_instance(&type_handle[0], &instance_handle[0], 
							  (void*)applicatonThread, (void *)NULL);
	
	rets = pthread_create( &mwareThread, NULL, (void*)&MWARE_Runtime, &thread_comm);
	
	paapi_dvs_start_taskset();
	
	/* Wait till threads are complete before main continues. Unless we  */
	/* wait we run the risk of executing an exit which will terminate   */
	/* the process and all threads before the threads have completed.   */
	
	pthread_join( mwareThread, NULL);
	freeSharedMemory(shm_ptr);
	freeSemaphore(sem_ptr);
	
	freeSharedMemory(paapi_shm_ptr);
	freeSemaphore(paapi_sem_ptr);
	exit(0);
}

