/**
 * @file device.h
 * @brief Device Side Middleware Framework.  
 *
 * This is the configuration file for the device side of the 
 * middleware framework.
 *
 * Copyright (C) 2004
 * Dynamo Middleware Group
 *
 * version 0.5
 *
 * Authors: Michael Philpott, Shivajit Mohapatra 
 */

#ifndef _DEVICE_H
#define _DEVICE_H

#include <unistd.h>
#include <stdio.h>
#include <string.h> 
#include <stdlib.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

#include "libDynamoMiddlewareARM.h"
#include "dyncommunication.h"

//#define KEY 563736

//
//Structures
struct Dyn_Thread_Comm
{
	int sock_ptr;				//pointer to the socket
	int sem_ptr;				//pointer to the semaphore
	int shm_ptr;				//pointer to the shared memory
};

//
// Globals
int sem_ptr;
int shm_ptr;

//
// Set to your application Thread (Device Side) 
// ie. applicationThread = (void*) &threadName
void* applicatonThread;

void mwSendThreadFunction(void* val)
{
  int rc, size;
  struct Dyn_Device2Proxy_Comm shared_info;
  struct Dyn_Thread_Comm thread_comm = *(struct Dyn_Thread_Comm*)val;
  
  while(1)
  {
    //
    // perform operations gather and send data
    
	
    
    //
    // Send Dyn_Device2Proxy_Comm to the proxy
    if( (rc = UDP_Send(thread_comm.sock_ptr, PROXYIP, PROXYPORT, MOBILEPORT,
                    (void *) &shared_info, (size=sizeof(shared_info)))) != size)
    {
        perror("mware: sending datagram message");
            pthread_exit((void *)NULL);
    }
    
    //
    // Sleep till the next send time
    sleep(SEND_SLEEP_TIME);
  }
}

void mwReciveThreadFunction(void* val)
{
  int rc, size;
  struct Dyn_Proxy2Device_Comm recv_info;
  struct Dyn_Thread_Comm thread_comm = *(struct Dyn_Thread_Comm*)val;
  
  while(1)
  {
    //
    // recive the information from the proxy
    if( (rc = UDP_Recv(thread_comm.sock_ptr, &recv_info, (size=sizeof(recv_info)))) != size)
    {
        perror("recvfrom mwrecv");
        pthread_exit((void *)NULL);
    }
    
    //
    // Get recived information and perform action

  }
}
#endif
