/**
* @file dyncommunication.h
* @brief Shared Header between proxy and device.  
*
* This is the configuration 
* file used for shared information between the proxy and client device
* in the dynamo middleware framework.
*
* Copyright (C) 2004
* Dynamo Middleware Group
*
* version 0.5
*
* Authors: Michael Philpott, Shivajit Mohapatra 
 */


#ifndef _DYNCOMMUNICATION_H_
#define _DYNCOMMUNICATION_H_

/**
* @def SEND_SLEEP_TIME
* @brief The pause between sending information
*/
#define SEND_SLEEP_TIME 6

/**
 * @def MOBILEIP
 * @brief IP Address of the mobile device
 */
#define MOBILEIP "128.195.31.51"
/**
 * @def MOBILEPORT
 * @brief the port on the mobile device to use
 */
#define MOBILEPORT 2939

/**
 * @def PROXYIP
 * @brief IP Address of the proxy
 */
#define PROXYIP "128.195.11.163"
/**
 * @def PROXYPORT
 * @brief the port on the proxy to use
 */
#define PROXYPORT 2939

/**
* @def KEY
* @brief the key to be used for the shared memory and semaphores
*
* This key is used to create the shared memory and semaphores to have
* the middleware and application communicate
*/
#define KEY 57363

//
//Structures

/**
 * @struct Dyn_Device2Proxy_Comm
 * @brief communications structure for device to proxy
 * 
 * This structure can be changed or substituted 
 */
struct Dyn_Device2Proxy_Comm
{
};

/**
 * @struct Dyn_Proxy2Device_Comm
 * @brief communications structure for proxy to device
 * 
 * This structure can be changed or substituted 
 */
struct Dyn_Proxy2Device_Comm
{
};

#endif //_DYNCOMMUNICATION_H_
