/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#include <pthread.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h> 
#include <stdlib.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>

//
// Semaphore Operations
int createSemaphore(int key)  /* translate semaphore key to an ID */
{
  int sid;

  if ((sid=semget ((key_t)key, 1, 0666 | IPC_CREAT)) == -1) {
	   printf ("couldn't get semaphore\n");
	   exit (-1);
  }
  return (sid);
}

int freeSemaphore(int sem_id)
{
	 return semctl(sem_id, 1, IPC_RMID);
}

static void semcall (int sid, int op)    /* call semop */
{
  struct sembuf sb;
  sb.sem_num = 0;
  sb.sem_op = op;
  sb.sem_flg = 0;
  if (semop(sid, &sb, 1) == -1) {
	   printf ("Error in semop\n");
	   exit (-1);
  }
}

void P(int sid)  /* acquire semaphore */
{
  semcall (sid, -1);
}

void V(int sid) /* release semaphore */
{
  semcall (sid, 1);
}
