#define _MULTI_THREADED

#include <pthread.h>
#include "proxy.h"


//
// Middleware Code
void MWARE_Runtime(void *val)
{
	pthread_t sendThread;
	pthread_t reciveThread;
	int  retr, rets;
	struct Dyn_Thread_Comm *thread_comm = (struct Dyn_Thread_Comm*)val;
	
	
	if((thread_comm->sock_ptr = CreateUDPSocket(PROXYIP, PROXYPORT)) < 0)
	{
		perror("main: opening datagram socket");
		exit(1);
	}
	
	retr = pthread_create( &sendThread, NULL, (void*)&mwSendThreadFunction, (void*) thread_comm);
	rets = pthread_create( &reciveThread, NULL, (void*)&mwReciveThreadFunction, (void*) thread_comm);
	
	/* Wait till threads are complete before main continues. Unless we  */
	/* wait we run the risk of executing an exit which will terminate   */
	/* the process and all threads before the threads have completed.   */
	
	pthread_join( sendThread, NULL);
	pthread_join( reciveThread, NULL);
	
	
	exit(0);
}


//
// main
int main(int argc, char *argv[])
{
	pthread_t appThread;
	pthread_t mwareThread;
	int  retr, rets;
	struct Dyn_Thread_Comm thread_comm;
	
	//printf("started proxy \n");
	//
	// init total time to 0
	
    	//
	// Create shared memory & semaphore
	
/*
	if ((sem_ptr = createSemaphore(KEY)) < 0) 
	{
        perror("shmget");
        exit(1);
    }
	
	if ((shm_ptr = createSharedMemory(KEY, sizeof(transcode_info))) < 0) 
	{
        perror("shmget proxy");
        exit(1);
    } 
*/	
	thread_comm.loop_count = 5;

/*	
	//
	//Init semaphore
	V(sem_ptr);
	
	setSharedPtrs(shm_ptr, sem_ptr);
  */  
	retr = pthread_create( &appThread, NULL, applicationThread, &thread_comm);
	rets = pthread_create( &mwareThread, NULL, (void*)&MWARE_Runtime, &thread_comm);
	
	/* Wait till threads are complete before main continues. Unless we  */
	/* wait we run the risk of executing an exit which will terminate   */
	/* the process and all threads before the threads have completed.   */
	
	pthread_join( appThread, NULL);
	pthread_join( mwareThread, NULL);
	
	freeSharedMemory(shm_ptr);
	freeSemaphore(sem_ptr);
	exit(0);
}
