/**
 * @file proxy.h
 * @brief Proxy Side Middleware Framework.  
 *
 * This is the configuration file for the proxy side of the 
 * middleware framework.
 *
 * Copyright (C) 2004
 * Dynamo Middleware Group
 *
 * version 0.5
 *
 * Authors: Michael Philpott, Shivajit Mohapatra 
 */
#ifndef _PROXY_H
#define _PROXY_H

#include <string.h> 
#include <stdlib.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <math.h>
#include <time.h>
#include <unistd.h>
#include <stdio.h>

#include "libDynamoMiddleware.h"
#include "dyncommunication.h"

//#define KEY 563736

//
//Structures

/**
 * @struct Dyn_Thread_Comm
 * @brief Communication structure
 *
 * Contains information for the send recive threads to send and recive to
 * the same location
 */
struct Dyn_Thread_Comm
{
	int sock_ptr;
	int loop_count;
};

//
// Globals
int sem_ptr;
int shm_ptr;

//
// Update to application thread 
// ie void* applicationThread = (void*) &transcoderRuntime;
void* applicationThread;

//
//Helper function

void mwSendThreadFunction(void* val)
{
	int rc, size;
	struct Dyn_Proxy2Device_Comm shared_info;
	struct Dyn_Thread_Comm thread_comm = *(struct Dyn_Thread_Comm*)val;
	
	while(1)
	{
      sleep(SEND_SLEEP_TIME);
      
	  //
      // Send the information to the proxy
      if( (rc = UDP_Send(thread_comm.sock_ptr, MOBILEIP, MOBILEPORT, PROXYPORT,
                      (void *) &shared_info, (size=sizeof(shared_info)))) != size)
      {
          perror("mware: sending datagram message");
          pthread_exit((void *)NULL);
      }
	}
}

void mwReciveThreadFunction(void* val)
{
  int rc, size;
  struct Dyn_Device2Proxy_Comm recv_info;
  struct Dyn_Thread_Comm thread_comm = *(struct Dyn_Thread_Comm*)val;
  size = sizeof(recv_info);
  
  while(1)
  {
    //
    // recive the information from the proxy
    if( (rc = UDP_Recv(thread_comm.sock_ptr, &recv_info, (size=sizeof(recv_info)))) != size)
    {
        printf("%d", thread_comm.sock_ptr);fflush(stdout);
        perror("recvfrom proxy:");
        pthread_exit((void *)NULL);
    }
	
	//Perform actions here on recived information
  }    
}
#endif
