#ifndef HOSTAP_H
#define HOSTAP_H

/* hostap.c */

extern struct proc_dir_entry *hostap_proc;

int hostap_set_word(struct net_device *dev, int rid, u16 val);
int hostap_set_string(struct net_device *dev, int rid, const char *val);
u16 hostap_get_porttype(local_info_t *local);
int hostap_set_encryption(local_info_t *local);
void hostap_dump_rx_header(const char *name,
			   const struct hfa384x_rx_frame *rx);
void hostap_dump_tx_header(const char *name,
			   const struct hfa384x_tx_frame *tx);
void hostap_netif_wake_queues(struct net_device *dev);
void hostap_netif_stop_queues(struct net_device *dev);
int hostap_80211_header_parse(struct sk_buff *skb, unsigned char *haddr);
int hostap_80211_prism_header_parse(struct sk_buff *skb, unsigned char *haddr);
struct net_device_stats *hostap_get_stats(struct net_device *dev);
void hostap_setup_dev(struct net_device *dev, local_info_t *local,
		      int main_dev);


/* hostap_proc.c */

void hostap_init_proc(local_info_t *local);
void hostap_remove_proc(local_info_t *local);

#endif /* HOSTAP_H */
