#ifndef HOSTAP_COMPAT_H
#define HOSTAP_COMPAT_H

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0))
/* 2.2 compatibility */
#ifndef spin_lock_bh
#define spin_lock_bh(lock) spin_lock_irq(lock)
#define spin_unlock_bh(lock) spin_unlock_irq(lock)
#endif
#ifndef __constant_cpu_to_le16
#define __constant_cpu_to_le16 __cpu_to_le16
#endif

#define PRISM2_NETDEV_EXTRA IFNAMSIZ
#define prism2_set_dev_name(dev, pos) (dev)->name = (char *) (pos)

/* tq_scheduler was removed in 2.4.0-test12 */
#define PRISM2_SCHEDULE_TASK(q) \
MOD_INC_USE_COUNT; \
queue_task((q), &tq_scheduler);

#define PRISM2_FLUSH_SCHEDULED_TASKS() do { schedule(); schedule(); } while (0)

static inline void HOSTAP_TQ_INIT(struct tq_struct *tq)
{
	tq->next = NULL;
}

static inline void dev_kfree_skb_any(struct sk_buff *skb)
{
	if (in_interrupt())
		dev_kfree_skb_irq(skb);
	else
		dev_kfree_skb(skb);
}

static __inline__ void list_del_init(struct list_head *entry)
{
	__list_del(entry->prev, entry->next);
	INIT_LIST_HEAD(entry); 
}


/* end 2.2 compatibility */

#else /* kernel < 2.4.0 */

/* no extra space needed for 2.4.x net_device */
#define PRISM2_NETDEV_EXTRA 0
#define prism2_set_dev_name(dev, pos) do { } while (0)

#define PRISM2_SCHEDULE_TASK(q) \
MOD_INC_USE_COUNT; \
if (schedule_task((q)) == 0) \
	MOD_DEC_USE_COUNT;

#define PRISM2_FLUSH_SCHEDULED_TASKS() flush_scheduled_tasks()

static inline void HOSTAP_TQ_INIT(struct tq_struct *tq)
{
	INIT_LIST_HEAD(&tq->list);
}

#endif /* kernel < 2.4.0 */

#endif /* HOSTAP_COMPAT_H */
