#ifndef HOSTAP_CONFIG_H
#define HOSTAP_CONFIG_H

#define PRISM2_VERSION "0.0.0 2002-09-12"

/* define PRISM2_MONITOR to add support for raw WLAN frame sniffing */
#define PRISM2_MONITOR

/* define PRISM2_USE_TX_INTERRUPT to instruct the driver to handle TX
 * interrupts and increments tx_packets counter only for successfully sent
 * frames. This will produce more exact statistics by removing, e.g., TX errors
 * from the counter, but also more load due to extra interrupts for all TX
 * frames. If this is commented, the extra TX interrupts are masked out and
 * tx_packets counter is incremented from Alloc events. */
/* #define PRISM2_USE_TX_INTERRUPT */

/* define PRISM2_HOSTAPD to use user space daemon to handle management frames;
 */
/* #define PRISM2_HOSTAPD */

/* Maximum number of events handler per one interrupt */
#define PRISM2_MAX_INTERRUPT_EVENTS 20

/* Use PCI bus master to copy data to/from BAP (only available for
 * hostap_pci.o).
 *
 * Note! This is extremely experimental. PCI bus master is not supported by
 * Intersil and it seems to have some problems at least on TX path (see below).
 * The driver code for implementing bus master support is based on guessing
 * and experimenting suitable control bits and these might not be correct.
 * This code is included because using bus master makes a huge difference in
 * host CPU load (something like 40% host CPU usage to 5-10% when sending or
 * receiving at maximum throughput).
 *
 * Note2! Station firmware version 1.3.5 and primary firmware version 1.0.7
 * have some fixes for PCI corruption and these (or newer) versions are
 * recommended especially when using bus mastering. */
/* #define PRISM2_BUS_MASTER */

#ifdef PRISM2_BUS_MASTER

/* PCI bus master implementation seems to be broken in current
 * hardware/firmware versions. Enable this to use enable command to fix
 * something before starting bus master operation on TX path. This will add
 * some latency and an extra interrupt to each TX packet. */
#define PRISM2_ENABLE_BEFORE_TX_BUS_MASTER

#endif /* PRISM2_BUS_MASTER */

/* Include code for downloading firmware images. */
/* #define PRISM2_DOWNLOAD_SUPPORT */

/* Include wireless extensions sub-ioctl support even if wireless extensions
 * version is less than 15 (actually, only if it is 12 .. 14). If ver >= 15,
 * these will be included. Please note, that this requires iwpriv version 25
 * or higher (older versions will segfault due to long ioctl list). */
/* #define PRISM2_USE_WE_SUB_IOCTLS */

/* Use IW_PRIV_TYPE_ADDR with private WE ioctls taking MAC address argument
 * (instead of old 18*char). This requires iwpriv ver >= 25. This will be
 * automatically included for WIRELESS_EXT >= 15. */
/* #define PRISM2_USE_WE_TYPE_ADDR */

/* Check whether interrupt delivery works. This seems to be one of the most
 * common problems with pcmcia-cs, so enabled automatically for hostap_cs.o */
#ifdef PRISM2_PCCARD
#define PRISM2_CHECK_INTERRUPT_DELIVERY
#endif

/* Following defines can be used to remove unneeded parts of the driver, e.g.,
 * to limit the size of the kernel module. Definitions can be added here in
 * hostap_config.h or they can be added to make command with EXTRA_CFLAGS,
 * e.g.,
 * 'make pccard EXTRA_CFLAGS="-DPRISM2_NO_DEBUG -DPRISM2_NO_PROCFS_DEBUG"'
 */

/* Do not include debug messages into the driver */
/* #define PRISM2_NO_DEBUG */

/* Do not include /proc/net/prism2/wlan#/{registers,rids,unknown_rids,debug} */
/* #define PRISM2_NO_PROCFS_DEBUG */

/* Do not include station functionality (i.e., allow only Master (Host AP) mode
 */
/* #define PRISM2_NO_STATION_MODES */

/* PRISM2_MONITOR is defined in default config; make it possible to undefine it
 */
#ifdef PRISM2_NO_MONITOR
#ifdef PRISM2_MONITOR
#undef PRISM2_MONITOR
#endif
#endif /* PRISM2_NO_MONITOR */

#endif /* HOSTAP_CONFIG_H */
