/*
 *      Home-agent header file
 *
 *      Authors:
 *      Sami Kivisaari          <skivisaa@cc.hut.fi>
 *
 *      $Id: ha.h,v 1.4 2002/03/25 13:51:37 ville Exp $
 *
 *      This program is free software; you can redistribute it and/or
 *      modify it under the terms of the GNU General Public License
 *      as published by the Free Software Foundation; either version
 *      2 of the License, or (at your option) any later version.
 *
 */

#ifndef _HA_H
#define _HA_H

/*
 * Global configuration flags
 */
extern int mipv6_is_ha;

#define MAX_LIFETIME 1000

int mipv6_initialize_ha(void);
void mipv6_shutdown_ha(void);

int mipv6_proxy_nd(
	struct in6_addr *home_addr, 
	int ifindex,
	int prefix_length,
	int router);

int mipv6_proxy_nd_rem(
	struct in6_addr *home_addr,
	int ifindex,
	int prefix_length,
	int router);

int mipv6_lifetime_check(int lifetime);

static __inline__ void mipv6_generate_ll_addr(struct in6_addr *ll_addr,
					      struct in6_addr *addr)
{
	ll_addr->s6_addr32[0] = __constant_htonl(0xfe800000);
	ll_addr->s6_addr32[1] = 0;
	ll_addr->s6_addr32[2] = addr->s6_addr32[2];
	ll_addr->s6_addr32[3] = addr->s6_addr32[3];
}

#endif



