/*--------------------------------------------------------------------
Copyright  2001 The Regents of the University of California.
All Rights Reserved. Permission to use, copy, modify, and distribute
this software and its documentation for educational, research and
non-profit purposes, without fee, and without a written agreement is
hereby granted, provided that the above copyright notice, this
paragraph and the following two paragraphs appear in all copies.
This software program and documentation are copyrighted by The
Regents of the University of California ("The University of California")

THE SOFTWARE PROGRAM AND DOCUMENTATION ARE SUPPLIED "AS IS," WITHOUT
ANY ACCOMPANYING SERVICES FROM THE UNIVERSITY OF CALFORNIA.
FURTHERMORE, THE UNIVERSITY OF CALIFORNIA DOES NOT WARRANT THAT THE
OPERATION OF THE PROGRAM WILL BE UNINTERRUPTED OR ERROR-FREE. THE
END-USER UNDERSTANDS THAT THE PROGRAM WAS DEVELOPED FOR RESEARCH
PURPOSES AND IS ADVISED NOT TO RELY EXCLUSIVELY ON THE PROGRAM FOR
ANY REASON.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES,
INCLUDING LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS
DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF
THE POSSIBILITY OF SUCH DAMAGES. THE UNIVERSITY OF CALIFORNIA
SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND
THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE,
SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
--------------------------------------------------------------------*/

#include "paapi.h"

#define NUM_TASKS 3

struct thread_type_handle_t type_handle[NUM_TASKS];
struct thread_instance_handle_t instance_handle[NUM_TASKS];

void task(void *data);

void main(void)
{
  int i;
  struct thread_type_info_t th_type_info;
  struct thread_instance_info_t th_instance_info;
  unsigned data;

  // pahal_initialize_processor_power_management();

  paapi_dvs_init_power_scheduler();

  /* thead type info */
  th_type_info.wcet = 20;
  th_type_info.deadline = 100;
  th_type_info.period = 100;
  th_type_info.hard = 1;
  th_type_info.entry_point = task;
 
  paapi_dvs_create_task_type(th_type_info, &type_handle[2]);

  /* thead type info */
  th_type_info.wcet = 15; 
  th_type_info.deadline = 80;
  th_type_info.period = 80;
  th_type_info.hard = 1;
  th_type_info.entry_point = task;

  paapi_dvs_create_task_type(th_type_info, &type_handle[1]);

  /* thead type info */
  th_type_info.wcet = 10; 
  th_type_info.deadline = 40;
  th_type_info.period = 40;
  th_type_info.hard = 1;
  th_type_info.entry_point = task;
 
  paapi_dvs_create_task_type(th_type_info, &type_handle[0]);

  for ( i = 0; i < NUM_TASKS; i++ ) {
    data = i;
    paapi_dvs_create_task_instance(type_handle[i], &instance_handle[i], 
				   (void *)data);
  }
}

void task(void *data)
{
  paapi_task_handle_t task_handle;

  task_handle = paapi_get_handle();

  while (1) {
    // Useful thread work is within app_started and app_done function calls
    paapi_dvs_app_status(PAAPI_START);

    // do work ...

    paapi_dvs_app_status(PAAPI_DONE);
  }
}
