#include <stdio.h>
#include <math.h>
#include "paapi_dvs.h"
#include "gsl_randist.h"

#define NUM_TASKS 2
#define FRACTION 0.5

void task(void *ptr)
{
  struct paapi_thread_data_t *th_data = (struct paapi_thread_data_t *)ptr; 
  void *data = th_data->data;
  unsigned wcet, scaled_wcet;
  unsigned char complete = 0;
  unsigned long long exec_time, i, j = 0, k;
  unsigned change;
  struct thread_type_t th_type_info;
  gsl_rng *rng = (gsl_rng *)gsl_rng_alloc(gsl_rng_default);

  change = *((unsigned *)&data);

  paapi_dvs_app_associate((struct paapi_thread_data_t *)ptr);

  /* ** compute execution time. For simulation only *** */
  paapi_dvs_get_wcet(&wcet);
  printf("wcet: %d\n", wcet);

#ifdef PAAPI_IPAQ_LINUX
  scaled_wcet = (3500) * wcet;
#endif
#ifdef PAAPI_UML_LINUX
  scaled_wcet = 2800000 * wcet;
#endif
  /* ************************************************** */

  paapi_dvs_app_start_period();
  do {
    paapi_dvs_app_start();

    exec_time = scaled_wcet;
    //exec_time = (unsigned)ceil(((1.0 + FRACTION)*scaled_wcet) / (double)2.0 + 
    //  gsl_ran_gaussian(rng, ((1.0 - FRACTION)*scaled_wcet) / (double)6.0));

    /* the actual code goes here... */
    for ( i = 0; i < exec_time; i++ ) {
      k++;
    }
    /* notifies the kernel I'm done for now and sleeps until next 
       arrival time */
    paapi_dvs_app_done();
    if ( j++ < 40 ) { 
      if ( change && j == 20 ) {
    	th_type_info.wcet = 33; 
    	th_type_info.deadline = 90;
     	th_type_info.period = 90;      
    	paapi_dvs_change_thread_type(&th_type_info);
      }
      paapi_dvs_app_sleep_until_next_period(); 
    }
    else { 
      complete = 1; 
    }
  } while (!complete);

  //  Leave the taskset
  paapi_dvs_app_leave();
}

main()
{
  struct thread_type_t th_type_info;
  struct thread_type_handle_t type_handle[NUM_TASKS];
  struct thread_instance_handle_t instance_handle[NUM_TASKS];
  unsigned change_parameter = 1;

  paapi_dvs_init();
  paapi_dvs_select_policy(PAAPI_DVS_STATIC_SLOWDOWN |
                          PAAPI_DVS_DYNAMIC_PREDICTIVE|
                          PAAPI_DVS_DYNAMIC_ADAPTIVE);

  /* thead type info */
  th_type_info.wcet = 20; 
  th_type_info.deadline = 40;
  th_type_info.period = 40;
  th_type_info.hard = 1;
  paapi_dvs_create_thread_type(&th_type_info, &type_handle[0]);

  /* thead type info */
  th_type_info.wcet = 32; 
  th_type_info.deadline = 80;
  th_type_info.period = 80;
  th_type_info.hard = 1;
  paapi_dvs_create_thread_type(&th_type_info, &type_handle[1]);

  paapi_dvs_create_instance(&type_handle[0], &instance_handle[0], 
			    (void *)&task, &change_parameter);

  paapi_dvs_create_instance(&type_handle[1], &instance_handle[1], 
   			    (void *)&task, NULL);
  paapi_dvs_start_taskset();
  exit(0);
}
