#include <stdio.h>
#include <math.h>
#include "gsl_randist.h"

#define FRACTION 0.5

int main()
{
  gsl_rng *rng = (gsl_rng *)gsl_rng_alloc(gsl_rng_default);
  unsigned scaled_wcet, exec_time;
  unsigned i;

  scaled_wcet = (3500) * 10;

  for ( i = 0; i < 10; i++ ) {
    exec_time = (unsigned)ceil(((1.0 + FRACTION)*scaled_wcet) / (double)2.0 +
     gsl_ran_gaussian(rng, ((1.0 - FRACTION)*scaled_wcet) / (double)6.0));
    printf("%d:%d:%d\n", scaled_wcet, exec_time, abs((int)gsl_ran_gaussian(rng,10)));
  }
}
