#ifndef __PAAPI_DVS_H
#define __PAAPI_DVS_H

#include <sys/time.h>
#include "linux/paapi-user.h"
                                                                               
#define PAAPI_MEASURE_OVERHEAD
#define TIME_TRACE_BUFFER_LENGTH (1024)

#define APP_TIME_PAAPI_CREATE_TYPE 1
#define APP_TIME_PAAPI_CREATE_INSTANCE 2
#define APP_TIME_PAAPI_STATUS_START 3
#define APP_TIME_PAAPI_STATUS_DONE 4
#define APP_TIME_PAAPI_STATUS_START_PERIOD 5
#define APP_TIME_PAAPI_CONTROL_START_TASKSET 6
#define APP_TIME_PAAPI_CHANGE_TYPE 7
#define APP_TIME_PAAPI_LEAVE 8

#ifdef  PAAPI_MEASURE_OVERHEAD
#define DECLARE_TIMESTAMP(t) struct timeval t
#define TAKE_TIMESTAMP(t)    (gettimeofday(&t,NULL))
#define TOTAL_TIME(t1,t2)    (((t2.tv_sec * 1000000)+t2.tv_usec)- \
                              ((t1.tv_sec * 1000000)+t1.tv_usec))
#define LOG_TIME_TRACE(tp,tm) (log_timetrace(tp,tm))
#define PRINT_TIME_TRACE print_time_trace()
#else
#define DECLARE_TIMESTAMP(t)
#define TAKE_TIMESTAMP(t)
#define TOTAL_TIME(t1,t2)
#define LOG_TIME_TRACE (tp,tm)
#define PRINT_TIME_TRACE
#endif
                                                                                
struct paapi_time_info {
  char type;
  int  time;
};
 
struct paapi_thread_data_t {
  struct thread_instance_handle_t inst_handle;
  void *data;
};

extern struct paapi_time_info timetracebuffer[TIME_TRACE_BUFFER_LENGTH];
extern unsigned time_trace_buffer_index;

void 
paapi_dvs_create_thread_type(struct thread_type_t *,
			     struct thread_type_handle_t *);

void 
paapi_dvs_change_thread_type(struct thread_type_t *th_type_info);

void 
paapi_dvs_create_instance(struct thread_type_handle_t * type_handle,
			  struct thread_instance_handle_t *instance_handle,
			  void * (*code)(void *), void *data);
void 
paapi_dvs_app_start(void);

void
paapi_dvs_app_done(void);

void
paapi_dvs_app_sleep_until_next_period();

void
paapi_dvs_app_leave();

void
paapi_dvs_app_associate(struct paapi_thread_data_t *);

void
paapi_dvs_start_taskset(void);

void
paapi_dvs_get_wcet(unsigned *);

void
paapi_dvs_init();

void
paapi_dvs_select_policy(int);

void
log_timetrace(char type, int time);

void 
print_time_trace();

#endif
