/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#ifndef _BATTERY_H_
#define _BATTERY_H_

struct dynamo_battery 
{
	int ac_status;
	int level;
	int min_remaining;
};

/***
* Returns the systems AC status (is the system pluged in)
* returns 0 or 1
***/
extern int get_battery_ac_status();

/***
* Returns the systems power level in percentage
* 0 - 100
***/
extern int get_battery_power_level();

/***
* Returns the amount of minutes that the system will have power for
* Note: need to implament to return -1 if its pluged in
***/
extern int get_battery_min_remaining();


extern int get_battery_info(struct dynamo_battery* battery);

#endif //BATTERY
