#include "commlib.h"

/*
 *  Description:
 *      Creates a datagram socket, connects to the target IP and sends
 *      the buffer. Closes the socket on a successful send. 
 *
 *  inputs: 
 *      1. receiver IP address and port. /SERV_HOST_ADDR, SERV_UDP_PORT     
 *      2. buffer to send, size of the buffer 
 *      3. local port 
 *      
 *  return value: <= 0 means failure, otherwise success. 
 */

int SendDatagram(char *targetIP, int targetPort, 
                                  int localPort, void *buf, int bufsiz)
{
	int sockfd;
	struct sockaddr_in  cli_addr;
	struct sockaddr_in  serv_addr;
	int    rc,size;

	memset((char *)&serv_addr,0,sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = inet_addr(targetIP);
	serv_addr.sin_port = htons(targetPort);

   	/* Create socket on which to send. */
	if( (sockfd = socket(AF_INET,SOCK_DGRAM,0)) < 0)
		return sockfd;

	memset((char *)&cli_addr,0,sizeof(cli_addr));
	cli_addr.sin_family = AF_INET;
	cli_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	cli_addr.sin_port = htons(localPort);

	//size = sizeof(clientInfo);
   	/* Send message. */
	if( (rc = sendto(sockfd,buf,bufsiz,0,
				(struct sockaddr *)&serv_addr,sizeof(serv_addr))) != bufsiz)
	{
   		close(sockfd); 
		return 0; 
	}

	close(sockfd);
	return (bufsiz);
}


/*
 *  Description:
 *     Create UDP socket and bind it to localport 
 *     
 *  inputs: 
 *      1. local IP address and port. 
 *      
 *  return value: <= 0 means failure, otherwise returns socket descriptor. 
 */

int CreateUDPSocket(char *localIP, int localPort)
{
	int  sockfd;
	struct sockaddr_in serv_addr;

	if( (sockfd = socket(AF_INET,SOCK_DGRAM,0)) < 0)
		return sockfd;

	memset((char *)&serv_addr,0,sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	serv_addr.sin_port = htons(localPort);

	if( bind(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr)) < 0)
	{
		close(sockfd);
		return (-1);
	}

	return sockfd;
}

int UDP_Recv(int sockfd, void *buf, int size)
{
	int    clilen,rc;
	struct sockaddr_in cli_addr;

	clilen = sizeof(cli_addr);
	if( (rc = recvfrom(sockfd,buf,size,0,
		(struct sockaddr *)&cli_addr,&clilen)) != size)
	{
		close(sockfd);
       	return rc;
	}
	return rc;
}

int UDP_Send(int sockfd, char *targetIP, int targetPort, 
                        int localPort, void *buf, int bufsiz)
{
	struct sockaddr_in  cli_addr;
	struct sockaddr_in  serv_addr;
	int    rc,size;

	memset((char *)&serv_addr,0,sizeof(serv_addr));
	serv_addr.sin_family = AF_INET;
	serv_addr.sin_addr.s_addr = inet_addr(targetIP);
	serv_addr.sin_port = htons(targetPort);

	memset((char *)&cli_addr,0,sizeof(cli_addr));
	cli_addr.sin_family = AF_INET;
	cli_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	cli_addr.sin_port = htons(localPort);

	if( (rc = sendto(sockfd,buf,bufsiz,0,
				(struct sockaddr *)&serv_addr,sizeof(serv_addr))) != bufsiz)
	{
   		close(sockfd); 
		return rc; 
	}

	return (bufsiz);
}
