/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cpu.h"
#include "procread.h"

#define PROC_CPU_INFO "/proc/cpuinfo"
#define PROC_LOAD_AVG "/proc/loadavg"

char* get_cpu_model()
{
	FILE* file_ptr = fopen(PROC_CPU_INFO, "r");
	char* temp = read_row_named(file_ptr, "Processor");
	fclose(file_ptr);

	if(temp)
		return temp;
	else
		return (char *)NULL;
}

float get_cpu_load()
{
	FILE* file_ptr = fopen(PROC_LOAD_AVG, "r");
	char* temp = read_table(file_ptr, 2, 1);
	fclose(file_ptr);

	if(temp)
	{
		int load = atof(temp);
		free(temp);
		return load;
	}
	else
		return -1;
}

int get_cpu_total_process()
{
	FILE* file_ptr = fopen(PROC_LOAD_AVG, "r");
	char* temp = read_table(file_ptr, 2, 4);
	fclose(file_ptr);
	
	if(temp)
	{
		char* place;
		int p_num;
		
		place = strtok(temp, "/\0");
		place = strtok(NULL, "/");
		p_num = atoi(place);
		free(temp);
		return p_num;
	}
	else
		return -1;
}

int get_cpu_running_process()
{
	FILE* file_ptr = fopen(PROC_LOAD_AVG, "r");
	char* temp = read_table(file_ptr, 2, 4);
	fclose(file_ptr);
	
	if(temp)
	{
		int procs = atoi(temp);
		free(temp);
		return procs;
	}
	else
		return -1;
}

int get_cpu_info(struct dynamo_cpu* cpu)
{
	
	char* model = get_cpu_model();
	
#if 0
	printf("model"); fflush(stdout);
#endif	
	if(model)
	{
		strcpy(cpu->model, model);
		free( model );
	}
	cpu->load = get_cpu_load();
#if 0
	printf("load"); fflush(stdout);
#endif	
    cpu->total_process = get_cpu_total_process();
#if 0
	printf("totproc"); fflush(stdout);
#endif	
    cpu->active_process = get_cpu_running_process();
#if 0
	printf("actproc"); fflush(stdout);
#endif	
	//
	// need to implament a return of true or false for these
	return 1;
}

